/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.PropertySheet;
import xyz.cofe.gui.swing.properties.editor.AbstractPropertyEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.text.Text;

public class BooleanFormatter
extends AbstractPropertyEditor
implements PropertyDBService,
TreeTableNodeGetFormatOf {
    private static final Logger logger = Logger.getLogger(BooleanFormatter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private ImageIcon checkedIcon = null;
    private ImageIcon unCheckedIcon = null;
    protected Boolean value;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(BooleanFormatter.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(BooleanFormatter.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(BooleanFormatter.class.getName(), method, result);
    }

    public BooleanFormatter() {
        this.prepareIcons();
    }

    public BooleanFormatter(BooleanFormatter sample) {
        this.prepareIcons();
        this.checkedIcon = sample.checkedIcon;
        this.unCheckedIcon = sample.unCheckedIcon;
    }

    @Override
    public BooleanFormatter clone() {
        return new BooleanFormatter(this);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(Boolean.class, this, 0.5);
        pdb.registerTypeEditor(Boolean.TYPE, this, 0.5);
    }

    private void prepareIcons() {
        URL uncheckIconUrl;
        URL checkIconUrl = PropertySheet.class.getResource("/xyz/cofe/gui/swing/properties/editors/checked-2.png");
        if (checkIconUrl != null) {
            this.checkedIcon = new ImageIcon(checkIconUrl);
        }
        if ((uncheckIconUrl = PropertySheet.class.getResource("/xyz/cofe/gui/swing/properties/editors/unchecked-2.png")) != null) {
            this.unCheckedIcon = new ImageIcon(uncheckIconUrl);
        }
    }

    @Override
    public TreeTableNodeFormat getTreeTableNodeFormatOf(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            return null;
        }
        Boolean bval = (Boolean)value;
        TreeTableNodeFormatBasic fmt = new TreeTableNodeFormatBasic();
        if (this.checkedIcon != null && this.unCheckedIcon != null) {
            if (bval.booleanValue()) {
                fmt.getIcons().add(this.checkedIcon);
            } else {
                fmt.getIcons().add(this.unCheckedIcon);
            }
        }
        return fmt;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean) {
            this.value = (Boolean)value;
        } else if (value == null) {
            this.value = null;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value != null) {
            return this.value != false ? "true" : "false";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (this.value != null) {
            return this.value != false ? "true" : "false";
        }
        return "null";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.value = text == null ? null : (text.equalsIgnoreCase("null") ? null : Boolean.valueOf(Text.in((String)text.trim().toLowerCase(), (String[])new String[]{"true", "1", "yes", "on"})));
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

