/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.PropertySheet;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.text.Text;

public class BooleanNullableEditor
extends CustomEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(BooleanNullableEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private ImageIcon checkedIcon = null;
    private ImageIcon unCheckedIcon = null;
    private Icon nullIcon = null;
    private JComboBox combo = null;
    protected Boolean value;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(BooleanNullableEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(BooleanNullableEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(BooleanNullableEditor.class.getName(), method, result);
    }

    public BooleanNullableEditor() {
        this.prepareIcons();
        this.combo = new JComboBox<Object>(new Object[]{"true", "false", "null"});
        BasicComboBoxRenderer cr = new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if ("true".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.checkedIcon);
                } else if ("false".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.unCheckedIcon);
                } else if ("null".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.nullIcon);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        this.combo.setRenderer(cr);
        this.listenComboBoxChanges();
    }

    public BooleanNullableEditor(BooleanNullableEditor sample) {
        this.prepareIcons();
        this.combo = new JComboBox<Object>(new Object[]{"true", "false", "null"});
        BasicComboBoxRenderer cr = new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if ("true".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.checkedIcon);
                } else if ("false".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.unCheckedIcon);
                } else if ("null".equals(value)) {
                    this.setIcon(BooleanNullableEditor.this.nullIcon);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        this.combo.setRenderer(cr);
        if (sample != null) {
            this.checkedIcon = sample.checkedIcon;
            this.unCheckedIcon = sample.unCheckedIcon;
            this.nullIcon = sample.nullIcon;
        }
        this.listenComboBoxChanges();
    }

    protected void listenComboBoxChanges() {
        Reciver rFinish = new Reciver(){

            public void recive(Object obj) {
                BooleanNullableEditor.this.fireEditingStopped(BooleanNullableEditor.this);
            }
        };
        SwingListener.onActionPerformed(this.combo, (Reciver<ActionEvent>)rFinish);
    }

    @Override
    public BooleanNullableEditor clone() {
        return new BooleanNullableEditor(this);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb != null) {
            pdb.registerTypeEditor(Boolean.class, this, 1.0);
        }
    }

    private void prepareIcons() {
        URL uncheckIconUrl;
        URL checkIconUrl = PropertySheet.class.getResource("/xyz/cofe/gui/swing/properties/editors/checked-2.png");
        if (checkIconUrl != null) {
            this.checkedIcon = new ImageIcon(checkIconUrl);
        }
        if ((uncheckIconUrl = PropertySheet.class.getResource("/xyz/cofe/gui/swing/properties/editors/unchecked-2.png")) != null) {
            this.unCheckedIcon = new ImageIcon(uncheckIconUrl);
        }
        this.nullIcon = Icons.getNullIcon();
    }

    @Override
    protected JComponent createComponent() {
        return this.combo;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean) {
            this.value = (Boolean)value;
            Boolean v = (Boolean)value;
            this.combo.setSelectedIndex(v != false ? 0 : 1);
        } else if (value == null) {
            this.value = null;
            this.combo.setSelectedIndex(2);
        }
    }

    @Override
    public void startEditing(Object value, Object context) {
        this.setValue(value);
    }

    public Boolean getBooleanValue() {
        int sel = this.combo.getSelectedIndex();
        if (sel == 0) {
            return Boolean.TRUE;
        }
        if (sel == 1) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.getBooleanValue();
    }

    @Override
    public String getJavaInitializationString() {
        if (this.getBooleanValue() != null) {
            return this.getBooleanValue() != false ? "true" : "false";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (this.getBooleanValue() != null) {
            return this.getBooleanValue() != false ? "true" : "false";
        }
        return "null";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.combo.setSelectedIndex(2);
        } else if (text.equalsIgnoreCase("null")) {
            this.combo.setSelectedIndex(2);
        } else if (Text.in((String)text.trim().toLowerCase(), (String[])new String[]{"true", "1", "yes", "on"})) {
            this.combo.setSelectedIndex(0);
        } else {
            this.combo.setSelectedIndex(1);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

