/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.ComboBoxEditor;

public class CharsetEditor
extends ComboBoxEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(CharsetEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected boolean nullAsDefault = true;
    protected boolean emptyAsDefault = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(CharsetEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(CharsetEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CharsetEditor.class.getName(), method, result);
    }

    public CharsetEditor() {
        Object[] csarr = Charset.availableCharsets().keySet().toArray(new String[0]);
        this.setVartiants(csarr);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(Charset.class, this, 1.0);
    }

    @Override
    public Object getValue() {
        Object val = super.getValue();
        if (val == null) {
            return this.nullAsDefault ? Charset.defaultCharset() : null;
        }
        String str = val.toString();
        if (str.trim().length() < 1) {
            return this.emptyAsDefault ? Charset.defaultCharset() : null;
        }
        try {
            Charset cs = Charset.forName(str);
            return cs;
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            CharsetEditor.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), "Charset exception", 0);
            return Charset.defaultCharset();
        }
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Charset) {
            super.setValue(((Charset)value).name());
            return;
        }
        super.setValue(Charset.defaultCharset().name());
    }

    @Override
    public void startEditing(Object value, Object context) {
        Object[] csarr = Charset.availableCharsets().keySet().toArray(new String[0]);
        this.setVartiants(csarr);
        JComboBox cb = this.getComboBox();
        if (cb != null) {
            cb.setSelectedItem(value != null ? value.toString() : Charset.defaultCharset().toString());
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

