/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.border.LineBorder;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.typeconv.impl.RGB;

public class ColorEditor
extends CustomEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(ColorEditor.class.getName());
    protected final JPanel panel = new JPanel();
    protected final JLabel selectColor = new JLabel();
    protected final JLabel nameColor = new JLabel();
    protected final JLabel selectNull = new JLabel("null");
    protected Color color;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = ColorEditor.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(ColorEditor.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ColorEditor.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(Color.class, this);
    }

    public ColorEditor() {
        this.buildUI();
    }

    public ColorEditor(ColorEditor sample) {
        super(sample);
        this.buildUI();
    }

    protected void buildUI() {
        EmptyBorder ebrd = new EmptyBorder(0, 0, 0, 0);
        this.panel.setBorder(ebrd);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.nameColor, "Center");
        JPanel buts = new JPanel(new FlowLayout(1, 0, 0));
        buts.add(this.selectColor);
        buts.add(this.selectNull);
        buts.setBorder(ebrd);
        int lbrdW = 1;
        int lbrdP = 1;
        int lbrdM = 1;
        Color lbrdC = Color.black;
        LineBorder lbrd = new LineBorder().bottom(lbrdW, 0, 2, lbrdC).top(lbrdW, 0, 0, lbrdC).right(lbrdW, lbrdP, lbrdM, lbrdC).left(lbrdW, 1, 3, lbrdC);
        this.selectColor.setBorder(lbrd);
        this.selectNull.setBorder(lbrd);
        this.selectNull.setBackground(Color.gray);
        this.selectNull.setForeground(Color.white);
        this.selectNull.setOpaque(true);
        this.selectNull.setCursor(Cursor.getPredefinedCursor(12));
        this.selectColor.setBackground(Color.gray);
        this.selectColor.setForeground(Color.white);
        this.selectColor.setOpaque(true);
        this.selectColor.setCursor(Cursor.getPredefinedCursor(12));
        this.panel.add((Component)buts, "East");
        this.selectColor.setText("..");
        SwingListener.onMouseClicked(this.selectColor, new Reciver<MouseEvent>(){

            public void recive(MouseEvent ae) {
                ColorEditor.this.color = JColorChooser.showDialog(ColorEditor.this.panel, "Select color", ColorEditor.this.color == null ? Color.black : ColorEditor.this.color);
                ColorEditor.this.nameColor.setText(RGB.rgb(ColorEditor.this.color));
                ColorEditor.this.fireEditingStopped(this);
            }
        });
        SwingListener.onMouseClicked(this.selectNull, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                ColorEditor.this.setValue(null);
                ColorEditor.this.fireEditingStopped(this);
            }
        });
        SwingListener.onMouseEntered(this.selectColor, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                ColorEditor.this.selectColor.setBackground(Color.black);
            }
        });
        SwingListener.onMouseExited(this.selectColor, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                ColorEditor.this.selectColor.setBackground(Color.gray);
            }
        });
        SwingListener.onMouseEntered(this.selectNull, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                ColorEditor.this.selectNull.setBackground(Color.black);
            }
        });
        SwingListener.onMouseExited(this.selectNull, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                ColorEditor.this.selectNull.setBackground(Color.gray);
            }
        });
    }

    @Override
    public ColorEditor clone() {
        return new ColorEditor(this);
    }

    @Override
    protected JComponent createComponent() {
        return this.panel;
    }

    @Override
    public void setValue(Object value) {
        this.color = value instanceof Color ? (Color)value : null;
        this.nameColor.setText(this.color != null ? RGB.rgb(this.color) : "null");
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public String getJavaInitializationString() {
        return RGB.rgb(this.color == null ? Color.black : this.color);
    }

    @Override
    public String getAsText() {
        return this.color == null ? "null" : RGB.rgb(this.color);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.color = text == null || text.trim().equalsIgnoreCase("null") ? null : RGB.rgb(text);
    }
}

