/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import xyz.cofe.collection.Convertor;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.AbstractPropertyEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.typeconv.impl.RGB;

public class ColorFormatter
extends AbstractPropertyEditor
implements PropertyDBService,
TreeTableNodeGetFormatOf {
    private static final Logger logger = Logger.getLogger(ColorFormatter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Color value;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ColorFormatter.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ColorFormatter.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ColorFormatter.class.getName(), method, result);
    }

    public ColorFormatter() {
    }

    public ColorFormatter(ColorFormatter sample) {
    }

    @Override
    public ColorFormatter clone() {
        return new ColorFormatter(this);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(Color.class, this, 0.5);
    }

    @Override
    public TreeTableNodeFormat getTreeTableNodeFormatOf(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Color)) {
            return null;
        }
        Color color = (Color)value;
        TreeTableNodeFormatBasic fmt = new TreeTableNodeFormatBasic();
        fmt.getIcons().add(new ColorIcon(color, Color.black, 12, 12));
        fmt.setIconWidthMin(18);
        fmt.setConvertor(new Convertor<Object, String>(){

            public String convert(Object from) {
                if (from instanceof Color) {
                    return RGB.rgb((Color)from);
                }
                return null;
            }
        });
        return fmt;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Color) {
            this.value = (Color)value;
        } else if (value == null) {
            this.value = null;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getJavaInitializationString() {
        return RGB.rgb(this.value == null ? Color.black : this.value);
    }

    @Override
    public String getAsText() {
        return this.value == null ? "null" : RGB.rgb(this.value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.value = RGB.rgb(text == null ? "#000000" : text);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class ColorIcon
    implements Icon {
        public final int width;
        public final int height;
        public final Color color;
        public final Color border;

        public ColorIcon(Color color, Color border, int w, int h) {
            this.width = w;
            this.height = h;
            this.color = color;
            this.border = border;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D gs = (Graphics2D)g;
            if (this.width > 0 && this.height > 0) {
                if (this.color != null) {
                    gs.setPaint(this.color);
                    gs.fillRect(x, y, this.width, this.height);
                }
                if (this.border != null) {
                    gs.setPaint(this.border);
                    gs.drawRect(x, y, this.width, this.height);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

