/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import xyz.cofe.collection.Pointer;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.properties.SetPropertyEditorOpts;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.LexerUtil;
import xyz.cofe.text.parser.ListLexer;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.Identifier;
import xyz.cofe.text.parser.lex.IdentifierParser;
import xyz.cofe.text.parser.lex.Keyword;
import xyz.cofe.text.parser.lex.KeywordsParser;
import xyz.cofe.text.parser.lex.TextConst;
import xyz.cofe.text.parser.lex.TextConstParser;
import xyz.cofe.text.parser.lex.WhiteSpace;
import xyz.cofe.text.parser.lex.WhiteSpaceParser;

public class ComboBoxEditor
extends CustomEditor
implements SetPropertyEditorOpts {
    private static final Logger logger = Logger.getLogger(ComboBoxEditor.class.getName());
    protected ListCellRenderer listCellRenderer = new BasicComboBoxRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderValue = value;
            if (value == null) {
                renderValue = "null";
            }
            super.getListCellRendererComponent((JList<?>)list, renderValue, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setIcon(Icons.getNullIcon());
            } else {
                this.setIcon(null);
            }
            return this;
        }
    };
    protected String optionsString = null;
    protected JComboBox comboBox;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ComboBoxEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ComboBoxEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ComboBoxEditor.class.getName(), method, result);
    }

    public ComboBoxEditor() {
    }

    public ComboBoxEditor(ComboBoxEditor sample) {
    }

    @Override
    public ComboBoxEditor clone() {
        return new ComboBoxEditor(this);
    }

    private void parseOptionsString(String optsString, Object context) {
        if (optsString == null || optsString.length() == 0) {
            this.setVartiants(new Object[0]);
            return;
        }
        Matcher m = Pattern.compile("(?is)^variants\\s*[=:](?<vars>.*)").matcher(optsString);
        if (m.matches()) {
            String varsGroup = m.group("vars");
            this.parseVariants(varsGroup);
            return;
        }
        m = Pattern.compile("(?is)^variants\\s+call\\s+(?<vcall>.+)").matcher(optsString);
        if (m.matches()) {
            this.parseVariantsCall(m.group("vcall"), context);
            return;
        }
        this.setVartiants(new Object[0]);
    }

    private void parseVariants(String variantsString) {
        ListLexer ll = new ListLexer();
        ll.getParsers().add(new WhiteSpaceParser("ws"));
        ll.getParsers().add(new KeywordsParser(false, new String[]{"|"}));
        ll.getParsers().add(new TextConstParser("text"));
        ll.getParsers().add(new IdentifierParser("id"));
        List tokens = ll.parse(variantsString);
        tokens = LexerUtil.filter((List)tokens, (Class[])new Class[]{WhiteSpace.class});
        ArrayList<String> variants = new ArrayList<String>();
        Pointer ptr = new Pointer(tokens);
        int state = 0;
        while (state >= 0) {
            switch (state) {
                case 0: {
                    Token t = (Token)ptr.lookup(0);
                    if (t == null) {
                        state = -1;
                        break;
                    }
                    ptr.move(1);
                    if (t instanceof Keyword) {
                        switch (((Keyword)t).getKeyword()) {
                            case "|": {
                                break;
                            }
                            default: {
                                state = -2;
                            }
                        }
                    }
                    if (t instanceof TextConst) {
                        variants.add(((TextConst)t).getDecodedText());
                    }
                    if (!(t instanceof Identifier)) break;
                    variants.add(((Identifier)t).getMatchedText());
                }
            }
        }
        this.setVartiants(variants.toArray());
    }

    private void parseVariantsCall(String variantsCallString, Object context) {
        Matcher m = Pattern.compile("(?is)^\\s*(class\\s+(?<clsName>[\\w_][\\.\\w_\\d]+)\\s*)?(method\\s+(?<meth>[\\w_][\\w\\d_]+))").matcher(variantsCallString);
        if (m.matches()) {
            ClassLoader cl;
            TreeTableNodeValue ttnv;
            Object oval;
            String clsName = m.group("clsName");
            String meth = m.group("meth");
            Object ctx = null;
            if (context instanceof PropertyValue) {
                Property prop = ((PropertyValue)context).getProperty();
                ctx = prop != null ? prop.getBean() : null;
            } else if (context instanceof TreeTableNode) {
                TreeTableNode ttn = (TreeTableNode)context;
                ctx = ttn.getData();
            } else if (context instanceof TreeTableNodeValue && (oval = (ttnv = (TreeTableNodeValue)context).getDataOfNode()) instanceof Property) {
                Property prop = (Property)oval;
                ctx = prop != null ? prop.getBean() : null;
            }
            Class<?> vclass = null;
            if (clsName != null && clsName.trim().length() > 0 && !clsName.contains(".") && ctx != null) {
                cl = ctx.getClass().getClassLoader();
                String pkg = ctx.getClass().getPackage().getName();
                String tcls = pkg.trim().length() > 0 ? Text.trimEnd((String)pkg, (String)".") + "." + clsName : clsName;
                try {
                    vclass = Class.forName(tcls, true, cl);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(ComboBoxEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (clsName != null && clsName.trim().length() > 0) {
                cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ComboBoxEditor.class.getClassLoader();
                }
                if (ctx != null) {
                    cl = ctx.getClass().getClassLoader();
                }
                try {
                    vclass = Class.forName(clsName, true, cl);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(ComboBoxEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.callVariants(ctx, vclass, meth);
        }
    }

    private void callVariants(Object ctx, Class vclass, String method) {
        if (vclass != null && method != null) {
            try {
                Object octx = vclass.newInstance();
                Method m = vclass.getMethod(method, new Class[0]);
                Object ovars = m.invoke(octx, new Object[0]);
                this.initVariants(ovars);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ComboBoxEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (ctx != null && method != null) {
            try {
                Method m = ctx.getClass().getMethod(method, new Class[0]);
                Object ovars = m.invoke(ctx, new Object[0]);
                this.initVariants(ovars);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ComboBoxEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void initVariants(Object ovars) {
        if (ovars != null) {
            Class<?> c = ovars.getClass();
            if (c.isArray()) {
                ArrayList<Object> l = new ArrayList<Object>();
                int len = Array.getLength(ovars);
                for (int ai = 0; ai < len; ++ai) {
                    Object el = Array.get(ovars, ai);
                    if (el == null) continue;
                    l.add(el);
                }
                this.setVartiants(l.toArray());
            } else if (ovars instanceof Iterable) {
                ArrayList l = new ArrayList();
                for (Object el : (Iterable)ovars) {
                    if (el == null) continue;
                    l.add(el);
                }
                this.setVartiants(l.toArray());
            }
        } else {
            this.setVartiants(new Object[0]);
        }
    }

    @Override
    public void startEditing(Object value, Object context) {
        this.parseOptionsString(this.optionsString, context);
        super.startEditing(value, context);
    }

    @Override
    public void setPropertyEditorOpts(String opts) {
        this.optionsString = opts;
    }

    public Object[] getVaraints() {
        ArrayList l = new ArrayList();
        JComboBox cb = this.getComboBox();
        ComboBoxModel cbm = cb.getModel();
        for (int i = 0; i < cbm.getSize(); ++i) {
            l.add(cbm.getElementAt(i));
        }
        return l.toArray();
    }

    public void setVartiants(Object[] variants) {
        if (variants == null) {
            throw new IllegalArgumentException("variants == null");
        }
        DefaultComboBoxModel<Object> dcbm = new DefaultComboBoxModel<Object>(variants);
        this.getComboBox().setModel(dcbm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComboBox getComboBox() {
        ComboBoxEditor comboBoxEditor = this;
        synchronized (comboBoxEditor) {
            if (this.comboBox != null) {
                return this.comboBox;
            }
            this.comboBox = new JComboBox();
            this.comboBox.setEditable(true);
            this.comboBox.setRenderer(this.listCellRenderer);
            javax.swing.ComboBoxEditor cbeditor = this.comboBox.getEditor();
            Component cmpt = cbeditor.getEditorComponent();
            if (cmpt != null) {
                cmpt.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e == null) {
                            return;
                        }
                        if (e.getKeyCode() == 10) {
                            ComboBoxEditor.this.fireEditingStopped(ComboBoxEditor.this);
                        }
                    }
                });
            }
            return this.comboBox;
        }
    }

    @Override
    protected JComponent createComponent() {
        return this.getComboBox();
    }

    @Override
    public void setValue(Object value) {
        JComboBox cb = this.getComboBox();
        if (value == null) {
            cb.getEditor().setItem(null);
        } else {
            cb.getEditor().setItem(value);
        }
    }

    @Override
    public Object getValue() {
        JComboBox cb = this.getComboBox();
        Object val = cb.getEditor().getItem();
        return val;
    }

    @Override
    public String getJavaInitializationString() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        return val.toString();
    }

    @Override
    public String getAsText() {
        Object val = this.getValue();
        return val == null ? "" : val.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }
}

