/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.editor.PropertyEditorSupport;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public abstract class CustomEditor
extends TreeTableNodeValueEditor.BaseEditor
implements PropertyEditor {
    private static final Logger logger = Logger.getLogger(CustomEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final PropertyEditorSupport propertyEditorSupport = new PropertyEditorSupport(this);

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(CustomEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(CustomEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CustomEditor.class.getName(), method, result);
    }

    public CustomEditor() {
    }

    public CustomEditor(CustomEditor sample) {
        if (sample != null) {
            this.setTags(sample.getTags());
        }
    }

    public abstract CustomEditor clone();

    @Override
    public String[] getTags() {
        return this.propertyEditorSupport.getTags();
    }

    public void setTags(String[] tags) {
        this.propertyEditorSupport.setTags(tags);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyEditorSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyEditorSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChanged(String name, Object oldValue, Object newValue) {
        this.propertyEditorSupport.firePropertyChanged(name, oldValue, newValue);
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue();
    }

    protected void parseEditOptions(String opts) {
    }

    @Override
    public void startEditing(Object value, Object context) {
        if (context instanceof TreeTableNodeValue) {
            TreeTableNodeValue ttnv = (TreeTableNodeValue)context;
            if (ttnv.getNode().getData() instanceof Property) {
                Property prop = (Property)ttnv.getNode().getData();
                UiBean uib = prop.getUiBean();
                if (uib != null) {
                    this.parseEditOptions(uib.editorOpts());
                } else {
                    this.parseEditOptions("");
                }
            } else {
                this.parseEditOptions("");
            }
        } else {
            this.parseEditOptions("");
        }
        this.setValue(value);
        super.startEditing(value, context);
    }

    protected abstract JComponent createComponent();

    @Override
    public JComponent getComponent() {
        if (this.component != null) {
            return this.component;
        }
        this.component = this.createComponent();
        return this.component;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Component getCustomEditor() {
        return this.getComponent();
    }

    @Override
    public boolean supportsCustomEditor() {
        JComponent cmp = this.getComponent();
        return cmp != null;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

