/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;
import xyz.cofe.gui.swing.text.ValidatedTextField;

public class DateEditor
extends TextFieldEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(DateEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private List<DateFormat> dateFormats;
    protected String baloonText;
    protected DateFormat preffredDateFormat;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DateEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DateEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DateEditor.class.getName(), method, result);
    }

    public DateEditor(boolean allowNull) {
        super(allowNull);
    }

    public DateEditor(boolean allowNull, List<DateFormat> dateFormats, DateFormat prefferedDateFormat) {
        super(allowNull);
        this.dateFormats = dateFormats;
        this.preffredDateFormat = prefferedDateFormat;
    }

    public DateEditor(boolean allowNull, DateFormat prefferedDateFormat) {
        super(allowNull);
        this.preffredDateFormat = prefferedDateFormat;
    }

    public DateEditor(DateEditor sample) {
        super(sample);
        if (sample != null) {
            this.baloonText = sample.baloonText;
            this.dateFormats = new ArrayList<DateFormat>();
            if (sample.dateFormats != null) {
                for (DateFormat df : sample.dateFormats) {
                    DateFormat cdf = (DateFormat)df.clone();
                    this.dateFormats.add(cdf);
                }
            }
            if (sample.preffredDateFormat != null) {
                this.preffredDateFormat = (DateFormat)sample.preffredDateFormat.clone();
            }
        }
    }

    public DateEditor() {
        super(true);
    }

    @Override
    public DateEditor clone() {
        return new DateEditor(this);
    }

    public static DateEditor getDateEditor(boolean nullable, String prefFormat) {
        return new DateEditor(nullable, new SimpleDateFormat(prefFormat != null ? prefFormat : "yyyy-MM-dd HH:mm:ss.SSSXXX"));
    }

    public static DateEditor getSQLTimeEditor(boolean nullable, String prefFormat) {
        return new DateEditor(nullable, new SimpleDateFormat(prefFormat != null ? prefFormat : "yyyy-MM-dd HH:mm:ss.SSSXXX")){

            @Override
            protected java.util.Date createDate(long t) {
                return new Time(t);
            }
        };
    }

    public static DateEditor getSQLTimestampEditor(boolean nullable, String prefFormat) {
        return new DateEditor(nullable, new SimpleDateFormat(prefFormat != null ? prefFormat : "yyyy-MM-dd HH:mm:ss.SSSXXX")){

            @Override
            protected java.util.Date createDate(long t) {
                return new Timestamp(t);
            }
        };
    }

    public static DateEditor getSQLDateEditor(boolean nullable, String prefFormat) {
        return new DateEditor(nullable, new SimpleDateFormat(prefFormat != null ? prefFormat : "yyyy-MM-dd")){

            @Override
            protected java.util.Date createDate(long t) {
                return new Date(t);
            }
        };
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(java.util.Date.class, this);
        pdb.registerTypeEditor(Time.class, DateEditor.getSQLTimeEditor(true, null));
        pdb.registerTypeEditor(Timestamp.class, DateEditor.getSQLTimestampEditor(true, null));
        pdb.registerTypeEditor(Date.class, DateEditor.getSQLDateEditor(true, null));
    }

    protected java.util.Date createDate(long t) {
        return new java.util.Date(t);
    }

    public synchronized List<DateFormat> getDateFormats() {
        if (this.dateFormats != null) {
            return this.dateFormats;
        }
        this.dateFormats = new ArrayList<DateFormat>();
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd"));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        this.dateFormats.add(new SimpleDateFormat("yyyyMMdd'T'HHmmss"));
        this.dateFormats.add(new SimpleDateFormat("yyyyMMdd'T'HHmm"));
        StringBuilder sb = new StringBuilder();
        sb.append("Supported date formats:\n");
        for (DateFormat o : this.dateFormats) {
            if (!(o instanceof SimpleDateFormat)) continue;
            SimpleDateFormat sdf = (SimpleDateFormat)o;
            sb.append(sdf.toPattern()).append("\n");
        }
        this.baloonText = sb.toString();
        return this.dateFormats;
    }

    protected java.util.Date parse(String txt) {
        List<DateFormat> dfs;
        if (txt == null) {
            return null;
        }
        if ((txt = txt.trim()).length() < 1) {
            return null;
        }
        DateFormat dfPref = this.getPreffredDateFormat();
        if (dfPref != null) {
            try {
                java.util.Date d = dfPref.parse(txt);
                if (d != null) {
                    return this.createDate(d.getTime());
                }
            }
            catch (ParseException ex) {
                DateEditor.logFiner("can't parse {0} with format {1}", txt, dfPref);
            }
        }
        if ((dfs = this.getDateFormats()).isEmpty()) {
            return null;
        }
        for (DateFormat df : dfs) {
            try {
                java.util.Date d = df.parse(txt);
                if (d == null) continue;
                return this.createDate(d.getTime());
            }
            catch (ParseException ex) {
                DateEditor.logFiner("can't parse {0} with format {1}", txt, df);
            }
        }
        return null;
    }

    protected String getBaloonText() {
        if (this.baloonText != null) {
            return this.baloonText;
        }
        this.baloonText = "Date formats";
        return this.baloonText;
    }

    public DateFormat getPreffredDateFormat() {
        if (this.preffredDateFormat == null) {
            List<DateFormat> ldf = this.getDateFormats();
            if (ldf != null && !ldf.isEmpty()) {
                return ldf.get(0);
            }
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX");
        }
        return this.preffredDateFormat;
    }

    public void setPreffredDateFormat(DateFormat preffredDateFormat) {
        this.preffredDateFormat = preffredDateFormat;
    }

    @Override
    protected JTextComponent getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        final ValidatedTextField tf = new ValidatedTextField();
        Predicate<String> parseFilter = new Predicate<String>(){

            public boolean validate(String txt) {
                java.util.Date d = DateEditor.this.parse(txt);
                if (d == null) {
                    tf.setBalloonText(DateEditor.this.getBaloonText());
                    return false;
                }
                return true;
            }
        };
        tf.setFilter(parseFilter);
        tf.setPlaceholder("Enter date");
        tf.setBalloonText("");
        tf.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField = tf;
        return this.textField;
    }

    @Override
    protected Object getTextFieldValue() {
        String txt = this.getTextField().getText();
        java.util.Date d = this.parse(txt);
        if (d == null) {
            JOptionPane.showMessageDialog(null, this.getBaloonText(), "Date format error", 0);
            return null;
        }
        return d;
    }

    @Override
    protected void setTextFieldValue(Object value) {
        DateFormat df;
        if (value instanceof java.util.Date && (df = this.getPreffredDateFormat()) != null) {
            super.setTextFieldValue(df.format((java.util.Date)value));
            return;
        }
        super.setTextFieldValue(value);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

