/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;

public class EnumEditor
extends CustomEditor {
    private static final Logger logger = Logger.getLogger(EnumEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Class classEnum;
    protected boolean allowNull;
    protected int nullIndex;
    protected JComboBox combo = null;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(EnumEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(EnumEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(EnumEditor.class.getName(), method, result);
    }

    public EnumEditor(Class cenum, boolean allowNull) {
        if (cenum == null) {
            throw new IllegalArgumentException("cenum==null");
        }
        if (!cenum.isEnum()) {
            throw new IllegalArgumentException("cenum is not enum");
        }
        this.classEnum = cenum;
        this.allowNull = allowNull;
        T[] consts = cenum.getEnumConstants();
        if (allowNull) {
            consts = Arrays.copyOf(consts, consts.length + 1);
            consts[consts.length - 1] = null;
            this.nullIndex = consts.length - 1;
        }
        BasicComboBoxRenderer cr = new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object renderValue = value;
                if (value == null) {
                    renderValue = "null";
                }
                super.getListCellRendererComponent((JList<?>)list, renderValue, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setIcon(Icons.getNullIcon());
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        this.combo = new JComboBox(consts);
        this.combo.setRenderer(cr);
        SwingListener.onItemStateChanged(this.combo, new Reciver<ItemEvent>(){

            public void recive(ItemEvent obj) {
                EnumEditor.this.fireEditingStopped(EnumEditor.this);
            }
        });
    }

    public EnumEditor(EnumEditor sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.classEnum = sample.classEnum;
        this.allowNull = sample.allowNull;
        T[] consts = this.classEnum.getEnumConstants();
        if (this.allowNull) {
            consts = Arrays.copyOf(consts, consts.length + 1);
            consts[consts.length - 1] = null;
            this.nullIndex = consts.length - 1;
        }
        BasicComboBoxRenderer cr = new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object renderValue = value;
                if (value == null) {
                    renderValue = "null";
                }
                super.getListCellRendererComponent((JList<?>)list, renderValue, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setIcon(Icons.getNullIcon());
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        this.combo = new JComboBox(consts);
        this.combo.setRenderer(cr);
        SwingListener.onItemStateChanged(this.combo, new Reciver<ItemEvent>(){

            public void recive(ItemEvent obj) {
                EnumEditor.this.fireEditingStopped(EnumEditor.this);
            }
        });
    }

    @Override
    public EnumEditor clone() {
        return new EnumEditor(this);
    }

    @Override
    protected JComponent createComponent() {
        return this.combo;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            if (!this.allowNull) {
                throw new IllegalArgumentException("value == null");
            }
            this.combo.setSelectedIndex(this.nullIndex);
            return;
        }
        this.combo.setSelectedItem(value);
    }

    @Override
    public Object getValue() {
        int selIdx = this.combo.getSelectedIndex();
        if (selIdx == this.nullIndex && this.allowNull) {
            return null;
        }
        return this.combo.getSelectedItem();
    }

    @Override
    public String getJavaInitializationString() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        return val.toString();
    }

    @Override
    public String getAsText() {
        Object v = this.getValue();
        return v == null ? "null" : v.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.equals("null")) {
            if (this.allowNull) {
                this.combo.setSelectedIndex(this.nullIndex);
                return;
            }
            throw new IllegalArgumentException("text == null");
        }
        this.combo.setSelectedItem(Enum.valueOf(this.classEnum, text));
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

