/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.GuiUtil;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.editor.ExternalEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditorConsumer;

public class ExternalTextAreaEditor
implements ExternalEditor {
    private static final Logger logger = Logger.getLogger(ExternalTextAreaEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private JFrame frame = null;
    private JScrollPane scroll = null;
    private JTextArea textArea = null;
    private ExternalEditorConsumer consumer = null;
    private Component context;
    protected CloseableSet textChangedListeners = new CloseableSet();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ExternalTextAreaEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ExternalTextAreaEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ExternalTextAreaEditor.class.getName(), method, result);
    }

    protected void buildUI() {
        this.frame = new JFrame("text editor");
        this.frame.setSize(400, 300);
        this.frame.setDefaultCloseOperation(2);
        SwingListener.onWindowClosing(this.frame, new Reciver<WindowEvent>(){

            public void recive(WindowEvent obj) {
                if (ExternalTextAreaEditor.this.consumer != null) {
                    ExternalTextAreaEditor.this.consumer.closed(ExternalTextAreaEditor.this);
                }
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.scroll = new JScrollPane(this.textArea);
        this.frame.getContentPane().add(this.scroll);
        JPanel buttons = new JPanel(new FlowLayout());
        this.frame.getContentPane().add((Component)buttons, "South");
        JButton okButton = new JButton("Ok");
        JButton cancelButton = new JButton("Cancel");
        buttons.add(cancelButton);
        buttons.add(okButton);
        SwingListener.onActionPerformed(okButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                if (ExternalTextAreaEditor.this.consumer != null) {
                    ExternalTextAreaEditor.this.consumer.updated(ExternalTextAreaEditor.this, ExternalTextAreaEditor.this.getValue());
                    if (ExternalTextAreaEditor.this.frame != null) {
                        ExternalTextAreaEditor.this.frame.setVisible(false);
                        ExternalTextAreaEditor.this.frame.dispose();
                        ExternalTextAreaEditor.this.consumer.closed(ExternalTextAreaEditor.this);
                    }
                }
            }
        });
        SwingListener.onActionPerformed(cancelButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                if (ExternalTextAreaEditor.this.consumer != null && ExternalTextAreaEditor.this.frame != null) {
                    ExternalTextAreaEditor.this.frame.setVisible(false);
                    ExternalTextAreaEditor.this.frame.dispose();
                    ExternalTextAreaEditor.this.consumer.canceled(ExternalTextAreaEditor.this);
                }
            }
        });
        this.listenChanges(true);
    }

    protected void listenChanges(boolean listen) {
        this.textChangedListeners.closeAll();
        if (listen) {
            Closeable cl = SwingListener.onFocusLost(this.textArea, new Reciver<FocusEvent>(){

                public void recive(FocusEvent obj) {
                    if (ExternalTextAreaEditor.this.consumer != null) {
                        ExternalTextAreaEditor.this.consumer.updated(ExternalTextAreaEditor.this, ExternalTextAreaEditor.this.getValue());
                    }
                }
            });
            this.textChangedListeners.add(cl);
        }
    }

    @Override
    public void setContextComponent(Component contextComponent) {
        this.context = contextComponent;
    }

    @Override
    public Component getContextComponent() {
        return this.context;
    }

    @Override
    public void setConsumer(ExternalEditorConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public ExternalEditorConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void open(Object value) {
        if (this.frame == null || !this.frame.isVisible()) {
            this.buildUI();
        }
        if (this.context != null && this.context.isVisible()) {
            Point loc = this.context.getLocationOnScreen();
            Dimension sz = this.context.getSize();
            Rectangle screenRect = GuiUtil.getScreenRectangle();
            Point start = new Point(loc.x, loc.y + sz.height);
            int bottomFree = screenRect.height - start.y;
            if (bottomFree < this.frame.getHeight()) {
                start = new Point(loc.x, loc.y - this.frame.getHeight());
            }
            this.frame.setLocation(start);
        }
        this.listenChanges(false);
        this.setValue(value);
        this.listenChanges(true);
        this.frame.setVisible(true);
        this.frame.toFront();
        if (this.textArea != null) {
            this.textArea.requestFocus();
        }
    }

    @Override
    public boolean isOpen() {
        return this.frame != null && this.frame.isVisible();
    }

    @Override
    public void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
            this.listenChanges(false);
        }
    }

    @Override
    public void setValue(Object value) {
        this.listenChanges(false);
        if (this.textArea != null) {
            this.textArea.setText(value != null ? value.toString() : "");
        }
        this.listenChanges(true);
    }

    @Override
    public Object getValue() {
        if (this.textArea != null) {
            return this.textArea.getText();
        }
        return null;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

