/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.io.File;
import xyz.cofe.text.parser.LexerUtil;
import xyz.cofe.text.parser.ListLexer;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.Identifier;
import xyz.cofe.text.parser.lex.IdentifierParser;
import xyz.cofe.text.parser.lex.Keyword;
import xyz.cofe.text.parser.lex.KeywordsParser;
import xyz.cofe.text.parser.lex.NumberConst;
import xyz.cofe.text.parser.lex.NumberConstParser;
import xyz.cofe.text.parser.lex.TextConst;
import xyz.cofe.text.parser.lex.TextConstParser;
import xyz.cofe.text.parser.lex.WhiteSpace;
import xyz.cofe.text.parser.lex.WhiteSpaceParser;

public class FileEditor
extends CustomEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(FileEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private JPanel panel;
    private JTextComponent fileTextField;
    private JLabel nullButton;
    private JLabel dlgButton;
    protected Object defaultFile;
    protected FileSelectionMode fileSelectionMode = FileSelectionMode.FilesAndDirs;
    protected DialogType dialogType = DialogType.Open;
    private String saveLabel;
    private String openLabel;
    private String title;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FileEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FileEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FileEditor.class.getName(), method, result);
    }

    public FileEditor() {
    }

    public FileEditor(FileEditor sample) {
    }

    @Override
    public FileEditor clone() {
        return new FileEditor(this);
    }

    public void setNullSelected(boolean selected) {
        boolean old = this.isNullSelected();
        if (this.nullButton != null) {
            Icon icn1 = FileEditor.getNullSelectedIcon();
            Icon icn2 = FileEditor.getNullUnSelectedIcon();
            this.nullButton.setIcon(selected ? icn1 : icn2);
        }
        boolean cur = this.isNullSelected();
        this.firePropertyChanged("nullSelected", old, cur);
    }

    public boolean isNullSelected() {
        if (this.nullButton == null) {
            return false;
        }
        Icon icn = this.nullButton.getIcon();
        return icn == FileEditor.getNullSelectedIcon();
    }

    public void setNullable(boolean nullable) {
        if (this.nullButton == null) {
            return;
        }
        boolean old = this.isNullable();
        this.nullButton.setVisible(nullable);
        if (this.panel != null) {
            this.panel.revalidate();
            this.panel.invalidate();
            this.panel.repaint();
        }
        boolean cur = this.isNullable();
        if (Objects.equals(old, cur)) {
            this.firePropertyChanged("nullable", old, cur);
        }
    }

    public boolean isNullable() {
        if (this.nullButton == null) {
            return false;
        }
        return this.nullButton.isVisible();
    }

    public Object getDefaultFile() {
        return this.defaultFile;
    }

    public void setDefaultFile(Object defaultFile) {
        this.defaultFile = defaultFile;
    }

    @Override
    protected JComponent createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fileTextField = new JTextField();
        this.fileTextField.setBorder(new EmptyBorder(0, 0, 0, 0));
        SwingListener.onTextChanged(this.fileTextField, new Runnable(){

            @Override
            public void run() {
                FileEditor.this.setNullSelected(false);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panel.add((Component)this.fileTextField, gbc);
        this.nullButton = new JLabel(FileEditor.getNullIcon());
        this.nullButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.nullButton.setCursor(Cursor.getPredefinedCursor(12));
        SwingListener.onMouseClicked(this.nullButton, new Reciver<MouseEvent>(){

            public void recive(MouseEvent me) {
                if (me.getButton() == 1) {
                    FileEditor.this.setNullSelected(!FileEditor.this.isNullSelected());
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 3, 0, 0);
        this.panel.add((Component)this.nullButton, gbc);
        this.dlgButton = new JLabel(FileEditor.getEditIcon());
        this.dlgButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.dlgButton.setCursor(Cursor.getPredefinedCursor(12));
        SwingListener.onMouseClicked(this.dlgButton, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                JTextComponent txtcmpt = FileEditor.this.fileTextField;
                if (txtcmpt == null) {
                    return;
                }
                String newtxt = FileEditor.this.openFileDialog(txtcmpt.getText());
                if (newtxt != null) {
                    txtcmpt.setText(newtxt);
                    FileEditor.this.setNullSelected(false);
                    FileEditor.this.fireEditingStopped(FileEditor.this);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 3, 0, 0);
        this.panel.add((Component)this.dlgButton, gbc);
        this.panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return this.panel;
    }

    public FileSelectionMode getFileSelectionMode() {
        if (this.fileSelectionMode == null) {
            this.fileSelectionMode = FileSelectionMode.FilesAndDirs;
        }
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(FileSelectionMode fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public DialogType getDialogType() {
        if (this.dialogType == null) {
            this.dialogType = DialogType.Open;
        }
        return this.dialogType;
    }

    public void setDialogType(DialogType dialogType) {
        this.dialogType = dialogType;
    }

    public String getSaveLabel() {
        if (this.saveLabel == null) {
            return "Save";
        }
        return this.saveLabel;
    }

    public void setSaveLabel(String saveLabel) {
        this.saveLabel = saveLabel;
    }

    public String getOpenLabel() {
        if (this.openLabel == null) {
            return "Open";
        }
        return this.openLabel;
    }

    public void setOpenLabel(String openLabel) {
        this.openLabel = openLabel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String str) {
        this.title = str;
    }

    protected Map<String, Object> parseOptions(String opts) {
        LinkedHashMap<String, Object> hm = new LinkedHashMap<String, Object>();
        if (opts != null) {
            ListLexer llexer = new ListLexer();
            llexer.getParsers().add(new KeywordsParser(true, new String[]{"=", ";", "save", "open", "files", "dirs", "files+dirs", "dirs+files"}));
            llexer.getParsers().add(new IdentifierParser());
            llexer.getParsers().add(new TextConstParser());
            llexer.getParsers().add(new NumberConstParser());
            llexer.getParsers().add(new WhiteSpaceParser("ws"));
            List toks = llexer.parse(opts);
            toks = LexerUtil.filter((List)toks, (Class[])new Class[]{WhiteSpace.class});
            Identifier prop = null;
            int state = 0;
            block7: for (Token tok : toks) {
                switch (state) {
                    case 0: {
                        Identifier id;
                        if (!(tok instanceof Identifier)) break;
                        prop = id = (Identifier)tok;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (tok instanceof Keyword && ((Keyword)tok).getKeyword().equals("=")) {
                            state = 2;
                            break;
                        }
                        if (tok instanceof Keyword && ((Keyword)tok).getKeyword().equals(";")) {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case 2: {
                        if (tok instanceof Keyword) {
                            Keyword kw = (Keyword)tok;
                            if (kw.getKeyword().equals(";")) {
                                state = 0;
                                break;
                            }
                            if (prop == null) continue block7;
                            hm.put(prop.getMatchedText(), kw.getKeyword());
                            state = 5;
                            break;
                        }
                        if (tok instanceof NumberConst) {
                            if (prop == null) break;
                            hm.put(prop.getMatchedText(), ((NumberConst)tok).getNumber());
                            state = 5;
                            break;
                        }
                        if (!(tok instanceof TextConst) || prop == null) break;
                        hm.put(prop.getMatchedText(), ((TextConst)tok).getDecodedText());
                        state = 5;
                        break;
                    }
                    case 5: {
                        if (tok instanceof Keyword && ((Keyword)tok).getKeyword().equals(";")) {
                            state = 0;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    case -1: {
                        if (!(tok instanceof Keyword) || !((Keyword)tok).getKeyword().equals(";")) break;
                        state = 0;
                    }
                }
            }
        }
        return hm;
    }

    @Override
    protected void parseEditOptions(String opts) {
        this.fileSelectionMode = FileSelectionMode.FilesAndDirs;
        this.dialogType = DialogType.Open;
        this.title = null;
        if (opts != null) {
            Map<String, Object> hm = this.parseOptions(opts);
            if (hm.containsKey("type")) {
                this.setDialogType("save".equalsIgnoreCase(hm.get("type").toString()) ? DialogType.Save : DialogType.Open);
            }
            if (hm.containsKey("mode")) {
                String mode;
                switch (mode = hm.get("mode").toString().toLowerCase()) {
                    case "files": {
                        this.setFileSelectionMode(FileSelectionMode.FilesOnly);
                        break;
                    }
                    case "dirs": {
                        this.setFileSelectionMode(FileSelectionMode.DirsOnly);
                        break;
                    }
                    case "files+dirs": {
                        this.setFileSelectionMode(FileSelectionMode.FilesAndDirs);
                        break;
                    }
                    case "dirs+files": {
                        this.setFileSelectionMode(FileSelectionMode.FilesAndDirs);
                    }
                }
            }
            if (hm.containsKey("title")) {
                this.setTitle(hm.get("title").toString());
            }
        }
    }

    protected String openFileDialog(String currentFilename) {
        JFileChooser fc = new JFileChooser();
        java.io.File currentFile = currentFilename != null ? new java.io.File(currentFilename) : null;
        java.io.File curDir = currentFile != null ? currentFile.getParentFile() : new java.io.File(".").getAbsoluteFile();
        fc.setCurrentDirectory(curDir);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(this.getFileSelectionMode().value());
        fc.setDialogType(this.getDialogType().value());
        if (this.title != null) {
            fc.setDialogTitle(this.title);
        }
        int dlgres = -1;
        switch (this.getDialogType()) {
            case Open: {
                dlgres = fc.showDialog(this.panel, this.getOpenLabel());
                break;
            }
            case Save: {
                dlgres = fc.showDialog(this.panel, this.getSaveLabel());
            }
        }
        if (dlgres == 0) {
            java.io.File selfile = fc.getSelectedFile();
            return selfile != null ? selfile.toString() : null;
        }
        return null;
    }

    protected Object createFileFromString(String text) {
        return new java.io.File(text);
    }

    @Override
    public void setValue(Object value) {
        if (this.fileTextField == null) {
            return;
        }
        if (value instanceof java.io.File) {
            this.fileTextField.setText(value.toString());
            this.setNullSelected(false);
        } else if (value instanceof File) {
            this.fileTextField.setText(value.toString());
            this.setNullSelected(false);
        } else if (value instanceof Path) {
            this.fileTextField.setText(value.toString());
            this.setNullSelected(false);
        } else {
            this.fileTextField.setText("");
            this.setNullSelected(true);
        }
    }

    @Override
    public Object getValue() {
        JTextComponent txtcmpt;
        if (this.isNullable() && this.isNullSelected()) {
            return null;
        }
        if (!this.isNullable() && (this.isNullSelected() || this.fileTextField != null && this.fileTextField.getText().length() == 0)) {
            Object deffile = this.getDefaultFile();
            if (deffile instanceof String) {
                return this.createFileFromString(deffile.toString());
            }
            if (deffile instanceof java.io.File || deffile instanceof Path || deffile instanceof File) {
                return deffile;
            }
        }
        if ((txtcmpt = this.fileTextField) != null) {
            String txt = txtcmpt.getText();
            return this.createFileFromString(txt);
        }
        return null;
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        JTextComponent txt = this.fileTextField;
        return txt != null ? txt.getText() : "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        JTextComponent txt = this.fileTextField;
        if (txt != null) {
            txt.setText(text != null ? text : "");
        }
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        FileEditor fed1 = new FileEditor();
        pdb.registerTypeEditor(java.io.File.class, fed1);
        FileEditor fed2 = new FileEditor(){

            @Override
            protected Object createFileFromString(String text) {
                return Paths.get(text, new String[0]);
            }
        };
        pdb.registerTypeEditor(Path.class, fed2);
        FileEditor fed3 = new FileEditor(){

            @Override
            protected Object createFileFromString(String text) {
                return new File(text, new String[0]);
            }
        };
        pdb.registerTypeEditor(File.class, fed3);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static enum DialogType {
        Open,
        Save;


        public int value() {
            switch (this) {
                case Open: {
                    return 0;
                }
                case Save: {
                    return 1;
                }
            }
            return 1;
        }
    }

    public static enum FileSelectionMode {
        FilesOnly,
        DirsOnly,
        FilesAndDirs;


        public int value() {
            switch (this) {
                case DirsOnly: {
                    return 1;
                }
                case FilesOnly: {
                    return 0;
                }
                case FilesAndDirs: {
                    return 2;
                }
            }
            return 2;
        }
    }
}

