/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;
import xyz.cofe.gui.swing.text.ValidatedTextField;

public class IntegerEditor
extends TextFieldEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(IntegerEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(IntegerEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(IntegerEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(IntegerEditor.class.getName(), method, result);
    }

    public IntegerEditor() {
        super(true);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(Integer.class, this, 1.0);
    }

    @Override
    protected JTextComponent getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        final ValidatedTextField tf = new ValidatedTextField();
        Predicate<String> parseFilter = new Predicate<String>(){

            public boolean validate(String txt) {
                try {
                    boolean anull = IntegerEditor.this.isAllowNull();
                    if (anull && (txt == null || txt.length() == 0)) {
                        return true;
                    }
                    Integer.parseInt(txt);
                    return true;
                }
                catch (NumberFormatException ex) {
                    tf.setBalloonText("format exception: " + ex.getLocalizedMessage());
                    return false;
                }
            }
        };
        tf.setFilter(parseFilter);
        tf.setPlaceholder("Enter number (Integer)");
        tf.setBalloonText("");
        tf.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField = tf;
        return this.textField;
    }

    @Override
    protected Object getTextFieldValue() {
        String txt = this.getTextField().getText();
        try {
            if (this.isAllowNull() && (txt == null || txt.length() == 0)) {
                return null;
            }
            int val = Integer.parseInt(txt);
            Integer ival = val;
            return ival;
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), "NumberFormatException", 0);
            return 0;
        }
    }

    @Override
    protected void setTextFieldValue(Object value) {
        if (value instanceof Integer) {
            super.setTextFieldValue(Integer.toString((Integer)value));
            return;
        }
        super.setTextFieldValue(value);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

