/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditorConsumer;
import xyz.cofe.gui.swing.properties.editor.ExternalTextAreaEditor;

public class MultilineEditor
extends CustomEditor {
    private static final Logger logger = Logger.getLogger(MultilineEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected JPanel inlineEditorPanel;
    protected JLabel inlineLabel;
    protected JButton openEditor;
    protected ExternalEditor externalEditor = null;
    protected ExternalEditorConsumer externalEditorConsumer = new ExternalEditorConsumer(){

        @Override
        public void canceled(ExternalEditor ed) {
            if (ed == null) {
                return;
            }
            if (MultilineEditor.this.externalEditor != ed) {
                return;
            }
            if (MultilineEditor.this.prestartValues.containsKey(ed)) {
                MultilineEditor.this.setValue(MultilineEditor.this.prestartValues.get(ed));
            }
            MultilineEditor.this.fireEditingCanceled(MultilineEditor.this);
        }

        @Override
        public void closed(ExternalEditor ed) {
            if (ed == null) {
                return;
            }
            if (MultilineEditor.this.externalEditor != ed) {
                return;
            }
            MultilineEditor.this.fireEditingStopped(MultilineEditor.this);
        }

        @Override
        public void updated(ExternalEditor ed, Object value) {
            if (ed == null) {
                return;
            }
            if (MultilineEditor.this.externalEditor != ed) {
                return;
            }
            MultilineEditor.this.setValue(value, false);
        }
    };
    protected WeakHashMap<ExternalEditor, Object> prestartValues = new WeakHashMap();
    private String value = null;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(MultilineEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(MultilineEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(MultilineEditor.class.getName(), method, result);
    }

    public MultilineEditor() {
        this.buildUI();
    }

    public MultilineEditor(MultilineEditor sample) {
        this.buildUI();
    }

    private void buildUI() {
        this.inlineEditorPanel = new JPanel();
        this.inlineEditorPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.inlineEditorPanel.setBackground(Color.white);
        this.inlineEditorPanel.setLayout(new BorderLayout());
        this.inlineLabel = new JLabel();
        this.inlineEditorPanel.add(this.inlineLabel);
        this.openEditor = new JButton("..");
        SwingListener.onActionPerformed(this.openEditor, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                MultilineEditor.this.openEditor();
            }
        });
        this.inlineEditorPanel.add((Component)this.openEditor, "East");
        this.externalEditor = new ExternalTextAreaEditor();
        this.externalEditor.setContextComponent(this.inlineEditorPanel);
        this.externalEditor.setConsumer(this.externalEditorConsumer);
    }

    protected void openEditor() {
        if (this.externalEditor != null) {
            this.prestartValues.put(this.externalEditor, this.value);
            this.externalEditor.open(this.value);
        }
    }

    @Override
    public MultilineEditor clone() {
        return new MultilineEditor(this);
    }

    @Override
    protected JComponent createComponent() {
        return this.inlineEditorPanel;
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    protected void setValue(Object value, boolean withExternal) {
        String string = this.value = value != null ? value.toString() : null;
        if (this.inlineLabel != null) {
            this.inlineLabel.setText(value != null ? value.toString() : null);
        }
        if (withExternal && this.externalEditor != null && this.externalEditor.isOpen()) {
            this.externalEditor.setValue(value);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getJavaInitializationString() {
        return this.value;
    }

    @Override
    public String getAsText() {
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.value = text;
        if (this.externalEditor != null && this.externalEditor.isOpen()) {
            this.externalEditor.setValue(this.value);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

