/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.ExternalEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditorConsumer;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;
import xyz.cofe.gui.swing.text.ValidatedTextField;

public class PatternEditor
extends TextFieldEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(PatternEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected ExternalEditor patternExternalEditor;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PatternEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(PatternEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PatternEditor.class.getName(), method, result);
    }

    public PatternEditor() {
        super(true);
    }

    public PatternEditor(boolean allowNull) {
        super(allowNull);
    }

    public PatternEditor(TextFieldEditor sample) {
        super(sample);
    }

    @Override
    public PatternEditor clone() {
        return new PatternEditor(this);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        PatternEditor pe = new PatternEditor();
        pe.setExternalEditor(this.getPatternExternalEditor());
        pdb.registerTypeEditor(Pattern.class, pe);
    }

    @Override
    protected JTextComponent getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        final ValidatedTextField tf = new ValidatedTextField();
        Predicate<String> parseFilter = new Predicate<String>(){

            public boolean validate(String txt) {
                try {
                    if (PatternEditor.this.isAllowNull() && (txt == null || txt.length() == 0)) {
                        return true;
                    }
                    Pattern ptrn = Pattern.compile(txt);
                    return true;
                }
                catch (PatternSyntaxException ex) {
                    String msg = ex.getDescription();
                    msg = msg != null ? msg : ex.getLocalizedMessage();
                    msg = msg != null ? msg : ex.getMessage();
                    msg = msg != null ? msg : ex.getClass().getName();
                    tf.setBalloonText("format exception: " + ex.getLocalizedMessage());
                    return false;
                }
            }
        };
        tf.setFilter(parseFilter);
        tf.setPlaceholder("Enter regex");
        tf.setBalloonText("");
        tf.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField = tf;
        return this.textField;
    }

    @Override
    protected Object getTextFieldValue() {
        Object otxt = super.getTextFieldValue();
        if (otxt != null) {
            String txt = otxt.toString();
            try {
                Pattern ptrn = Pattern.compile(txt);
                return ptrn;
            }
            catch (Throwable err) {
                PatternEditor.logException(err);
                return null;
            }
        }
        return super.getTextFieldValue();
    }

    @Override
    protected void setTextFieldValue(Object value) {
        if (value instanceof Pattern) {
            Pattern ptrn = (Pattern)value;
            super.setTextFieldValue(ptrn.pattern());
            return;
        }
        super.setTextFieldValue(value);
    }

    public ExternalEditor getPatternExternalEditor() {
        if (this.patternExternalEditor != null) {
            return this.patternExternalEditor;
        }
        this.patternExternalEditor = new ExternalEditor(){
            private Component cmpt;
            private ExternalEditorConsumer consum;
            private WeakReference<PatternExternalDlg> dlg;

            @Override
            public void setContextComponent(Component contextComponent) {
                this.cmpt = contextComponent;
            }

            @Override
            public Component getContextComponent() {
                return this.cmpt;
            }

            @Override
            public void setConsumer(ExternalEditorConsumer consumer) {
                this.consum = consumer;
            }

            @Override
            public ExternalEditorConsumer getConsumer() {
                return this.consum;
            }

            @Override
            public void open(Object value) {
                this.close();
                PatternExternalDlg pdlg = new PatternExternalDlg();
                this.dlg = new WeakReference<PatternExternalDlg>(pdlg);
                if (value instanceof Pattern) {
                    pdlg.setPatternText(((Pattern)value).pattern());
                } else {
                    pdlg.setPatternText("");
                }
                pdlg.setConsumer(this.consum);
                pdlg.setExternalEditor(this);
                if (this.cmpt != null) {
                    pdlg.setLocationRelativeTo(this.cmpt);
                }
                pdlg.setVisible(true);
            }

            @Override
            public boolean isOpen() {
                if (this.dlg == null) {
                    return false;
                }
                PatternExternalDlg d = (PatternExternalDlg)this.dlg.get();
                if (d == null) {
                    return false;
                }
                return d.isVisible();
            }

            @Override
            public void close() {
                if (this.dlg == null) {
                    return;
                }
                PatternExternalDlg d = (PatternExternalDlg)this.dlg.get();
                if (d == null) {
                    return;
                }
                d.setVisible(false);
            }

            @Override
            public void setValue(Object value) {
                if (this.dlg == null) {
                    return;
                }
                PatternExternalDlg d = (PatternExternalDlg)this.dlg.get();
                if (d == null) {
                    return;
                }
                if (value instanceof Pattern) {
                    Pattern ptn = (Pattern)value;
                    d.setPatternText(ptn.pattern());
                } else {
                    d.setPatternText("");
                }
            }

            @Override
            public Object getValue() {
                if (this.dlg == null) {
                    return null;
                }
                PatternExternalDlg d = (PatternExternalDlg)this.dlg.get();
                if (d == null) {
                    return null;
                }
                String ptrnText = d.getPatternText();
                if (ptrnText == null) {
                    return null;
                }
                try {
                    Pattern ptrn = Pattern.compile(ptrnText);
                    return ptrn;
                }
                catch (Throwable err) {
                    return null;
                }
            }
        };
        return this.patternExternalEditor;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class PatternExternalDlg
    extends JDialog {
        protected JTextArea regexTextArea;
        protected JTextArea inputTextArea;
        protected JTextArea matchTextArea;
        protected JButton testMatchButton;
        protected JButton okButton;
        protected ExternalEditorConsumer consumer;
        protected ExternalEditor externalEditor;

        public PatternExternalDlg() {
            this.initUI();
        }

        protected void initUI() {
            this.getContentPane().setLayout(new BorderLayout());
            this.regexTextArea = new JTextArea();
            this.regexTextArea.setText("regex");
            this.inputTextArea = new JTextArea();
            this.inputTextArea.setText("input text");
            this.matchTextArea = new JTextArea();
            this.matchTextArea.setText("match result");
            JPanel matchPln = new JPanel();
            JPanel matchBtns = new JPanel();
            matchBtns.setLayout(new FlowLayout());
            this.testMatchButton = new JButton("match");
            matchBtns.add(this.testMatchButton);
            this.okButton = new JButton("ok");
            matchBtns.add(this.okButton);
            matchPln.setLayout(new BorderLayout());
            matchPln.add((Component)matchBtns, "South");
            matchPln.add((Component)new JScrollPane(this.matchTextArea), "Center");
            JSplitPane split1 = new JSplitPane(0, new JScrollPane(this.regexTextArea), new JScrollPane(this.inputTextArea));
            JSplitPane split2 = new JSplitPane(1, split1, matchPln);
            this.getContentPane().add((Component)split2, "Center");
            this.setMinimumSize(new Dimension(400, 200));
            this.pack();
            split1.setDividerLocation(0.5);
            split1.setResizeWeight(0.5);
            split2.setDividerLocation(0.5);
            split2.setResizeWeight(0.5);
            SwingListener.onActionPerformed(this.okButton, new Reciver<ActionEvent>(){

                public void recive(ActionEvent obj) {
                    PatternExternalDlg.this.okClicked();
                }
            });
            SwingListener.onActionPerformed(this.testMatchButton, new Reciver<ActionEvent>(){

                public void recive(ActionEvent obj) {
                    PatternExternalDlg.this.matchClicked();
                }
            });
            this.setDefaultCloseOperation(2);
            this.setTitle("Regex pattern editor");
        }

        protected void okClicked() {
            if (this.consumer != null && this.externalEditor != null) {
                this.consumer.updated(this.externalEditor, this.externalEditor.getValue());
            }
            this.setVisible(false);
            if (this.consumer != null && this.externalEditor != null) {
                this.consumer.closed(this.externalEditor);
            }
        }

        protected void matchClicked() {
            Pattern ptrn = null;
            try {
                ptrn = Pattern.compile(this.getPatternText());
                Matcher m = ptrn.matcher(this.inputTextArea.getText());
                if (m.matches()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("matches() = true\n");
                    int gc = m.groupCount();
                    for (int gi = 1; gi <= gc; ++gi) {
                        sb.append("group ").append(gi).append(": ").append(m.group(gi)).append("\n");
                    }
                    this.matchTextArea.setText(sb.toString());
                } else {
                    this.matchTextArea.setText("matches() = false");
                }
            }
            catch (Throwable err) {
                this.matchTextArea.setText(err.toString());
            }
        }

        public void setPatternText(String pattern) {
            this.regexTextArea.setText(pattern != null ? pattern : "");
        }

        public String getPatternText() {
            return this.regexTextArea.getText();
        }

        public ExternalEditorConsumer getConsumer() {
            return this.consumer;
        }

        public void setConsumer(ExternalEditorConsumer consumer) {
            this.consumer = consumer;
        }

        public ExternalEditor getExternalEditor() {
            return this.externalEditor;
        }

        public void setExternalEditor(ExternalEditor externalEditor) {
            this.externalEditor = externalEditor;
        }
    }
}

