/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.AbstractPropertyEditor;
import xyz.cofe.text.Text;

public class StringLinePropertyEditor
extends AbstractPropertyEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(StringLinePropertyEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected JPanel panel = new JPanel(new BorderLayout());
    protected JTextField textField = new JTextField();
    protected JCheckBox nullCheckBox;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(StringLinePropertyEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(StringLinePropertyEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(StringLinePropertyEditor.class.getName(), method, result);
    }

    public StringLinePropertyEditor() {
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.nullCheckBox = new JCheckBox();
        this.nullCheckBox.setText("null");
        Reciver<KeyEvent> cons = new Reciver<KeyEvent>(){

            public void recive(KeyEvent obj) {
                StringLinePropertyEditor.this.nullCheckBox.setSelected(false);
            }
        };
        SwingListener.onKeyPressed(this.textField, cons);
        SwingListener.onKeyTyped(this.textField, cons);
        this.panel.add((Component)this.textField, "Center");
        this.panel.add((Component)this.nullCheckBox, "East");
    }

    public StringLinePropertyEditor(StringLinePropertyEditor sample) {
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.nullCheckBox = new JCheckBox();
        this.nullCheckBox.setText("null");
        Reciver<KeyEvent> cons = new Reciver<KeyEvent>(){

            public void recive(KeyEvent obj) {
                StringLinePropertyEditor.this.nullCheckBox.setSelected(false);
            }
        };
        SwingListener.onKeyPressed(this.textField, cons);
        SwingListener.onKeyTyped(this.textField, cons);
        this.panel.add((Component)this.textField, "Center");
        this.panel.add((Component)this.nullCheckBox, "East");
    }

    @Override
    public StringLinePropertyEditor clone() {
        return new StringLinePropertyEditor(this);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb == null) {
            return;
        }
        pdb.registerTypeEditor(String.class, this, 0.5);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.textField.setText("");
            this.nullCheckBox.setSelected(true);
        } else {
            this.textField.setText(value.toString());
            this.nullCheckBox.setSelected(false);
        }
    }

    @Override
    public Object getValue() {
        if (this.nullCheckBox.isSelected()) {
            return null;
        }
        return this.getAsText();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getJavaInitializationString() {
        if (this.nullCheckBox.isSelected()) {
            return "null";
        }
        return Text.encodeStringConstant((String)this.getAsText());
    }

    @Override
    public String getAsText() {
        return this.textField.getText();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        this.textField.setText(text);
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

