/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.properties.SetPropertyEditorOpts;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditor;
import xyz.cofe.gui.swing.properties.editor.ExternalEditorConsumer;

public class TextFieldEditor
extends CustomEditor
implements SetPropertyEditorOpts {
    private static final Logger logger = Logger.getLogger(TextFieldEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private boolean allowNull;
    private JLabel nullButton;
    protected JTextComponent textField;
    private JLabel extEditorButton;
    protected ExternalEditor externalEditor = null;
    protected WeakHashMap<ExternalEditor, Object> prestartValues = new WeakHashMap();
    protected ExternalEditorConsumer externalEditorConsumer = new ExternalEditorConsumer(){

        @Override
        public void canceled(ExternalEditor ed) {
            if (ed == null) {
                return;
            }
            if (TextFieldEditor.this.externalEditor != ed) {
                return;
            }
            if (TextFieldEditor.this.prestartValues.containsKey(ed)) {
                TextFieldEditor.this.setValue(TextFieldEditor.this.prestartValues.get(ed));
            }
            TextFieldEditor.this.fireEditingCanceled(TextFieldEditor.this);
        }

        @Override
        public void closed(ExternalEditor ed) {
            if (ed == null) {
                return;
            }
            if (TextFieldEditor.this.externalEditor != ed) {
                return;
            }
            TextFieldEditor.this.fireEditingStopped(TextFieldEditor.this);
        }

        @Override
        public void updated(ExternalEditor ed, Object value) {
            if (ed == null) {
                return;
            }
            if (TextFieldEditor.this.externalEditor != ed) {
                return;
            }
            TextFieldEditor.this.setValue(value, false);
        }
    };
    protected JPanel panel;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TextFieldEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TextFieldEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TextFieldEditor.class.getName(), method, result);
    }

    public TextFieldEditor(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public TextFieldEditor(TextFieldEditor sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.allowNull = sample.allowNull;
    }

    @Override
    public CustomEditor clone() {
        return new TextFieldEditor(this);
    }

    @Override
    public void setPropertyEditorOpts(String opts) {
    }

    @Override
    public void startEditing(Object value, Object context) {
        super.startEditing(value, context);
    }

    protected JLabel getNullButton() {
        if (this.nullButton != null) {
            return this.nullButton;
        }
        this.nullButton = new JLabel(TextFieldEditor.getNullIcon());
        this.nullButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.nullButton.setCursor(Cursor.getPredefinedCursor(12));
        SwingListener.onMouseClicked(this.nullButton, new Reciver<MouseEvent>(){

            public void recive(MouseEvent me) {
                if (me.getButton() == 1) {
                    TextFieldEditor.this.setNullSelected(!TextFieldEditor.this.isNullSelected());
                }
            }
        });
        return this.nullButton;
    }

    public void setNullSelected(boolean selected) {
        boolean old = this.isNullSelected();
        if (this.nullButton != null) {
            Icon icn1 = TextFieldEditor.getNullSelectedIcon();
            Icon icn2 = TextFieldEditor.getNullUnSelectedIcon();
            this.nullButton.setIcon(selected ? icn1 : icn2);
        }
        boolean cur = this.isNullSelected();
        this.firePropertyChanged("nullSelected", old, cur);
    }

    public boolean isNullSelected() {
        if (this.nullButton == null) {
            return false;
        }
        Icon icn = this.nullButton.getIcon();
        return icn == TextFieldEditor.getNullSelectedIcon();
    }

    protected JTextComponent getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = new JTextField();
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        return this.textField;
    }

    public boolean isAllowNull() {
        return this.getNullButton().isVisible();
    }

    public void setAllowNull(boolean allow) {
        boolean cur;
        if (this.nullButton == null) {
            return;
        }
        boolean old = this.isAllowNull();
        this.nullButton.setVisible(allow);
        if (this.panel != null) {
            this.panel.revalidate();
            this.panel.invalidate();
            this.panel.repaint();
        }
        this.allowNull = cur = this.isAllowNull();
        if (Objects.equals(old, cur)) {
            this.firePropertyChanged("nullable", old, cur);
        }
    }

    protected JLabel getOpenExternalEditor() {
        if (this.extEditorButton != null) {
            return this.extEditorButton;
        }
        this.extEditorButton = new JLabel(TextFieldEditor.getEditIcon());
        this.extEditorButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.extEditorButton.setCursor(Cursor.getPredefinedCursor(12));
        SwingListener.onMouseClicked(this.extEditorButton, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                Object curVal = TextFieldEditor.this.getValue();
                TextFieldEditor.this.openEditor(curVal);
            }
        });
        return this.extEditorButton;
    }

    protected void openEditor(Object currentValue) {
        if (this.externalEditor != null) {
            this.prestartValues.put(this.externalEditor, currentValue);
            this.externalEditor.open(currentValue);
        }
    }

    public ExternalEditor getExternalEditor() {
        return this.externalEditor;
    }

    public void setExternalEditor(ExternalEditor externalEditor) {
        this.externalEditor = externalEditor;
        if (this.externalEditor != null) {
            this.externalEditor.setConsumer(this.externalEditorConsumer);
        }
        if (this.panel != null && this.extEditorButton != null) {
            this.extEditorButton.setVisible(externalEditor != null);
            this.panel.revalidate();
            this.panel.invalidate();
            this.panel.repaint();
        }
    }

    protected JComponent getEditorPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagConstraints gbc = null;
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panel.add((Component)this.getTextField(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 3, 0, 0);
        this.panel.add((Component)this.getNullButton(), gbc);
        Reciver<KeyEvent> cons1 = new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                TextFieldEditor.this.setNullSelected(false);
            }
        };
        SwingListener.onKeyTyped(this.getTextField(), cons1);
        Reciver<KeyEvent> cons2 = new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    TextFieldEditor.this.fireEditingStopped(TextFieldEditor.this);
                }
            }
        };
        SwingListener.onKeyPressed(this.getTextField(), cons2);
        if (this.allowNull) {
            this.getNullButton().setVisible(true);
        } else {
            this.getNullButton().setVisible(false);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 3, 0, 0);
        this.panel.add((Component)this.getOpenExternalEditor(), gbc);
        this.getOpenExternalEditor().setVisible(this.externalEditor != null);
        return this.panel;
    }

    @Override
    protected JComponent createComponent() {
        return this.getEditorPanel();
    }

    protected void setTextFieldValue(Object value) {
        if (value != null) {
            this.getTextField().setText(value.toString());
        } else {
            this.getTextField().setText("");
        }
    }

    protected Object getTextFieldValue() {
        return this.getTextField().getText();
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    @Override
    public Object getValue() {
        if (this.allowNull && this.isNullSelected()) {
            return null;
        }
        return this.getTextFieldValue();
    }

    protected void setValue(Object value, boolean withExternal) {
        if (this.allowNull) {
            this.setNullSelected(value == null);
        }
        this.setTextFieldValue(value);
        if (withExternal && this.externalEditor != null && this.externalEditor.isOpen()) {
            this.externalEditor.setValue(value);
        }
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        Object val = this.getValue();
        return val != null ? val.toString() : null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

