/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;
import xyz.cofe.gui.swing.text.ValidatedTextField;
import xyz.cofe.time.TimeDiff;

public class TimeDiffEditor
extends TextFieldEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(TimeDiffEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TimeDiffEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TimeDiffEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TimeDiffEditor.class.getName(), method, result);
    }

    public TimeDiffEditor(boolean allowNull) {
        super(allowNull);
    }

    public TimeDiffEditor(TimeDiffEditor sample) {
        super(sample);
    }

    public TimeDiffEditor() {
        super(false);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb != null) {
            pdb.registerTypeEditor(TimeDiff.class, this);
        }
    }

    @Override
    public TimeDiffEditor clone() {
        return new TimeDiffEditor(this);
    }

    @Override
    protected JTextComponent getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        final ValidatedTextField tf = new ValidatedTextField();
        Predicate<String> parseFilter = new Predicate<String>(){

            public boolean validate(String txt) {
                if (txt == null) {
                    return true;
                }
                TimeDiff tdiff = TimeDiff.parse((String)txt);
                if (tdiff == null) {
                    if (TimeDiffEditor.this.isAllowNull()) {
                        return true;
                    }
                    tf.setBalloonText("format exception, enter like this: +2d 10:34:53.234");
                    return false;
                }
                return true;
            }
        };
        tf.setFilter(parseFilter);
        tf.setPlaceholder("Enter number time diff like: +2d 10:34:53.234");
        tf.setBalloonText("");
        tf.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField = tf;
        return this.textField;
    }

    @Override
    protected Object getTextFieldValue() {
        String text = this.getTextField().getText();
        TimeDiff tdiff = TimeDiff.parse((String)text);
        return tdiff;
    }

    @Override
    protected void setTextFieldValue(Object value) {
        super.setTextFieldValue(value);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

