/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public class TreeTableWrapEditor
implements TreeTableNodeValueEditor.Editor {
    private static final Logger logger = Logger.getLogger(TreeTableWrapEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected PropertyEditor pe;
    protected JTextField textField;
    protected boolean cellEditable = true;
    protected boolean shouldSelectCell = true;
    protected final TreeTableNodeValueEditor.CellEditorListenerSupport listeners = new TreeTableNodeValueEditor.CellEditorListenerSupport();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableWrapEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableWrapEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableWrapEditor.class.getName(), method, result);
    }

    public TreeTableWrapEditor(PropertyEditor pe) {
        if (pe == null) {
            throw new IllegalArgumentException("pe==null");
        }
        this.pe = pe;
        if (!pe.supportsCustomEditor()) {
            this.textField = new JTextField();
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.textField != null) {
            return this.textField;
        }
        Component cmpt = this.pe.getCustomEditor();
        if (cmpt instanceof JComponent) {
            return (JComponent)cmpt;
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add(cmpt);
        return p;
    }

    @Override
    public void startEditing(Object value, Object context) {
        this.pe.setValue(value);
        if (this.textField != null) {
            this.textField.setText(this.pe.getAsText());
        }
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public Object getCellEditorValue() {
        if (this.textField != null) {
            this.pe.setAsText(this.textField.getText());
            return this.pe.getValue();
        }
        return this.pe.getValue();
    }

    public void setCellEditable(boolean v) {
        this.cellEditable = true;
    }

    @Override
    public boolean isCellEditable() {
        return this.cellEditable;
    }

    @Override
    public boolean isShouldSelectCell() {
        return this.shouldSelectCell;
    }

    public void setShouldSelectCell(boolean shouldSelectCell) {
        this.shouldSelectCell = shouldSelectCell;
    }

    @Override
    public void clearAllListeners() {
        this.listeners.clearAllListeners();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.removeCellEditorListener(l);
    }

    @Override
    public void fireEditingCanceled(Object src) {
        this.listeners.fireEditingCanceled(src);
    }

    @Override
    public void fireEditingStopped(Object src) {
        this.listeners.fireEditingStopped(src);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

