/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.shortcuts;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.FocusFinder;
import xyz.cofe.gui.swing.GetFocusedObject;
import xyz.cofe.gui.swing.GetTarget;
import xyz.cofe.gui.swing.KeyboardShortcut;
import xyz.cofe.gui.swing.menu.MenuItem;

public class ShortcutManager
extends DefaultKeyboardFocusManager {
    private static ShortcutManager instance = null;
    private boolean allowMultipleActions = false;
    private Iterable<Action> actions = null;
    private Comparator<Pair<Action, Object>> cmpAct = new Comparator<Pair<Action, Object>>(){

        @Override
        public int compare(Pair<Action, Object> pa1, Pair<Action, Object> pa2) {
            int cmpByName;
            block12: {
                Action a2;
                Action a1;
                block13: {
                    block11: {
                        a1 = (Action)pa1.A();
                        if (a1 == (a2 = (Action)pa2.A())) {
                            return 0;
                        }
                        cmpByName = ((String)a1.getValue("Name")).compareTo((String)a2.getValue("Name"));
                        if (!(a1 instanceof BasicAction) || !(a2 instanceof BasicAction)) break block11;
                        BasicAction ba1 = (BasicAction)a1;
                        BasicAction ba2 = (BasicAction)a2;
                        if (ba1.getKeyboardShortcuts().isEmpty() && ba2.getKeyboardShortcuts().isEmpty()) {
                            return cmpByName;
                        }
                        boolean hasWnd1 = false;
                        for (KeyboardShortcut ks : ba1.getKeyboardShortcuts()) {
                            if (ks.getTarget() == null) continue;
                            hasWnd1 = true;
                        }
                        boolean hasWnd2 = false;
                        for (KeyboardShortcut ks : ba2.getKeyboardShortcuts()) {
                            if (ks.getTarget() == null) continue;
                            hasWnd2 = true;
                        }
                        if (hasWnd1 == hasWnd2) {
                            return cmpByName;
                        }
                        if (hasWnd1 && !hasWnd2) {
                            return -1;
                        }
                        if (!hasWnd1 && hasWnd2) {
                            return 1;
                        }
                        break block12;
                    }
                    if (a1 instanceof BasicAction || !(a2 instanceof BasicAction)) break block13;
                    BasicAction ba2 = (BasicAction)a2;
                    if (ba2.getKeyboardShortcuts().isEmpty()) {
                        return cmpByName;
                    }
                    for (KeyboardShortcut ks : ba2.getKeyboardShortcuts()) {
                        if (ks.getTarget() == null) continue;
                        return 1;
                    }
                    break block12;
                }
                if (!(a1 instanceof BasicAction) || a2 instanceof BasicAction) break block12;
                BasicAction ba1 = (BasicAction)a1;
                if (ba1.getKeyboardShortcuts().isEmpty()) {
                    return cmpByName;
                }
                for (KeyboardShortcut ks : ba1.getKeyboardShortcuts()) {
                    if (ks.getTarget() == null) continue;
                    return -1;
                }
            }
            return cmpByName;
        }
    };
    private int minLastCallTimeout = 150;
    private final WeakHashMap<Action, Long> lastCall = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ShortcutManager.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static ShortcutManager get() {
        if (instance != null) {
            return instance;
        }
        instance = new ShortcutManager();
        return instance;
    }

    public static void install() {
        KeyboardFocusManager o = ShortcutManager.getCurrentKeyboardFocusManager();
        if (!(o instanceof ShortcutManager)) {
            ShortcutManager.setCurrentKeyboardFocusManager(ShortcutManager.get());
        }
    }

    @Override
    public boolean dispatchEvent(AWTEvent e) {
        if (e instanceof KeyEvent && this.hook((KeyEvent)e)) {
            return true;
        }
        return super.dispatchEvent(e);
    }

    protected boolean hook(KeyEvent e) {
        int eventID = e.getID();
        int code = e.getKeyCode();
        char typeChar = e.getKeyChar();
        if (eventID == 401) {
            int modif = 0;
            if (e.isAltDown()) {
                modif |= 0x200;
            }
            if (e.isControlDown()) {
                modif |= 0x80;
            }
            if (e.isMetaDown()) {
                modif |= 0x100;
            }
            if (e.isShiftDown()) {
                modif |= 0x40;
            }
            KeyStroke ks = null;
            ks = KeyStroke.getKeyStroke(code, modif, false);
            return this.hook(ks, e);
        }
        if (eventID == 402) {
            int modif = 0;
            if (e.isAltDown()) {
                modif |= 0x200;
            }
            if (e.isControlDown()) {
                modif |= 0x80;
            }
            if (e.isMetaDown()) {
                modif |= 0x100;
            }
            if (e.isShiftDown()) {
                modif |= 0x40;
            }
            KeyStroke ks = null;
            ks = KeyStroke.getKeyStroke(code, modif, true);
            return this.hook(ks, e);
        }
        if (eventID == 400) {
            int modif = 0;
            if (e.isAltDown()) {
                modif |= 0x200;
            }
            if (e.isControlDown()) {
                modif |= 0x80;
            }
            if (e.isMetaDown()) {
                modif |= 0x100;
            }
            if (e.isShiftDown()) {
                modif |= 0x40;
            }
            KeyStroke ks = null;
            ks = KeyStroke.getKeyStroke((int)typeChar, modif);
            return this.hook(ks, e);
        }
        return false;
    }

    public boolean isAllowMultipleActions() {
        return this.allowMultipleActions;
    }

    public void setAllowMultipleActions(boolean allowMultipleActions) {
        this.allowMultipleActions = allowMultipleActions;
    }

    public Iterable<Action> getActions() {
        return this.actions;
    }

    public void setActions(Iterable<Action> actions) {
        this.actions = actions;
    }

    public void setActionsOf(MenuItem miRoot) {
        this.actions = MenuItem.actionsOf(miRoot);
    }

    public void setActionsOf(Iterable<MenuItem> miRoot) {
        this.actions = MenuItem.actionsOf(miRoot);
    }

    private Iterable<Pair<Action, Object>> findActions(KeyStroke ks) {
        ArrayList<Pair<Action, Object>> res = new ArrayList<Pair<Action, Object>>();
        Iterable<Action> iact = this.actions;
        if (iact == null) {
            return res;
        }
        ArrayList<Action> lacts = new ArrayList<Action>();
        for (Action a : iact) {
            lacts.add(a);
        }
        for (Action a : lacts) {
            if (a instanceof BasicAction) {
                BasicAction ba = (BasicAction)a;
                Pair<Boolean, Object> matched = this.matchKeyStroke(ks, ba);
                if (!((Boolean)matched.A()).booleanValue()) continue;
                res.add((Pair<Action, Object>)new BasicPair((Object)a, matched.B()));
                continue;
            }
            if (!this.matchKeyStroke(ks, a)) continue;
            res.add((Pair<Action, Object>)new BasicPair((Object)a, null));
        }
        Collections.sort(res, this.cmpAct);
        return res;
    }

    private boolean matchKeyStroke(KeyStroke ks1, KeyStroke ks2) {
        char c2;
        char c1;
        int ev2;
        boolean ctrl2;
        int mod1 = ks1.getModifiers();
        int mod2 = ks2.getModifiers();
        boolean shift1 = (mod1 & 0x40) == 64 || (mod1 & 1) == 1;
        boolean alt1 = (mod1 & 0x200) == 512 || (mod1 & 8) == 8;
        boolean ctrl1 = (mod1 & 0x80) == 128 || (mod1 & 2) == 2;
        boolean shift2 = (mod2 & 0x40) == 64 || (mod2 & 1) == 1;
        boolean alt2 = (mod2 & 0x200) == 512 || (mod2 & 8) == 8;
        boolean bl = ctrl2 = (mod2 & 0x80) == 128 || (mod2 & 2) == 2;
        if (shift1 != shift2) {
            return false;
        }
        if (ctrl1 != ctrl2) {
            return false;
        }
        if (alt1 != alt2) {
            return false;
        }
        int ev1 = ks1.getKeyEventType();
        if (ev1 != (ev2 = ks2.getKeyEventType())) {
            return false;
        }
        return !(ev1 == 400 ? (c1 = ks1.getKeyChar()) != (c2 = ks2.getKeyChar()) : (ev1 == 401 ? (c1 = ks1.getKeyCode()) != (c2 = ks2.getKeyCode()) : ev1 == 402 && (c1 = ks1.getKeyCode()) != (c2 = ks2.getKeyCode())));
    }

    private boolean matchKeyStroke(KeyStroke ks, Action a) {
        Object oks = a.getValue("AcceleratorKey");
        if (!(oks instanceof KeyStroke)) {
            return false;
        }
        KeyStroke aks = (KeyStroke)oks;
        return this.matchKeyStroke(ks, aks);
    }

    private Pair<Boolean, Object> matchKeyStroke(KeyStroke ks, BasicAction a) {
        Class trgt = a instanceof GetTarget ? a.getTarget() : null;
        KeyStroke bks = a.getAccelerator();
        if (bks != null && this.matchKeyStroke(ks, bks)) {
            if (trgt != null) {
                Pair<Boolean, Object> res = this.matchWindowClass(trgt);
                return res;
            }
            return new BasicPair((Object)true, null);
        }
        for (KeyboardShortcut eks1 : a.getKeyboardShortcuts()) {
            KeyStroke eks = eks1.getKeyStroke();
            if (!this.matchKeyStroke(ks, eks)) continue;
            Class wcls = eks1.getTarget();
            Class clazz = wcls = wcls == null ? trgt : null;
            if (wcls != null) {
                Pair<Boolean, Object> res = this.matchWindowClass(wcls);
                return res;
            }
            return new BasicPair((Object)true, null);
        }
        return new BasicPair((Object)false, null);
    }

    private Pair<Boolean, Object> matchWindowClass(Class targetClass) {
        Object throughFocus = FocusFinder.findThroughFocus(targetClass);
        if (throughFocus != null) {
            return new BasicPair((Object)true, throughFocus);
        }
        Object throughMouse = FocusFinder.findThroughMouse(targetClass);
        if (throughMouse != null) {
            return new BasicPair((Object)true, throughMouse);
        }
        Component c = this.getFocusOwner();
        Pair<Boolean, Object> byFocus = FocusFinder.matchWindowClass(c, targetClass);
        return new BasicPair((Object)false, null);
    }

    public int getMinLastCallTimeout() {
        return this.minLastCallTimeout;
    }

    public void setMinLastCallTimeout(int minLastCallTimeout) {
        this.minLastCallTimeout = minLastCallTimeout;
    }

    protected boolean hook(KeyStroke keyStroke, KeyEvent keyEvent) {
        ShortcutManager.logFine("hook( {0} )", keyStroke);
        Long curTime = new Date().getTime();
        Iterable<Pair<Action, Object>> acts = this.findActions(keyStroke);
        int co = 0;
        if (acts != null) {
            for (final Pair<Action, Object> pa : acts) {
                Object c;
                long diff;
                Action a;
                if (pa == null || (a = (Action)pa.A()) == null) continue;
                ShortcutManager.logFinest("matched action {0}", a.getValue("Name"));
                if (!a.isEnabled()) continue;
                Long lCall = this.lastCall.get(a);
                if (lCall != null && this.minLastCallTimeout > 0 && (diff = curTime - lCall) < (long)this.minLastCallTimeout && diff >= 0L) {
                    ShortcutManager.logFinest("skip by min last call timeout", new Object[0]);
                    continue;
                }
                ShortcutManager.logFine("fire actionPerformed {0}", a.getValue("Name"));
                if (a instanceof SetMatchedComponent && (c = pa.B()) != null && c instanceof Component) {
                    ((SetMatchedComponent)((Object)a)).setMatchedComponent((Component)c);
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (pa.B() != null) {
                            FocusedObjectActionEvent ae = new FocusedObjectActionEvent(this, 0, "shortcut");
                            ae.setFocusedObject(pa.B());
                            a.actionPerformed(ae);
                        } else {
                            a.actionPerformed(new ActionEvent(this, 0, "shortcut"));
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
                ++co;
                this.lastCall.put(a, curTime);
                if (this.allowMultipleActions) continue;
                break;
            }
        }
        return co > 0;
    }

    public static class FocusedObjectActionEvent
    extends ActionEvent
    implements GetFocusedObject {
        private Object focusedObject;

        public FocusedObjectActionEvent(Object source, int id, String command) {
            super(source, id, command);
        }

        public FocusedObjectActionEvent(Object source, int id, String command, int modifiers) {
            super(source, id, command, modifiers);
        }

        public FocusedObjectActionEvent(Object source, int id, String command, long when, int modifiers) {
            super(source, id, command, when, modifiers);
        }

        @Override
        public Object getFocusedObject() {
            return this.focusedObject;
        }

        public void setFocusedObject(Object focusedObject) {
            this.focusedObject = focusedObject;
        }
    }

    public static interface SetMatchedComponent {
        public void setMatchedComponent(Component var1);
    }
}

