/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.collection.set.EventSetAdapter;
import xyz.cofe.collection.set.EventSetListener;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.table.ListTM;

public class CachedTM<E>
extends ListTM<E> {
    private static final Logger logger = Logger.getLogger(CachedTM.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Iterable<E> source = null;
    protected final CloseableSet sourceCloseableSet = new CloseableSet();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Iterable<E> getSource() {
        try {
            this.lock.lock();
            Iterable<E> iterable = this.source;
            return iterable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(Iterable<E> source) {
        Iterable<E> old = this.source;
        try {
            this.lock.lock();
            old = this.source;
            this.sourceCloseableSet.closeAll();
            this.source = source;
            if (this.source != null) {
                Closeable c;
                if (this.source instanceof EventList) {
                    Closeable c2 = this.addEventListener((EventList)this.source);
                    if (c2 != null) {
                        this.sourceCloseableSet.add(c2);
                    }
                } else if (this.source instanceof EventSet && (c = this.addEventListener((EventSet)this.source)) != null) {
                    this.sourceCloseableSet.add(c);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fetch();
        this.firePropertyChange("source", old, source);
    }

    protected void removeFromCache(E item) {
        IndexEventList l = this.getList();
        l.remove(item);
    }

    protected void addToCache(E item) {
        IndexEventList<E> l = this.getList();
        l.add(item);
    }

    protected Closeable addEventListener(EventSet<E> es) {
        Closeable c = es.addEventSetListener((EventSetListener)new EventSetAdapter<E>(){

            protected void deleted(E item) {
                CachedTM.this.removeFromCache(item);
            }

            protected void inserted(E item) {
                CachedTM.this.addToCache(item);
            }
        });
        return c;
    }

    protected Closeable addEventListener(EventList<E> el) {
        Closeable c = el.addEventListListener((EventListListener)new SimpleListAdapter<E>(){

            protected void removed(E e, EventList<E> list, Integer position) {
                CachedTM.this.removeFromCache(e);
            }

            protected void added(E e, EventList<E> list, Integer position) {
                CachedTM.this.addToCache(e);
            }
        });
        return c;
    }

    protected boolean contains(Collection<E> col, E obj) {
        if (col == null) {
            throw new IllegalArgumentException("col==null");
        }
        return col.contains(obj);
    }

    public void refresh() {
        Iterable<E> src = this.getSource();
        IndexEventList cache = this.getList();
        cache.clear();
        if (src == null) {
            return;
        }
        boolean skipNulls = true;
        for (E itm : src) {
            if (itm == null) {
                if (skipNulls) continue;
                this.addToCache(itm);
                continue;
            }
            this.addToCache(itm);
        }
    }

    public void fetch() {
        Iterable<E> src = this.getSource();
        IndexEventList l = this.getList();
        if (src == null) {
            l.clear();
            return;
        }
        LinkedHashSet<E> srcSet = new LinkedHashSet<E>();
        LinkedHashSet<E> removeSet = new LinkedHashSet<E>();
        LinkedHashSet<E> addSet = new LinkedHashSet<E>();
        for (E i : src) {
            if (i == null) continue;
            srcSet.add(i);
        }
        for (E s : srcSet) {
            if (this.contains((Collection<E>)l, s)) continue;
            addSet.add(s);
        }
        for (E e : l) {
            if (this.contains(srcSet, e)) continue;
            removeSet.add(e);
        }
        for (E o : removeSet) {
            this.removeFromCache(o);
        }
        for (E o : addSet) {
            this.addToCache(o);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

