/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import sun.swing.DefaultLookup;

public class CellHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final Logger logger = Logger.getLogger(CellHeaderRenderer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private boolean horizontalTextPositionSet;
    private Icon sortArrow;
    private EmptyIcon emptyIcon = new EmptyIcon();
    private TableCellRenderer defaultRenderer;
    protected WeakReference<Component> rendererComponent;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(CellHeaderRenderer.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(CellHeaderRenderer.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CellHeaderRenderer.class.getName(), method, result);
    }

    public CellHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    public CellHeaderRenderer(TableCellRenderer defaultRenderer) {
        this.setHorizontalAlignment(0);
        this.defaultRenderer = defaultRenderer;
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        this.horizontalTextPositionSet = true;
        super.setHorizontalTextPosition(textPosition);
    }

    protected Component useDefaultCellRenderer(TableCellRenderer defrendrer, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cmpt = defrendrer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.rendererComponent = new WeakReference<Component>(cmpt);
        return cmpt;
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.defaultRenderer != null) {
            return this.useDefaultCellRenderer(this.defaultRenderer, table, value, isSelected, hasFocus, row, column);
        }
        return this.useInternalCellRenderer(table, value, isSelected, hasFocus, row, column);
    }

    protected Component useInternalCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon sortIcon = null;
        boolean isPaintingForPrint = false;
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                Color fgColor = null;
                Color bgColor = null;
                if (hasFocus) {
                    fgColor = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellForeground");
                    bgColor = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellBackground");
                }
                if (fgColor == null) {
                    fgColor = header.getForeground();
                }
                if (bgColor == null) {
                    bgColor = header.getBackground();
                }
                this.setForeground(fgColor);
                this.setBackground(bgColor);
                this.setFont(header.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null) {
                SortOrder sortOrder;
                if (!this.horizontalTextPositionSet) {
                    this.setHorizontalTextPosition(10);
                }
                if ((sortOrder = CellHeaderRenderer.getColumnSortOrder(table, column)) != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.descendingSortIcon");
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.naturalSortIcon");
                        }
                    }
                }
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setIcon(sortIcon);
        this.sortArrow = sortIcon;
        Border border = null;
        if (hasFocus) {
            border = DefaultLookup.getBorder(this, this.ui, "TableHeader.focusCellBorder");
        }
        if (border == null) {
            border = DefaultLookup.getBorder(this, this.ui, "TableHeader.cellBorder");
        }
        this.setBorder(border);
        return this;
    }

    public static SortOrder getColumnSortOrder(JTable table, int column) {
        SortOrder rv = null;
        if (table == null || table.getRowSorter() == null) {
            return rv;
        }
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
            rv = sortKeys.get(0).getSortOrder();
        }
        return rv;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean b = DefaultLookup.getBoolean(this, this.ui, "TableHeader.rightAlignSortArrow", false);
        if (b && this.sortArrow != null) {
            this.emptyIcon.width = this.sortArrow.getIconWidth();
            this.emptyIcon.height = this.sortArrow.getIconHeight();
            this.setIcon(this.emptyIcon);
            super.paintComponent(g);
            Point position = this.computeIconPosition(g);
            this.sortArrow.paintIcon(this, g, position.x, position.y);
        } else {
            super.paintComponent(g);
        }
    }

    private Point computeIconPosition(Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle viewR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle iconR = new Rectangle();
        Insets i = this.getInsets();
        viewR.x = i.left;
        viewR.y = i.top;
        viewR.width = this.getWidth() - (i.left + i.right);
        viewR.height = this.getHeight() - (i.top + i.bottom);
        SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.sortArrow, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
        int x = this.getWidth() - i.right - this.sortArrow.getIconWidth();
        int y = iconR.y;
        return new Point(x, y);
    }

    @Override
    public synchronized void setIconTextGap(int iconTextGap) {
        Component cmpt;
        super.setIconTextGap(iconTextGap);
        Component component = cmpt = this.rendererComponent != null ? (Component)this.rendererComponent.get() : null;
        if (cmpt instanceof JLabel) {
            ((JLabel)cmpt).setIconTextGap(iconTextGap);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        Component cmpt;
        super.setIcon(icon);
        Component component = cmpt = this.rendererComponent != null ? (Component)this.rendererComponent.get() : null;
        if (cmpt instanceof JLabel) {
            ((JLabel)cmpt).setIcon(icon);
        }
    }

    @Override
    public void setText(String text) {
        Component cmpt;
        super.setText(text);
        Component component = cmpt = this.rendererComponent != null ? (Component)this.rendererComponent.get() : null;
        if (cmpt instanceof JLabel) {
            ((JLabel)cmpt).setText(text);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private class EmptyIcon
    implements Icon,
    Serializable {
        int width = 0;
        int height = 0;

        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

