/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import xyz.cofe.gui.swing.color.ColorModificator;

public class DefTableCellRender
extends DefaultTableCellRenderer {
    private static final Logger logger = Logger.getLogger(DefTableCellRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Color unselectedForeground;
    protected Color unselectedBackground;
    protected Color alternateRowColor;
    protected Color selectionForeground;
    protected Color selectionBackground;
    protected Color focusedBackground;
    protected Color focusedForeground;
    protected boolean hasFocus = false;
    protected boolean isSelected = false;
    protected int row = 0;
    protected int column = 0;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DefTableCellRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DefTableCellRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DefTableCellRender.class.getName(), method, result);
    }

    public DefTableCellRender(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table==null");
        }
        this.unselectedForeground = table.getForeground();
        this.unselectedForeground = this.unselectedForeground == null ? Color.black : this.unselectedForeground;
        this.unselectedBackground = table.getBackground();
        this.unselectedBackground = this.unselectedBackground == null ? Color.white : this.unselectedBackground;
        this.alternateRowColor = UIManager.getColor("Table.alternateRowColor");
        this.selectionForeground = table.getSelectionForeground();
        this.selectionForeground = this.selectionForeground == null ? Color.white : this.selectionForeground;
        this.selectionBackground = table.getSelectionBackground();
        this.selectionBackground = this.selectionBackground == null ? Color.blue : this.selectionBackground;
        this.focusedBackground = new ColorModificator().brighter(-0.5f).apply(this.selectionBackground);
        this.focusedForeground = new ColorModificator().brighter(0.5f).apply(this.selectionForeground);
        this.setOpaque(true);
    }

    protected boolean isPaintAlternateRowColor(int row) {
        return this.alternateRowColor != null && row % 2 != 0;
    }

    protected Color getForegroundColorFor(boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg = this.unselectedForeground;
        if (isSelected) {
            fg = this.selectionForeground;
        }
        if (hasFocus && this.focusedBackground != null) {
            fg = this.focusedForeground;
        }
        return fg;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Insets inst;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.hasFocus = hasFocus;
        this.isSelected = isSelected;
        this.row = row;
        this.column = column;
        Color bg = this.unselectedBackground;
        Color fg = this.getForegroundColorFor(isSelected, hasFocus, row, column);
        if (this.isPaintAlternateRowColor(row)) {
            bg = this.alternateRowColor;
        }
        if (isSelected) {
            bg = this.selectionBackground;
        }
        if (hasFocus && this.focusedBackground != null) {
            bg = this.focusedBackground;
        }
        this.setBackground(bg);
        this.setForeground(fg);
        Border brd = this.getBorder();
        if (brd != null && (inst = brd.getBorderInsets(this)) != null) {
            brd = new EmptyBorder(inst);
            this.setBorder(brd);
        }
        return this;
    }

    protected void paintBackground(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D gs = (Graphics2D)g;
            Color bg = this.getBackground();
            if (this.hasFocus && this.focusedBackground != null) {
                bg = this.focusedBackground;
            }
            if (bg != null && this.isOpaque()) {
                int w = this.getWidth();
                int h = this.getHeight();
                gs.setColor(bg);
                gs.fillRect(0, 0, w, h);
            }
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

