/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class EventSupport {
    private transient PropertyChangeSupport propertyChangeSupport = null;
    protected TableModel tableModel = null;
    private boolean notifyInAwtThread = true;
    private boolean awtInvokeAndWait = false;
    private int fireAllChangedLevel = 0;
    private int fireColumnsChangedLevel = 0;
    private int fireRowUpdated = 0;
    private int fireRowUpdated2 = 0;
    private int fireCellChanged = 0;
    private int fireRowsInserted = 0;
    private int fireRowsDeleted = 0;
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    private int fireTableModelEvent = 0;
    protected volatile Collection<TableModelListener> listeners = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(EventSupport.class.getName()).log(Level.SEVERE, null, ex);
    }

    public EventSupport(TableModel owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner==null");
        }
        this.tableModel = owner;
    }

    public PropertyChangeSupport propertySupport() {
        if (this.propertyChangeSupport != null) {
            return this.propertyChangeSupport;
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        return this.propertyChangeSupport;
    }

    public void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertySupport().firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().removePropertyChangeListener(listener);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner==null");
        }
        TableModel old = this.tableModel;
        this.tableModel = owner;
        this.firePropertyChange("tableModel", old, this.tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotifyInAwtThread() {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            return this.notifyInAwtThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyInAwtThread(boolean notifyInAwtThread) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            this.notifyInAwtThread = notifyInAwtThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAwtInvokeAndWait() {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            return this.awtInvokeAndWait;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAwtInvokeAndWait(boolean awtInvokeAndWait) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            this.awtInvokeAndWait = awtInvokeAndWait;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllChanged() {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireAllChangedLevel;
                if (this.fireAllChangedLevel > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel());
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireAllChangedLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireColumnsChanged() {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireColumnsChangedLevel;
                if (this.fireColumnsChangedLevel > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), -1);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireColumnsChangedLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowUpdated(int row) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireRowUpdated;
                if (this.fireRowUpdated > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), row);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireRowUpdated;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireRowUpdated2;
                if (this.fireRowUpdated2 > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), rowIndexFrom, toIndexInclude);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireRowUpdated2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCellChanged(int rowIndex, int columnIndex) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireCellChanged;
                if (this.fireCellChanged > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), rowIndex, rowIndex, columnIndex);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireCellChanged;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireRowsInserted;
                if (this.fireRowsInserted > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), rowIndexFrom, toIndexInclude, -1, 1);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireRowsInserted;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            try {
                ++this.fireRowsDeleted;
                if (this.fireRowsDeleted > 1) {
                    return;
                }
                TableModelEvent e = new TableModelEvent(this.getTableModel(), rowIndexFrom, toIndexInclude, -1, -1);
                this.fireTableModelEvent(e);
            }
            finally {
                --this.fireRowsDeleted;
            }
        }
    }

    private void processEventQueue() {
        Runnable r;
        while ((r = this.eventQueue.poll()) != null) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fireTableModelEvent(TableModelEvent e) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            block16: {
                try {
                    ++this.fireTableModelEvent;
                    if (this.fireTableModelEvent > 32) {
                        return;
                    }
                    if (e == null) {
                        return;
                    }
                    int evQueueSize = this.eventQueue.size();
                    TableModelEventSender tmeSender = new TableModelEventSender(this.getListenersCollection(), e);
                    this.eventQueue.add(tmeSender);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            EventSupport.this.processEventQueue();
                        }
                    };
                    if (this.isNotifyInAwtThread()) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            this.processEventQueue();
                            break block16;
                        }
                        if (this.isAwtInvokeAndWait()) {
                            try {
                                SwingUtilities.invokeAndWait(r);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(EventSupport.class.getName()).log(Level.SEVERE, null, ex);
                                Thread.currentThread().interrupt();
                            }
                            catch (InvocationTargetException ex) {
                                Logger.getLogger(EventSupport.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break block16;
                        } else {
                            if (evQueueSize >= 1) return;
                            SwingUtilities.invokeLater(r);
                        }
                        break block16;
                    }
                    this.processEventQueue();
                }
                finally {
                    --this.fireTableModelEvent;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TableModelListener> getListenersCollection() {
        if (this.listeners != null) {
            return this.listeners;
        }
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            if (this.listeners != null) {
                return this.listeners;
            }
            this.listeners = this.createListenersCollections();
            return this.listeners;
        }
    }

    public TableModelListener[] getListeners() {
        Collection<TableModelListener> coll = this.getListenersCollection();
        return coll.toArray(new TableModelListener[0]);
    }

    public Collection<TableModelListener> createListenersCollections() {
        return new ConcurrentLinkedQueue<TableModelListener>();
    }

    private Collection<TableModelListener> lstnrs() {
        return this.getListenersCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableModelListener(TableModelListener l) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            if (l == null) {
                return;
            }
            this.lstnrs().add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModelListener(TableModelListener l) {
        EventSupport eventSupport = this;
        synchronized (eventSupport) {
            if (l == null) {
                return;
            }
            this.lstnrs().remove(l);
        }
    }

    protected static class TableModelEventSender
    implements Runnable {
        protected Collection<TableModelListener> listeners;
        protected TableModelEvent event;

        public TableModelEventSender(Collection<TableModelListener> listeners, TableModelEvent event) {
            if (listeners == null) {
                throw new IllegalArgumentException("listeners == null");
            }
            if (event == null) {
                throw new IllegalArgumentException("event == null");
            }
            this.listeners = listeners;
            this.event = event;
        }

        @Override
        public void run() {
            for (TableModelListener l : this.listeners) {
                if (l == null) continue;
                l.tableChanged(this.event);
            }
        }
    }
}

