/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Convertor;
import xyz.cofe.gui.swing.table.Column;

public class ExtendColumn
extends Column {
    protected int sourceColumn = -1;
    protected int rowIndex = -1;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ExtendColumn.class.getName()).log(Level.SEVERE, null, ex);
    }

    public int getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(int sourceColumn) {
        Integer old = this.sourceColumn;
        this.sourceColumn = sourceColumn;
        this.firePropertyChange("sourceColumn", old, sourceColumn);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public static ExtendColumn createFrom(TableModel tm, int columnIndex, boolean writeable) {
        final ExtendColumn dc = new ExtendColumn();
        dc.setSourceColumn(columnIndex);
        dc.setName(tm.getColumnName(columnIndex));
        dc.setType(tm.getColumnClass(columnIndex));
        dc.setReader(new Convertor<Object, Object>(){

            public Object convert(Object from) {
                return from;
            }
        });
        if (writeable) {
            final TableModel ftm = tm;
            final int srcColIdx = columnIndex;
            dc.setWriter(new Convertor<Column.Cell, Boolean>(){

                public Boolean convert(Column.Cell cell) {
                    int ri = dc.getRowIndex();
                    ftm.setValueAt(cell.newValue, ri, srcColIdx);
                    return true;
                }
            });
        }
        return dc;
    }
}

