/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.ExtendColumn;
import xyz.cofe.gui.swing.table.GetReaderForRow;
import xyz.cofe.gui.swing.table.WrapTM;

public class ExtendTM
extends WrapTM {
    private PropertyChangeListener columnPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null) {
                int rc;
                if ("name".equals(evt.getPropertyName()) || "type".equals(evt.getPropertyName())) {
                    ExtendTM.this.fireColumnsChanged();
                } else if ("sourceColumn".equals(evt.getPropertyName()) && (rc = ExtendTM.this.getColumnCount()) > 0) {
                    ExtendTM.this.fireRowsUpdated(0, rc - 1);
                }
            }
        }
    };
    private SimpleListAdapter<Column> columnsListener = new SimpleListAdapter<Column>(){

        protected void removed(Column e, EventList<Column> list, Integer position) {
            if (e != null) {
                e.removePropertyChangeListener(ExtendTM.this.columnPropertyListener);
            }
            ExtendTM.this.fireColumnsChanged();
        }

        protected void added(Column e, EventList<Column> list, Integer position) {
            if (e != null) {
                e.addPropertyChangeListener(ExtendTM.this.columnPropertyListener);
            }
            ExtendTM.this.fireColumnsChanged();
        }
    };
    private BasicEventList<Column> columns = new BasicEventList();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ExtendTM.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ExtendTM() {
        this.columns.addEventListListener(this.columnsListener);
    }

    public BasicEventList<Column> getColumns() {
        return this.columns;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 0) {
            return null;
        }
        if (columnIndex >= this.columns.size()) {
            return null;
        }
        return ((Column)this.columns.get(columnIndex)).getType();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0) {
            return null;
        }
        if (columnIndex >= this.columns.size()) {
            return null;
        }
        return ((Column)this.columns.get(columnIndex)).getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Convertor<Object, Object> conv;
        if (columnIndex < 0) {
            return null;
        }
        if (columnIndex >= this.columns.size()) {
            return null;
        }
        if (this.tableModel == null) {
            return null;
        }
        Column co = (Column)this.columns.get(columnIndex);
        int srcColumnIndex = columnIndex;
        if (co instanceof ExtendColumn) {
            srcColumnIndex = ((ExtendColumn)co).getSourceColumn();
        }
        Object srcVal = this.tableModel.getValueAt(rowIndex, srcColumnIndex);
        Convertor<Object, Object> convertor = conv = co instanceof GetReaderForRow ? co.getReader(rowIndex) : co.getReader();
        if (conv == null) {
            return null;
        }
        return conv.convert(srcVal);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex < 0) {
            return false;
        }
        if (columnIndex >= this.columns.size()) {
            return false;
        }
        return ((Column)this.columns.get(columnIndex)).getWriter() != null;
    }

    @Override
    public void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < 0) {
            return;
        }
        if (columnIndex >= this.columns.size()) {
            return;
        }
        if (this.tableModel == null) {
            return;
        }
        Column co = (Column)this.columns.get(columnIndex);
        int srcColumnIndex = columnIndex;
        if (co instanceof ExtendColumn) {
            ExtendColumn dcol = (ExtendColumn)co;
            srcColumnIndex = dcol.getSourceColumn();
            dcol.setRowIndex(rowIndex);
        }
        Object srcVal = this.tableModel.getValueAt(rowIndex, srcColumnIndex);
        Convertor<Column.Cell, Boolean> writer = co.getWriter();
        if (writer == null) {
            return;
        }
        Boolean succ = (Boolean)writer.convert((Object)new Column.Cell(srcVal, aValue));
        if (!succ.booleanValue()) {
            return;
        }
        this.fireRowUpdated(rowIndex);
    }
}

