/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.set.IndexSet;
import xyz.cofe.collection.set.IndexSetBasic;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.table.WrapTM;

public class FilterRowTM
extends WrapTM {
    private static final Logger logger = Logger.getLogger(FilterRowTM.class.getName());
    protected Predicate<RowData> rowFilter = null;
    private RowData rowData = new RowData();
    protected IndexSet<Integer> source;

    private static final Level logLevel() {
        return Logger.getLogger(FilterRowTM.class.getName()).getLevel();
    }

    private static final boolean isLogSevere() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static final boolean isLogWarning() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static final boolean isLogInfo() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static final boolean isLogFine() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static final boolean isLogFiner() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static final boolean isLogFinest() {
        Level logLevel = FilterRowTM.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FilterRowTM.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FilterRowTM.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FilterRowTM.class.getName(), method, result);
    }

    public void setRowFilter(Predicate<RowData> filter) {
        Predicate<RowData> old = this.rowFilter;
        this.rowFilter = filter;
        this.applyFilter();
        this.firePropertyChange("rowFilter", old, this.rowFilter);
    }

    public Predicate<RowData> getRowFilter() {
        return this.rowFilter;
    }

    public synchronized IndexSet<Integer> getSourceIndexSet() {
        return this.source;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.source == null && this.rowFilter != null && this.tableModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FilterRowTM.this.applyFilter();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.source == null) {
            return super.getRowCount();
        }
        return this.source.size();
    }

    @Override
    public synchronized int getColumnCount() {
        if (this.source == null && this.rowFilter != null && this.tableModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FilterRowTM.this.applyFilter();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        return super.getColumnCount();
    }

    @Override
    public synchronized int mapColumnToInside(int columnIndex) {
        if (this.source == null && this.rowFilter != null && this.tableModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FilterRowTM.this.applyFilter();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        return super.mapColumnToInside(columnIndex);
    }

    @Override
    public synchronized int mapRowToInside(int rowIndex) {
        if (this.source == null && this.rowFilter != null && this.tableModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FilterRowTM.this.applyFilter();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.source != null) {
            int maxRow = this.source.size() - 1;
            if (rowIndex > maxRow || rowIndex < 0) {
                return -1;
            }
            return (Integer)this.source.get(rowIndex);
        }
        return super.mapRowToInside(rowIndex);
    }

    @Override
    public synchronized int mapRowToOutside(int rowIndex) {
        if (this.source == null && this.rowFilter != null && this.tableModel != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FilterRowTM.this.applyFilter();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.source != null) {
            int idx = this.source.indexOf((Comparable)Integer.valueOf(rowIndex));
            return idx >= 0 ? idx : -1;
        }
        return rowIndex;
    }

    public void applyFilter() {
        this.applyFilter(true);
    }

    public synchronized void applyFilter(boolean fireAllChanged) {
        FilterRowTM.logFine("applyFilter({0}), filter setted={1}", fireAllChanged, this.rowFilter != null);
        if (this.source != null) {
            this.source.clear();
        }
        this.source = null;
        if (this.rowFilter != null && this.tableModel != null) {
            this.source = this.buildSourceIndex();
        }
        if (fireAllChanged) {
            this.fireAllChanged();
        }
    }

    public synchronized boolean filterSource(int sourceRow) {
        if (this.rowFilter != null && this.tableModel != null) {
            this.rowData.setTableModel(this.tableModel);
            this.rowData.setRowIndex(sourceRow);
            return this.rowFilter.validate((Object)this.rowData);
        }
        return true;
    }

    public synchronized IndexSetBasic<Integer> buildSourceIndex() {
        IndexSetBasic source = new IndexSetBasic();
        if (this.rowFilter != null && this.tableModel != null) {
            this.rowData.setTableModel(this.tableModel);
            for (int srcRi = 0; srcRi < this.tableModel.getRowCount(); ++srcRi) {
                this.rowData.setRowIndex(srcRi);
                if (!this.rowFilter.validate((Object)this.rowData)) continue;
                source.add((Comparable)Integer.valueOf(srcRi));
            }
        }
        return source;
    }

    @Override
    public synchronized void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        this.rowData.setTableModel(tableModel);
        FilterRowTM.logFiner("setTableModel( {0} )", tableModel);
        this.applyFilter();
    }

    protected synchronized void shiftOnInsertIndexes(int from, int toInc) {
        FilterRowTM.logFine("shiftOnInsertIndexes({0},{1})", from, toInc);
        if (this.source == null) {
            return;
        }
        final int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        final LinkedHashMap updates = new LinkedHashMap();
        Pair tailStart = this.source.tailEntry((Comparable)Integer.valueOf(from), false, 0, this.source.size());
        if (tailStart == null) {
            return;
        }
        this.source.eachByIndex(this.source.size(), ((Integer)tailStart.A()).intValue(), (Func2)new Func2<Object, Integer, Integer>(){

            public Object apply(Integer idx, Integer val) {
                updates.put(val, val + icnt);
                return null;
            }
        });
        for (Map.Entry en : updates.entrySet()) {
            int v;
            int k = (Integer)en.getKey();
            if (k == (v = ((Integer)en.getValue()).intValue())) continue;
            int oldIdx = this.source.remove((Comparable)Integer.valueOf(k));
            int newIdx = this.source.add((Comparable)Integer.valueOf(v));
            FilterRowTM.logFinest("shift [{0}]={1} => [{2}]={3}", oldIdx, k, newIdx, v);
        }
    }

    protected synchronized void shiftOnDeleteIndexes(int from, int toInc, Reciver<Integer> deletedOutterIndexes) {
        FilterRowTM.logFine("shiftOnDeleteIndexes({0},{1})", from, toInc);
        if (this.source == null) {
            return;
        }
        final int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        final LinkedHashSet removedDI = new LinkedHashSet();
        this.source.eachByValue((Comparable)Integer.valueOf(toInc), true, (Comparable)Integer.valueOf(from), true, (Func2)new Func2<Object, Integer, Integer>(){

            public Object apply(Integer idx, Integer val) {
                removedDI.add(idx);
                return null;
            }
        });
        for (Integer removeDI : removedDI) {
            Integer si = (Integer)this.source.removeByIndex(removeDI.intValue());
            FilterRowTM.logFinest("removed [{0}]={1}", removeDI, si);
        }
        final LinkedHashMap updates = new LinkedHashMap();
        FilterRowTM.logFinest("shiftOnDeleteIndexes debug1 source.size = {0}", this.source.size());
        Pair tailStart = this.source.tailEntry((Comparable)Integer.valueOf(toInc), false, 0, this.source.size());
        if (tailStart != null) {
            int newVal;
            int oldVal;
            this.source.eachByIndex(this.source.size(), ((Integer)tailStart.A()).intValue(), (Func2)new Func2<Object, Integer, Integer>(){

                public Object apply(Integer idx, Integer val) {
                    updates.put(val, val - icnt);
                    return null;
                }
            });
            for (Map.Entry entry : updates.entrySet()) {
                oldVal = (Integer)entry.getKey();
                if (oldVal == (newVal = ((Integer)entry.getValue()).intValue())) continue;
                int oldIdx = this.source.remove((Comparable)Integer.valueOf(oldVal));
                FilterRowTM.logFinest("shift [{0}]={1} => delete", oldIdx, oldVal);
            }
            for (Map.Entry entry : updates.entrySet()) {
                oldVal = (Integer)entry.getKey();
                if (oldVal == (newVal = ((Integer)entry.getValue()).intValue())) continue;
                int newIdx = this.source.add((Comparable)Integer.valueOf(newVal));
                FilterRowTM.logFinest("shift [{0}]={1} => insert", newIdx, newVal);
            }
        }
        FilterRowTM.logFinest("shiftOnDeleteIndexes debug2 source.size = {0}", this.source.size());
        if (deletedOutterIndexes != null) {
            for (Integer n : removedDI) {
                deletedOutterIndexes.recive((Object)n);
            }
        }
    }

    @Override
    protected synchronized List<TableModelEvent> onRowInserted(TableModelEvent e, int firstRow, int lastRow) {
        ArrayList<TableModelEvent> evs = new ArrayList<TableModelEvent>();
        FilterRowTM.logFine("onRowInserted({0},{1})", firstRow, lastRow);
        FilterRowTM.logFiner("source.size={0}", this.source == null ? "null" : Integer.valueOf(this.source.size()));
        if (this.source == null && this.rowFilter != null) {
            this.applyFilter(false);
            evs.add(new TableModelEvent(this));
            return evs;
        }
        if (this.tableModel == null) {
            return this.deletageTMEvent(e);
        }
        if (this.source == null) {
            return this.deletageTMEvent(e);
        }
        if (lastRow < firstRow) {
            return this.deletageTMEvent(e);
        }
        this.shiftOnInsertIndexes(firstRow, lastRow);
        TreeSet<Integer> inserted = new TreeSet<Integer>();
        int icnt = lastRow - firstRow + 1;
        if (icnt > 0) {
            FilterRowTM.logFiner("source insert count {0}", icnt);
            for (int si = firstRow; si <= lastRow; ++si) {
                this.rowData.setRowIndex(si);
                if (this.rowFilter != null && !this.rowFilter.validate((Object)this.rowData)) continue;
                int di = this.source.add((Comparable)Integer.valueOf(si));
                inserted.add(di);
                FilterRowTM.logFinest("inserted [{0}]={1}", di, si);
            }
        }
        int rangeStart = -1;
        int rangeEnd = -1;
        int lidx = -1;
        int i = -1;
        for (Integer idx : inserted) {
            if (++i == 0) {
                lidx = idx;
                rangeStart = idx;
                rangeEnd = idx;
                FilterRowTM.logFinest("first range [{0}..", rangeStart);
            } else {
                int didx = Math.abs(lidx - idx);
                if (didx > 1) {
                    rangeEnd = lidx;
                    TableModelEvent eins = new TableModelEvent(this, rangeStart, rangeEnd, -1, 1);
                    FilterRowTM.logFinest("insert range [{0}..{1}] cnt={2}", rangeStart, rangeEnd, Math.abs(rangeEnd - rangeStart) + 1);
                    evs.add(eins);
                    rangeStart = idx;
                }
            }
            lidx = idx;
        }
        if (rangeStart <= lidx && rangeStart >= 0) {
            TableModelEvent eins = new TableModelEvent(this, rangeStart, rangeEnd, -1, 1);
            FilterRowTM.logFinest("insert range [{0}..{1}] cnt={2}", rangeStart, rangeEnd, Math.abs(rangeEnd - rangeStart) + 1);
            evs.add(eins);
        }
        FilterRowTM.logFiner("after source.size={0}", this.source == null ? "null" : Integer.valueOf(this.source.size()));
        return evs;
    }

    public synchronized List<TableModelEvent> processRowUpdated(int sourceFirstRow, int sourceLastRow) {
        LinkedList<TableModelEvent> evs = new LinkedList<TableModelEvent>();
        if (this.tableModel == null) {
            return null;
        }
        if (sourceLastRow < sourceFirstRow) {
            return null;
        }
        TreeSet<Integer> incList = new TreeSet<Integer>();
        TreeSet<Integer> decList = new TreeSet<Integer>();
        TreeSet<Integer> updList = new TreeSet<Integer>();
        if (this.rowFilter != null && this.source != null) {
            for (int srcRi = sourceFirstRow; srcRi <= sourceLastRow; ++srcRi) {
                this.rowData.setRowIndex(srcRi);
                boolean inc = this.rowFilter.validate((Object)this.rowData);
                if (inc) {
                    if (!this.source.exists((Comparable)Integer.valueOf(srcRi))) {
                        incList.add(srcRi);
                        continue;
                    }
                    updList.add(srcRi);
                    continue;
                }
                if (!this.source.exists((Comparable)Integer.valueOf(srcRi))) continue;
                decList.add(srcRi);
            }
        } else {
            TableModelEvent e = new TableModelEvent(this, sourceFirstRow, sourceLastRow, -1, 0);
            evs.add(e);
            return evs;
        }
        if (this.source != null) {
            TableModelEvent e;
            for (Integer srcRi : updList) {
                int di = this.source.indexOf((Comparable)srcRi);
                FilterRowTM.logFinest("source.updated di={0} si={1}", di, srcRi);
                e = new TableModelEvent(this, di, di, -1, 0);
                evs.add(e);
            }
            for (Integer si : decList.descendingSet()) {
                Integer di = this.source.remove((Comparable)si);
                e = new TableModelEvent(this, di, di, -1, -1);
                evs.add(e);
                FilterRowTM.logFinest("source.removed di={0} si={1}", di, si);
                FilterRowTM.logFinest("processRowUpdated({0},{1}) - fire row delete {2} -> {3}", sourceFirstRow, sourceLastRow, di, si);
            }
            for (Integer si : incList) {
                int di = this.source.add((Comparable)si);
                FilterRowTM.logFinest("source.inserted di={0} si={1}", di, si);
                e = new TableModelEvent(this, di, di, -1, 1);
                evs.add(e);
            }
            return evs;
        }
        return null;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowUpdated(TableModelEvent e, int firstRow, int lastRow) {
        FilterRowTM.logFine("onRowUpdated({0},{1})", firstRow, lastRow);
        if (this.source == null && this.rowFilter != null) {
            LinkedList<TableModelEvent> evs = new LinkedList<TableModelEvent>();
            this.applyFilter(false);
            evs.add(new TableModelEvent(this));
            return evs;
        }
        List<TableModelEvent> evs = this.processRowUpdated(firstRow, lastRow);
        if (evs == null) {
            return this.deletageTMEvent(e);
        }
        return evs;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowDeleted(TableModelEvent onDeleteEvent, int firstRow, int lastRow) {
        FilterRowTM.logFine("onRowDeleted({0},{1})", firstRow, lastRow);
        FilterRowTM.logFiner("source.size={0}", this.source == null ? "null" : Integer.valueOf(this.source.size()));
        if (this.source == null) {
            this.applyFilter(true);
            return new LinkedList<TableModelEvent>();
        }
        if (this.tableModel == null) {
            return this.deletageTMEvent(onDeleteEvent);
        }
        if (lastRow < firstRow) {
            return this.deletageTMEvent(onDeleteEvent);
        }
        return this.syncOnDelete(((SyncDeleteOpts)((SyncDeleteOpts)((SyncDeleteOpts)new SyncDeleteOpts().fireDeleted(true)).fireInserted(false)).fireUpdated(false)).range(firstRow, lastRow));
    }

    protected List<TableModelEvent> syncOnDelete(SyncDeleteOpts sopts) {
        int i;
        if (sopts == null) {
            sopts = new SyncDeleteOpts();
        }
        LinkedList<TableModelEvent> evs = new LinkedList<TableModelEvent>();
        IndexSetBasic<Integer> newIdx = this.buildSourceIndex();
        IndexSetBasic oldIdx = new IndexSetBasic();
        oldIdx.add(this.source, (Reciver)new Reciver<Pair<Integer, Integer>>(){

            public void recive(Pair<Integer, Integer> obj) {
            }
        });
        if (sopts.fireDeleted && sopts.firstRow <= sopts.lastRow && sopts.firstRow >= 0) {
            while (true) {
                int deleteIdx = -1;
                for (int i2 = oldIdx.size() - 1; i2 >= 0; --i2) {
                    int trgtIdx = (Integer)oldIdx.get(i2);
                    if (trgtIdx < sopts.firstRow || trgtIdx > sopts.lastRow) continue;
                    deleteIdx = i2;
                    break;
                }
                if (deleteIdx < 0) break;
                TableModelEvent e = new TableModelEvent(this, deleteIdx, deleteIdx, -1, -1);
                evs.add(e);
                oldIdx.removeByIndex(deleteIdx);
            }
        }
        if (sopts.fireUpdated) {
            for (i = 0; i < Math.min(newIdx.size(), oldIdx.size()); ++i) {
                Integer newSrcRi;
                Integer oldSrcRi = (Integer)oldIdx.get(i);
                if (Objects.equals(oldSrcRi, newSrcRi = (Integer)newIdx.get(i))) continue;
                TableModelEvent e = new TableModelEvent(this, i, i, -1, 0);
                evs.add(e);
            }
        }
        for (i = 0; i < newIdx.size(); ++i) {
            Integer srcRi = (Integer)newIdx.get(i);
            if (oldIdx.exists((Comparable)srcRi) || !sopts.fireInserted) continue;
            TableModelEvent e = new TableModelEvent(this, i, i, -1, 1);
            evs.add(e);
        }
        this.source = newIdx;
        return evs;
    }

    @Override
    protected List<TableModelEvent> onTableChanged(TableModelEvent e) {
        FilterRowTM.logFine("onTableChanged({0},{1})", new Object[0]);
        this.applyFilter();
        return null;
    }

    protected static class SyncDeleteOpts
    extends SyncOpts<SyncDeleteOpts> {
        public int firstRow;
        public int lastRow;

        protected SyncDeleteOpts() {
        }

        public SyncDeleteOpts range(int first, int last) {
            this.firstRow = first;
            this.lastRow = last;
            return this;
        }
    }

    protected static class SyncOpts<T extends SyncOpts> {
        public boolean fireDeleted = true;
        public boolean fireUpdated = true;
        public boolean fireInserted = true;

        protected SyncOpts() {
        }

        public T fireDeleted(boolean v) {
            this.fireDeleted = v;
            return (T)this;
        }

        public T fireUpdated(boolean v) {
            this.fireUpdated = v;
            return (T)this;
        }

        public T fireInserted(boolean v) {
            this.fireInserted = v;
            return (T)this;
        }
    }
}

