/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.gui.swing.table.EventSupport;

public class HUnionTM
implements TableModel {
    private EventList<TableModel> tableModels = new BasicEventList();
    protected final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
        }
    };
    protected EventSupport eventSupport = new EventSupport(this);

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(HUnionTM.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected void attachTableModelListener(TableModel tm) {
        if (tm == null) {
            return;
        }
        tm.addTableModelListener(this.tableModelListener);
    }

    protected void detachTableModelListener(TableModel tm) {
        if (tm == null) {
            return;
        }
        tm.removeTableModelListener(this.tableModelListener);
    }

    @Override
    public int getRowCount() {
        if (this.tableModels == null) {
            return 0;
        }
        if (this.tableModels.size() == 0) {
            return 0;
        }
        return ((TableModel)this.tableModels.get(0)).getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.tableModels == null) {
            return 0;
        }
        if (this.tableModels.size() == 0) {
            return 0;
        }
        int co = 0;
        for (TableModel tm : this.tableModels) {
            if (tm == null) continue;
            co += tm.getColumnCount();
        }
        return co;
    }

    protected Pair<TableModel, Integer> getTMColumn(int columnIndex) {
        if (this.tableModels == null) {
            return null;
        }
        if (this.tableModels.size() == 0) {
            return null;
        }
        if (columnIndex < 0) {
            return null;
        }
        int offset = 0;
        for (TableModel tm : this.tableModels) {
            int cc = tm.getColumnCount();
            if (columnIndex < offset + cc && columnIndex < offset) {
                return new BasicPair((Object)tm, (Object)(columnIndex - offset));
            }
            offset += cc;
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.tableModels == null) {
            return "?";
        }
        if (this.tableModels.size() == 0) {
            return "?";
        }
        Pair<TableModel, Integer> pTC = this.getTMColumn(columnIndex);
        if (pTC == null) {
            return "?";
        }
        return ((TableModel)pTC.A()).getColumnName((Integer)pTC.B());
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.tableModels == null) {
            return null;
        }
        if (this.tableModels.size() == 0) {
            return null;
        }
        Pair<TableModel, Integer> pTC = this.getTMColumn(columnIndex);
        if (pTC == null) {
            return null;
        }
        return ((TableModel)pTC.A()).getColumnClass((Integer)pTC.B());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.tableModels == null) {
            return false;
        }
        if (this.tableModels.size() == 0) {
            return false;
        }
        Pair<TableModel, Integer> pTC = this.getTMColumn(columnIndex);
        if (pTC == null) {
            return false;
        }
        return ((TableModel)pTC.A()).isCellEditable(rowIndex, (Integer)pTC.B());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.tableModels == null) {
            return null;
        }
        if (this.tableModels.size() == 0) {
            return null;
        }
        Pair<TableModel, Integer> pTC = this.getTMColumn(columnIndex);
        if (pTC == null) {
            return false;
        }
        return ((TableModel)pTC.A()).getValueAt(rowIndex, (Integer)pTC.B());
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.tableModels == null) {
            return;
        }
        if (this.tableModels.size() == 0) {
            return;
        }
        Pair<TableModel, Integer> pTC = this.getTMColumn(columnIndex);
        if (pTC == null) {
            return;
        }
        ((TableModel)pTC.A()).setValueAt(aValue, rowIndex, (Integer)pTC.B());
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.eventSupport.removeTableModelListener(l);
    }

    public TableModelListener[] getListeners() {
        return this.eventSupport.getListeners();
    }

    public void fireTableModelEvent(TableModelEvent e) {
        this.eventSupport.fireTableModelEvent(e);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        this.eventSupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        this.eventSupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        this.eventSupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowUpdated(int row) {
        this.eventSupport.fireRowUpdated(row);
    }

    public void fireColumnsChanged() {
        this.eventSupport.fireColumnsChanged();
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        this.eventSupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireAllChanged() {
        this.eventSupport.fireAllChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.eventSupport.addTableModelListener(l);
    }
}

