/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.EventSupport;
import xyz.cofe.gui.swing.table.GetReaderForRow;
import xyz.cofe.gui.swing.table.IsRowEditable;

public class ListTM<E>
implements TableModel {
    protected final Lock lock;
    private volatile transient PropertyChangeSupport propertyChangeSupport = null;
    protected EventSupport evSupport = new EventSupport(this);
    protected final CloseableSet listListeners = new CloseableSet();
    protected IndexEventList<E> list = new IndexEventList();
    protected final SimpleListAdapter<Column> columnsAdapter = new SimpleListAdapter<Column>(){

        protected void removed(Column e, EventList<Column> list, Integer position) {
            if (e != null) {
                e.removePropertyChangeListener(ListTM.this.columnPropertiesListener);
            }
            ListTM.this.fireColumnsChanged();
        }

        protected void added(Column e, EventList<Column> list, Integer position) {
            if (e != null) {
                e.addPropertyChangeListener(ListTM.this.columnPropertiesListener);
            }
            ListTM.this.fireColumnsChanged();
        }
    };
    protected PropertyChangeListener columnPropertiesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                ListTM.this.fireColumnsChanged();
            } else if ("type".equals(evt.getPropertyName())) {
                ListTM.this.fireColumnsChanged();
            } else if ("sourceColumn".equals(evt.getPropertyName())) {
                ListTM.this.fireAllChanged();
            } else if ("reader".equals(evt.getPropertyName())) {
                ListTM.this.fireAllChanged();
            }
        }
    };
    protected Columns columns = new Columns();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ListTM.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ListTM.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ListTM.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ListTM.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ListTM.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ListTM.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ListTM() {
        this.lock = new ReentrantLock();
        if (this.list != null) {
            this.addSourceListeners();
        }
        if (this.columns != null) {
            this.columns.addEventListListener((EventListListener)this.columnsAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeSupport propertySupport() {
        if (this.propertyChangeSupport != null) {
            return this.propertyChangeSupport;
        }
        ListTM listTM = this;
        synchronized (listTM) {
            if (this.propertyChangeSupport != null) {
                return this.propertyChangeSupport;
            }
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
            return this.propertyChangeSupport;
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertySupport().firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().removePropertyChangeListener(listener);
    }

    public EventSupport getEventSupport() {
        return this.evSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.removeTableModelListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TableModelListener> getListenersCollection() {
        ListTM listTM = this;
        synchronized (listTM) {
            return this.evSupport.getListenersCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableModelListener[] getListeners() {
        ListTM listTM = this;
        synchronized (listTM) {
            return this.evSupport.getListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTableModelEvent(TableModelEvent e) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireTableModelEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRowUpdated(int row) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireRowUpdated(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireColumnsChanged() {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireColumnsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCellChanged(int rowIndex, int columnIndex) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireCellChanged(rowIndex, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllChanged() {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.fireAllChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        ListTM listTM = this;
        synchronized (listTM) {
            this.evSupport.addTableModelListener(l);
        }
    }

    protected void addSourceListeners() {
        if (this.list == null) {
            return;
        }
        Closeable cl = this.list.onInserted(new Func3<Object, Integer, E, E>(){

            public Object apply(Integer idx, E oldv, E newv) {
                ListTM.this.onInserted(newv, idx);
                return null;
            }
        });
        this.listListeners.add(cl);
        cl = this.list.onUpdated(new Func3<Object, Integer, E, E>(){

            public Object apply(Integer idx, E oldv, E newv) {
                ListTM.this.onUpdated(oldv, newv, idx);
                return null;
            }
        });
        this.listListeners.add(cl);
        cl = this.list.onDeleted(new Func3<Object, Integer, E, E>(){

            public Object apply(Integer idx, E oldv, E newv) {
                ListTM.this.onDeleted(oldv, idx);
                return null;
            }
        });
        this.listListeners.add(cl);
    }

    public boolean isSourceListen() {
        try {
            this.lock.lock();
            if (this.list == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.listListeners.getCloseables().length > 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSourceListen(boolean listen) {
        boolean old = this.isSourceListen();
        if (listen != old) {
            try {
                this.lock.lock();
                if (listen) {
                    this.addSourceListeners();
                } else {
                    this.listListeners.closeAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            boolean now = this.isSourceListen();
            if (now != old) {
                this.firePropertyChange("sourceListen", old, now);
            }
        }
    }

    public IndexEventList<E> getList() {
        try {
            this.lock.lock();
            if (this.list == null) {
                this.list = new IndexEventList();
                this.addSourceListeners();
            }
            IndexEventList<E> indexEventList = this.list;
            return indexEventList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(IndexEventList<E> newList) {
        IndexEventList<E> oldl = null;
        IndexEventList<E> newl = null;
        try {
            this.lock.lock();
            this.listListeners.closeAll();
            oldl = this.list;
            newl = newList;
            this.list = newList;
            if (this.list != null) {
                this.addSourceListeners();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.firePropertyChange("list", oldl, newl);
        this.fireAllChanged();
    }

    protected void onInserted(E e, Integer position) {
        if (position == null) {
            throw new IllegalArgumentException("position == null");
        }
        this.fireRowsInserted(position, position);
    }

    protected void onUpdated(E oldv, E newv, Integer position) {
        if (position == null) {
            throw new IllegalArgumentException("position == null");
        }
        this.fireRowsUpdated(position, position);
    }

    protected void onDeleted(E e, Integer position) {
        if (position == null) {
            throw new IllegalArgumentException("position == null");
        }
        this.fireRowsDeleted(position, position);
    }

    public E getItemByIndex(int index) {
        try {
            this.lock.lock();
            if (this.list == null) {
                E e = null;
                return e;
            }
            if (index < 0) {
                E e = null;
                return e;
            }
            if (index >= this.list.size()) {
                E e = null;
                return e;
            }
            Object object = this.list.get(index);
            return (E)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfItem(E item) {
        int res = -1;
        try {
            this.lock.lock();
            if (this.list == null) {
                int n = -1;
                return n;
            }
            res = this.list.indexOf(item);
        }
        finally {
            this.lock.unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getIndexesOfItem(Predicate<E> pred) {
        if (pred == null) {
            throw new IllegalArgumentException("pred==null");
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        int idx = -1;
        try {
            this.lock.lock();
            if (this.list == null) {
                ArrayList<Integer> arrayList = res;
                return arrayList;
            }
            for (Object o : this.list) {
                ++idx;
                if (!pred.validate(o)) continue;
                res.add(idx);
            }
        }
        finally {
            this.lock.unlock();
        }
        return res;
    }

    public Columns getColumns() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        try {
            this.lock.lock();
            if (this.list == null) {
                int n = 0;
                return n;
            }
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columns == null || columnIndex < 0 || columnIndex >= this.columns.size()) {
            return "?";
        }
        return ((Column)this.columns.get(columnIndex)).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.columns == null || columnIndex < 0 || columnIndex >= this.columns.size()) {
            return Object.class;
        }
        return ((Column)this.columns.get(columnIndex)).getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            this.lock.lock();
            if (this.list == null) {
                boolean bl = false;
                return bl;
            }
            if (this.columns == null) {
                boolean bl = false;
                return bl;
            }
            if (rowIndex < 0) {
                boolean bl = false;
                return bl;
            }
            if (rowIndex >= this.list.size()) {
                boolean bl = false;
                return bl;
            }
            if (columnIndex < 0) {
                boolean bl = false;
                return bl;
            }
            if (columnIndex >= this.columns.size()) {
                boolean bl = false;
                return bl;
            }
            Column col = (Column)this.columns.get(columnIndex);
            if (col.getWriter() != null) {
                Object v = this.list.get(rowIndex);
                if (col instanceof IsRowEditable) {
                    boolean bl = ((IsRowEditable)((Object)col)).isRowEditable(v);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Convertor<Object, Object> conv;
        Column c = null;
        Object v = null;
        try {
            this.lock.lock();
            if (this.list == null) {
                Object var5_5 = null;
                return var5_5;
            }
            if (this.columns == null) {
                Object var5_6 = null;
                return var5_6;
            }
            if (rowIndex < 0) {
                Object var5_7 = null;
                return var5_7;
            }
            if (rowIndex >= this.list.size()) {
                Object var5_8 = null;
                return var5_8;
            }
            if (columnIndex < 0) {
                Object var5_9 = null;
                return var5_9;
            }
            if (columnIndex >= this.columns.size()) {
                Object var5_10 = null;
                return var5_10;
            }
            v = this.list.get(rowIndex);
            c = (Column)this.columns.get(columnIndex);
        }
        finally {
            this.lock.unlock();
        }
        if (c == null) {
            return null;
        }
        Convertor<Object, Object> convertor = conv = c instanceof GetReaderForRow ? c.getReader(rowIndex) : c.getReader();
        if (conv == null) {
            return null;
        }
        return conv.convert(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Column c = null;
        Object v = null;
        try {
            this.lock.lock();
            if (this.list == null) {
                return;
            }
            if (this.columns == null) {
                return;
            }
            if (rowIndex < 0) {
                return;
            }
            if (rowIndex >= this.list.size()) {
                return;
            }
            if (columnIndex < 0) {
                return;
            }
            if (columnIndex >= this.columns.size()) {
                return;
            }
            v = this.list.get(rowIndex);
            c = (Column)this.columns.get(columnIndex);
        }
        finally {
            this.lock.unlock();
        }
        if (c == null) {
            return;
        }
        Convertor<Column.Cell, Boolean> cellWriter = c.getWriter();
        if (cellWriter == null) {
            return;
        }
        Boolean succ = (Boolean)cellWriter.convert((Object)new Column.Cell(v, aValue));
        if (succ.booleanValue()) {
            this.fireRowsUpdated(rowIndex, rowIndex);
        }
    }
}

