/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.EventMapAdapter;
import xyz.cofe.collection.map.EventMapListener;
import xyz.cofe.gui.swing.table.EventSupport;

public class MapTM<K, V>
implements TableModel {
    private static final Logger logger = Logger.getLogger(MapTM.class.getName());
    private static final Level logLevel = logger.getLevel();
    private transient PropertyChangeSupport propertyChangeSupport = null;
    protected EventSupport evSupport = new EventSupport(this);
    private EventMap<K, V> map = null;
    private final EventMapListener<K, V> listener = new EventMapAdapter<K, V>(){

        protected void updated(EventMap<K, V> map, V old, K key, V value) {
            MapTM.this.onMapEntryUpdated(map, key, value, old);
        }

        protected void deleted(EventMap<K, V> map, K key, V value) {
            MapTM.this.onMapEntryDeleted(map, key, value);
        }

        protected void inserted(EventMap<K, V> map, K key, V value) {
            MapTM.this.onMapEntryInserted(map, key, value);
        }
    };
    private final List<Runnable> eventQueue = new ArrayList<Runnable>();
    private final AtomicBoolean generateEvents = new AtomicBoolean(true);
    private List<Pair<K, V>> cache = null;
    private WeakHashMap<K, Integer> key2rowCache = new WeakHashMap();
    private int nullKeyRow = -1;
    private Class keyType;
    private String keyName;
    private Class valueType;
    private String valueName;
    private Convertor<K, Object> keyReader;
    private Convertor<Object, K> keyWriter;
    private Convertor<V, Object> valueReader;
    private Convertor<Object, V> valueWriter;
    private final AtomicBoolean isCellEditableCalled = new AtomicBoolean(false);
    private final AtomicBoolean getValueAtCalled = new AtomicBoolean(false);
    private boolean removeOldKey = true;
    private final AtomicBoolean setValueAtCalled = new AtomicBoolean(false);
    private final AtomicInteger setValueAt_updateRowIdx = new AtomicInteger(-1);

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    protected PropertyChangeSupport propertySupport() {
        if (this.propertyChangeSupport != null) {
            return this.propertyChangeSupport;
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertySupport().firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.evSupport.removeTableModelListener(l);
    }

    public Collection<TableModelListener> getListenersCollection() {
        return this.evSupport.getListenersCollection();
    }

    public TableModelListener[] getListeners() {
        return this.evSupport.getListeners();
    }

    public void fireTableModelEvent(TableModelEvent e) {
        this.evSupport.fireTableModelEvent(e);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        this.evSupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        this.evSupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        this.evSupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowUpdated(int row) {
        this.evSupport.fireRowUpdated(row);
    }

    public void fireColumnsChanged() {
        this.evSupport.fireColumnsChanged();
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        this.evSupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireAllChanged() {
        this.evSupport.fireAllChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.evSupport.addTableModelListener(l);
    }

    public EventMap<K, V> getMap() {
        return this.map;
    }

    public void setMap(EventMap<K, V> map) {
        int oldCount = -1;
        int newCount = -1;
        EventMap<K, V> old = null;
        oldCount = this.getRowCount();
        old = this.map;
        if (this.map != null) {
            this.map.removeEventMapListener(this.listener);
        }
        this.map = map;
        if (this.map != null) {
            this.map.addEventMapListener(this.listener, true);
        }
        this.clearCache();
        newCount = this.getRowCount();
        this.firePropertyChange("map", old, this.map);
        if (oldCount < 0 || newCount < 0) {
            this.fireAllChanged();
        } else {
            if (oldCount > 0) {
                this.fireRowsDeleted(0, oldCount - 1);
            }
            if (newCount > 0) {
                this.fireRowsInserted(0, newCount - 1);
            }
        }
    }

    protected List<Runnable> getEventQueue() {
        return this.eventQueue;
    }

    protected void addEventQueue(Runnable r) {
        if (r != null) {
            this.getEventQueue().add(r);
        }
    }

    protected void runEventQueue() {
        List<Runnable> l = this.getEventQueue();
        for (Runnable r : l.toArray(new Runnable[0])) {
            r.run();
        }
        l.clear();
    }

    protected boolean isTMMethodCalled() {
        return this.isCellEditableCalled.get() || this.getValueAtCalled.get() || this.setValueAtCalled.get();
    }

    protected void addCachePair(Pair<K, V> p) {
        this.getCachePairs().add(p);
    }

    protected int getCachePairsSize() {
        return this.getCachePairs().size();
    }

    protected void onMapEntryInserted(EventMap<K, V> map, K key, V value) {
        final int[] rowidx = new int[]{-1};
        BasicPair p = new BasicPair(key, value);
        this.addCachePair((Pair<K, V>)p);
        rowidx[0] = this.getCachePairsSize() - 1;
        this.setKeyRow(key, rowidx[0]);
        Runnable ev = new Runnable(){

            @Override
            public void run() {
                MapTM.this.fireRowsInserted(rowidx[0], rowidx[0]);
            }
        };
        if (this.generateEvents.get()) {
            this.addEventQueue(ev);
        }
        if (!this.isTMMethodCalled()) {
            this.runEventQueue();
        }
    }

    protected void removeCachePairByIndex(int idx) {
        this.getCachePairs().remove(idx);
    }

    protected void rebuildKeyRowCache() {
        this.key2rowCache.clear();
        int idx = -1;
        for (Pair<K, V> p : this.getCachePairs()) {
            this.key2rowCache.put(p.A(), ++idx);
        }
    }

    protected void onMapEntryDeleted(EventMap<K, V> map, K key, V value) {
        int csize;
        final int rowidx = this.getKeyRow(key);
        if (rowidx >= 0 && rowidx < (csize = this.getCachePairsSize())) {
            this.removeCachePairByIndex(rowidx);
            this.rebuildKeyRowCache();
            Runnable ev = new Runnable(){

                @Override
                public void run() {
                    MapTM.this.fireRowsDeleted(rowidx, rowidx);
                }
            };
            if (this.generateEvents.get()) {
                this.addEventQueue(ev);
            }
        }
        if (!this.isTMMethodCalled()) {
            this.runEventQueue();
        }
    }

    protected void onMapEntryUpdated(EventMap<K, V> map, K key, V value, V oldValue) {
        Pair<K, V> p;
        int csize;
        final int rowidx = this.getKeyRow(key);
        if (rowidx >= 0 && rowidx < (csize = this.getCachePairsSize()) && (p = this.getCachePair(rowidx)) != null) {
            this.setCachePair(rowidx, (Pair<K, V>)new BasicPair(key, value));
            Runnable ev = new Runnable(){

                @Override
                public void run() {
                    MapTM.this.fireRowsUpdated(rowidx, rowidx);
                }
            };
            if (this.generateEvents.get()) {
                this.addEventQueue(ev);
            }
        }
        if (!this.isTMMethodCalled()) {
            this.runEventQueue();
        }
    }

    protected void clearCache() {
        this.clearCache0();
    }

    private void clearCache0() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
        this.key2rowCache.clear();
        this.nullKeyRow = -1;
    }

    protected Pair<K, V> getCachePair(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getCachePairs().size()) {
            return null;
        }
        return this.getCachePairs().get(index);
    }

    protected void setCachePair(int index, Pair<K, V> p) {
        if (index < 0) {
            return;
        }
        if (index >= this.getCachePairs().size()) {
            return;
        }
        this.getCachePairs().set(index, p);
    }

    protected void setKeyRow(K key, int row) {
        if (key == null) {
            this.nullKeyRow = row;
        } else {
            this.key2rowCache.put(key, row);
        }
    }

    protected int getKeyRow(K key) {
        if (key == null) {
            return this.nullKeyRow;
        }
        Integer row = this.key2rowCache.get(key);
        return row == null ? -1 : row;
    }

    protected List<Pair<K, Integer>> getKeyRowMap() {
        ArrayList<Pair<K, Integer>> res = new ArrayList<Pair<K, Integer>>();
        if (this.nullKeyRow >= 0) {
            res.add((Pair<K, Integer>)new BasicPair(null, (Object)this.nullKeyRow));
        }
        for (K k : this.key2rowCache.keySet()) {
            if (k == null) continue;
            res.add((Pair<K, Integer>)new BasicPair(k, (Object)this.key2rowCache.get(k)));
        }
        return res;
    }

    protected void rebuildCache() {
        this.clearCache0();
        ArrayList<Pair<K, V>> res = new ArrayList<Pair<K, V>>();
        this.cache = res;
        if (this.map == null) {
            return;
        }
        int rowidx = -1;
        for (Map.Entry oEntry : this.map.entrySet()) {
            if (oEntry == null || !(oEntry instanceof Map.Entry)) continue;
            ++rowidx;
            Map.Entry en = oEntry;
            Object k = en.getKey();
            Object v = en.getValue();
            BasicPair p = new BasicPair(k, v);
            res.add((Pair<K, V>)p);
            this.setKeyRow(k, rowidx);
        }
    }

    protected List<Pair<K, V>> getCachePairs() {
        if (this.cache != null) {
            return this.cache;
        }
        this.rebuildCache();
        return this.cache;
    }

    public Class getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Class keyType) {
        Class old = this.keyType;
        this.keyType = keyType;
        this.firePropertyChange("keyType", old, keyType);
        this.fireColumnsChanged();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        String old = this.keyName;
        this.keyName = keyName;
        this.firePropertyChange("keyName", old, keyName);
        this.fireColumnsChanged();
    }

    public Class getValueType() {
        return this.valueType;
    }

    public void setValueType(Class valueType) {
        Class old = this.valueType;
        this.valueType = valueType;
        this.firePropertyChange("valueType", old, valueType);
        this.fireColumnsChanged();
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        String old = this.valueName;
        this.valueName = valueName;
        this.firePropertyChange("valueName", old, valueName);
        this.fireColumnsChanged();
    }

    public Convertor<K, Object> getKeyReader() {
        return this.keyReader;
    }

    public void setKeyReader(Convertor<K, Object> keyReader) {
        Convertor<K, Object> old = null;
        int co = -1;
        old = this.keyReader;
        this.keyReader = keyReader;
        co = this.getRowCount();
        this.firePropertyChange("keyReader", old, keyReader);
        if (co > 0) {
            this.fireRowsUpdated(0, co - 1);
        }
    }

    public Convertor<Object, K> getKeyWriter() {
        return this.keyWriter;
    }

    public void setKeyWriter(Convertor<Object, K> keyWriter) {
        Convertor<Object, K> old = this.keyWriter;
        this.keyWriter = keyWriter;
        this.firePropertyChange("keyWriter", old, keyWriter);
    }

    public Convertor<V, Object> getValueReader() {
        return this.valueReader;
    }

    public void setValueReader(Convertor<V, Object> valueReader) {
        Convertor<V, Object> old = null;
        int co = -1;
        old = this.valueReader;
        this.valueReader = valueReader;
        co = this.getRowCount();
        this.firePropertyChange("valueReader", old, valueReader);
        if (co > 0) {
            this.fireRowsUpdated(0, co - 1);
        }
    }

    public Convertor<Object, V> getValueWriter() {
        return this.valueWriter;
    }

    public void setValueWriter(Convertor<Object, V> valueWriter) {
        Convertor<Object, V> old = this.valueWriter;
        this.valueWriter = valueWriter;
        this.firePropertyChange("valueWriter", old, valueWriter);
    }

    @Override
    public int getRowCount() {
        return this.getCachePairsSize();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            if (this.keyName != null) {
                return this.keyName;
            }
            return "key";
        }
        if (columnIndex == 1) {
            if (this.valueName != null) {
                return this.valueName;
            }
            return "value";
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.keyType != null) {
            return this.keyType;
        }
        if (columnIndex == 1 && this.valueType != null) {
            return this.valueType;
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            this.isCellEditableCalled.set(true);
            if (columnIndex < 0) {
                boolean bl = false;
                return bl;
            }
            if (columnIndex > 1) {
                boolean bl = false;
                return bl;
            }
            if (rowIndex < 0) {
                boolean bl = false;
                return bl;
            }
            if (rowIndex >= this.getRowCount()) {
                boolean bl = false;
                return bl;
            }
            if (columnIndex == 0 && this.keyWriter != null) {
                boolean bl = true;
                return bl;
            }
            if (columnIndex == 1 && this.valueWriter != null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.isCellEditableCalled.set(false);
            this.runEventQueue();
        }
        return false;
    }

    public Pair<K, V> getKeyValueForRow(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        Pair<K, V> p = this.getCachePair(rowIndex);
        if (p == null) {
            return null;
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            this.getValueAtCalled.set(true);
            if (columnIndex < 0) {
                Boolean bl = false;
                return bl;
            }
            if (columnIndex > 1) {
                Boolean bl = false;
                return bl;
            }
            if (rowIndex < 0) {
                Boolean bl = false;
                return bl;
            }
            if (rowIndex >= this.getRowCount()) {
                Boolean bl = false;
                return bl;
            }
            Pair<K, V> p = this.getCachePair(rowIndex);
            if (p == null) {
                Object var4_8 = null;
                return var4_8;
            }
            if (columnIndex == 0) {
                if (this.keyReader != null) {
                    Object object = this.keyReader.convert(p.A());
                    return object;
                }
                Object object = p.A();
                return object;
            }
            if (columnIndex == 1) {
                if (this.valueReader != null) {
                    Object object = this.valueReader.convert(p.B());
                    return object;
                }
                Object object = p.B();
                return object;
            }
        }
        finally {
            this.getValueAtCalled.set(false);
            this.runEventQueue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.setValueAtCalled.set(true);
            this.setValueAt_updateRowIdx.set(-1);
            if (this.map == null) {
                return;
            }
            if (columnIndex < 0) {
                return;
            }
            if (columnIndex > 1) {
                return;
            }
            if (rowIndex < 0) {
                return;
            }
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            if (columnIndex == 0 && this.keyWriter != null) {
                Object v;
                Pair<K, V> p = this.getCachePair(rowIndex);
                Object newKey = this.keyWriter.convert(aValue);
                Object object = v = p == null ? null : p.B();
                if (this.removeOldKey) {
                    final int row = this.getKeyRow(p.A());
                    this.setValueAt_updateRowIdx.set(row);
                    if (row >= 0) {
                        this.generateEvents.set(false);
                    }
                    this.map.remove(p.A());
                    this.map.put(newKey, v);
                    if (row >= 0) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                MapTM.this.fireRowUpdated(row);
                            }
                        };
                        this.addEventQueue(r);
                    }
                } else {
                    this.map.put(newKey, v);
                }
            }
            if (columnIndex == 1 && this.valueWriter != null) {
                Object newValue = this.valueWriter.convert(aValue);
                Pair<K, V> p = this.getCachePair(rowIndex);
                Object k = p == null ? null : p.A();
                this.map.put(k, newValue);
            }
        }
        finally {
            this.generateEvents.set(true);
            this.setValueAtCalled.set(false);
            this.runEventQueue();
        }
    }
}

