/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.gui.swing.properties.GetPropertyType;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.properties.editor.TreeTableWrapEditor;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.IsRowEditable;
import xyz.cofe.gui.swing.table.PropertyTable;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public class PropertyColumn
extends Column
implements IsRowEditable {
    private static final Logger logger = Logger.getLogger(PropertyColumn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final ListenersHelper<Listener, Event> listeners = new ListenersHelper((Func2)new Func2<Object, Listener, Event>(){

        public Object apply(Listener ls, Event ev) {
            ls.propertyColumnEvent(ev);
            return null;
        }
    });
    protected Boolean forceReadOnly = null;
    protected volatile transient PropertyDB pdb;
    protected PropertyTable propertyTable;
    protected Icon nullIcon = null;
    protected volatile TreeTableNodeFormat nullValueFormat;
    protected ClassMap<Func2<TreeTableNodeFormat, Object, Object>> valueFormat = new ClassMap();
    protected String propertyName = null;
    private ClassMap<Property> classProperties = new ClassMap();
    private Map<Object, Property> mapProperties = new WeakHashMap<Object, Property>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PropertyColumn.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(PropertyColumn.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertyColumn.class.getName(), method, result);
    }

    public PropertyColumn() {
        this.init();
    }

    public PropertyColumn(String name) {
        this.init();
        this.setName(name);
    }

    public PropertyColumn(String name, boolean forceReadonly) {
        this.init();
        this.setName(name);
        this.setForceReadOnly(forceReadonly);
    }

    public PropertyColumn(Object sync, PropertyColumn sample) {
        super(sync, sample);
        if (sample != null) {
            if (sample.valueFormat != null) {
                this.getValueFormat().putAll(sample.getValueFormat());
            }
            if (sample.classProperties != null) {
                this.getClassProperties().putAll(sample.classProperties);
            }
            this.setForceReadOnly(sample.forceReadOnly);
            this.nullIcon = sample.nullIcon;
            if (sample.nullValueFormat != null) {
                this.nullValueFormat = sample.nullValueFormat.clone();
            }
            this.pdb = sample.pdb;
            this.propertyName = sample.propertyName;
            this.propertyTable = sample.propertyTable;
        }
        this.init();
    }

    public boolean hasListener(Listener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<Listener> getListeners() {
        return this.listeners.getListeners();
    }

    public Closeable addListener(Listener listener) {
        return this.listeners.addListener((Object)listener);
    }

    public Closeable addListener(Listener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    public void removeListener(Listener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void fireEvent(Event event) {
        this.listeners.fireEvent((Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getForceReadOnly() {
        Object object = this.sync;
        synchronized (object) {
            return this.forceReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceReadOnly(Boolean forceReadOnly) {
        Object object = this.sync;
        synchronized (object) {
            this.forceReadOnly = forceReadOnly;
        }
    }

    public PropertyColumn forceReadonly(Boolean forceReadOnly) {
        this.setForceReadOnly(forceReadOnly);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PropertyDB getPropertyDB() {
        if (this.pdb != null) {
            return this.pdb;
        }
        Runnable fev = null;
        try {
            Object object = this.sync;
            // MONITORENTER : object
            if (this.pdb != null) {
                PropertyDB propertyDB = this.pdb;
                // MONITOREXIT : object
                if (fev == null) return propertyDB;
                fev.run();
                return propertyDB;
            }
            this.pdb = new PropertyDB();
        }
        catch (Throwable throwable) {
            if (fev == null) throw throwable;
            fev.run();
            throw throwable;
        }
        fev = new Runnable(){

            @Override
            public void run() {
                PropertyColumn.this.firePropertyChange("propertyDB", null, PropertyColumn.this.pdb);
            }
        };
        PropertyDB propertyDB = this.pdb;
        // MONITOREXIT : object
        if (fev == null) return propertyDB;
        fev.run();
        return propertyDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyDB(final PropertyDB newPdb) {
        Runnable fev = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                final PropertyDB old = this.pdb;
                this.pdb = newPdb;
                fev = new Runnable(){

                    @Override
                    public void run() {
                        PropertyColumn.this.firePropertyChange("propertyDB", old, newPdb);
                    }
                };
            }
        }
        finally {
            if (fev != null) {
                fev.run();
            }
        }
    }

    public PropertyColumn propertyDB(PropertyDB newPdb) {
        this.setPropertyDB(newPdb);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyTable getPropertyTable() {
        Object object = this.sync;
        synchronized (object) {
            return this.propertyTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyTable(PropertyTable propertyTable) {
        PropertyTable old = null;
        Object object = this.sync;
        synchronized (object) {
            old = this.getPropertyTable();
            this.propertyTable = propertyTable;
        }
        this.firePropertyChange("propertyTable", old, this.getPropertyTable());
    }

    public PropertyColumn propertyTable(PropertyTable propertyTable) {
        this.setPropertyTable(propertyTable);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Columns getColumns() {
        Object object = this.sync;
        synchronized (object) {
            PropertyTable pt = this.getPropertyTable();
            if (pt == null) {
                return null;
            }
            return pt.getColumns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getModelIndex() {
        Object object = this.sync;
        synchronized (object) {
            Columns cols = this.getColumns();
            if (cols == null) {
                return -1;
            }
            return cols.indexOf(this);
        }
    }

    protected Icon getNullIcon() {
        if (this.nullIcon != null) {
            return this.nullIcon;
        }
        this.nullIcon = Icons.getNullIcon();
        return this.nullIcon;
    }

    protected void setNullIcon(Icon ico) {
        this.nullIcon = ico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeFormat getNullValueFormat() {
        TreeTableNodeFormat fmt = this.nullValueFormat;
        if (fmt != null) {
            return fmt;
        }
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            fmt = this.nullValueFormat;
            if (fmt != null) {
                return fmt;
            }
            fmt = new TreeTableNodeFormatBasic();
            fmt.setBold(true);
            fmt.setItalic(true);
            fmt.setForeground(Color.gray);
            Icon ico = this.getNullIcon();
            if (ico != null) {
                fmt.getIcons().add(ico);
            }
            this.nullValueFormat = fmt;
            return this.nullValueFormat;
        }
    }

    public void setNullValueFormat(TreeTableNodeFormat nullValueFormat) {
        this.nullValueFormat = nullValueFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("init()", new Object[0]);
            this.setType(PropertyValue.class);
            this.setReader(new Convertor<Object, Object>(){

                public Object convert(Object bean) {
                    return PropertyColumn.this.read(bean);
                }
            });
            this.setWriter(new Convertor<Column.Cell, Boolean>(){

                public Boolean convert(Column.Cell from) {
                    if (from == null) {
                        return false;
                    }
                    if (from.newValue instanceof PropertyValue) {
                        return PropertyColumn.this.write(from.object, (PropertyValue)from.newValue);
                    }
                    return false;
                }
            });
        }
    }

    public ClassMap<Func2<TreeTableNodeFormat, Object, Object>> getValueFormat() {
        if (this.valueFormat != null) {
            return this.valueFormat;
        }
        this.valueFormat = new ClassMap();
        return this.valueFormat;
    }

    public <T> PropertyColumn addValueFormat(Class<T> cls, Func2<TreeTableNodeFormat, Object, T> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.getValueFormat().put(cls, reader);
        return this;
    }

    public <T> PropertyColumn addValueFormat(Class<T> cls, final Func1<TreeTableNodeFormat, T> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.getValueFormat().put(cls, (Object)new Func2<TreeTableNodeFormat, Object, Object>(){

            public TreeTableNodeFormat apply(Object bean, Object data) {
                return (TreeTableNodeFormat)reader.apply(data);
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("setName({0})", name);
            this.classProperties.clear();
            this.mapProperties.clear();
            super.setName(name);
        }
    }

    @Override
    public PropertyColumn name(String name) {
        this.setName(name);
        return this;
    }

    @Override
    public Convertor<Column.Cell, Boolean> getWriter() {
        return super.getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRowEditable(Object row) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("isRowEditable( {0} )", row);
            if (this.forceReadOnly != null && this.forceReadOnly.booleanValue()) {
                PropertyColumn.logFine("read only forced", new Object[0]);
                return false;
            }
            if (row == null) {
                return false;
            }
            Property property = this.getClassProperty(row.getClass(), this.getName(), row);
            if (property != null) {
                boolean readOnly = property.isReadOnly();
                PropertyColumn.logFiner("isRowEditable( {0} ) = {1}", row, !readOnly);
                return !readOnly;
            }
            if (row instanceof Map && (property = this.getMapProperty((Map)row, this.getName())) != null) {
                boolean readOnly = property.isReadOnly();
                PropertyColumn.logFiner("isRowEditable( {0} ) = {1}", row, !readOnly);
                return !readOnly;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyColumn clone() {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("clone()", new Object[0]);
            return new PropertyColumn(null, this);
        }
    }

    @Override
    public Column cloneWith(Object sync) {
        PropertyColumn.logFine("cloneWith()", new Object[0]);
        return new PropertyColumn(sync, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPropertyName() {
        Object object = this.sync;
        synchronized (object) {
            return this.propertyName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyName(String propertyName) {
        String old = null;
        Object object = this.sync;
        synchronized (object) {
            old = this.getPropertyName();
            this.propertyName = propertyName;
        }
        this.firePropertyChange("propertyName", old, this.getPropertyName());
    }

    public PropertyColumn propertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyValue read(Object bean) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            String name = this.getName();
            if (name == null || name.length() < 1) {
                name = "?";
            }
            PropertyValue pv = null;
            if (bean == null) {
                pv = this.readAsDummy(bean, name);
            } else {
                String pname = this.getPropertyName();
                pname = pname != null ? pname : name;
                pv = this.readFromBean(bean, pname);
            }
            if (pv.getValue() != null) {
                Set<TreeTableNodeGetFormatOf> formatters;
                TreeTableNodeFormat fmt;
                boolean valueFormatted = false;
                Func2 fn = (Func2)this.getValueFormat().fetch(pv.getValue().getClass());
                if (fn != null && (fmt = (TreeTableNodeFormat)fn.apply(bean, pv.getValue())) != null) {
                    pv.setFormat(fmt);
                    valueFormatted = true;
                }
                if (!valueFormatted && (formatters = this.getPropertyDB().getFormattersOf(pv.getValue().getClass())) != null && formatters.size() > 0) {
                    for (TreeTableNodeGetFormatOf gfmt : formatters) {
                        TreeTableNodeFormat fmt2;
                        if (gfmt == null || (fmt2 = gfmt.getTreeTableNodeFormatOf(pv.getValue())) == null) continue;
                        pv.setFormat(fmt2);
                        break;
                    }
                }
            } else {
                pv.setFormat(this.getNullValueFormat());
            }
            PropertyEditor pe = this.getPropertyDB().getPropertyEditorOf(pv);
            if (pe != null) {
                if (pe instanceof TreeTableNodeValueEditor.Editor) {
                    pv.setEditor((TreeTableNodeValueEditor.Editor)((Object)pe));
                } else if (pe.supportsCustomEditor()) {
                    pv.setEditor(new TreeTableWrapEditor(pe));
                }
            }
            return pv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Object bean, PropertyValue pvalue) {
        Property prop = null;
        Object newvalue = null;
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("write( {0}, {1} )", bean, pvalue);
            if (pvalue == null) {
                PropertyColumn.logFinest("exit from write", new Object[0]);
                return false;
            }
            prop = pvalue.getProperty();
            if (prop == null) {
                PropertyColumn.logFiner("property from pvalue not found", new Object[0]);
                return false;
            }
            if (prop.isReadOnly()) {
                PropertyColumn.logFiner("property is read only", new Object[0]);
                return false;
            }
            newvalue = pvalue.getValue();
            PropertyColumn.logFiner("assign value = {0}", newvalue);
            if (prop.isNotNull() && newvalue == null) {
                PropertyColumn.logFiner("is null - not allowed (isNotNull())", new Object[0]);
                return false;
            }
            try {
                prop.setBean(bean);
                prop.write(newvalue);
                PropertyColumn.logFiner("write property ({0}) value ({1}) success", prop.getName(), newvalue);
            }
            catch (Throwable err) {
                PropertyColumn.logException(err);
                System.err.println(err.toString());
                return false;
            }
        }
        this.fireEvent(new PropertyWrited(this, prop, bean, newvalue));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue readAsDummy(final Object bean, final String name) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("readAsDummy( {0}, {1} )", bean, name);
            Property prop = new Property(name, Void.class, new Func0(){

                public Object apply() {
                    PropertyColumn.logFiner("read dummy ( {0}, {1} ) = null", new Object[]{bean, name});
                    return null;
                }
            }, new Func1(){

                public Object apply(Object arg) {
                    PropertyColumn.logFiner("write dummy ( {0}, {1} ) = {2}", new Object[]{bean, name, arg});
                    return null;
                }
            });
            prop.setBean(bean);
            prop.setName(name);
            prop.setReadOnly(true);
            PropertyValue pvalue = new PropertyValue(prop, null, null);
            return pvalue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap<Property> getClassProperties() {
        Object object = this.sync;
        synchronized (object) {
            return this.classProperties;
        }
    }

    public PropertyColumn classProperty(Class beanClass, Property prop) {
        if (beanClass != null && prop != null) {
            this.getClassProperties().put(beanClass, (Object)prop);
        }
        return this;
    }

    public <BEAN, PROP> PropertyColumn classProperty(final Class<BEAN> beanClass, String name, final Class<PROP> propType, final Func1<PROP, BEAN> propReader, final Func2<Object, BEAN, PROP> propWrite) {
        Property prop;
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass==null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (propType == null) {
            throw new IllegalArgumentException("propType==null");
        }
        if (propReader == null) {
            throw new IllegalArgumentException("propReader==null");
        }
        final Property[] cprop = new Property[1];
        Func1 fwr = null;
        Func0 frd = new Func0(){

            public Object apply() {
                Property pr = cprop[0];
                Object bean = null;
                if (pr != null) {
                    bean = pr.getBean();
                }
                if (bean != null) {
                    if (beanClass.isAssignableFrom(bean.getClass())) {
                        return propReader.apply(bean);
                    }
                    return propReader.apply(null);
                }
                return propReader.apply(null);
            }
        };
        if (propWrite != null) {
            fwr = new Func1(){

                public Object apply(Object val) {
                    Property pr = cprop[0];
                    Object bean = null;
                    if (pr != null) {
                        bean = pr.getBean();
                    }
                    if (bean != null) {
                        if (beanClass.isAssignableFrom(bean.getClass())) {
                            if (val == null) {
                                return propWrite.apply(bean, null);
                            }
                            if (propType.isAssignableFrom(val.getClass())) {
                                return propWrite.apply(bean, val);
                            }
                        } else {
                            return propWrite.apply(null, null);
                        }
                    }
                    return propWrite.apply(null, null);
                }
            };
        }
        cprop[0] = prop = new Property(name, propType, frd, fwr);
        this.getClassProperties().put(beanClass, (Object)prop);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property getClassProperty(Class beanClass, String propertyName, Object bean) {
        Object object = this.sync;
        synchronized (object) {
            if (beanClass == null) {
                throw new IllegalArgumentException("beanClass==null");
            }
            if (propertyName == null) {
                throw new IllegalArgumentException("propertyName==null");
            }
            PropertyColumn.logFine("getClassProperty( {0}, {1}, {2} )", beanClass, propertyName, bean);
            Property cachedProperty = (Property)this.classProperties.fetch(beanClass);
            if (cachedProperty != null) {
                cachedProperty.setBean(bean);
                PropertyColumn.logFine("getClassProperty( {0}, {1}, {2} ) read cached {3}", beanClass, propertyName, bean, cachedProperty);
                return cachedProperty;
            }
            Set<Property> sprops = Property.propertiesOf(beanClass, bean, true, propertyName);
            if (sprops == null || sprops.isEmpty()) {
                PropertyColumn.logFine("getClassProperty( {0}, {1}, {2} ) property not found", beanClass, propertyName, bean);
                return null;
            }
            Property firstProperty = null;
            Iterator<Property> iterator = sprops.iterator();
            if (iterator.hasNext()) {
                Property p;
                firstProperty = p = iterator.next();
            }
            if (firstProperty == null) {
                PropertyColumn.logFine("getClassProperty( {0}, {1}, {2} ) property not found", beanClass, propertyName, bean);
                return null;
            }
            this.classProperties.put(beanClass, (Object)firstProperty);
            PropertyColumn.logFiner("getClassProperty( {0}, {1}, {2} ) cache property ", beanClass, propertyName, bean, firstProperty);
            return firstProperty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue readFromBean(Object bean, String name) {
        Object object = this.sync;
        synchronized (object) {
            PropertyColumn.logFine("readFromBean( {0}, {1} )", bean, name);
            Property property = this.getClassProperty(bean.getClass(), name, bean);
            if (property == null) {
                if (bean instanceof Map) {
                    PropertyColumn.logFiner("readFromBean( {0}, {1} ) property not found, try read bean as map", bean, name);
                    return this.readFromMap((Map)bean, name);
                }
                PropertyColumn.logFiner("readFromBean( {0}, {1} ) property not found, read as dummy", bean, name);
                return this.readAsDummy(bean, name);
            }
            try {
                property.setBean(bean);
                Object val = property.read();
                PropertyValue pvalue = new PropertyValue(property, val, null);
                PropertyColumn.logFiner("readFromBean property={0} value={2} readOnly={1}", property.getName(), property.isReadOnly(), val);
                return pvalue;
            }
            catch (Throwable err) {
                return new PropertyValue(property, null, err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property getMapProperty(final Map map, final String name) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            if (map == null) {
                return null;
            }
            Property p = this.mapProperties.get(map);
            if (p == null && name == null) {
                return null;
            }
            if (name != null && p == null) {
                Class<String> t;
                Object value = map.get(name);
                Class<String> clazz = t = map instanceof GetPropertyType ? ((GetPropertyType)((Object)map)).getPropertyType(name) : null;
                t = t == null ? (value == null ? String.class : value.getClass()) : t;
                PropertyColumn.logFiner("create property {0} : {1} = {2}", name, t, value);
                final Property[] createdProp = new Property[]{null};
                createdProp[0] = p = new Property(name, t, new Func0(){

                    public Object apply() {
                        Object val = map.get(name);
                        PropertyColumn.logFiner("readed map property {0} : {1} = {2}", new Object[]{createdProp[0] == null ? name : createdProp[0].getName(), val == null ? Void.class : val.getClass(), val});
                        return val;
                    }
                }, new Func1(){

                    public Object apply(Object arg) {
                        PropertyColumn.logFiner("write map property {0} : {1} = {2}", new Object[]{createdProp[0] == null ? name : createdProp[0].getName(), arg == null ? Void.class : arg.getClass(), arg});
                        map.put(name, arg);
                        return null;
                    }
                });
                this.mapProperties.put(map, p);
                return p;
            }
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue readFromMap(Map map, String name) {
        PropertyColumn propertyColumn = this;
        synchronized (propertyColumn) {
            PropertyColumn.logFine("readFromMap( {0}, {1} )", map, name);
            Property property = this.getMapProperty(map, name);
            Object value = null;
            if (property == null) {
                return this.readAsDummy(map, name);
            }
            property.setBean(map);
            value = property.read();
            PropertyColumn.logFiner("return PropertyValue( {0}, {1}, null )", property, value);
            PropertyValue pvalue = new PropertyValue(property, value, null);
            return pvalue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumn[] getTableColumns() {
        Object object = this.sync;
        synchronized (object) {
            PropertyTable pt = this.getPropertyTable();
            if (pt == null) {
                return new TableColumn[0];
            }
            int modelIdx = this.getModelIndex();
            if (modelIdx < 0) {
                return new TableColumn[0];
            }
            TableColumnModel tcm = pt.getTable().getColumnModel();
            if (tcm == null) {
                return new TableColumn[0];
            }
            ArrayList<TableColumn> ltc = new ArrayList<TableColumn>();
            int cc = tcm.getColumnCount();
            for (int tci = 0; tci < cc; ++tci) {
                TableColumn tc = tcm.getColumn(tci);
                if (tc.getModelIndex() != modelIdx) continue;
                ltc.add(tc);
            }
            return ltc.toArray(new TableColumn[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        Object object = this.sync;
        synchronized (object) {
            return this.getTableColumns().length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        PropertyTable pt = null;
        Object object = this.sync;
        synchronized (object) {
            pt = this.getPropertyTable();
            if (pt == null) {
                return;
            }
            boolean cv = this.isVisible();
            if (cv == visible) {
                return;
            }
        }
        if (visible) {
            final JTable jt = pt.getTable();
            if (jt == null) {
                return;
            }
            final TableColumn tc = this.createTableColumn();
            if (tc == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    jt.addColumn(tc);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        } else {
            final TableColumn[] tcs = this.getTableColumns();
            final JTable jt = pt.getTable();
            if (jt == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    for (TableColumn tc : tcs) {
                        jt.removeColumn(tc);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumn createTableColumn() {
        Object object = this.sync;
        synchronized (object) {
            TableCellRenderer hcr;
            PropertyTable pt = this.getPropertyTable();
            if (pt == null) {
                return null;
            }
            TableCellRenderer tcRender = pt.getPropertyRender();
            if (tcRender == null) {
                return null;
            }
            TreeTableNodeValueEditor tcEditor = pt.getPropertyEditor();
            if (tcEditor != null) {
                return null;
            }
            int mi = this.getModelIndex();
            if (mi < 0) {
                return null;
            }
            TableColumn tc = new TableColumn(mi);
            String name = this.getName();
            if (name == null) {
                name = "column#" + mi;
            }
            if ((hcr = pt.getHeaderRender()) != null) {
                tc.setHeaderRenderer(hcr);
            }
            tc.setHeaderValue(name);
            tc.setCellRenderer(tcRender);
            tc.setCellEditor(tcEditor);
            return tc;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static interface Listener {
        public void propertyColumnEvent(Event var1);
    }

    public static class PropertyWrited
    extends Event {
        protected Property property;
        protected Object bean;
        protected Object value;

        public PropertyWrited() {
        }

        public PropertyWrited(PropertyColumn propertyColumn) {
            super(propertyColumn);
        }

        public PropertyWrited(PropertyColumn propertyColumn, Property property, Object bean, Object value) {
            super(propertyColumn);
            this.property = property;
            this.bean = bean;
            this.value = value;
        }

        public Property getProperty() {
            return this.property;
        }

        public void setProperty(Property property) {
            this.property = property;
        }

        public Object getBean() {
            return this.bean;
        }

        public void setBean(Object bean) {
            this.bean = bean;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class Event {
        private PropertyColumn propertyColumn;

        public Event() {
        }

        public Event(PropertyColumn propertyColumn) {
            this.propertyColumn = propertyColumn;
        }

        public PropertyColumn getPropertyColumn() {
            return this.propertyColumn;
        }

        public void setPropertyColumn(PropertyColumn propertyColumn) {
            this.propertyColumn = propertyColumn;
        }
    }
}

