/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.table.CachedTM;
import xyz.cofe.gui.swing.table.CellHeaderRenderer;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.FilterRowTM;
import xyz.cofe.gui.swing.table.PropertyColumn;
import xyz.cofe.gui.swing.table.PropertyTableEvent;
import xyz.cofe.gui.swing.table.PropertyTableListener;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.table.SortRowTM;
import xyz.cofe.gui.swing.table.Table;
import xyz.cofe.gui.swing.table.TableFocusTracker;
import xyz.cofe.gui.swing.table.de.CSVExchanger;
import xyz.cofe.gui.swing.table.de.PropertyTableExchanger;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditorDef;

public class PropertyTable
extends JPanel {
    protected final ListenersHelper<PropertyTableListener, PropertyTableEvent> propertyTableListeners = new ListenersHelper((Func2)new Func2<Object, PropertyTableListener, PropertyTableEvent>(){

        public Object apply(PropertyTableListener ls, PropertyTableEvent ev) {
            ls.propertyTableEvent(ev);
            return null;
        }
    });
    protected final PropertyColumn.Listener propertyColumnListener = new PropertyColumn.Listener(){

        @Override
        public void propertyColumnEvent(PropertyColumn.Event ev) {
            if (ev instanceof PropertyColumn.PropertyWrited) {
                PropertyTable.this.firePropertyTableEvent(new PropertyTableEvent.PropertyWrited(PropertyTable.this, (PropertyColumn.PropertyWrited)ev));
            }
        }
    };
    private TableCellRenderer headerRender;
    private TableFocusTracker focusTracker;
    private ImageIcon arrowUpIcon = PropertyTable.readIcon("/xyz/cofe/gui/swing/table/arrow-up.png");
    private ImageIcon arrowDownIcon = PropertyTable.readIcon("/xyz/cofe/gui/swing/table/arrow-down.png");
    protected final CloseableSet csColumns = new CloseableSet();
    protected PropertyDB pdb;
    protected volatile JToolBar toolbar;
    protected volatile JTable table;
    protected volatile JScrollPane tableScroll;
    protected Icon nullIcon = null;
    protected volatile TreeTableNodeFormat nullValueFormat;
    protected boolean autoCreateTableColumn = true;
    protected volatile TableCellRenderer propertyRender;
    protected volatile TreeTableNodeValueEditor propertyEditor;
    protected Func2<Boolean, Object, Collection> inOperator = null;
    protected volatile CachedTM cachedTM;
    protected volatile FilterRowTM filterRowTM;
    protected volatile SortRowTM sortRowTM;
    private Comparator<RowData> defaultComparator = new Comparator<RowData>(){

        @Override
        public int compare(RowData rd1, RowData rd2) {
            int listRI1 = -1;
            int listRI2 = -1;
            if (PropertyTable.eq(rd1.getTableModel(), PropertyTable.this.getSortRowTM())) {
                listRI1 = PropertyTable.this.getSortRowTM().mapRowToInside(rd1.getRowIndex());
                listRI1 = PropertyTable.this.getFilterRowTM().mapRowToInside(listRI1);
            } else if (PropertyTable.eq(rd1.getTableModel(), PropertyTable.this.getFilterRowTM())) {
                listRI1 = PropertyTable.this.getFilterRowTM().mapRowToInside(rd1.getRowIndex());
            }
            if (PropertyTable.eq(rd2.getTableModel(), PropertyTable.this.getSortRowTM())) {
                listRI2 = PropertyTable.this.getSortRowTM().mapRowToInside(rd2.getRowIndex());
                listRI2 = PropertyTable.this.getFilterRowTM().mapRowToInside(listRI2);
            } else if (PropertyTable.eq(rd2.getTableModel(), PropertyTable.this.getFilterRowTM())) {
                listRI2 = PropertyTable.this.getFilterRowTM().mapRowToInside(rd2.getRowIndex());
            }
            if (listRI2 >= 0 && listRI1 >= 0) {
                int res = listRI1 == listRI2 ? 0 : (listRI1 < listRI2 ? -1 : 1);
                return res;
            }
            return 0;
        }
    };
    private Pair<Integer, Boolean>[] columnSort = new Pair[0];
    private boolean selectFirstMatched = false;
    protected Func0<Object> defaultItemBuilder;
    protected BasicAction refreshAction = new BasicAction("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c").actionListener(new Runnable(){

        @Override
        public void run() {
            PropertyTable.this.refresh();
        }
    }).shortDescription("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c").smallIcon(PropertyTable.readIcon("/xyz/cofe/gui/swing/ico/refresh/refresh-icon-16.png"));
    protected JButton refreshButton;
    protected boolean insertEnable = true;
    protected boolean pasteEnable = true;
    protected boolean copyEnable = true;
    protected boolean deleteEnable = true;
    protected BasicAction deleteAction = new BasicAction("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").actionListener(new Runnable(){

        @Override
        public void run() {
            PropertyTable.this.deleteSelected();
        }
    }).shortDescription("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442").smallIcon(PropertyTable.readIcon("/xyz/cofe/gui/swing/table/node-minus-v3-12x12.png"));
    protected JButton deleteButton;
    protected JButton createNewButton;
    protected BasicAction createNewAction = new BasicAction("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c").actionListener(new Runnable(){

        @Override
        public void run() {
            PropertyTable.this.createNew(Integer.MAX_VALUE, true);
        }
    }).shortDescription("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442").smallIcon(PropertyTable.readIcon("/xyz/cofe/gui/swing/table/node-plus-v3-12x12.png"));
    private PropertyTableExchanger exchanger;
    protected BasicAction copyToClipboardAction = new BasicAction("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c").actionListener(new Runnable(){

        @Override
        public void run() {
            PropertyTable.this.copyToClipboard();
        }
    }).shortDescription("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b").smallIcon(PropertyTable.readIcon("/xyz/cofe/gui/swing/ico/copy/copy-16.png"));
    protected JButton copyToClipboardButton;
    protected JButton pasteFromClipboardButton;
    protected BasicAction pasteFromClipboardAction = new BasicAction("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c").actionListener(new Runnable(){

        @Override
        public void run() {
            PropertyTable.this.pasteFromClipboard();
        }
    }).shortDescription("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u044b").smallIcon(PropertyTable.readIcon("/xyz/cofe/gui/swing/ico/paste/paste-16.png"));

    public boolean hasPropertyTableListener(PropertyTableListener listener) {
        return this.propertyTableListeners.hasListener((Object)listener);
    }

    public Set<PropertyTableListener> getPropertyTableListeners() {
        return this.propertyTableListeners.getListeners();
    }

    public Closeable addPropertyTableListener(PropertyTableListener listener) {
        return this.propertyTableListeners.addListener((Object)listener);
    }

    public Closeable addPropertyTableListener(PropertyTableListener listener, boolean weakLink) {
        return this.propertyTableListeners.addListener((Object)listener, weakLink);
    }

    public void removePropertyTableListener(PropertyTableListener listener) {
        this.propertyTableListeners.removeListener((Object)listener);
    }

    public void firePropertyTableEvent(PropertyTableEvent event) {
        this.propertyTableListeners.fireEvent((Object)event);
    }

    public PropertyTable() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTableScroll(), "Center");
        this.add((Component)this.getToolBar(), "North");
        this.setNotifyInAwtThread(true);
        this.setAwtInvokeAndWait(false);
        this.setAutoCreateTableColumn(true);
        this.revalidate();
        this.focusTracker = new TableFocusTracker(this.getTable(), 250, true);
        this.focusTracker.setRowChanged(new Func2<Object, Integer, Integer>(){

            public Object apply(Integer lastRow, Integer currentRow) {
                Object lastObj = PropertyTable.this.getByRow(lastRow);
                Object currObj = PropertyTable.this.getByRow(currentRow);
                PropertyTable.this.firePropertyChange("focused", lastObj, currObj);
                return null;
            }
        });
        this.addPropertyChangeListener("defaultItemBuilder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.checkCreateNewEnable();
            }
        });
        this.addPropertyChangeListener("allowInsert", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.checkCreateNewEnable();
            }
        });
        this.addPropertyChangeListener("allowDelete", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.checkDeleteEnable();
            }
        });
        this.addPropertyChangeListener("allowPaste", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.checkPasteEnable();
            }
        });
        this.addPropertyChangeListener("allowCopy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.checkCopyEnable();
            }
        });
        this.addPropertyChangeListener("inOperator", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyTable.this.refresh();
            }
        });
        this.checkCreateNewEnable();
        this.checkRefreshEnable();
        this.checkDeleteEnable();
        JTableHeader tableHeader = this.getTable().getTableHeader();
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tci = PropertyTable.this.getTable().getColumnModel().getColumnIndexAtX(e.getX());
                if (tci < 0) {
                    return;
                }
                TableColumn tc = PropertyTable.this.getTable().getColumnModel().getColumn(tci);
                if (tc == null) {
                    return;
                }
                int mi = tc.getModelIndex();
                if (mi < 0 || mi >= PropertyTable.this.getColumns().size()) {
                    return;
                }
                PropertyTable.this.onHeaderColumnClicked(e, tc, mi);
            }
        });
        TableCellRenderer tcr = tableHeader.getDefaultRenderer();
        this.headerRender = new CellHeaderRenderer(tcr){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setIcon(null);
                Component cmpt = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Pair[] columnSort = PropertyTable.this.columnSort;
                if (PropertyTable.this.arrowUpIcon != null && PropertyTable.this.arrowDownIcon != null && columnSort != null) {
                    for (Pair p : columnSort) {
                        if (p.A() == null || !((Integer)p.A()).equals(column)) continue;
                        if (p.B() != null && ((Boolean)p.B()).booleanValue()) {
                            this.setIcon(PropertyTable.this.arrowDownIcon);
                            continue;
                        }
                        this.setIcon(PropertyTable.this.arrowUpIcon);
                    }
                }
                return cmpt;
            }
        };
        tableHeader.setDefaultRenderer(this.headerRender);
        this.getColumns().onAdded((Reciver)new Reciver<Column>(){

            public void recive(Column col) {
                if (col instanceof PropertyColumn) {
                    ((PropertyColumn)col).addListener(PropertyTable.this.propertyColumnListener, true);
                }
            }
        });
        this.getColumns().onRemoved((Reciver)new Reciver<Column>(){

            public void recive(Column col) {
                if (col instanceof PropertyColumn) {
                    ((PropertyColumn)col).removeListener(PropertyTable.this.propertyColumnListener);
                }
            }
        });
    }

    public TableCellRenderer getHeaderRender() {
        return this.headerRender;
    }

    private void onHeaderColumnClicked(MouseEvent e, TableColumn tc, int modelIndex) {
        if (e.getButton() == 1) {
            this.updateRowComparator(e, tc, modelIndex);
        }
    }

    public synchronized PropertyDB getPropertyDB() {
        if (this.pdb != null) {
            return this.pdb;
        }
        this.pdb = new PropertyDB();
        return this.pdb;
    }

    public synchronized void setPropertyDB(PropertyDB newPdb) {
        this.pdb = newPdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JToolBar getToolBar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.toolbar != null) {
                return this.toolbar;
            }
            this.toolbar = new JToolBar();
            this.refreshButton = this.toolbar.add(this.getRefreshAction());
            this.copyToClipboardButton = this.toolbar.add(this.getCopyToClipboardAction());
            this.pasteFromClipboardButton = this.toolbar.add(this.getPasteFromClipboardAction());
            this.createNewButton = this.toolbar.add(this.getCreateNewAction());
            this.toolbar.add(new JSeparator());
            this.deleteButton = this.toolbar.add(this.getDeleteSelectedAction());
            this.toolbar.setFloatable(false);
            this.toolbar.addPropertyChangeListener("visible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PropertyTable.this.revalidate();
                }
            });
            this.toolbar.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    Component cmpt = e.getChild();
                }

                @Override
                public void componentRemoved(ContainerEvent e) {
                    Component cmpt = e.getChild();
                }
            });
            return this.toolbar;
        }
    }

    public boolean getToolBarVisible() {
        return this.getToolBar().isVisible();
    }

    public void setToolBarVisible(boolean v) {
        this.getToolBar().setVisible(v);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JTable getTable() {
        if (this.table != null) {
            return this.table;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.table != null) {
                return this.table;
            }
            this.table = new Table();
            this.table.setAutoCreateRowSorter(false);
            this.table.setAutoCreateColumnsFromModel(false);
            this.table.setModel(this.getSortRowTM());
            this.table.setDefaultEditor(PropertyValue.class, this.getPropertyEditor());
            this.table.setDefaultRenderer(PropertyValue.class, this.getPropertyRender());
            this.table.setBackground(Color.white);
            this.table.setFillsViewportHeight(true);
            this.table.setShowVerticalLines(true);
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JScrollPane getTableScroll() {
        if (this.tableScroll != null) {
            return this.tableScroll;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.tableScroll != null) {
                return this.tableScroll;
            }
            this.tableScroll = new JScrollPane(this.getTable());
            return this.tableScroll;
        }
    }

    protected Icon getNullIcon() {
        if (this.nullIcon != null) {
            return this.nullIcon;
        }
        this.nullIcon = Icons.getNullIcon();
        return this.nullIcon;
    }

    protected void setNullIcon(Icon ico) {
        this.nullIcon = ico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeFormat getNullValueFormat() {
        TreeTableNodeFormat fmt = this.nullValueFormat;
        if (fmt != null) {
            return fmt;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            fmt = this.nullValueFormat;
            if (fmt != null) {
                return fmt;
            }
            fmt = new TreeTableNodeFormatBasic();
            fmt.setForeground(Color.gray);
            fmt.setItalic(true);
            fmt.setBold(true);
            Icon ico = this.getNullIcon();
            if (ico != null) {
                fmt.getIcons().add(ico);
            }
            this.nullValueFormat = fmt;
            return this.nullValueFormat;
        }
    }

    public void setNullValueFormat(TreeTableNodeFormat nullValueFormat) {
        this.nullValueFormat = nullValueFormat;
    }

    public boolean isNotifyInAwtThread() {
        return this.getCachedTM().getEventSupport().isNotifyInAwtThread();
    }

    public void setNotifyInAwtThread(boolean v) {
        this.getCachedTM().getEventSupport().setNotifyInAwtThread(v);
    }

    public boolean isAwtInvokeAndWait() {
        return this.getCachedTM().getEventSupport().isAwtInvokeAndWait();
    }

    public void setAwtInvokeAndWait(boolean v) {
        this.getCachedTM().getEventSupport().setAwtInvokeAndWait(v);
    }

    public Iterable getSource() {
        return this.getCachedTM().getSource();
    }

    public void setSource(Iterable src) {
        this.getCachedTM().setSource(src);
        this.checkRefreshEnable();
    }

    public IndexEventList getCache() {
        return this.getCachedTM().getList();
    }

    public List<PTableColumnDesc> getColumnsDesc() {
        ArrayList<PTableColumnDesc> cols = new ArrayList<PTableColumnDesc>();
        JTable tbl = this.getTable();
        TableColumnModel tcm = tbl.getColumnModel();
        for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            cols.add(PTableColumnDesc.create(this, ci, tc));
        }
        return cols;
    }

    public Columns getColumns() {
        return this.getCachedTM().getColumns();
    }

    protected void onColumnInserted(int colIdx, Column col) {
        if (!this.isAutoCreateTableColumn()) {
            return;
        }
        final TableColumn tc = new TableColumn(colIdx);
        tc.setHeaderValue(col.getName());
        if (this.headerRender != null) {
            tc.setHeaderRenderer(this.headerRender);
        }
        if (col instanceof PropertyColumn) {
            tc.setCellRenderer(this.getPropertyRender());
            tc.setCellEditor(this.getPropertyEditor());
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PropertyTable.this.getTable().addColumn(tc);
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    protected void onColumnDeleted(int colIdx, Column col) {
        if (!this.isAutoCreateTableColumn()) {
            return;
        }
        final LinkedHashSet<TableColumn> cols = new LinkedHashSet<TableColumn>();
        TableColumnModel tcm = this.getTable().getColumnModel();
        int colCount = tcm.getColumnCount();
        for (int tci = 0; tci < colCount; ++tci) {
            TableColumn tc = tcm.getColumn(tci);
            if (tc == null || tc.getModelIndex() != colIdx) continue;
            cols.add(tc);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                for (TableColumn tc : cols) {
                    PropertyTable.this.getTable().removeColumn(tc);
                }
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    protected void onColumnUpdated(int colIdx, Column oldcol, Column newcol) {
    }

    public boolean isAutoCreateTableColumn() {
        return this.autoCreateTableColumn;
    }

    public void setAutoCreateTableColumn(boolean autoCreateTableColumn) {
        this.autoCreateTableColumn = autoCreateTableColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCellRenderer getPropertyRender() {
        if (this.propertyRender != null) {
            return this.propertyRender;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.propertyRender != null) {
                return this.propertyRender;
            }
            this.propertyRender = new TCRenderer();
            return this.propertyRender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeValueEditor getPropertyEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.propertyEditor != null) {
                return this.propertyEditor;
            }
            this.propertyEditor = new TreeTableNodeValueEditorDef();
            return this.propertyEditor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Func2<Boolean, Object, Collection> getInOperator() {
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            return this.inOperator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInOperator(Func2<Boolean, Object, Collection> inOperator) {
        Func2<Boolean, Object, Collection> old = this.inOperator;
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            old = this.inOperator;
            this.inOperator = inOperator;
        }
        this.firePropertyChange("inOperator", old, inOperator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedTM getCachedTM() {
        if (this.cachedTM != null) {
            return this.cachedTM;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.cachedTM != null) {
                return this.cachedTM;
            }
            this.cachedTM = new CachedTM(){

                protected boolean contains(Collection col, Object obj) {
                    Boolean v;
                    Func2<Boolean, Object, Collection> inOperator = PropertyTable.this.inOperator;
                    if (inOperator != null && (v = (Boolean)inOperator.apply(obj, (Object)col)) != null) {
                        return v;
                    }
                    return super.contains(col, obj);
                }
            };
            this.cachedTM.getColumns().onChanged((Func3)new Func3<Object, Integer, Column, Column>(){

                public Object apply(Integer cidx, Column oldCol, Column newCol) {
                    if (oldCol != null && newCol != null) {
                        PropertyTable.this.onColumnUpdated(cidx, oldCol, newCol);
                    } else if (oldCol == null && newCol != null) {
                        PropertyTable.this.onColumnInserted(cidx, newCol);
                    } else if (oldCol != null && newCol == null) {
                        PropertyTable.this.onColumnDeleted(cidx, oldCol);
                    }
                    return null;
                }
            });
            this.cachedTM.getColumns().onAdded((Reciver)new Reciver<Column>(){

                public void recive(Column col) {
                    if (col instanceof PropertyColumn) {
                        ((PropertyColumn)col).setPropertyDB(PropertyTable.this.getPropertyDB());
                        ((PropertyColumn)col).setPropertyTable(PropertyTable.this);
                    }
                }
            });
            return this.cachedTM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRowTM getFilterRowTM() {
        if (this.filterRowTM != null) {
            return this.filterRowTM;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.filterRowTM != null) {
                return this.filterRowTM;
            }
            this.filterRowTM = new FilterRowTM();
            this.filterRowTM.setRowFilter(new Predicate<RowData>(){

                public boolean validate(RowData value) {
                    return true;
                }
            });
            this.filterRowTM.setTableModel(this.getCachedTM());
            return this.filterRowTM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortRowTM getSortRowTM() {
        if (this.sortRowTM != null) {
            return this.sortRowTM;
        }
        PropertyTable propertyTable = this;
        synchronized (propertyTable) {
            if (this.sortRowTM != null) {
                return this.sortRowTM;
            }
            this.sortRowTM = new SortRowTM();
            this.sortRowTM.setRowComparator(this.defaultComparator);
            this.sortRowTM.setTableModel(this.getFilterRowTM());
            return this.sortRowTM;
        }
    }

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    private boolean isColumnInSort(Pair<Integer, Boolean>[] columnSort, int modelIndex) {
        if (columnSort == null || columnSort.length < 1) {
            return false;
        }
        for (Pair<Integer, Boolean> p : columnSort) {
            if (p == null || p.A() == null || modelIndex != (Integer)p.A()) continue;
            return true;
        }
        return false;
    }

    private boolean isColumnReverseSort(Pair<Integer, Boolean>[] columnSort, int modelIndex) {
        if (columnSort == null || columnSort.length < 1) {
            return false;
        }
        for (Pair<Integer, Boolean> p : columnSort) {
            if (p == null || p.A() == null || modelIndex != (Integer)p.A()) continue;
            return (Boolean)p.B();
        }
        return false;
    }

    private Pair<Integer, Boolean>[] updateColumnSort(Pair<Integer, Boolean>[] columnSort, int modelIndex, boolean reverse) {
        if (columnSort == null) {
            return null;
        }
        columnSort = Arrays.copyOf(columnSort, columnSort.length);
        for (int ci = 0; ci < columnSort.length; ++ci) {
            BasicPair p;
            if (columnSort[ci] == null || columnSort[ci].A() == null || modelIndex != (Integer)columnSort[ci].A()) continue;
            columnSort[ci] = p = new BasicPair((Object)modelIndex, (Object)reverse);
        }
        return columnSort;
    }

    private Pair<Integer, Boolean>[] appendColumnSort(Pair<Integer, Boolean>[] columnSort, int modelIndex, boolean reverse) {
        if (columnSort == null) {
            columnSort = new Pair[]{};
        }
        columnSort = Arrays.copyOf(columnSort, columnSort.length + 1);
        columnSort[columnSort.length - 1] = new BasicPair((Object)modelIndex, (Object)reverse);
        return columnSort;
    }

    private void updateRowComparator(MouseEvent e, TableColumn tc, int modelIndex) {
        if (e.isControlDown() && e.isShiftDown()) {
            this.resetSort();
            return;
        }
        if (e.isShiftDown()) {
            if (this.isColumnInSort(this.columnSort, modelIndex)) {
                boolean reverse = this.isColumnReverseSort(this.columnSort, modelIndex);
                this.columnSort = this.updateColumnSort(this.columnSort, modelIndex, !this.isColumnReverseSort(this.columnSort, modelIndex));
                Comparator<RowData> rcmp = this.createColumnSort(this.columnSort);
                if (rcmp != null) {
                    this.getSortRowTM().setRowComparator(rcmp);
                }
                return;
            }
            this.columnSort = this.appendColumnSort(this.columnSort, modelIndex, false);
            Comparator<RowData> rcmp = this.createColumnSort(this.columnSort);
            if (rcmp != null) {
                this.getSortRowTM().setRowComparator(rcmp);
            }
            return;
        }
        if (this.columnSort == null || this.columnSort.length < 1) {
            this.columnSort = new Pair[]{new BasicPair((Object)modelIndex, (Object)false)};
            Comparator<RowData> rcmp = this.createColumnSort(this.columnSort);
            if (rcmp != null) {
                this.getSortRowTM().setRowComparator(rcmp);
            }
        } else {
            int ecol = (Integer)this.columnSort[0].A();
            boolean reverse = (Boolean)this.columnSort[0].B();
            if (ecol == modelIndex) {
                this.columnSort = new Pair[]{new BasicPair((Object)modelIndex, (Object)(!reverse ? 1 : 0))};
                Comparator<RowData> rcmp = this.createColumnSort(this.columnSort);
                if (rcmp != null) {
                    this.getSortRowTM().setRowComparator(rcmp);
                }
            } else {
                this.columnSort = new Pair[]{new BasicPair((Object)modelIndex, (Object)false)};
                Comparator<RowData> rcmp = this.createColumnSort(this.columnSort);
                if (rcmp != null) {
                    this.getSortRowTM().setRowComparator(rcmp);
                }
            }
        }
    }

    private Comparator<RowData> createColumnSort(Pair<Integer, Boolean>[] columnSort) {
        Comparator<RowData> cmp = null;
        if (columnSort == null || columnSort.length < 1) {
            cmp = new Comparator<RowData>(){

                @Override
                public int compare(RowData o1, RowData o2) {
                    return 0;
                }
            };
            return cmp;
        }
        final ArrayList<23> comparators = new ArrayList<23>();
        for (final Pair<Integer, Boolean> pcmp : columnSort) {
            cmp = new Comparator<RowData>(){

                @Override
                public int compare(RowData rd1, RowData rd2) {
                    return ((Boolean)pcmp.B() != false ? -1 : 1) * PropertyTable.this.compareCells(rd1, rd2, (Integer)pcmp.A());
                }
            };
            comparators.add(cmp);
        }
        Comparator<RowData> rcmp = new Comparator<RowData>(){

            @Override
            public int compare(RowData rd1, RowData rd2) {
                int r = 0;
                for (Comparator c : comparators) {
                    r = c.compare(rd1, rd2);
                    if (r == 0) continue;
                    return r;
                }
                return r;
            }
        };
        return rcmp;
    }

    private int compareCellValue(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Double d1 = ((Number)o1).doubleValue();
            Double d2 = ((Number)o2).doubleValue();
            return d1.compareTo(d2);
        }
        if (o1.getClass().isAssignableFrom(o2.getClass()) && o1 instanceof Comparable) {
            int cmp = ((Comparable)o1).compareTo(o2);
            return cmp;
        }
        if (o2.getClass().isAssignableFrom(o1.getClass()) && o2 instanceof Comparable) {
            int cmp = -((Comparable)o2).compareTo(o1);
            return cmp;
        }
        return 0;
    }

    private int compareCells(RowData rd1, RowData rd2, int column) {
        int cc1 = rd1.getTableModel().getColumnCount();
        if (column < 0 || column >= cc1) {
            return 0;
        }
        int cc2 = rd2.getTableModel().getColumnCount();
        if (column < 0 || column >= cc2) {
            return 0;
        }
        Object val1 = rd1.getValue(column);
        Object val2 = rd2.getValue(column);
        if (val1 instanceof PropertyValue) {
            val1 = ((PropertyValue)val1).getValue();
        }
        if (val2 instanceof PropertyValue) {
            val2 = ((PropertyValue)val2).getValue();
        }
        return this.compareCellValue(val1, val2);
    }

    public void resetSort() {
        this.columnSort = new Pair[0];
        this.getSortRowTM().setRowComparator(this.defaultComparator);
    }

    public List getSelected() {
        int[] rows;
        LinkedList<Object> selected = new LinkedList<Object>();
        for (int row : rows = this.getTable().getSelectedRows()) {
            int crow;
            int frow;
            if (row < 0 || (frow = this.getSortRowTM().mapRowToInside(row)) < 0 || (crow = this.getFilterRowTM().mapRowToInside(frow)) < 0 || crow >= this.getCachedTM().getList().size()) continue;
            Object r = this.getCachedTM().getList().get(crow);
            selected.add(r);
        }
        return selected;
    }

    public void setSelected(List selected) {
        this.setSelectedIterable(selected);
    }

    public void setSelectedIterable(final Iterable selected) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PropertyTable.this.getTable().getSelectionModel().clearSelection();
                if (selected == null) {
                    return;
                }
                TreeSet<Integer> selListIndexes = new TreeSet<Integer>();
                for (Object sel : selected) {
                    if (Thread.interrupted()) break;
                    if (PropertyTable.this.selectFirstMatched) {
                        int idx = PropertyTable.this.getCache().indexOf(sel);
                        if (idx < 0) continue;
                        selListIndexes.add(idx);
                        continue;
                    }
                    for (int li = 0; li < PropertyTable.this.getCache().size(); ++li) {
                        Object lio = PropertyTable.this.getCache().get(li);
                        if (!PropertyTable.eq(sel, lio)) continue;
                        selListIndexes.add(li);
                    }
                }
                Iterator<Object> iterator = selListIndexes.iterator();
                while (iterator.hasNext()) {
                    int selListIdx = (Integer)iterator.next();
                    if (selListIdx < 0) continue;
                    int row = selListIdx;
                    row = PropertyTable.this.getFilterRowTM().mapRowToOutside(row);
                    if (row < 0 || (row = PropertyTable.this.getSortRowTM().mapRowToOutside(row)) < 0) continue;
                    PropertyTable.this.getTable().getSelectionModel().addSelectionInterval(row, row);
                }
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    public int mapRowToInside(int row) {
        if (row < 0) {
            return -1;
        }
        row = this.getSortRowTM().mapRowToInside(row);
        if (row < 0) {
            return -1;
        }
        row = this.getFilterRowTM().mapRowToInside(row);
        if (row < 0) {
            return -1;
        }
        return row;
    }

    public int mapRowToOutside(int row) {
        if (row < 0) {
            return -1;
        }
        if (row >= this.getCache().size()) {
            return -1;
        }
        row = this.getFilterRowTM().mapRowToOutside(row);
        if (row < 0) {
            return -1;
        }
        row = this.getSortRowTM().mapRowToOutside(row);
        if (row < 0) {
            return -1;
        }
        return row;
    }

    public Object getByRow(int idx) {
        return this.getByRow(idx, null);
    }

    public Object getByRow(int idx, Object def) {
        if (idx < 0) {
            return def;
        }
        if ((idx = this.mapRowToInside(idx)) >= 0) {
            return this.getCache().get(idx);
        }
        return def;
    }

    public Object getFocused() {
        int idx = this.getTable().getSelectionModel().getLeadSelectionIndex();
        if (idx >= 0) {
            return this.getByRow(idx);
        }
        return null;
    }

    public void setFocused(final Object val) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                int row = PropertyTable.this.getCache().indexOf(val);
                if (row < 0) {
                    return;
                }
                if ((row = PropertyTable.this.mapRowToOutside(row)) < 0) {
                    return;
                }
                PropertyTable.this.getTable().getColumnModel().getSelectionModel().addSelectionInterval(0, 0);
                PropertyTable.this.getTable().getColumnModel().getSelectionModel().setLeadSelectionIndex(0);
                PropertyTable.this.getTable().getSelectionModel().addSelectionInterval(row, row);
                PropertyTable.this.getTable().getSelectionModel().setLeadSelectionIndex(row);
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    public Func0<Object> getDefaultItemBuilder() {
        return this.defaultItemBuilder;
    }

    public void setDefaultItemBuilder(Func0<Object> defaultItemBuilder) {
        Func0<Object> old = this.defaultItemBuilder;
        this.defaultItemBuilder = defaultItemBuilder;
        this.firePropertyChange("defaultItemBuilder", old, defaultItemBuilder);
    }

    private static ImageIcon readIcon(String resource) {
        if (resource == null) {
            return null;
        }
        URL url = PropertyTable.class.getResource(resource);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public void refresh() {
        this.getCachedTM().fetch();
    }

    public BasicAction getRefreshAction() {
        return this.refreshAction;
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public boolean getRefreshVisible() {
        return this.refreshButton.isVisible();
    }

    public void setRefreshVisible(boolean v) {
        this.refreshButton.setVisible(v);
    }

    protected void checkRefreshEnable() {
        Iterable itr = this.getSource();
        this.getRefreshAction().setEnabled(itr != null);
    }

    public boolean isInsertEnable() {
        return this.insertEnable;
    }

    public void setInsertEnable(boolean insertEnable) {
        boolean old = this.insertEnable;
        this.insertEnable = insertEnable;
        this.firePropertyChange("insertEnable", old, this.insertEnable);
    }

    public boolean isPasteEnable() {
        return this.pasteEnable;
    }

    public void setPasteEnable(boolean pasteEnable) {
        boolean old = this.pasteEnable;
        this.pasteEnable = pasteEnable;
        this.firePropertyChange("pasteEnable", old, this.pasteEnable);
    }

    public boolean isCopyEnable() {
        return this.copyEnable;
    }

    public void setCopyEnable(boolean copyEnable) {
        boolean old = this.copyEnable;
        this.copyEnable = copyEnable;
        this.firePropertyChange("copyEnable", old, this.copyEnable);
    }

    public boolean isDeleteEnable() {
        return this.deleteEnable;
    }

    public void setDeleteEnable(boolean deleteEnable) {
        Boolean old = this.deleteEnable;
        this.deleteEnable = deleteEnable;
        this.firePropertyChange("deleteEnable", old, (Object)this.isDeleteEnable());
    }

    public BasicAction getDeleteSelectedAction() {
        return this.deleteAction;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public boolean getDeleteButtonVisible() {
        return this.deleteButton.isVisible();
    }

    public void setDeleteButtonVisible(boolean v) {
        this.deleteButton.setVisible(v);
    }

    public void deleteSelected() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Object[] sel = PropertyTable.this.getSelected().toArray();
                if (sel == null || sel.length < 1) {
                    return;
                }
                IndexEventList eCacheList = PropertyTable.this.getCache();
                final LinkedHashMap deletedElements = new LinkedHashMap();
                CloseableSet cs = new CloseableSet();
                cs.add(eCacheList.onDeleted(new Func3(){

                    public Object apply(Object idx, Object oldv, Object curv) {
                        if (idx instanceof Number && oldv != null) {
                            deletedElements.put(oldv, ((Number)idx).intValue());
                        }
                        return null;
                    }
                }, true));
                if (eCacheList != null) {
                    LinkedHashSet<Object> lhs = new LinkedHashSet<Object>();
                    for (Object e : sel) {
                        lhs.add(e);
                    }
                    eCacheList.removeAll(lhs);
                }
                cs.closeAll();
                for (Map.Entry en : deletedElements.entrySet()) {
                    PropertyTableEvent.ElementCacheRemoved ev = new PropertyTableEvent.ElementCacheRemoved(PropertyTable.this);
                    ev.setCache((List)eCacheList);
                    ev.setIndex((Integer)en.getValue());
                    ev.setElement(en.getKey());
                    PropertyTable.this.firePropertyTableEvent(ev);
                }
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    protected void checkDeleteEnable() {
        this.getDeleteSelectedAction().setEnabled(this.isDeleteEnable());
    }

    public JButton getCreateNewButton() {
        return this.createNewButton;
    }

    public boolean getCreateNewVisible() {
        return this.createNewButton.isVisible();
    }

    public void setCreateNewVisible(boolean v) {
        this.createNewButton.setVisible(v);
    }

    protected void checkCreateNewEnable() {
        BasicAction act;
        boolean enable = false;
        if (this.getDefaultItemBuilder() != null && this.isInsertEnable()) {
            enable = true;
        }
        if ((act = this.getCreateNewAction()) != null) {
            act.setEnabled(enable);
        }
    }

    public BasicAction getCreateNewAction() {
        return this.createNewAction;
    }

    public void append(final int pos, final Object obj, final boolean setfocus) {
        if (obj == null) {
            throw new IllegalArgumentException("obj==null");
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                int listIdx = -1;
                if (pos < 0) {
                    PropertyTable.this.getCache().add(0, obj);
                    listIdx = 0;
                } else if (pos >= PropertyTable.this.getCache().size()) {
                    PropertyTable.this.getCache().add(obj);
                    listIdx = PropertyTable.this.getCache().indexOf(obj);
                } else {
                    PropertyTable.this.getCache().add(pos, obj);
                    listIdx = PropertyTable.this.getCache().indexOf(obj);
                }
                int row = PropertyTable.this.mapRowToOutside(listIdx);
                if (row < 0) {
                    return;
                }
                if (setfocus) {
                    PropertyTable.this.setFocused(obj);
                    Rectangle rect = PropertyTable.this.getTable().getCellRect(row, 0, true);
                    if (rect != null) {
                        PropertyTable.this.getTable().scrollRectToVisible(rect);
                    }
                }
                PropertyTableEvent.ElementCacheCreated ev = new PropertyTableEvent.ElementCacheCreated(PropertyTable.this);
                ev.setCache((List)PropertyTable.this.getCache());
                ev.setElement(obj);
                ev.setRow(row);
                ev.setIndex(listIdx);
                PropertyTable.this.firePropertyTableEvent(ev);
            }
        };
        if (this.isNotifyInAwtThread() && !SwingUtilities.isEventDispatchThread()) {
            if (this.isAwtInvokeAndWait()) {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(PropertyTable.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(run);
            }
        } else {
            run.run();
        }
    }

    public void createNew(int pos, boolean setfocus) {
        Func0<Object> fn = this.getDefaultItemBuilder();
        if (fn == null) {
            throw new IllegalStateException("defaultItemBuilder not set");
        }
        Object obj = fn.apply();
        if (obj == null) {
            throw new IllegalStateException("defaultItemBuilder return null");
        }
        this.append(pos, obj, setfocus);
    }

    public PropertyTableExchanger getExchanger() {
        if (this.exchanger != null) {
            return this.exchanger;
        }
        this.exchanger = new CSVExchanger();
        return this.exchanger;
    }

    public void setExchanger(PropertyTableExchanger exchanger) {
        PropertyTableExchanger old = this.getExchanger();
        this.exchanger = exchanger;
        this.firePropertyChange("exchanger", old, this.getExchanger());
    }

    public void copyToClipboard() {
        List selected = this.getSelected();
        if (selected == null || selected.isEmpty()) {
            return;
        }
        PropertyTableExchanger csve = this.getExchanger();
        StringWriter sw = new StringWriter();
        csve.exportTable(sw, selected, this);
        Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(sw.toString());
        cp.setContents(ss, null);
    }

    public BasicAction getCopyToClipboardAction() {
        return this.copyToClipboardAction;
    }

    public JButton getCopyToClipboardButton() {
        return this.copyToClipboardButton;
    }

    public boolean getCopyToClipboardVisible() {
        return this.copyToClipboardButton.isVisible();
    }

    public void setCopyToClipboardVisible(boolean v) {
        this.copyToClipboardButton.setVisible(v);
    }

    protected void checkCopyEnable() {
        boolean en = this.getExchanger() != null && this.isCopyEnable();
        this.getCopyToClipboardAction().setEnabled(en);
    }

    public JButton getPasteFromClipboardButton() {
        return this.pasteFromClipboardButton;
    }

    public boolean getPasteFromClipboardVisible() {
        return this.pasteFromClipboardButton.isVisible();
    }

    public void setPasteFromClipboardVisible(boolean v) {
        this.pasteFromClipboardButton.setVisible(v);
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable trans = clipboard.getContents(null);
        String strClipBoard = null;
        if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                strClipBoard = (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e2) {
                e2.printStackTrace();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }
        if (strClipBoard == null) {
            return;
        }
        PropertyTableExchanger csve = this.getExchanger();
        if (csve != null) {
            Iterable items = csve.importTable(new StringReader(strClipBoard), this);
            for (Object item : items) {
                if (Thread.interrupted()) break;
                if (item == null) continue;
                this.getCache().add(item);
            }
        }
    }

    public BasicAction getPasteFromClipboardAction() {
        return this.pasteFromClipboardAction;
    }

    protected void checkPasteEnable() {
        boolean en = this.getExchanger() != null && this.isPasteEnable();
        this.getPasteFromClipboardAction().setEnabled(en);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static class PTableColumnDesc
    implements Serializable {
        public int modelIndex = -1;
        public int index = -1;
        public int width;
        public int minWidth;
        public int maxWidth;
        public int preferredWidth;
        public String modelName;
        public boolean resizable;

        public static PTableColumnDesc create(PropertyTable pt, int ci, TableColumn tc) {
            Column col;
            if (pt == null) {
                throw new IllegalArgumentException("pt==null");
            }
            if (tc == null) {
                throw new IllegalArgumentException("tc==null");
            }
            PTableColumnDesc tcd = new PTableColumnDesc();
            tcd.index = ci;
            tcd.width = tc.getWidth();
            tcd.minWidth = tc.getMinWidth();
            tcd.maxWidth = tc.getMaxWidth();
            tcd.preferredWidth = tc.getPreferredWidth();
            tcd.modelIndex = tc.getModelIndex();
            if (tcd.modelIndex >= 0 && tcd.modelIndex < pt.getColumns().size() && (col = (Column)pt.getColumns().get(tcd.modelIndex)) != null) {
                tcd.modelName = col.getName();
            }
            tcd.resizable = tc.getResizable();
            return tcd;
        }

        public void widthWrite(PropertyTable pt, TableColumn tc) {
            if (pt == null) {
                throw new IllegalArgumentException("pt==null");
            }
            if (tc == null) {
                throw new IllegalArgumentException("tc==null");
            }
            tc.setWidth(this.width);
            tc.setPreferredWidth(this.width);
            tc.setResizable(this.resizable);
            tc.setMinWidth(this.minWidth);
            tc.setMaxWidth(this.maxWidth);
        }

        public boolean match(PropertyTable pt, int ci, TableColumn tc) {
            if (pt == null) {
                throw new IllegalArgumentException("pt==null");
            }
            if (tc == null) {
                throw new IllegalArgumentException("tc==null");
            }
            boolean modelNameMatched = false;
            if (this.modelName != null) {
                Column col;
                int mi = tc.getModelIndex();
                if (mi >= 0 && mi < pt.getColumns().size() && (col = (Column)pt.getColumns().get(mi)) != null) {
                    modelNameMatched = this.modelName.equals(col.getName());
                }
            } else {
                modelNameMatched = true;
            }
            boolean idxMatched = this.index == ci;
            return idxMatched && modelNameMatched;
        }

        public static void applyWidth(PropertyTable pt, Iterable<PTableColumnDesc> columnsDesc) {
            if (pt == null) {
                throw new IllegalArgumentException("pt==null");
            }
            if (columnsDesc == null) {
                throw new IllegalArgumentException("columnsDesc==null");
            }
            TableColumnModel tcm = pt.getTable().getColumnModel();
            for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
                TableColumn tc = tcm.getColumn(ci);
                for (PTableColumnDesc cdesc : columnsDesc) {
                    if (cdesc == null || !cdesc.match(pt, ci, tc)) continue;
                    cdesc.widthWrite(pt, tc);
                }
            }
        }
    }
}

