/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.Closeable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.table.PropertyColumn;
import xyz.cofe.gui.swing.table.PropertyTable;
import xyz.cofe.gui.swing.table.PropertyTableListener;

public class PropertyTableEvent {
    private static final Logger logger = Logger.getLogger(PropertyTableEvent.class.getName());
    protected PropertyTable propertyTable;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = PropertyTableEvent.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(PropertyTableEvent.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertyTableEvent.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public PropertyTable getPropertyTable() {
        return this.propertyTable;
    }

    public void setPropertyTable(PropertyTable propertyTable) {
        this.propertyTable = propertyTable;
    }

    public PropertyTableEvent() {
    }

    public PropertyTableEvent(PropertyTable ptable) {
        this.propertyTable = ptable;
    }

    public static Closeable onElementCacheCreated(PropertyTable pt, final Reciver<ElementCacheCreated> consumer) {
        if (pt == null) {
            throw new IllegalArgumentException("pt == null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer == null");
        }
        return pt.addPropertyTableListener(new PropertyTableListener(){

            @Override
            public void propertyTableEvent(PropertyTableEvent event) {
                if (event instanceof ElementCacheCreated) {
                    consumer.recive((Object)((ElementCacheCreated)event));
                }
            }
        });
    }

    public static Closeable onPropertyWrited(PropertyTable pt, final Reciver<PropertyWrited> consumer) {
        if (pt == null) {
            throw new IllegalArgumentException("pt == null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer == null");
        }
        return pt.addPropertyTableListener(new PropertyTableListener(){

            @Override
            public void propertyTableEvent(PropertyTableEvent event) {
                if (event instanceof PropertyWrited) {
                    consumer.recive((Object)((PropertyWrited)event));
                }
            }
        });
    }

    public static class PropertyWrited
    extends PropertyTableEvent {
        protected PropertyColumn propertyColumn;
        protected Property property;
        protected Object bean;
        protected Object value;

        public PropertyWrited() {
        }

        public PropertyWrited(PropertyTable ptable) {
            super(ptable);
        }

        public PropertyWrited(PropertyTable ptable, PropertyColumn pcolumn, Property p, Object bean, Object val) {
            super(ptable);
            this.propertyColumn = pcolumn;
            this.property = p;
            this.bean = bean;
            this.value = val;
        }

        public PropertyWrited(PropertyTable ptable, PropertyColumn.PropertyWrited ev) {
            super(ptable);
            if (ev != null) {
                this.propertyColumn = ev.getPropertyColumn();
                this.property = ev.getProperty();
                this.bean = ev.getBean();
                this.value = ev.value;
            }
        }

        public PropertyColumn getPropertyColumn() {
            return this.propertyColumn;
        }

        public void setPropertyColumn(PropertyColumn propertyColumn) {
            this.propertyColumn = propertyColumn;
        }

        public Property getProperty() {
            return this.property;
        }

        public void setProperty(Property property) {
            this.property = property;
        }

        public Object getBean() {
            return this.bean;
        }

        public void setBean(Object bean) {
            this.bean = bean;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class ElementCacheRemoved
    extends PropertyTableEvent {
        protected List cache;
        protected int index;
        protected int row;
        protected Object element;

        public ElementCacheRemoved() {
        }

        public ElementCacheRemoved(PropertyTable ptable) {
            super(ptable);
        }

        public List getCache() {
            return this.cache;
        }

        public void setCache(List cache) {
            this.cache = cache;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public Object getElement() {
            return this.element;
        }

        public void setElement(Object element) {
            this.element = element;
        }
    }

    public static class ElementCacheCreated
    extends PropertyTableEvent {
        protected List cache;
        protected int index;
        protected int row;
        protected Object element;

        public ElementCacheCreated() {
        }

        public ElementCacheCreated(PropertyTable ptable) {
            super(ptable);
        }

        public List getCache() {
            return this.cache;
        }

        public void setCache(List cache) {
            this.cache = cache;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public Object getElement() {
            return this.element;
        }

        public void setElement(Object element) {
            this.element = element;
        }
    }
}

