/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.Predicates;
import xyz.cofe.gui.swing.table.FilterRowTM;
import xyz.cofe.gui.swing.text.DocumentAdapter;
import xyz.cofe.text.Text;

public class RowData {
    protected TableModel tableModel = null;
    protected int rowIndex = -1;
    private static Predicate<String> falseTextPredicate = new Predicate<String>(){

        public boolean validate(String value) {
            return false;
        }
    };

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(RowData.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(RowData.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(RowData.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(RowData.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(RowData.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(RowData.class.getName()).log(Level.SEVERE, null, ex);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColumnCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    public Object getValue(int column) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getValueAt(this.getRowIndex(), column);
    }

    public String getName(int column) {
        if (column < 0) {
            return null;
        }
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnName(column);
    }

    public static Predicate<RowData> like(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        final Pattern ptrn = Text.wildcard((String)text, (boolean)false, (boolean)true);
        return new Predicate<RowData>(){

            public boolean validate(RowData frow) {
                if (frow == null) {
                    return false;
                }
                for (int iC = 0; iC < frow.getColumnCount(); ++iC) {
                    String txt;
                    Matcher m;
                    Object val = frow.getValue(iC);
                    if (val == null || !(m = ptrn.matcher(txt = val.toString())).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<RowData> textContains(int column, String wildcard) {
        final String txt = wildcard;
        return RowData.stringValue(column, new Predicate<String>(){

            public boolean validate(String value) {
                if (value == null) {
                    return true;
                }
                if (txt == null) {
                    return true;
                }
                if (txt.length() == 0) {
                    return true;
                }
                return value.contains(txt);
            }
        });
    }

    public static Predicate<String> textLikeWildcard(String woldcard) {
        if (woldcard == null) {
            return falseTextPredicate;
        }
        return Text.Predicates.matchRegex((Pattern)Text.wildcard((String)woldcard, (boolean)false, (boolean)true));
    }

    public static Predicate<RowData> stringValue(int columnIndex, Predicate<String> pred) {
        final int cIdx = columnIndex;
        final Predicate<String> p = pred;
        return new Predicate<RowData>(){

            public boolean validate(RowData frow) {
                Object val;
                if (frow == null) {
                    return false;
                }
                if (p == null) {
                    return false;
                }
                if (cIdx >= frow.getColumnCount()) {
                    return false;
                }
                if (cIdx == -1) {
                    for (int c = 0; c < frow.getColumnCount(); ++c) {
                        Object val2 = frow.getValue(c);
                        boolean matched = p.validate((Object)(val2 != null ? val2.toString() : null));
                        if (!matched) continue;
                        return true;
                    }
                }
                return p.validate((Object)((val = frow.getValue(cIdx)) != null ? val.toString() : null));
            }
        };
    }

    public static Predicate<RowData> or(Predicate<RowData> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("predicates==null");
        }
        return Predicates.or(predicates);
    }

    public static Predicate<RowData> and(Predicate<RowData> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("predicates==null");
        }
        return Predicates.and(predicates);
    }

    public static Predicate<RowData> not(Predicate<RowData> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("predicate==null");
        }
        return Predicates.not(predicate);
    }

    public static Convertor<String, Predicate<RowData>> getContainsConvertor(int column) {
        return new Convertor<String, Predicate<RowData>>(){

            public Predicate<RowData> convert(String from) {
                return RowData.textContains(-1, from);
            }
        };
    }

    public static Convertor<String, Predicate<RowData>> andConvertor(final Convertor<String, Predicate<RowData>> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("predicates==null");
        }
        return new Convertor<String, Predicate<RowData>>(){

            public Predicate<RowData> convert(String from) {
                ArrayList<Predicate> al = new ArrayList<Predicate>();
                for (Convertor c : predicates) {
                    Predicate p;
                    if (c == null || (p = (Predicate)c.convert((Object)from)) == null) continue;
                    al.add(p);
                }
                return RowData.and(al.toArray(new Predicate[0]));
            }
        };
    }

    public static Closeable bind(final FilterRowTM filterRowTM, final JTextComponent filterTextCmpt, final Convertor<String, Predicate<RowData>> convertToFilter) {
        if (filterRowTM == null) {
            throw new IllegalArgumentException("filterRowTM==null");
        }
        if (filterTextCmpt == null) {
            throw new IllegalArgumentException("filterTextCmpt==null");
        }
        if (convertToFilter == null) {
            throw new IllegalArgumentException("convertToFilter==null");
        }
        Predicate fltr = (Predicate)convertToFilter.convert((Object)filterTextCmpt.getText());
        filterRowTM.setRowFilter((Predicate<RowData>)fltr);
        final DocumentAdapter da = new DocumentAdapter(){

            @Override
            protected void onTextChanged() {
                if (filterTextCmpt != null && convertToFilter != null) {
                    Predicate fltr = (Predicate)convertToFilter.convert((Object)filterTextCmpt.getText());
                    filterRowTM.setRowFilter((Predicate<RowData>)fltr);
                }
            }
        };
        filterTextCmpt.getDocument().addDocumentListener(da);
        return new Closeable(){
            JTextComponent ffilterTextCmpt;
            DocumentAdapter fda;
            {
                this.ffilterTextCmpt = filterTextCmpt;
                this.fda = da;
            }

            @Override
            public void close() throws IOException {
                if (this.ffilterTextCmpt != null && this.fda != null) {
                    Document doc = this.ffilterTextCmpt.getDocument();
                    doc.removeDocumentListener(this.fda);
                    this.fda = null;
                    this.ffilterTextCmpt = null;
                }
            }
        };
    }
}

