/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.impl.SortInsertDefault;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.table.WrapTM;
import xyz.cofe.gui.swing.table.impl.SortRowTMImpl;
import xyz.cofe.text.Output;

public class SortRowTM
extends WrapTM {
    protected TreeMap<Integer, Integer> row2srcMap = null;
    protected TreeMap<Integer, Integer> src2rowMap = null;
    protected RowData rowData = new RowData();
    private Comparator<RowData> rowComparator = null;
    private long onRowUpdatedCall = 0L;
    private long onRowInsertedCall = 0L;

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(SortRowTM.class.getName()).log(Level.SEVERE, null, ex);
    }

    public synchronized Comparator<RowData> getRowComparator() {
        return this.rowComparator;
    }

    public synchronized void setRowComparator(Comparator<RowData> rowComparator) {
        this.rowComparator = rowComparator;
        this.applySort();
        this.fireAllChanged();
    }

    @Override
    public synchronized int getRowCount() {
        if (this.row2srcMap == null) {
            return super.getRowCount();
        }
        return this.row2srcMap.size();
    }

    @Override
    public synchronized int getColumnCount() {
        return super.getColumnCount();
    }

    protected synchronized void shiftOnInsertIndexes(int from, int toInc) {
        if (this.row2srcMap == null) {
            return;
        }
        SortRowTM.logFine("shiftOnInsertIndexes( {0}, {1} )", from, toInc);
        int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            Integer si = me.getValue();
            if (si < from) continue;
            me.setValue(si + icnt);
        }
        if (this.src2rowMap == null) {
            this.src2rowMap = new TreeMap();
        }
        this.src2rowMap.clear();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            this.src2rowMap.put(me.getValue(), me.getKey());
        }
    }

    protected synchronized void insertRow(int di, int si) {
        Integer si1;
        if (this.row2srcMap == null) {
            return;
        }
        SortRowTM.logFine("insertRow( {0}, {1} )", di, si);
        TreeMap<Integer, Integer> nrs = new TreeMap<Integer, Integer>();
        for (Integer n : this.row2srcMap.descendingKeySet()) {
            if (n >= di) {
                Integer di2 = n + 1;
                si1 = this.row2srcMap.get(n);
                nrs.put(di2, si1);
                continue;
            }
            Integer si12 = this.row2srcMap.get(n);
            nrs.put(n, si12);
        }
        nrs.put(di, si);
        this.row2srcMap = nrs;
        if (this.src2rowMap == null) {
            this.src2rowMap = new TreeMap();
        }
        this.src2rowMap.clear();
        for (Map.Entry entry : this.row2srcMap.entrySet()) {
            Integer di1 = (Integer)entry.getKey();
            si1 = (Integer)entry.getValue();
            this.src2rowMap.put(si1, di1);
        }
    }

    protected synchronized void shiftOnDeleteIndexes(int from, int toInc, Reciver<Integer> deletedOutterIndexes) {
        if (this.row2srcMap == null) {
            return;
        }
        SortRowTM.logFine("shiftOnDeleteIndexes( {0}, {1} )", from, toInc);
        int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        LinkedHashSet<Integer> removedDI = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            Integer di = me.getKey();
            Integer si = me.getValue();
            if (si < from) continue;
            if (si <= toInc) {
                removedDI.add(di);
                continue;
            }
            Integer si2 = si - icnt;
            me.setValue(si2);
        }
        for (Integer di : removedDI) {
            this.row2srcMap.remove(di);
            if (deletedOutterIndexes == null) continue;
            deletedOutterIndexes.recive((Object)di);
        }
        AtomicInteger ni = new AtomicInteger(0);
        TreeMap<Integer, Integer> nrow2srcMap = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> enR2S : this.row2srcMap.entrySet()) {
            Integer di = enR2S.getKey();
            Integer si = enR2S.getValue();
            nrow2srcMap.put(ni.get(), si);
            ni.incrementAndGet();
        }
        this.row2srcMap = nrow2srcMap;
        if (this.src2rowMap == null) {
            this.src2rowMap = new TreeMap();
        }
        this.src2rowMap.clear();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            this.src2rowMap.put(me.getValue(), me.getKey());
        }
    }

    protected synchronized void checkDestIndexesFast() {
        if (this.row2srcMap == null) {
            return;
        }
        int size = this.row2srcMap.size();
        if (size < 1) {
            return;
        }
        int fk = this.row2srcMap.firstKey();
        if (fk != 0) {
            throw new Error("checkDestIndexesFast fail, fk=" + fk);
        }
        int lk = this.row2srcMap.lastKey();
        if (lk != size - 1) {
            throw new Error("checkDestIndexesFast fail, lk=" + lk + " size=" + size);
        }
    }

    protected synchronized boolean isIndexesValid() {
        if (this.row2srcMap == null && this.src2rowMap != null) {
            SortRowTM.logWarning("isIndexesValid row2srcMap==null && src2rowMap!=null", new Object[0]);
            return false;
        }
        if (this.src2rowMap == null && this.row2srcMap != null) {
            SortRowTM.logWarning("isIndexesValid row2srcMap!=null && src2rowMap==null", new Object[0]);
            return false;
        }
        if (this.src2rowMap == null && this.row2srcMap == null) {
            return true;
        }
        if (this.row2srcMap.size() != this.src2rowMap.size()) {
            SortRowTM.logWarning("isIndexesValid row2srcMap.size() != src2rowMap.size()", new Object[0]);
            return false;
        }
        if (this.row2srcMap.size() < 1) {
            return true;
        }
        Integer rs_fk = this.row2srcMap.firstKey();
        Integer rs_lk = this.row2srcMap.lastKey();
        if (rs_fk == null) {
            SortRowTM.logWarning("row2srcMap.firstKey() == null", new Object[0]);
            return false;
        }
        if (rs_lk == null) {
            SortRowTM.logWarning("row2srcMap.lastKey() == null", new Object[0]);
            return false;
        }
        if (rs_fk != 0) {
            SortRowTM.logWarning("row2srcMap.lastKey() != 0", new Object[0]);
            return false;
        }
        if (rs_lk != this.row2srcMap.size() - 1) {
            SortRowTM.logWarning("row2srcMap.lastKey() != (row2srcMap.size()-1)", new Object[0]);
            StringWriter sw = new StringWriter();
            this.dump(new Output((Writer)sw, true));
            SortRowTM.logWarning("dump:\n{0}", sw.toString());
            return false;
        }
        int idx = -1;
        for (Map.Entry<Integer, Integer> rs_e : this.row2srcMap.entrySet()) {
            StringWriter sw;
            Integer rs_di = rs_e.getKey();
            Integer rs_si = rs_e.getValue();
            if (rs_di == null || rs_di != ++idx) {
                SortRowTM.logWarning("row2srcMap key={0} waitKey={1} key null or not equ wait", rs_di, idx);
                sw = new StringWriter();
                this.dump(new Output((Writer)sw, true));
                SortRowTM.logWarning("dump:\n{0}", sw.toString());
                return false;
            }
            if (rs_si == null) {
                SortRowTM.logWarning("row2srcMap key={0} value={1} value null", rs_di, rs_si);
                sw = new StringWriter();
                this.dump(new Output((Writer)sw, true));
                SortRowTM.logWarning("dump:\n{0}", sw.toString());
                return false;
            }
            if (!this.src2rowMap.containsKey(rs_si)) {
                SortRowTM.logWarning("src2rowMap key={0} not found", rs_si);
                sw = new StringWriter();
                this.dump(new Output((Writer)sw, true));
                SortRowTM.logWarning("dump:\n{0}", sw.toString());
                return false;
            }
            Integer sr_di = this.src2rowMap.get(rs_si);
            if (sr_di == null) {
                SortRowTM.logWarning("src2rowMap key={0} value={1} value null", rs_si, sr_di);
                StringWriter sw2 = new StringWriter();
                this.dump(new Output((Writer)sw2, true));
                SortRowTM.logWarning("dump:\n{0}", sw2.toString());
                return false;
            }
            if (SortRowTM.eq(sr_di, rs_di)) continue;
            SortRowTM.logWarning("src2rowMap key={0} value={1} reverse fail (rs {2} -> {3} sr {3} -> {4})", rs_si, sr_di, rs_di, rs_si, sr_di);
            StringWriter sw3 = new StringWriter();
            this.dump(new Output((Writer)sw3, true));
            SortRowTM.logWarning("dump:\n{0}", sw3.toString());
            return false;
        }
        return true;
    }

    public synchronized void dump() {
        Output out = new Output((OutputStream)System.out);
        this.dump(out);
    }

    public synchronized void dump(Output xout) {
        if (xout == null) {
            xout = new Output((OutputStream)System.out);
        }
        Output out = xout;
        out.setLinePrefix("dump|");
        if (this.row2srcMap != null && this.src2rowMap != null) {
            out.template("row2srcMap(${rsc}) src2rowMap(${src})").bind("rsc", (Object)this.row2srcMap.size()).bind("src", (Object)this.src2rowMap.size()).println();
            for (Map.Entry<Integer, Integer> enR2S : this.row2srcMap.entrySet()) {
                Integer di1 = enR2S.getKey();
                Integer si1 = enR2S.getValue();
                Integer si2 = this.src2rowMap.containsKey(si1) ? si1 : null;
                Integer di2 = si2 != null ? this.src2rowMap.get(si2) : null;
                out.template("d${di1:3} -> s${si1:3} | d${di2:3} <- s${si2:3} | ${ok}").bind("di1", (Object)di1).bind("di2", (Object)di2).bind("si1", (Object)si1).bind("si2", (Object)si2).bind("ok", (Object)(si2 != null && di2 != null && si1 != null && di1 != null && si1 == si2 && di1 == di2 ? 1 : 0)).println();
            }
        } else {
            out.println("row2srcMap = " + this.row2srcMap);
            out.println("src2rowMap = " + this.src2rowMap);
        }
        out.flush();
    }

    @Override
    public synchronized int mapColumnToInside(int columnIndex) {
        return super.mapColumnToInside(columnIndex);
    }

    @Override
    public synchronized int mapRowToInside(int rowIndex) {
        if (this.row2srcMap != null) {
            if (this.row2srcMap.containsKey(rowIndex)) {
                return this.row2srcMap.get(rowIndex);
            }
            return -1;
        }
        return super.mapRowToInside(rowIndex);
    }

    @Override
    public synchronized int mapRowToOutside(int rowIndex) {
        if (this.src2rowMap == null) {
            return super.mapRowToOutside(rowIndex);
        }
        if (!this.src2rowMap.containsKey(rowIndex)) {
            return -1;
        }
        return this.src2rowMap.get(rowIndex);
    }

    @Override
    public synchronized void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        this.rowData.setTableModel(tableModel);
        this.applySort();
        this.fireAllChanged();
    }

    public synchronized void applySort() {
        if (this.row2srcMap != null) {
            this.row2srcMap.clear();
        }
        this.row2srcMap = null;
        if (this.src2rowMap != null) {
            this.src2rowMap.clear();
        }
        this.src2rowMap = null;
        if (this.rowComparator == null) {
            return;
        }
        if (this.tableModel == null) {
            return;
        }
        int rowCo = this.tableModel.getRowCount();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < rowCo; ++i) {
            indexes.add(i);
        }
        Comparator<Integer> srcRowCmp = this.createComparator(this.tableModel, this.rowComparator);
        Collections.sort(indexes, srcRowCmp);
        this.src2rowMap = new TreeMap();
        this.row2srcMap = new TreeMap();
        for (int outRowIndex = 0; outRowIndex < indexes.size(); ++outRowIndex) {
            int innerRowIndex = (Integer)indexes.get(outRowIndex);
            this.row2srcMap.put(outRowIndex, innerRowIndex);
            this.src2rowMap.put(innerRowIndex, outRowIndex);
        }
    }

    protected Comparator<Integer> createComparator(TableModel tm, Comparator<RowData> cmpr) {
        if (tm == null) {
            throw new IllegalArgumentException("tm==null");
        }
        if (cmpr == null) {
            throw new IllegalArgumentException("cmpr==null");
        }
        return this.createComparator(tm, tm, cmpr);
    }

    private Comparator<Integer> createComparator(final TableModel tm1, final TableModel tm2, final Comparator<RowData> cmpr) {
        if (tm1 == null) {
            throw new IllegalArgumentException("tm1==null");
        }
        if (tm2 == null) {
            throw new IllegalArgumentException("tm2==null");
        }
        if (cmpr == null) {
            throw new IllegalArgumentException("cmpr==null");
        }
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer r1, Integer r2) {
                RowData rd1 = new RowData();
                rd1.setTableModel(tm1);
                rd1.setRowIndex(r1);
                RowData rd2 = new RowData();
                rd2.setTableModel(tm2);
                rd2.setRowIndex(r2);
                return cmpr.compare(rd1, rd2);
            }
        };
    }

    protected synchronized int fitness(Func1<Boolean, Integer> skip) {
        if (this.rowComparator == null) {
            return 0;
        }
        if (this.row2srcMap == null) {
            return 0;
        }
        if (this.row2srcMap.size() < 2) {
            return 0;
        }
        int i = -1;
        RowData prevrd = new RowData();
        prevrd.setTableModel(this);
        RowData currrd = new RowData();
        currrd.setTableModel(this);
        int fit = 0;
        for (Integer di : this.row2srcMap.keySet()) {
            int cmp;
            if (skip != null && ((Boolean)skip.apply((Object)di)).booleanValue()) continue;
            currrd.setRowIndex(di);
            if (++i > 0 && (cmp = this.rowComparator.compare(prevrd, currrd)) > 0) {
                --fit;
                Integer di1 = prevrd.getRowIndex();
                Integer di2 = currrd.getRowIndex();
                Object objd1 = prevrd.getValue(0);
                Object object = currrd.getValue(0);
            }
            prevrd.setRowIndex(di);
        }
        return fit;
    }

    @Override
    protected synchronized List<TableModelEvent> onTableChanged(TableModelEvent e) {
        this.applySort();
        ArrayList<TableModelEvent> lev = new ArrayList<TableModelEvent>();
        lev.add(new TableModelEvent(this));
        return lev;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowUpdated(TableModelEvent e, final int firstRow, final int lastRow) {
        ++this.onRowUpdatedCall;
        ArrayList<TableModelEvent> lev = new ArrayList<TableModelEvent>();
        if (!this.isIndexesValid()) {
            this.applySort();
            lev.add(new TableModelEvent(this));
            return lev;
        }
        int eachNUpdated = SortRowTMImpl.getFitnessOnUpdateEach();
        if (eachNUpdated > 0) {
            int fit;
            boolean check = false;
            if (eachNUpdated == 1) {
                check = true;
            } else {
                boolean bl = check = this.onRowUpdatedCall % (long)eachNUpdated == 0L;
            }
            if (check && ((fit = this.fitness(new Func1<Boolean, Integer>(){

                public Boolean apply(Integer skipidx) {
                    return skipidx >= firstRow && skipidx <= lastRow;
                }
            })) != 0 || this.tableModel == null)) {
                this.applySort();
                lev.add(new TableModelEvent(this));
                return lev;
            }
        }
        lev.addAll(this.onRowDeleted(e, firstRow, lastRow));
        lev.addAll(this.onRowInserted(firstRow, lastRow, false, false));
        return lev;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowDeleted(TableModelEvent e, int firstRow, int lastRow) {
        ArrayList<TableModelEvent> lev = new ArrayList<TableModelEvent>();
        if (!this.isIndexesValid()) {
            this.applySort();
            lev.add(new TableModelEvent(this));
            return lev;
        }
        final TreeSet deleted = new TreeSet();
        this.shiftOnDeleteIndexes(firstRow, lastRow, new Reciver<Integer>(){

            public void recive(Integer di) {
                deleted.add(di);
            }
        });
        for (Integer di : deleted.descendingSet()) {
            lev.add(new TableModelEvent(this, di, di, -1, -1));
        }
        return lev;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowInserted(TableModelEvent e, int firstRow, int lastRow) {
        boolean checkFitness = false;
        ++this.onRowInsertedCall;
        int eachNInserted = SortRowTMImpl.getFitnessOnInsertEach();
        if (eachNInserted > 0) {
            checkFitness = eachNInserted == 1 ? true : this.onRowInsertedCall % (long)eachNInserted == 0L;
        }
        return this.onRowInserted(firstRow, lastRow, true, checkFitness);
    }

    protected synchronized List<TableModelEvent> onRowInserted(int firstRow, int lastRow, boolean checkDestIndexes, boolean checkFitness) {
        int fit;
        ArrayList<TableModelEvent> lev = new ArrayList<TableModelEvent>();
        if (!this.isIndexesValid()) {
            this.applySort();
            lev.add(new TableModelEvent(this));
            return lev;
        }
        if (checkDestIndexes) {
            this.checkDestIndexesFast();
        }
        if (checkFitness && ((fit = this.fitness(null)) != 0 || this.tableModel == null)) {
            this.applySort();
            lev.add(new TableModelEvent(this));
            return lev;
        }
        this.shiftOnInsertIndexes(firstRow, lastRow);
        if (this.rowComparator == null) {
            for (int si = Math.min(firstRow, lastRow); si <= Math.max(firstRow, lastRow); ++si) {
                int lastdi = this.row2srcMap.lastKey();
                int di = lastdi + 1;
                this.row2srcMap.put(di, si);
                this.src2rowMap.put(si, di);
                lev.add(new TableModelEvent(this, di, di, -1, 1));
            }
            return lev;
        }
        RowData rd2 = new RowData();
        rd2.setTableModel(this.tableModel);
        SortInsertDefault ins = new SortInsertDefault(){

            public void insert(Object container, int position, Object item) {
                if (!(item instanceof RowData)) {
                    throw new Error("can't insert not RowData");
                }
                RowData rd = (RowData)item;
                TableModel tm = rd.getTableModel();
                if (!SortRowTM.eq(tm, SortRowTM.this.tableModel)) {
                    throw new Error("can't insert RowData (tableModel is not source)");
                }
                int si = rd.getRowIndex();
                int di = position;
                SortRowTM.this.insertRow(di, si);
            }

            public Object get(Object container, int position) {
                RowData rd = new RowData();
                rd.setTableModel(SortRowTM.this);
                rd.setRowIndex(position);
                return rd;
            }
        };
        for (int si = firstRow; si <= lastRow; ++si) {
            rd2.setRowIndex(si);
            rd2.setTableModel(this.tableModel);
            int rowco = this.row2srcMap.size();
            int insertedPos = ins.sortInsert((Object)this, (Object)rd2, this.rowComparator, 0, rowco);
            lev.add(new TableModelEvent(this, insertedPos, insertedPos, -1, 1));
        }
        return lev;
    }
}

