/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.GuiUtil;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.table.TableCellResizer;
import xyz.cofe.gui.swing.table.TableEvent;
import xyz.cofe.gui.swing.table.TableFocusListener;
import xyz.cofe.gui.swing.table.TableListener;

public class Table
extends JTable {
    private static final Logger logger = Logger.getLogger(Table.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final ListenersHelper<TableListener, TableEvent> listeners = new ListenersHelper((Func2)new Func2<Object, TableListener, TableEvent>(){

        public Object apply(TableListener ls, TableEvent ev) {
            if (ls != null) {
                ls.tableEvent(ev);
            }
            return null;
        }
    });
    protected final TableFocusListener tableFocusListener;
    protected KeyStroke[] autoResizeKeyStrokes;
    private WeakReference<Graphics2D> memgsInst;
    protected volatile TableCellResizer resizer;
    protected int mouseAtRow = -1;
    protected int mouseAtColumn = -1;
    protected boolean mouseOver = false;
    protected Rectangle2D resizeCaptureRect;
    protected int resizeMouseButton = 1;
    protected Boolean resizeMouseAlt = false;
    protected Boolean resizeMouseShift = false;
    protected Boolean resizeMouseControl = false;
    protected Boolean resizeMouseMeta = false;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Table.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(Table.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Table.class.getName(), method, result);
    }

    public Table() {
        this.setFillsViewportHeight(true);
        this.tableFocusListener = new TableFocusListener(this, true){

            @Override
            protected void onFocusedRowChanged(JTable table, int oldRow, int curRow) {
                Table.this.focusedRowChanged(oldRow, curRow);
            }
        };
        this.autoResizeKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke("control pressed E")};
        SwingListener.onKeyPressed(this, new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                if (Table.this.autoResizeKeyStrokes == null) {
                    return;
                }
                if (GuiUtil.match(ke, Table.this.autoResizeKeyStrokes)) {
                    Table.this.autoResizeCell(ke);
                }
            }
        });
    }

    public boolean hasTableListener(TableListener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<TableListener> getTableListeners() {
        return this.listeners.getListeners();
    }

    public Closeable addTableListener(TableListener listener) {
        return this.listeners.addListener((Object)listener);
    }

    public Closeable addTableListener(TableListener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    public void removeTableListener(TableListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void removeAllTableListeners() {
        this.listeners.removeAllListeners();
    }

    public void fireTableEvent(TableEvent event) {
        this.listeners.fireEvent((Object)event);
    }

    public void addTableEvent(TableEvent ev) {
        this.listeners.addEvent((Object)ev);
    }

    public void fireTableEvents() {
        this.listeners.fireEvents();
    }

    protected void focusedRowChanged(int oldRow, int curRow) {
        this.fireTableEvent(new TableEvent.FocusedRowChanged(this, oldRow, curRow));
    }

    public Closeable onFocusedRowChanged(final Reciver<TableEvent.FocusedRowChanged> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer==null");
        }
        return this.addTableListener(new TableListener(){

            @Override
            public void tableEvent(TableEvent ev) {
                if (ev instanceof TableEvent.FocusedRowChanged) {
                    consumer.recive((Object)((TableEvent.FocusedRowChanged)ev));
                }
            }
        });
    }

    public synchronized KeyStroke[] getAutoResizeKeyStrokes() {
        return this.autoResizeKeyStrokes;
    }

    public synchronized void setAutoResizeKeyStrokes(KeyStroke[] kss) {
        this.autoResizeKeyStrokes = kss;
    }

    public synchronized Graphics2D getMemGraphics2D() {
        Graphics2D g;
        Graphics2D graphics2D = g = this.memgsInst != null ? (Graphics2D)this.memgsInst.get() : null;
        if (g != null) {
            return g;
        }
        BufferedImage bi = new BufferedImage(1, 1, 6);
        g = bi.createGraphics();
        this.memgsInst = new WeakReference<Graphics2D>(g);
        return g;
    }

    private void autoResizeCell(KeyEvent ke) {
        int frow = this.getFocusedRow();
        if (frow >= 0 && this.autoRowHeight(frow, true, true)) {
            ke.consume();
            this.autoCellSize(frow, this.getFocusedColumn(), true, false, true, false, true);
        }
    }

    public Rectangle2D getCellContentLayout(int row, int col, boolean selected, boolean focused) {
        if (row < 0 || col < 0) {
            return null;
        }
        int colCnt = this.getColumnCount();
        int rowCnt = this.getRowCount();
        if (row >= rowCnt) {
            return null;
        }
        if (col >= colCnt) {
            return null;
        }
        TableCellRenderer cellRender = this.getCellRenderer(row, col);
        if (cellRender == null) {
            return null;
        }
        if (!(cellRender instanceof TCRenderer)) {
            return null;
        }
        TCRenderer tcr = (TCRenderer)cellRender;
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return null;
        }
        int modCi = tc.getModelIndex();
        TableModel tm = this.getModel();
        if (tm == null) {
            return null;
        }
        if (modCi < 0 || modCi >= tm.getColumnCount()) {
            return null;
        }
        Object val = tm.getValueAt(row, modCi);
        tcr.getTableCellRendererComponent(this, val, selected, focused, row, col);
        Rectangle2D rect = tcr.computeRect(this.getMemGraphics2D());
        return rect;
    }

    public Rectangle2D getCellContentLayout(int row, int col) {
        int frow;
        if (row < 0 || col < 0) {
            return null;
        }
        int colCnt = this.getColumnCount();
        int rowCnt = this.getRowCount();
        if (row >= rowCnt) {
            return null;
        }
        if (col >= colCnt) {
            return null;
        }
        int[] selrows = this.getSelectedRows();
        boolean rowSelected = false;
        for (int selrow : selrows) {
            if (row != selrow) continue;
            rowSelected = true;
            break;
        }
        boolean hasFcs = row == (frow = this.getFocusedRow());
        return this.getCellContentLayout(row, col, rowSelected, hasFcs);
    }

    public Rectangle2D getRowMaxContentLayout(int row) {
        int frow;
        if (row < 0) {
            return null;
        }
        int colCnt = this.getColumnCount();
        int rowCnt = this.getRowCount();
        if (row >= rowCnt) {
            return null;
        }
        int[] selrows = this.getSelectedRows();
        boolean rowSelected = false;
        for (int selrow : selrows) {
            if (row != selrow) continue;
            rowSelected = true;
            break;
        }
        boolean hasFcs = row == (frow = this.getFocusedRow());
        Double minX = null;
        Double minY = null;
        Double maxX = null;
        Double maxY = null;
        for (int ci = 0; ci < colCnt; ++ci) {
            Rectangle2D rect = this.getCellContentLayout(row, ci, rowSelected, hasFcs);
            if (rect == null) continue;
            if (minX == null || minX > rect.getMinX()) {
                minX = rect.getMinX();
            }
            if (minY == null || minY > rect.getMinY()) {
                minY = rect.getMinY();
            }
            if (maxX == null || maxX < rect.getMaxX()) {
                maxX = rect.getMaxX();
            }
            if (maxY != null && !(maxY < rect.getMaxY())) continue;
            maxY = rect.getMaxY();
        }
        if (minX == null || minY == null || maxX == null || maxY == null) {
            return null;
        }
        return new Rectangle2D.Double(Math.min(minX, maxX), Math.min(minY, maxY), Math.abs(maxX - minX), Math.abs(maxY - minY));
    }

    public boolean autoRowHeight(int row, boolean extend, boolean shrink) {
        Rectangle2D maxCntLayout = this.getRowMaxContentLayout(row);
        if (maxCntLayout == null) {
            return false;
        }
        double cntHeight = maxCntLayout.getHeight();
        int curHeight = this.getRowHeight(row);
        if (cntHeight > 0.0 && cntHeight < Double.MAX_VALUE) {
            if ((double)curHeight < cntHeight && extend) {
                this.setRowHeight(row, (int)cntHeight);
            } else if ((double)curHeight > cntHeight && shrink) {
                this.setRowHeight(row, (int)cntHeight);
            }
            return true;
        }
        return false;
    }

    public boolean autoCellSize(int row, int col, boolean extendHeight, boolean shrinkHeight, boolean extendWidth, boolean shrinkWidth, boolean preferredWidth) {
        double trgWidth;
        Rectangle2D cntLayout = this.getCellContentLayout(row, col);
        if (cntLayout == null) {
            return false;
        }
        if (col < 0) {
            return false;
        }
        int colCnt = this.getColumnCount();
        if (col >= colCnt) {
            return false;
        }
        if (row < 0) {
            return false;
        }
        int rowCnt = this.getRowCount();
        if (row >= rowCnt) {
            return false;
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            return false;
        }
        double curHeight = this.getRowHeight(row);
        double curWidth = tc.getWidth();
        double trgHeight = cntLayout.getHeight();
        if (trgHeight < 1.0) {
            trgHeight = 1.0;
        }
        if ((trgWidth = cntLayout.getWidth()) < 1.0) {
            trgWidth = 1.0;
        }
        boolean heightChanged = false;
        boolean widthChanged = false;
        if (curHeight < trgHeight && extendHeight) {
            this.setRowHeight(row, (int)trgHeight);
            heightChanged = true;
        } else if (curHeight > trgWidth && shrinkHeight) {
            this.setRowHeight(row, (int)trgHeight);
            heightChanged = true;
        }
        if (curWidth < trgWidth && extendWidth) {
            if (preferredWidth) {
                tc.setPreferredWidth((int)trgWidth);
                widthChanged = true;
            } else {
                tc.setWidth((int)trgWidth);
                widthChanged = true;
            }
        } else if (curWidth > trgWidth && shrinkWidth) {
            if (preferredWidth) {
                tc.setPreferredWidth((int)trgWidth);
                widthChanged = true;
            } else {
                tc.setWidth((int)trgWidth);
                widthChanged = true;
            }
        }
        return heightChanged || widthChanged;
    }

    public int getColumnWidth(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("col < 0");
        }
        int colCnt = this.getColumnCount();
        if (col >= colCnt) {
            throw new IllegalArgumentException("col >= columnCount(=" + colCnt + ")");
        }
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (tc == null) {
            throw new IllegalStateException("can't get TableColumn for col=" + col);
        }
        return tc.getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCellResizer getTableCellResizer() {
        if (this.resizer != null) {
            return this.resizer;
        }
        Table table = this;
        synchronized (table) {
            if (this.resizer != null) {
                return this.resizer;
            }
            this.resizer = new TableCellResizer();
            this.resizer.setTable(this);
            return this.resizer;
        }
    }

    protected void changeMouseAtCell(MouseEvent e, int row, int col) {
        this.mouseAtRow = row;
        this.mouseAtColumn = col;
        this.resizeCaptureRect = this.getTableCellResizer().cellCaptureZone(this.mouseAtRow, this.mouseAtColumn);
        this.repaint();
    }

    protected boolean mouseEnter(MouseEvent e) {
        this.mouseOver = true;
        this.resizeCaptureRect = null;
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return false;
    }

    protected boolean mouseExit(MouseEvent e) {
        this.mouseOver = false;
        this.resizeCaptureRect = null;
        this.getTableCellResizer().stop();
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return false;
    }

    protected boolean mouseMove(MouseEvent e) {
        int mrow = this.rowAtPoint(e.getPoint());
        int mcol = this.columnAtPoint(e.getPoint());
        if (mrow != this.mouseAtRow || mcol != this.mouseAtColumn) {
            this.changeMouseAtCell(e, mrow, mcol);
        }
        if (this.resizeCaptureRect == null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.resizeCaptureRect.contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    protected boolean mouseDragged(MouseEvent e) {
        if (this.getTableCellResizer().isStarted()) {
            this.getTableCellResizer().drag(e);
            return true;
        }
        return false;
    }

    protected boolean isResizeStartEvent(MouseEvent e) {
        if (e == null) {
            return false;
        }
        if (e.getID() != 501) {
            return false;
        }
        if (e.getButton() != this.resizeMouseButton) {
            return false;
        }
        if (this.resizeMouseAlt != null && !Objects.equals(e.isAltDown(), this.resizeMouseAlt)) {
            return false;
        }
        if (this.resizeMouseControl != null && !Objects.equals(e.isControlDown(), this.resizeMouseControl)) {
            return false;
        }
        if (this.resizeMouseShift != null && !Objects.equals(e.isShiftDown(), this.resizeMouseShift)) {
            return false;
        }
        return this.resizeMouseMeta == null || Objects.equals(e.isMetaDown(), this.resizeMouseMeta);
    }

    protected boolean isResizeStopEvent(MouseEvent e) {
        if (e == null) {
            return false;
        }
        if (e.getID() == 502) {
            return true;
        }
        return e.getID() == 505;
    }

    protected boolean mousePressed(MouseEvent e) {
        if (this.isResizeStartEvent(e) && this.getTableCellResizer().isCaptureZone(e)) {
            this.getTableCellResizer().start(e);
            return true;
        }
        return false;
    }

    protected boolean mouseReleased(MouseEvent e) {
        if (this.isResizeStopEvent(e) && this.getTableCellResizer().isStarted()) {
            this.getTableCellResizer().stop();
            return true;
        }
        return false;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 503: {
                if (!this.mouseMove(e)) break;
                return;
            }
            case 506: {
                if (!this.mouseDragged(e)) break;
                return;
            }
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 504: {
                if (!this.mouseEnter(e)) break;
                return;
            }
            case 505: {
                if (!this.mouseExit(e)) break;
                return;
            }
            case 501: {
                if (!this.mousePressed(e)) break;
                return;
            }
            case 502: {
                if (!this.mouseReleased(e)) break;
                return;
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g instanceof Graphics2D) {
            Rectangle2D rect;
            Graphics2D gs = (Graphics2D)g;
            if (this.mouseOver && this.mouseAtRow >= 0 && this.mouseAtColumn >= 0 && (rect = this.getTableCellResizer().cellCaptureZone(this.mouseAtRow, this.mouseAtColumn)) != null) {
                this.getTableCellResizer().paintCaptureZone(gs, rect);
            }
        }
    }

    public int getFocusedRow() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public void setFocusedRow(int row, boolean clearSelection, boolean addSelection) {
        if (row < 0) {
            return;
        }
        int rc = this.getRowCount();
        if (row >= rc) {
            return;
        }
        if (clearSelection) {
            this.getSelectionModel().clearSelection();
            this.getColumnModel().getSelectionModel().clearSelection();
        }
        if (addSelection) {
            this.getSelectionModel().addSelectionInterval(row, row);
            this.getColumnModel().getSelectionModel().addSelectionInterval(0, 0);
        }
        this.getColumnModel().getSelectionModel().setLeadSelectionIndex(0);
        this.getSelectionModel().setLeadSelectionIndex(row);
    }

    public int getFocusedColumn() {
        return this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
    }

    public void setFocusedColumn(int col) {
        int colcnt = this.getColumnCount();
        if (col < 0) {
            return;
        }
        if (col >= colcnt) {
            return;
        }
        this.getColumnModel().getSelectionModel().setLeadSelectionIndex(col);
    }

    public VisibleArea getVisibleArea() {
        Rectangle cellRect;
        int ci;
        int ri;
        VisibleArea va = new VisibleArea();
        Rectangle vrect = this.getVisibleRect();
        va.setVisibleRect(vrect);
        int rc = this.getRowCount();
        if (rc < 1) {
            return va;
        }
        int centralRow = this.findCentralRow(vrect);
        if (centralRow < 0) {
            return va;
        }
        if (centralRow >= rc) {
            return va;
        }
        for (ri = centralRow; ri >= 0; --ri) {
            for (ci = 0; ci < this.getColumnCount(); ++ci) {
                cellRect = this.getCellRect(ri, ci, true);
                if (cellRect.intersects(vrect)) {
                    va.addCell(ri, ci, cellRect);
                    continue;
                }
                ri = -100;
            }
        }
        for (ri = centralRow; ri < rc; ++ri) {
            for (ci = 0; ci < this.getColumnCount(); ++ci) {
                cellRect = this.getCellRect(ri, ci, true);
                if (cellRect.intersects(vrect)) {
                    va.addCell(ri, ci, cellRect);
                    continue;
                }
                ri = rc + 100;
            }
        }
        return va;
    }

    private int findCentralRow(Rectangle rect) {
        if (rect == null) {
            return -1;
        }
        int rc = this.getRowCount();
        if (rc < 1) {
            return -1;
        }
        if (rc == 1) {
            return 0;
        }
        Point2D.Double cPt = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
        int row = rc / 2;
        int step = rc / 4;
        while (true) {
            int nrow;
            if (step < 1) {
                return row;
            }
            Rectangle cellRect = this.getCellRect(row, 0, true);
            double ydiff = cPt.getY() - cellRect.getCenterY();
            if (ydiff < 0.0) {
                nrow = row - step;
                if (nrow == row) {
                    return row;
                }
                if (nrow < 0) {
                    return 0;
                }
                row = nrow;
                step /= 2;
                continue;
            }
            if (!(ydiff > 0.0)) break;
            nrow = row + step;
            if (nrow == row) {
                return row;
            }
            if (nrow >= rc) {
                return nrow - 1;
            }
            row = nrow;
            step /= 2;
        }
        return row;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class VisibleArea {
        protected Integer minRow;
        protected Integer minColumn;
        protected Integer maxRow;
        protected Integer maxColumn;
        protected Rectangle visibleRect;

        public Rectangle getVisibleRect() {
            return this.visibleRect;
        }

        public void setVisibleRect(Rectangle visibleRect) {
            this.visibleRect = visibleRect;
        }

        public void addCell(int row, int col, Rectangle crect) {
            this.minRow = this.minRow == null ? row : Math.min(this.minRow, row);
            this.maxRow = this.maxRow == null ? row : Math.max(this.maxRow, row);
            this.minColumn = this.minColumn == null ? row : Math.min(this.minColumn, col);
            this.maxColumn = this.maxColumn == null ? row : Math.max(this.maxColumn, row);
        }

        public Integer getMinRow() {
            return this.minRow;
        }

        public Integer getMinColumn() {
            return this.minColumn;
        }

        public Integer getMaxRow() {
            return this.maxRow;
        }

        public Integer getMaxColumn() {
            return this.maxColumn;
        }

        public boolean hasCells() {
            return this.minRow != null && this.minColumn != null && this.maxRow != null && this.maxColumn != null;
        }
    }
}

