/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import xyz.cofe.gui.swing.color.ColorModificator;

public class TableCellResizer {
    private static final Logger logger = Logger.getLogger(TableCellResizer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected JTable table;
    protected double captureHAlign = 0.0;
    protected double captureWidth = 0.0;
    protected double captureWidthRelative = 1.0;
    protected double captureVAlign = 1.0;
    protected double captureHeight = 4.0;
    protected double captureHeightRelative = 0.0;
    protected int xStarted;
    protected int yStarted;
    protected int rowStarted = -1;
    protected int colStarted = -1;
    protected int rowHeightStarted;
    protected int colWidthStarted;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableCellResizer.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TableCellResizer.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableCellResizer.class.getName(), method, result);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public double getCaptureHAlign() {
        return this.captureHAlign;
    }

    public void setCaptureHAlign(double captureHAlign) {
        this.captureHAlign = captureHAlign;
    }

    public double getCaptureWidth() {
        return this.captureWidth;
    }

    public void setCaptureWidth(double captureWidth) {
        this.captureWidth = captureWidth;
    }

    public double getCaptureWidthRelative() {
        return this.captureWidthRelative;
    }

    public void setCaptureWidthRelative(double captureWidthRelative) {
        this.captureWidthRelative = captureWidthRelative;
    }

    public double getCaptureVAlign() {
        return this.captureVAlign;
    }

    public void setCaptureVAlign(double captureVAlign) {
        this.captureVAlign = captureVAlign;
    }

    public double getCaptureHeight() {
        return this.captureHeight;
    }

    public void setCaptureHeight(double captureHeight) {
        this.captureHeight = captureHeight;
    }

    public double getCaptureHeightRelative() {
        return this.captureHeightRelative;
    }

    public void setCaptureHeightRelative(double captureHeightRelative) {
        this.captureHeightRelative = captureHeightRelative;
    }

    public Rectangle2D cellCaptureZone(int row, int col) {
        JTable tbl = this.table;
        if (tbl == null) {
            return null;
        }
        Rectangle cellRect = tbl.getCellRect(row, col, true);
        if (cellRect == null) {
            return null;
        }
        double capw = cellRect.getWidth() * this.captureWidthRelative + this.captureWidth;
        double caph = cellRect.getHeight() * this.captureHeightRelative + this.captureHeight;
        double wdiff = cellRect.getWidth() - capw;
        double hdiff = cellRect.getHeight() - caph;
        double capx = cellRect.getMinX() + wdiff * this.captureHAlign;
        double capy = cellRect.getMinY() + hdiff * this.captureVAlign;
        Rectangle2D.Double crect = new Rectangle2D.Double(capx, capy, capw, caph);
        return crect;
    }

    public Rectangle2D captureZone(int x, int y) {
        JTable tbl = this.table;
        if (tbl == null) {
            return null;
        }
        if (x < 0) {
            return null;
        }
        if (y < 0) {
            return null;
        }
        Point pt = new Point(x, y);
        int row = tbl.rowAtPoint(pt);
        if (row < 0) {
            return null;
        }
        int col = tbl.columnAtPoint(pt);
        if (col < 0) {
            return null;
        }
        return this.cellCaptureZone(row, col);
    }

    public Rectangle2D captureZone(MouseEvent me) {
        return me == null ? null : this.captureZone(me.getX(), me.getY());
    }

    public boolean isCaptureZone(int x, int y) {
        Rectangle2D crect = this.captureZone(x, y);
        return crect != null ? crect.contains(x, y) : false;
    }

    public boolean isCaptureZone(MouseEvent me) {
        return me == null ? null : Boolean.valueOf(this.isCaptureZone(me.getX(), me.getY()));
    }

    public void paintCaptureZone(Graphics2D gs, Rectangle2D rect) {
        if (gs == null || rect == null) {
            return;
        }
        Paint savePaint = gs.getPaint();
        Shape saveClip = gs.getClip();
        Stroke saveStoke = gs.getStroke();
        Color lightColor = new ColorModificator().alpha(0.5f).apply(Color.white);
        Color bodyColor = new ColorModificator().alpha(0.5f).brighter(-0.25f).apply(lightColor);
        Color darkColor = new ColorModificator().alpha(0.5f).brighter(-0.5f).apply(lightColor);
        gs.setPaint(bodyColor);
        gs.draw(rect);
        if (rect.getHeight() > 2.0 && rect.getWidth() > 2.0) {
            gs.setStroke(new BasicStroke(1.0f));
            gs.setClip(rect);
            Color c1 = new ColorModificator().alpha(0.5f).apply(lightColor);
            Color c2 = new ColorModificator().alpha(0.5f).apply(darkColor);
            int ci = -1;
            double mm = Math.max(rect.getWidth(), rect.getHeight());
            for (double x = rect.getMinX() - rect.getHeight(); x < rect.getMaxX(); x += 2.0) {
                Color c = ++ci % 2 > 0 ? c2 : c1;
                gs.setPaint(c);
                gs.drawLine((int)x, (int)rect.getMaxY() + 1, (int)x + (int)mm, (int)rect.getMaxY() + 1 - (int)mm);
            }
            gs.setClip(saveClip);
        }
        gs.setStroke(new BasicStroke(1.0f));
        Path2D.Double pLight = new Path2D.Double();
        ((Path2D)pLight).moveTo(rect.getMinX(), rect.getMaxY());
        ((Path2D)pLight).lineTo(rect.getMinX(), rect.getMinY());
        ((Path2D)pLight).lineTo(rect.getMaxX(), rect.getMinY());
        gs.setPaint(lightColor);
        gs.draw(pLight);
        Path2D.Double pDark = new Path2D.Double();
        ((Path2D)pDark).moveTo(rect.getMaxX(), rect.getMinY());
        ((Path2D)pDark).lineTo(rect.getMaxX(), rect.getMaxY());
        ((Path2D)pDark).lineTo(rect.getMinX(), rect.getMaxY());
        gs.setPaint(darkColor);
        gs.draw(pDark);
        gs.setClip(saveClip);
        gs.setPaint(savePaint);
        gs.setStroke(saveStoke);
    }

    public void start(MouseEvent me) {
        if (me == null) {
            return;
        }
        JTable tbl = this.table;
        if (tbl == null) {
            return;
        }
        this.rowStarted = tbl.rowAtPoint(me.getPoint());
        this.colStarted = tbl.columnAtPoint(me.getPoint());
        if (this.rowStarted < 0 || this.colStarted < 0) {
            return;
        }
        this.xStarted = me.getX();
        this.yStarted = me.getY();
        this.rowHeightStarted = tbl.getRowHeight(this.rowStarted);
        this.colWidthStarted = tbl.getColumnModel().getColumn(this.colStarted).getWidth();
    }

    public void stop() {
        this.rowStarted = -1;
        this.colStarted = -1;
    }

    public boolean isStarted() {
        return this.rowStarted >= 0 && this.colStarted >= 0;
    }

    public void drag(MouseEvent me) {
        if (me == null) {
            return;
        }
        JTable tbl = this.table;
        if (tbl == null) {
            return;
        }
        if (this.rowStarted < 0) {
            return;
        }
        int ydiff = me.getY() - this.yStarted;
        int xdiff = me.getX() - this.xStarted;
        int trgtHeight = this.rowHeightStarted + ydiff;
        if (this.rowStarted >= 0 && trgtHeight >= 1) {
            tbl.setRowHeight(this.rowStarted, trgtHeight);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

