/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.table.Table;

public class TableEvent {
    private static final Logger logger = Logger.getLogger(TableEvent.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Table table;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableEvent.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TableEvent.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableEvent.class.getName(), method, result);
    }

    public TableEvent(Table tbl) {
        this.table = tbl;
    }

    public Table getTable() {
        return this.table;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class FocusedRowChanged
    extends TableEvent {
        protected int oldRow;
        protected int currentRow;

        public FocusedRowChanged(Table tbl, int oldRow, int curRow) {
            super(tbl);
            this.oldRow = oldRow;
            this.currentRow = curRow;
        }

        public FocusedRowChanged(FocusedRowChanged sample) {
            super(sample.table);
            this.oldRow = sample.oldRow;
            this.currentRow = sample.currentRow;
        }

        public int getOldRow() {
            return this.oldRow;
        }

        public int getCurrentRow() {
            return this.currentRow;
        }
    }
}

