/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xyz.cofe.common.CloseableSet;

public class TableFocusListener {
    private static final Logger logger = Logger.getLogger(TableFocusListener.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Object sync;
    protected JTable table;
    protected final CloseableSet tableListeners = new CloseableSet();
    protected int focusedRow = -1;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableFocusListener.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TableFocusListener.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableFocusListener.class.getName(), method, result);
    }

    public TableFocusListener() {
        this.sync = this;
    }

    public TableFocusListener(JTable table, boolean start) {
        this.sync = this;
        this.table = table;
        if (start) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JTable getTable() {
        Object object = this.sync;
        synchronized (object) {
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(JTable table) {
        Object object = this.sync;
        synchronized (object) {
            this.table = table;
        }
    }

    protected void listen() {
        this.tableListeners.closeAll();
        if (this.table == null) {
            return;
        }
        final JTable table = this.table;
        final ListSelectionModel listSelModel = table.getSelectionModel();
        this.focusedRow = listSelModel.getLeadSelectionIndex();
        final ListSelectionListener listSelectListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int curFocusedRow = listSelModel.getLeadSelectionIndex();
                if (curFocusedRow != TableFocusListener.this.focusedRow) {
                    int oldFocRow = TableFocusListener.this.focusedRow;
                    TableFocusListener.this.focusedRow = curFocusedRow;
                    TableFocusListener.this.onFocusedRowChanged(table, oldFocRow, TableFocusListener.this.focusedRow);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(listSelectListener);
        Closeable cl = new Closeable(){

            @Override
            public void close() throws IOException {
                listSelModel.removeListSelectionListener(listSelectListener);
            }
        };
        this.tableListeners.add(cl);
    }

    protected void onFocusedRowChanged(JTable table, int oldRow, int curRow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            if (this.table == null) {
                throw new IllegalStateException("table == null");
            }
            this.listen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            this.tableListeners.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.sync;
        synchronized (object) {
            Object[] listeners = this.tableListeners.getCloseables();
            return listeners != null && listeners.length > 0;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

