/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func4;
import xyz.cofe.collection.Func6;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.GuiUtil;

public class TableFocusTracker
implements Closeable {
    private static final Logger logger = Logger.getLogger(TableFocusTracker.class.getName());
    protected CloseableSet listeners = new CloseableSet();
    protected Timer timer;
    protected JTable table;
    protected WeakReference<JTable> tableRef;
    protected Func2<Object, Integer, Integer> cellReader;
    protected boolean compareRow = true;
    protected boolean compareColumn = false;
    protected boolean compareObject = false;
    protected Func2<Boolean, Object, Object> equalsComparator;
    protected Object lastFocusedItem;
    protected int lastFocusedRow;
    protected int lastFocusedColumn;
    protected volatile Func2<Object, Integer, Integer> rowChanged;
    protected volatile Func4<Object, Integer, Integer, Integer, Integer> cellChanged;
    protected volatile Func6<Object, Integer, Integer, Object, Integer, Integer, Object> itemChanged;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TableFocusTracker.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableFocusTracker.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableFocusTracker.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TableFocusTracker.class.getName(), method);
    }

    public TableFocusTracker(JTable table, int delay, boolean weak) {
        if (table == null) {
            throw new IllegalArgumentException("table==null");
        }
        if (delay < 1) {
            throw new IllegalArgumentException("delay<1");
        }
        this.table = weak ? null : table;
        this.tableRef = weak ? new WeakReference<JTable>(table) : null;
        this.timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFocusTracker.this.checkChanges();
            }
        });
        this.lastFocusedRow = this.getFocusedRow();
        this.lastFocusedColumn = this.getFocusedColumn();
        final ComponentAdapter cmptAdapter = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TableFocusTracker.logFiner("componentHidden", new Object[0]);
                TableFocusTracker.this.onTableHide();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TableFocusTracker.logFiner("componentShown", new Object[0]);
                TableFocusTracker.this.onTableShow();
            }
        };
        table.addComponentListener(cmptAdapter);
        final WeakReference<JTable> wref = new WeakReference<JTable>(table);
        this.listeners.add(new Runnable(){

            @Override
            public void run() {
                JTable t = (JTable)wref.get();
                if (t != null) {
                    t.removeComponentListener(cmptAdapter);
                }
            }
        });
        final CloseableSet wndListeners = new CloseableSet();
        final JTable ftable = table;
        final AncestorListener ancLsnr = new AncestorListener(){
            JTable iftable;
            {
                this.iftable = ftable;
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                TableFocusTracker.logFiner("ancestorAdded", new Object[0]);
                wndListeners.closeAll();
                TableFocusTracker.this.onTableShow();
                final Window wnd = GuiUtil.getWindowOfComponent(this.iftable);
                if (wnd != null) {
                    final WindowAdapter wclose = new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            TableFocusTracker.logFiner("windowClosed", new Object[0]);
                            TableFocusTracker.this.onTableHide();
                            Window wnd = e.getWindow();
                            if (wnd != null) {
                                TableFocusTracker.logFiner("removeWindowListener by self", new Object[0]);
                                wnd.removeWindowListener(this);
                            }
                        }

                        @Override
                        public void windowClosing(WindowEvent e) {
                            TableFocusTracker.logFiner("windowClosing", new Object[0]);
                            TableFocusTracker.this.onTableHide();
                            Window wnd = e.getWindow();
                            if (wnd != null) {
                                TableFocusTracker.logFiner("removeWindowListener by self", new Object[0]);
                                wnd.removeWindowListener(this);
                            }
                        }
                    };
                    final WeakReference<Window> wwnd = new WeakReference<Window>(wnd);
                    wndListeners.add(new Runnable(){

                        @Override
                        public void run() {
                            Window rwnd = (Window)wwnd.get();
                            if (rwnd != null) {
                                TableFocusTracker.logFiner("removeWindowListener by runnable", new Object[0]);
                                wnd.removeWindowListener(wclose);
                                wwnd.clear();
                            }
                        }
                    });
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                TableFocusTracker.logFiner("ancestorRemoved", new Object[0]);
                TableFocusTracker.this.onTableHide();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                TableFocusTracker.logFiner("ancestorMoved", new Object[0]);
            }
        };
        table.addAncestorListener(ancLsnr);
        this.listeners.add(new Runnable(){

            @Override
            public void run() {
                JTable t = (JTable)wref.get();
                if (t != null) {
                    t.removeAncestorListener(ancLsnr);
                }
            }
        });
        this.listeners.add((Closeable)wndListeners);
    }

    protected void onTableHide() {
        this.stop();
    }

    protected void onTableShow() {
        this.start();
        if (!this.isRunning()) {
            try {
                this.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TableFocusTracker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.stop();
            this.listeners.closeAll();
            if (this.timer != null) {
                this.timer = null;
            }
            if (this.table != null) {
                this.table = null;
            }
            if (this.tableRef != null) {
                this.tableRef.clear();
                this.tableRef = null;
            }
            this.cellReader = null;
            this.equalsComparator = null;
            this.lastFocusedItem = null;
            this.rowChanged = null;
            this.cellChanged = null;
            this.itemChanged = null;
        }
    }

    public static TableFocusTracker tracking(JTable tbl, boolean weak) {
        return new TableFocusTracker(tbl, 100, weak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableFocusTracker timerDelay(int delay) {
        if (delay < 1) {
            throw new IllegalArgumentException("delay<1");
        }
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            Timer t = this.getTimer();
            if (t != null) {
                t.setDelay(delay);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableFocusTracker start() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            if (this.timer != null) {
                this.timer.start();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableFocusTracker stop() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            if (this.timer == null) {
                return false;
            }
            return this.timer.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.timer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JTable getTable() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            if (this.table == null && this.tableRef != null) {
                return (JTable)this.tableRef.get();
            }
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFocusedRow() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            JTable tbl = this.getTable();
            if (tbl == null) {
                return -1;
            }
            return tbl.getSelectionModel().getLeadSelectionIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFocusedColumn() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            JTable tbl = this.getTable();
            if (tbl == null) {
                return -1;
            }
            return tbl.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Func2<Object, Integer, Integer> getCellReader() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.cellReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellReader(Func2<Object, Integer, Integer> cellReader) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.cellReader = cellReader;
            this.compareObject = cellReader != null;
        }
    }

    public TableFocusTracker cellReader(Func2<Object, Integer, Integer> cellReader) {
        this.setCellReader(cellReader);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getItem(int row, int col) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            if (this.cellReader != null) {
                return this.cellReader.apply((Object)row, (Object)col);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompareRow() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.compareRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompareRow(boolean compareRow) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.compareRow = compareRow;
        }
    }

    public TableFocusTracker compareRow(boolean compareRow) {
        this.setCompareRow(compareRow);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompareColumn() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.compareColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompareColumn(boolean compareColumn) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.compareColumn = compareColumn;
        }
    }

    public TableFocusTracker compareColumn(boolean compareColumn) {
        this.setCompareColumn(this.compareRow);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompareObject() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.compareObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompareObject(boolean compareObject) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.compareObject = compareObject;
        }
    }

    public TableFocusTracker compareObject(boolean compareObject) {
        this.setCompareObject(compareObject);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Func2<Boolean, Object, Object> getEqualsComparator() {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            return this.equalsComparator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEqualsComparator(Func2<Boolean, Object, Object> equalsComparator) {
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            this.equalsComparator = equalsComparator;
            this.compareRow = this.equalsComparator != null;
        }
    }

    public TableFocusTracker equalsComparator(Func2<Boolean, Object, Object> equalsComparator) {
        this.setEqualsComparator(equalsComparator);
        return this;
    }

    protected boolean compareEquals(Object i0, Object i1) {
        if (i0 == null || i1 == null) {
            return i0 == i1;
        }
        if (this.equalsComparator != null) {
            return (Boolean)this.equalsComparator.apply(i0, i1);
        }
        return i0.equals(i1);
    }

    public Object getLastFocusedItem() {
        return this.lastFocusedItem;
    }

    public int getLastFocusedRow() {
        return this.lastFocusedRow;
    }

    public int getLastFocusedColumn() {
        return this.lastFocusedColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkChanges() {
        boolean changed;
        boolean itmChanged;
        boolean cllChanged;
        boolean rowChanged;
        Object litm;
        int lcol;
        int lrow;
        Object fitm;
        int fcol;
        int frow;
        TableFocusTracker tableFocusTracker = this;
        synchronized (tableFocusTracker) {
            frow = this.getFocusedRow();
            fcol = this.getFocusedColumn();
            fitm = this.getItem(frow, fcol);
            lrow = this.lastFocusedRow;
            lcol = this.lastFocusedColumn;
            litm = this.lastFocusedItem;
            this.lastFocusedRow = frow;
            this.lastFocusedColumn = fcol;
            this.lastFocusedItem = fitm;
            rowChanged = frow != lrow && this.compareRow;
            cllChanged = fcol != lcol && this.compareColumn;
            itmChanged = this.compareObject && !this.compareEquals(litm, fitm);
            changed = rowChanged || cllChanged || itmChanged;
        }
        if (changed) {
            this.changed(litm, lrow, lcol, fitm, frow, fcol);
        }
        if (rowChanged) {
            this.rowChanged(litm, lrow, lcol, fitm, frow, fcol);
        }
        if (cllChanged) {
            this.cellChanged(litm, lrow, lcol, fitm, frow, fcol);
        }
        if (itmChanged) {
            this.itemChanged(litm, lrow, lcol, fitm, frow, fcol);
        }
    }

    protected void changed(Object lastItm, int lastRow, int lastCol, Object currentItem, int currentRow, int currentCol) {
    }

    public Func2<Object, Integer, Integer> getRowChanged() {
        return this.rowChanged;
    }

    public void setRowChanged(Func2<Object, Integer, Integer> rowChanged) {
        this.rowChanged = rowChanged;
    }

    public TableFocusTracker rowChanged(Func2<Object, Integer, Integer> rowChanged) {
        this.rowChanged = rowChanged;
        return this;
    }

    protected void rowChanged(Object lastItm, int lastRow, int lastCol, Object currentItem, int currentRow, int currentCol) {
        Func2<Object, Integer, Integer> f = this.rowChanged;
        if (f != null) {
            f.apply((Object)lastRow, (Object)currentRow);
        }
    }

    public Func4<Object, Integer, Integer, Integer, Integer> getCellChanged() {
        return this.cellChanged;
    }

    public void setCellChanged(Func4<Object, Integer, Integer, Integer, Integer> cellChanged) {
        this.cellChanged = cellChanged;
    }

    public TableFocusTracker cellChanged(Func4<Object, Integer, Integer, Integer, Integer> cellChanged) {
        this.cellChanged = cellChanged;
        return this;
    }

    protected void cellChanged(Object lastItm, int lastRow, int lastCol, Object currentItem, int currentRow, int currentCol) {
        Func4<Object, Integer, Integer, Integer, Integer> f = this.cellChanged;
        if (f != null) {
            f.apply((Object)lastRow, (Object)lastCol, (Object)currentRow, (Object)currentCol);
        }
    }

    public Func6<Object, Integer, Integer, Object, Integer, Integer, Object> getItemChanged() {
        return this.itemChanged;
    }

    public void setItemChanged(Func6<Object, Integer, Integer, Object, Integer, Integer, Object> rowChanged) {
        this.itemChanged = rowChanged;
    }

    public TableFocusTracker itemChanged(Func6<Object, Integer, Integer, Object, Integer, Integer, Object> rowChanged) {
        this.itemChanged = rowChanged;
        return this;
    }

    public TableFocusTracker itemChanged(final Reciver<Object> rowChanged) {
        if (rowChanged == null) {
            throw new IllegalArgumentException("rowChanged==null");
        }
        this.itemChanged = new Func6<Object, Integer, Integer, Object, Integer, Integer, Object>(){

            public Object apply(Integer oldRow, Integer oldCol, Object old, Integer curRow, Integer curCol, Object current) {
                rowChanged.recive(current);
                return null;
            }
        };
        return this;
    }

    protected void itemChanged(Object lastItm, int lastRow, int lastCol, Object currentItem, int currentRow, int currentCol) {
        Func6<Object, Integer, Integer, Object, Integer, Integer, Object> f = this.itemChanged;
        if (f != null) {
            f.apply((Object)lastRow, (Object)lastCol, lastItm, (Object)currentRow, (Object)currentCol, currentItem);
        }
    }
}

