/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.Reciver;

public class TableModelEventDelegator
implements Closeable {
    private static final Logger logger = Logger.getLogger(TableModelEventDelegator.class.getName());
    protected TableModel targetModel;
    protected TableModel sourceModel;
    protected boolean listen = false;
    protected Reciver<TableModelEvent> sender;
    protected TableModelListener listener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            Func1<Integer, Integer> row2out = TableModelEventDelegator.this.getMapRowToOutside();
            Func1<Integer, Integer> col2out = TableModelEventDelegator.this.getMapColumnToOutside();
            TableModel trgt = TableModelEventDelegator.this.getTargetModel();
            Reciver<TableModelEvent> sndr = TableModelEventDelegator.this.getSender();
            if (row2out == null || col2out == null || trgt == null || sndr == null) {
                return;
            }
            for (TableModelEvent de : TableModelEventDelegator.this.deletageTMEvent(e, trgt, row2out, col2out)) {
                sndr.recive((Object)de);
            }
        }
    };
    protected Func1<Integer, Integer> mapRowToOutside;
    protected Func1<Integer, Integer> mapColumnToOutside;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TableModelEventDelegator.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableModelEventDelegator.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableModelEventDelegator.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TableModelEventDelegator.class.getName(), method);
    }

    @Override
    public synchronized void close() {
        this.stop();
        this.mapColumnToOutside = null;
        this.mapRowToOutside = null;
        this.sender = null;
        this.sourceModel = null;
        this.targetModel = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized TableModel getTargetModel() {
        return this.targetModel;
    }

    public synchronized void setTargetModel(TableModel targetModel) {
        this.targetModel = targetModel;
    }

    public synchronized TableModel getSourceModel() {
        return this.sourceModel;
    }

    public synchronized void setSourceModel(TableModel sourceModel) {
        this.stop();
        this.sourceModel = sourceModel;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.sourceModel == null) {
            return;
        }
        this.sourceModel.addTableModelListener(this.listener);
        this.listen = true;
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this.sourceModel == null) {
            return;
        }
        this.sourceModel.removeTableModelListener(this.listener);
        this.listen = false;
    }

    public synchronized boolean isRunning() {
        return this.listen;
    }

    public synchronized Reciver<TableModelEvent> getSender() {
        return this.sender;
    }

    public synchronized void setSender(Reciver<TableModelEvent> sender) {
        this.sender = sender;
    }

    public synchronized Func1<Integer, Integer> getMapRowToOutside() {
        return this.mapRowToOutside;
    }

    public synchronized void setMapRowToOutside(Func1<Integer, Integer> mapRowToOutside) {
        this.mapRowToOutside = mapRowToOutside;
    }

    public synchronized Func1<Integer, Integer> getMapColumnToOutside() {
        return this.mapColumnToOutside;
    }

    public synchronized void setMapColumnToOutside(Func1<Integer, Integer> mapColumnToOutside) {
        this.mapColumnToOutside = mapColumnToOutside;
    }

    public List<TableModelEvent> deletageTMEvent(TableModelEvent e, TableModel newsrc, Func1<Integer, Integer> mapRowToOutside, Func1<Integer, Integer> mapColumnToOutside) {
        if (e == null) {
            throw new IllegalArgumentException("e==null");
        }
        if (newsrc == null) {
            throw new IllegalArgumentException("newsrc==null");
        }
        if (mapColumnToOutside == null) {
            throw new IllegalArgumentException("mapColumnToOutside==null");
        }
        if (mapRowToOutside == null) {
            throw new IllegalArgumentException("mapRowToOutside==null");
        }
        ArrayList<TableModelEvent> res = new ArrayList<TableModelEvent>();
        if (e == null) {
            return res;
        }
        int srcFirstRow = e.getFirstRow();
        int srcLastRow = e.getLastRow();
        int etype = e.getType();
        int srcColumn = e.getColumn();
        int outFirstRow = -1;
        int outLastRow = -1;
        int outType = -1;
        int outColumn = -1;
        if (srcFirstRow == 0 && srcLastRow == Integer.MAX_VALUE) {
            res.add(new TableModelEvent(newsrc, -1));
            return res;
        }
        if (srcFirstRow < 0) {
            res.add(new TableModelEvent(newsrc, -1));
            return res;
        }
        if (srcFirstRow >= 0 && srcLastRow >= srcFirstRow) {
            if (srcColumn >= 0 && (outColumn = ((Integer)mapColumnToOutside.apply((Object)srcColumn)).intValue()) < 0) {
                return null;
            }
            TreeSet<Integer> modifiedRows = new TreeSet<Integer>();
            for (int irow = srcFirstRow; irow <= srcLastRow; ++irow) {
                int orow = (Integer)mapRowToOutside.apply((Object)irow);
                if (orow < 0) continue;
                modifiedRows.add(orow);
            }
            if (modifiedRows.size() > 0) {
                ArrayList<BasicPair> beginEnd = new ArrayList<BasicPair>();
                int begin = -1;
                int end = -1;
                int nxt = -1;
                Iterator iterator = modifiedRows.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (begin < 0) {
                        begin = n;
                        end = n;
                        nxt = n + 1;
                        continue;
                    }
                    if (nxt == n) {
                        nxt = n + 1;
                        end = n;
                        continue;
                    }
                    beginEnd.add(new BasicPair((Object)begin, (Object)end));
                    begin = n;
                    end = n;
                    nxt = n + 1;
                }
                beginEnd.add(new BasicPair((Object)begin, (Object)end));
                if (etype == 0) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(new TableModelEvent(newsrc, begin, end, -1, 0));
                    }
                    return res;
                }
                if (etype == 1) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(new TableModelEvent(newsrc, begin, end, -1, 1));
                    }
                    return res;
                }
                if (etype == -1) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(0, new TableModelEvent(newsrc, begin, end, -1, -1));
                    }
                    return res;
                }
            }
        }
        res.clear();
        res.add(new TableModelEvent(newsrc, -1));
        return res;
    }
}

