/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;
import xyz.cofe.gui.swing.table.EventSupport;

public class WrapTM
implements TableModel {
    private transient PropertyChangeSupport propertyChangeSupport = null;
    protected EventSupport evSupport = new EventSupport(this);
    protected TableModel tableModel = null;
    protected boolean tableModelListenerStarted = false;
    protected final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e == null) {
                return;
            }
            TableModel tm = e.getSource() instanceof TableModel ? (TableModel)e.getSource() : WrapTM.this.tableModel;
            int frow = e.getFirstRow();
            int lrow = e.getLastRow();
            int col = e.getColumn();
            int type = e.getType();
            int category = -1;
            List<TableModelEvent> ev = null;
            if (frow == 0 && lrow == Integer.MAX_VALUE) {
                category = 10;
            } else if (frow >= 0 && lrow >= frow && type == 1) {
                category = 2;
            } else if (frow >= 0 && lrow >= frow && type == -1) {
                category = 3;
            } else if (frow >= 0 && lrow >= frow && type == 0) {
                category = 1;
            }
            switch (category) {
                case 1: {
                    WrapTM.logFiner("onRowUpdated(e={0}, from={1} to={2})", new Object[]{e, frow, lrow});
                    ev = WrapTM.this.onRowUpdated(e, frow, lrow);
                    WrapTM.logFinest("onRowUpdated(e={0}, from={1} to={2})={3}", new Object[]{e, frow, lrow, ev != null ? Integer.valueOf(ev.size()) : null});
                    break;
                }
                case 2: {
                    WrapTM.logFiner("onRowInserted(e={0}, from={1} to={2})", new Object[]{e, frow, lrow});
                    ev = WrapTM.this.onRowInserted(e, frow, lrow);
                    WrapTM.logFinest("onRowInserted(e={0}, from={1} to={2})={3}", new Object[]{e, frow, lrow, ev != null ? Integer.valueOf(ev.size()) : null});
                    break;
                }
                case 3: {
                    WrapTM.logFiner("onRowDeleted(e={0}, from={1} to={2})", new Object[]{e, frow, lrow});
                    ev = WrapTM.this.onRowDeleted(e, frow, lrow);
                    WrapTM.logFinest("onRowDeleted(e={0}, from={1} to={2})={3}", new Object[]{e, frow, lrow, ev != null ? Integer.valueOf(ev.size()) : null});
                    break;
                }
                default: {
                    WrapTM.logFiner("onTableChanged(e={0}, from={1} to={2})", new Object[]{e, frow, lrow});
                    ev = WrapTM.this.onTableChanged(e);
                    WrapTM.logFinest("onTableChanged(e={0}, from={1} to={2})={3}", new Object[]{e, frow, lrow, ev != null ? Integer.valueOf(ev.size()) : null});
                }
            }
            if (ev != null) {
                for (TableModelEvent te : ev) {
                    WrapTM.this.fireTableModelEvent(te);
                }
            }
        }
    };

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(WrapTM.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected PropertyChangeSupport propertySupport() {
        if (this.propertyChangeSupport != null) {
            return this.propertyChangeSupport;
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertySupport().firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.evSupport.removeTableModelListener(l);
    }

    public Collection<TableModelListener> getListenersCollection() {
        return this.evSupport.getListenersCollection();
    }

    public TableModelListener[] getListeners() {
        return this.evSupport.getListeners();
    }

    public void fireTableModelEvent(TableModelEvent e) {
        if (e != null) {
            WrapTM.logFinest("fireTableModelEvent column={0} type={1} first={2} last={3} src={4}", e.getColumn(), e.getType(), e.getFirstRow(), e.getLastRow(), e.getSource());
        }
        this.evSupport.fireTableModelEvent(e);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        WrapTM.logFiner("fireRowsUpdated from={0} to={1}", rowIndexFrom, toIndexInclude);
        this.evSupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        WrapTM.logFiner("fireRowsInserted from={0} to={1}", rowIndexFrom, toIndexInclude);
        this.evSupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        WrapTM.logFiner("fireRowsDeleted from={0} to={1}", rowIndexFrom, toIndexInclude);
        this.evSupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowUpdated(int row) {
        WrapTM.logFiner("fireRowUpdated {0}", row);
        this.evSupport.fireRowUpdated(row);
    }

    public void fireColumnsChanged() {
        WrapTM.logFiner("fireColumnsChanged", new Object[0]);
        this.evSupport.fireColumnsChanged();
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        WrapTM.logFiner("fireCellChanged row={0} col={1}", rowIndex, columnIndex);
        this.evSupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireAllChanged() {
        WrapTM.logFiner("fireAllChanged", new Object[0]);
        this.evSupport.fireAllChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.evSupport.addTableModelListener(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        int c = this.mapColumnToInside(columnIndex);
        if (c < 0) {
            return null;
        }
        return this.tableModel.getColumnClass(c);
    }

    @Override
    public int getColumnCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.tableModel == null) {
            return "?";
        }
        int c = this.mapColumnToInside(columnIndex);
        if (c < 0) {
            return "?";
        }
        return this.tableModel.getColumnName(c);
    }

    @Override
    public int getRowCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        int c = this.mapColumnToInside(columnIndex);
        if (c < 0) {
            return null;
        }
        int r = this.mapRowToInside(rowIndex);
        if (r < 0) {
            return null;
        }
        return this.tableModel.getValueAt(r, c);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.tableModel == null) {
            return false;
        }
        int c = this.mapColumnToInside(columnIndex);
        if (c < 0) {
            return false;
        }
        int r = this.mapRowToInside(rowIndex);
        if (r < 0) {
            return false;
        }
        return this.tableModel.isCellEditable(r, c);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.tableModel == null) {
            return;
        }
        int c = this.mapColumnToInside(columnIndex);
        if (c < 0) {
            return;
        }
        int r = this.mapRowToInside(rowIndex);
        if (r < 0) {
            return;
        }
        this.tableModel.setValueAt(aValue, r, c);
    }

    public int mapColumnToInside(int columnIndex) {
        return columnIndex;
    }

    public int mapRowToInside(int rowIndex) {
        return rowIndex;
    }

    public int mapColumnToOutside(int columnIndex) {
        return columnIndex;
    }

    public int mapRowToOutside(int rowIndex) {
        return rowIndex;
    }

    public boolean isSourceListen() {
        return this.tableModelListenerStarted;
    }

    public void setSourceListen(boolean listen) {
        boolean old = this.tableModelListenerStarted;
        if (listen != this.tableModelListenerStarted) {
            if (listen) {
                this.attachTMListener();
            } else {
                this.detachTMListener();
            }
            boolean now = this.tableModelListenerStarted;
            if (now != old) {
                this.firePropertyChange("sourceListen", old, now);
            }
        }
    }

    protected void detachTMListener() {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
            this.tableModelListenerStarted = false;
        }
    }

    protected void attachTMListener() {
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
            this.tableModelListenerStarted = true;
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.detachTMListener();
        TableModel old = this.tableModel;
        this.tableModel = tableModel;
        this.attachTMListener();
        this.firePropertyChange("tableModel", old, tableModel);
    }

    protected List<TableModelEvent> deletageTMEvent(TableModelEvent e) {
        WrapTM.logFine("deletageTMEvent(e)", new Object[0]);
        ArrayList<TableModelEvent> res = new ArrayList<TableModelEvent>();
        if (e == null) {
            return res;
        }
        int srcFirstRow = e.getFirstRow();
        int srcLastRow = e.getLastRow();
        int etype = e.getType();
        int srcColumn = e.getColumn();
        int outFirstRow = -1;
        int outLastRow = -1;
        int outType = -1;
        int outColumn = -1;
        if (srcFirstRow == 0 && srcLastRow == Integer.MAX_VALUE) {
            res.add(new TableModelEvent(this, -1));
            return res;
        }
        if (srcFirstRow < 0) {
            res.add(new TableModelEvent(this, -1));
            return res;
        }
        if (srcFirstRow >= 0 && srcLastRow >= srcFirstRow) {
            if (srcColumn >= 0 && (outColumn = this.mapColumnToOutside(srcColumn)) < 0) {
                return null;
            }
            TreeSet<Integer> modifiedRows = new TreeSet<Integer>();
            for (int irow = srcFirstRow; irow <= srcLastRow; ++irow) {
                int orow = this.mapRowToOutside(irow);
                if (orow < 0) continue;
                modifiedRows.add(orow);
            }
            if (modifiedRows.size() > 0) {
                ArrayList<BasicPair> beginEnd = new ArrayList<BasicPair>();
                int begin = -1;
                int end = -1;
                int nxt = -1;
                Iterator iterator = modifiedRows.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (begin < 0) {
                        begin = n;
                        end = n;
                        nxt = n + 1;
                        continue;
                    }
                    if (nxt == n) {
                        nxt = n + 1;
                        end = n;
                        continue;
                    }
                    beginEnd.add(new BasicPair((Object)begin, (Object)end));
                    begin = n;
                    end = n;
                    nxt = n + 1;
                }
                if (begin > 0 && end >= begin) {
                    beginEnd.add(new BasicPair((Object)begin, (Object)end));
                }
                if (etype == 0) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(new TableModelEvent(this, begin, end, -1, 0));
                    }
                    return res;
                }
                if (etype == 1) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(new TableModelEvent(this, begin, end, -1, 1));
                    }
                    return res;
                }
                if (etype == -1) {
                    for (Pair pair : beginEnd) {
                        begin = (Integer)pair.A();
                        end = (Integer)pair.B();
                        res.add(0, new TableModelEvent(this, begin, end, -1, -1));
                    }
                    return res;
                }
            }
        }
        res.clear();
        res.add(new TableModelEvent(this, -1));
        return res;
    }

    protected List<TableModelEvent> onRowInserted(TableModelEvent e, int firstRow, int lastRow) {
        return this.deletageTMEvent(e);
    }

    protected List<TableModelEvent> onRowUpdated(TableModelEvent e, int firstRow, int lastRow) {
        return this.deletageTMEvent(e);
    }

    protected List<TableModelEvent> onRowDeleted(TableModelEvent e, int firstRow, int lastRow) {
        return this.deletageTMEvent(e);
    }

    protected List<TableModelEvent> onTableChanged(TableModelEvent e) {
        return this.deletageTMEvent(e);
    }
}

