/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table.de;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.SwingPropertyChangeSupport;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.gui.swing.table.de.FixedColumn;

public class CSVDesc {
    protected final PropertyChangeSupport psupp = new SwingPropertyChangeSupport(this);
    protected String cellDelimiter = ",";
    protected String cellQuote = "\"";
    protected boolean skipEmptyLines = true;
    protected boolean skipFirstWS = false;
    protected QuoteVariants quoteVariants = QuoteVariants.Sometimes;
    protected int skipLines = 0;
    protected boolean firstLineAsName = true;
    protected boolean fixedWidth = false;
    protected List<FixedColumn> columns = new IndexEventList();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.SEVERE, null, ex);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.psupp.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.psupp.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.psupp.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupp.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupp.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.psupp.getPropertyChangeListeners(propertyName);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.psupp.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.psupp.firePropertyChange(event);
    }

    public CSVDesc() {
    }

    public CSVDesc(CSVDesc src) {
        if (src != null) {
            this.cellDelimiter = src.cellDelimiter;
            this.cellQuote = src.cellQuote;
            this.skipEmptyLines = src.skipEmptyLines;
            this.skipFirstWS = src.skipFirstWS;
            this.quoteVariants = src.quoteVariants;
            this.skipLines = src.skipLines;
            this.firstLineAsName = src.firstLineAsName;
            this.fixedWidth = src.fixedWidth;
            if (src.columns != null) {
                if (this.columns != null) {
                    this.columns.clear();
                } else {
                    this.columns = new ArrayList<FixedColumn>();
                }
                for (FixedColumn fc : src.columns) {
                    if (fc != null) {
                        this.columns.add(fc.clone());
                        continue;
                    }
                    this.columns.add(null);
                }
            }
        }
    }

    public CSVDesc clone() {
        return new CSVDesc(this);
    }

    public String getCellDelimiter() {
        if (this.cellDelimiter == null) {
            this.cellDelimiter = ",";
        }
        return this.cellDelimiter;
    }

    public void setCellDelimiter(String cellDelimiter) {
        String old = this.getCellDelimiter();
        this.cellDelimiter = cellDelimiter;
        this.firePropertyChange("cellDelimiter", old, this.getCellDelimiter());
    }

    public String getCellQuote() {
        if (this.cellQuote == null) {
            this.cellQuote = "\"";
        }
        return this.cellQuote;
    }

    public void setCellQuote(String cellQuote) {
        String old = this.getCellQuote();
        this.cellQuote = cellQuote;
        this.firePropertyChange("cellQuote", old, this.getCellQuote());
    }

    public boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public void setSkipEmptyLines(boolean skipEmptyLines) {
        Boolean old = this.isSkipEmptyLines();
        this.skipEmptyLines = skipEmptyLines;
        this.firePropertyChange("skipEmptyLines", old, this.isSkipEmptyLines());
    }

    public boolean isSkipFirstWS() {
        return this.skipFirstWS;
    }

    public void setSkipFirstWS(boolean skipFirstWS) {
        Boolean old = this.isSkipFirstWS();
        this.skipFirstWS = skipFirstWS;
        this.firePropertyChange("skipFirstWS", old, this.isSkipFirstWS());
    }

    public QuoteVariants getQuoteVariants() {
        if (this.quoteVariants == null) {
            this.quoteVariants = QuoteVariants.Sometimes;
        }
        return this.quoteVariants;
    }

    public void setQuoteVariants(QuoteVariants quoteVariants) {
        QuoteVariants old = this.getQuoteVariants();
        this.quoteVariants = quoteVariants;
        this.firePropertyChange("quoteVariants", (Object)old, (Object)this.getQuoteVariants());
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int skipLines) {
        Integer old = this.getSkipLines();
        this.skipLines = skipLines;
        this.firePropertyChange("skipLines", old, this.getSkipLines());
    }

    public boolean isFirstLineAsName() {
        return this.firstLineAsName;
    }

    public void setFirstLineAsName(boolean firstLineAsName) {
        Boolean old = this.isFirstLineAsName();
        this.firstLineAsName = firstLineAsName;
        this.firePropertyChange("firstLineAsName", old, this.isFirstLineAsName());
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(boolean fixedWidth) {
        Boolean old = this.isFixedWidth();
        this.fixedWidth = fixedWidth;
        this.firePropertyChange("fixedWidth", old, this.isFixedWidth());
    }

    public List<FixedColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new IndexEventList();
        }
        return this.columns;
    }

    public void setColumns(List<FixedColumn> columns) {
        this.columns = columns;
    }

    public static enum QuoteVariants {
        Always,
        Sometimes,
        Never;

    }
}

