/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table.de;

import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.graph.Edge;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.common.LazyValue;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.PropertyColumn;
import xyz.cofe.gui.swing.table.PropertyTable;
import xyz.cofe.gui.swing.table.de.CSVDesc;
import xyz.cofe.gui.swing.table.de.CSVUtil;
import xyz.cofe.gui.swing.table.de.PropertyTableExchanger;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.text.Output;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.SequenceCaster;
import xyz.cofe.typeconv.TypeCastGraph;

public class CSVExchanger
implements PropertyTableExchanger {
    private static final Logger logger = Logger.getLogger(CSVExchanger.class.getName());
    protected CSVDesc csvFormat;
    protected Map<String, Integer> columnMaping;
    protected TypeCastGraph typeCast;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = CSVExchanger.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(CSVExchanger.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CSVExchanger.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public CSVDesc getCsvFormat() {
        if (this.csvFormat != null) {
            return this.csvFormat;
        }
        this.csvFormat = new CSVDesc();
        this.csvFormat.setQuoteVariants(CSVDesc.QuoteVariants.Sometimes);
        this.csvFormat.setCellDelimiter(",");
        this.csvFormat.setCellQuote("\"");
        this.csvFormat.setFixedWidth(false);
        return this.csvFormat;
    }

    public void setCsvFormat(CSVDesc desc) {
        this.csvFormat = desc;
    }

    public Map<String, Integer> getColumnMaping() {
        if (this.columnMaping == null) {
            this.columnMaping = new LinkedHashMap<String, Integer>();
        }
        return this.columnMaping;
    }

    public void setColumnMaping(Map<String, Integer> columnMaping) {
        this.columnMaping = columnMaping;
    }

    public TypeCastGraph getTypeCast() {
        if (this.typeCast != null) {
            return this.typeCast;
        }
        this.typeCast = new ExtendedCastGraph();
        this.initNumCast(this.typeCast);
        this.initBoolCast(this.typeCast);
        return this.typeCast;
    }

    private void initBoolCast(TypeCastGraph tc) {
        SequenceCaster sc;
        final ArrayList<SequenceCaster> casters = new ArrayList<SequenceCaster>();
        for (Path p : tc.getCastPaths(String.class, Boolean.class)) {
            sc = new SequenceCaster(p);
            casters.add(sc);
        }
        Convertor<Object, Object> cnv = new Convertor<Object, Object>(){

            public Object convert(Object str) {
                if (str instanceof String) {
                    String s = (String)str;
                    if (s.equalsIgnoreCase("")) {
                        return null;
                    }
                    Boolean[] res = new Boolean[]{};
                    AtomicBoolean succConv = new AtomicBoolean(false);
                    for (SequenceCaster cst : casters) {
                        if (succConv.get()) continue;
                        try {
                            Object v = cst.convert(str);
                            if (v instanceof Boolean) {
                                res[0] = (Boolean)v;
                            }
                            succConv.set(true);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (!succConv.get()) {
                        throw new IllegalStateException("can't convert from " + str + " to bool");
                    }
                    return res[0];
                }
                throw new IllegalArgumentException("can't cast from " + str + " to bool");
            }
        };
        ArrayList<1> convs = new ArrayList<1>();
        convs.add(cnv);
        sc = new SequenceCaster(convs);
        sc.setWeight(Double.valueOf(0.8));
        tc.set(String.class, Boolean.class, (Object)sc);
    }

    private void initNumCast(TypeCastGraph tc) {
        List lp1 = tc.getCastPaths(String.class, BigDecimal.class);
        for (Path p : lp1) {
            for (Edge e : p.fetch(0, p.nodeCount())) {
                CSVExchanger.logFiner("initNumCast {0}", e.getEdge());
            }
        }
        List lp2 = tc.getCastPaths(BigDecimal.class, Integer.TYPE);
        for (Path p : lp2) {
            for (Edge e : p.fetch(0, p.nodeCount())) {
                CSVExchanger.logFiner("initNumCast {0}", e.getEdge());
            }
        }
        for (Path p1 : lp1) {
            for (Path p2 : lp2) {
                LinkedList<Object> path = new LinkedList<Object>();
                for (Edge e1 : p1.fetch(0, p1.nodeCount())) {
                    path.add(e1.getEdge());
                }
                for (Edge e2 : p2.fetch(0, p2.nodeCount())) {
                    path.add(e2.getEdge());
                }
                SequenceCaster sc = new SequenceCaster(path);
                sc.setWeight(Double.valueOf(0.8));
                tc.set(String.class, Integer.TYPE, (Object)sc);
            }
        }
    }

    public void setTypeCast(TypeCastGraph typeCast) {
        this.typeCast = typeCast;
    }

    @Override
    public void exportTable(Writer wr, Iterable objs, PropertyTable pt) {
        Output out;
        if (wr == null) {
            throw new IllegalArgumentException("wr==null");
        }
        if (objs == null) {
            throw new IllegalArgumentException("objs==null");
        }
        if (pt == null) {
            throw new IllegalArgumentException("pt==null");
        }
        CSVDesc csv = this.getCsvFormat().clone();
        Columns columns = pt.getColumns().clone();
        TypeCastGraph tc = this.getTypeCast().clone();
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>(this.getColumnMaping());
        Output output = out = wr instanceof Output ? (Output)wr : new Output(wr);
        if (csv.isFirstLineAsName()) {
            this.exportHeader(out, columns, csv, tc, colMap);
        }
        for (Object obj : objs) {
            if (Thread.interrupted()) break;
            if (obj == null) continue;
            this.exportObject(out, obj, columns, csv, tc, colMap);
        }
        out.flush();
    }

    private TreeMap<Integer, Column> rmapCols(Columns cols, Map<String, Integer> colMap) {
        TreeMap<Integer, Column> cm = new TreeMap<Integer, Column>();
        LinkedHashSet<Column> unmapped = new LinkedHashSet<Column>();
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            String colName;
            Column col = (Column)iterator.next();
            if (col == null || (colName = col.getName()) == null) continue;
            Integer coli = colMap.get(colName);
            if (coli != null) {
                if (coli < 0) continue;
                cm.put(coli, col);
                continue;
            }
            unmapped.add(col);
        }
        for (Column c : unmapped) {
            if (cm.isEmpty()) {
                cm.put(0, c);
                continue;
            }
            Integer k = cm.lastKey() + 1;
            cm.put(k, c);
        }
        return cm;
    }

    private void exportHeader(Output out, Columns cols, CSVDesc csv, TypeCastGraph tc, Map<String, Integer> colMap) {
        LinkedList<String> cells = new LinkedList<String>();
        TreeMap<Integer, Column> rmapcol = this.rmapCols(cols, colMap);
        if (rmapcol.isEmpty()) {
            return;
        }
        Integer lk = rmapcol.lastKey();
        if (lk == null && lk < 0) {
            return;
        }
        for (int ci = 0; ci < lk; ++ci) {
            Column col = rmapcol.get(ci);
            if (col != null) {
                cells.add(col.getName());
                continue;
            }
            cells.add("");
        }
        CSVUtil utl = new CSVUtil();
        out.println(utl.toString(cells.toArray(new String[0]), csv));
    }

    private void exportObject(Output out, Object ob, Columns cols, CSVDesc csv, TypeCastGraph tc, Map<String, Integer> colMap) {
        LinkedList<String> cells = new LinkedList<String>();
        TreeMap<Integer, Column> rmapcol = this.rmapCols(cols, colMap);
        if (rmapcol.isEmpty()) {
            return;
        }
        Integer lk = rmapcol.lastKey();
        if (lk == null && lk < 0) {
            return;
        }
        for (int ci = 0; ci < lk; ++ci) {
            Column col = rmapcol.get(ci);
            if (col != null) {
                String txt = this.getTextOfCell(ob, col, tc, new Reciver<Throwable>(){

                    public void recive(Throwable err) {
                        logger.log(Level.SEVERE, "can't export cell data", err);
                    }
                });
                cells.add(txt == null ? "" : txt);
                continue;
            }
            cells.add("");
        }
        CSVUtil utl = new CSVUtil();
        out.println(utl.toString(cells.toArray(new String[0]), csv));
    }

    private String getTextOfCell(Object ob, Column col, TypeCastGraph tc, Reciver<Throwable> errReciver) {
        Convertor<Object, Object> conv = col.getReader();
        if (conv == null) {
            return null;
        }
        try {
            Object val = conv.convert(ob);
            if (val == null) {
                return "";
            }
            if (val instanceof PropertyValue) {
                val = ((PropertyValue)val).getValue();
            } else if (val instanceof LazyValue) {
                val = ((LazyValue)val).evaluate();
            } else if (val instanceof TreeTableNode) {
                val = ((TreeTableNode)val).getData();
            }
            if (val == null) {
                return "";
            }
            String txt = (String)tc.cast(val, String.class);
            if (txt == null) {
                return "";
            }
            return txt;
        }
        catch (Throwable err) {
            if (errReciver != null) {
                errReciver.recive((Object)err);
            } else {
                logger.log(Level.SEVERE, "can't export cell data", err);
            }
            return null;
        }
    }

    @Override
    public Iterable importTable(Reader reader, PropertyTable pt) {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (pt == null) {
            throw new IllegalArgumentException("pt==null");
        }
        CSVDesc csv = this.getCsvFormat().clone();
        Columns columns = pt.getColumns().clone();
        final TypeCastGraph tc = this.getTypeCast().clone();
        LinkedHashMap<String, Integer> colMap = new LinkedHashMap<String, Integer>(this.getColumnMaping());
        TreeMap<Integer, Column> rmapcol = this.rmapCols(columns, colMap);
        final Func0<Object> defItmBuilder = pt.getDefaultItemBuilder();
        final Scanner scn = new Scanner(reader);
        final Iterator<String> strLineIterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return scn.hasNextLine();
            }

            @Override
            public String next() {
                String line = scn.nextLine();
                if (line == null) {
                    return null;
                }
                if (line.contains("\r\n")) {
                    line = line.replace("\r\n", "");
                }
                if (line.contains("\n\r")) {
                    line = line.replace("\n\r", "");
                }
                if (line.contains("\n")) {
                    line = line.replace("\n", "");
                }
                if (line.contains("\r")) {
                    line = line.replace("\r", "");
                }
                return line;
            }

            @Override
            public void remove() {
            }
        };
        Iterable<String> strIterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return strLineIterator;
            }
        };
        Iterable emptyLineSkip = Iterators.predicate((Iterable)strIterable, (Predicate)new Predicate<String>(){

            public boolean validate(String str) {
                return str != null && str.trim().length() > 0;
            }
        });
        Func1<Object, Map<Column, String>> itemBuilder = new Func1<Object, Map<Column, String>>(){

            public Object apply(Map<Column, String> map) {
                if (defItmBuilder == null) {
                    return null;
                }
                Object obj = defItmBuilder.apply();
                if (obj == null) {
                    return null;
                }
                if (map != null) {
                    for (Map.Entry<Column, String> enMap : map.entrySet()) {
                        Class<?> pcls;
                        Property prop;
                        PropertyColumn pc;
                        PropertyValue pv;
                        Column col = enMap.getKey();
                        String str = enMap.getValue();
                        if (!(col instanceof PropertyColumn) || (pv = (pc = (PropertyColumn)col).read(obj)) == null || (prop = pv.getProperty()) == null || prop.isReadOnly() || pc.getForceReadOnly() != null && pc.getForceReadOnly().booleanValue() || (pcls = prop.getPropertyType()) == null) continue;
                        Object casted = null;
                        if (casted == null) {
                            try {
                                casted = tc.cast((Object)str, pcls);
                            }
                            catch (Throwable err) {
                                logger.log(Level.SEVERE, "can't cast str to " + pcls, err);
                                continue;
                            }
                        }
                        pv.setValue(casted);
                        try {
                            pc.write(obj, pv);
                        }
                        catch (Throwable err) {
                            logger.log(Level.SEVERE, "can't set property " + pv.getProperty().getName(), err);
                        }
                    }
                }
                return obj;
            }
        };
        Convertor<String, Object> strConv = this.lineToObject(csv, rmapcol, itemBuilder);
        Iterable convIter = Iterators.convert((Iterable)emptyLineSkip, strConv);
        Iterable skipNullObjects = Iterators.notNullFilter((Iterable)convIter);
        return skipNullObjects;
    }

    private Convertor<String, Object> lineToObject(final CSVDesc csv, final TreeMap<Integer, Column> rmapcol, final Func1<Object, Map<Column, String>> itemBuilder) {
        final CSVUtil utl = new CSVUtil();
        return new Convertor<String, Object>(){

            public Object convert(String csvLine) {
                if (csvLine == null) {
                    return null;
                }
                LinkedHashMap<Column, String> m = new LinkedHashMap<Column, String>();
                String[] cells = utl.parseLine(csvLine, csv);
                for (Map.Entry en : rmapcol.entrySet()) {
                    Integer celli = (Integer)en.getKey();
                    Column col = (Column)en.getValue();
                    if (celli < 0 || celli >= cells.length || col == null) continue;
                    m.put(col, cells[celli]);
                }
                if (itemBuilder != null) {
                    Object itm = itemBuilder.apply(m);
                    return itm;
                }
                return null;
            }
        };
    }
}

