/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.table.impl;

import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Predicate;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.table.WrapTM;
import xyz.cofe.gui.swing.table.impl.GetRowToSourceMap;
import xyz.cofe.gui.swing.table.impl.GetSourceToRowMap;
import xyz.cofe.text.Output;

public class FilterRowTMUnOrdererMaps
extends WrapTM
implements GetRowToSourceMap,
GetSourceToRowMap {
    private static final Logger logger = Logger.getLogger(FilterRowTMUnOrdererMaps.class.getName());
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    protected Predicate<RowData> rowFilter = null;
    private RowData rowData = new RowData();
    private static volatile Integer validateIndexOnInsertEach;
    private static volatile Integer validateIndexOnUpdateEach;
    private static volatile Integer validateIndexOnDeleteEach;
    private TreeMap<Integer, Integer> row2srcMap = null;
    private TreeMap<Integer, Integer> src2rowMap = null;
    private int onRowInsertedCallCount = 0;
    private int onRowUpdatedCallCount = 0;
    private int onRowDeletedCallCount = 0;

    private static final boolean isLogFinest() {
        return logger.getLevel() == null ? false : logger.getLevel().intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FilterRowTMUnOrdererMaps.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FilterRowTMUnOrdererMaps.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FilterRowTMUnOrdererMaps.class.getName(), method, result);
    }

    public void setRowFilter(Predicate<RowData> filter) {
        Predicate<RowData> old = this.rowFilter;
        this.rowFilter = filter;
        this.applyFilter();
        this.firePropertyChange("rowFilter", old, this.rowFilter);
    }

    public Predicate<RowData> getRowFilter() {
        return this.rowFilter;
    }

    public static int getValidateIndexOnInsertEach() {
        if (validateIndexOnInsertEach == null) {
            String val = System.getProperties().getProperty("xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onInsertEach", "100");
            validateIndexOnInsertEach = val == null || !val.matches("-?\\d+") ? Integer.valueOf(100) : Integer.valueOf(Integer.parseInt(val));
        }
        return validateIndexOnInsertEach;
    }

    public static void setValidateIndexOnInsertEach(int validateIndexOnInsertEach) {
        FilterRowTMUnOrdererMaps.validateIndexOnInsertEach = validateIndexOnInsertEach;
    }

    public static int getValidateIndexOnUpdateEach() {
        if (validateIndexOnUpdateEach == null) {
            String val = System.getProperties().getProperty("xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onUpdateEach", "100");
            validateIndexOnUpdateEach = val == null || !val.matches("-?\\d+") ? Integer.valueOf(100) : Integer.valueOf(Integer.parseInt(val));
        }
        return validateIndexOnUpdateEach;
    }

    public static void setValidateIndexOnUpdateEach(int validateIndexOnUpdateEach) {
        FilterRowTMUnOrdererMaps.validateIndexOnUpdateEach = validateIndexOnUpdateEach;
    }

    public static int getValidateIndexOnDeleteEach() {
        if (validateIndexOnDeleteEach == null) {
            String val = System.getProperties().getProperty("xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onDeleteEach", "100");
            validateIndexOnDeleteEach = val == null || !val.matches("-?\\d+") ? Integer.valueOf(100) : Integer.valueOf(Integer.parseInt(val));
        }
        return validateIndexOnDeleteEach;
    }

    public static void setValidateIndexOnDeleteEach(int validateIndexOnDeleteEach) {
        FilterRowTMUnOrdererMaps.validateIndexOnDeleteEach = validateIndexOnDeleteEach;
    }

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public synchronized TreeMap<Integer, Integer> getRowToSourceMap() {
        if (this.row2srcMap == null) {
            return new TreeMap<Integer, Integer>();
        }
        return new TreeMap<Integer, Integer>((SortedMap<Integer, Integer>)this.row2srcMap);
    }

    @Override
    public synchronized TreeMap<Integer, Integer> getSourceToRowMap() {
        if (this.src2rowMap == null) {
            return new TreeMap<Integer, Integer>();
        }
        return new TreeMap<Integer, Integer>((SortedMap<Integer, Integer>)this.src2rowMap);
    }

    @Override
    public synchronized int getRowCount() {
        if (this.row2srcMap == null) {
            return super.getRowCount();
        }
        return this.row2srcMap.size();
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount();
    }

    @Override
    public int mapColumnToInside(int columnIndex) {
        return super.mapColumnToInside(columnIndex);
    }

    @Override
    public synchronized int mapRowToInside(int rowIndex) {
        if (this.row2srcMap != null) {
            if (this.row2srcMap.containsKey(rowIndex)) {
                return this.row2srcMap.get(rowIndex);
            }
            return -1;
        }
        return super.mapRowToInside(rowIndex);
    }

    @Override
    public synchronized int mapRowToOutside(int rowIndex) {
        if (this.src2rowMap == null) {
            return rowIndex;
        }
        if (!this.src2rowMap.containsKey(rowIndex)) {
            return -1;
        }
        return this.src2rowMap.get(rowIndex);
    }

    public void applyFilter() {
        this.applyFilter(true);
    }

    public synchronized void applyFilter(boolean fireAllChanged) {
        FilterRowTMUnOrdererMaps.logFine("applyFilter({0}), filter setted={1}", fireAllChanged, this.rowFilter != null);
        if (this.row2srcMap != null) {
            this.row2srcMap.clear();
        }
        this.row2srcMap = null;
        if (this.src2rowMap != null) {
            this.src2rowMap.clear();
        }
        this.src2rowMap = null;
        if (this.rowFilter != null && this.tableModel != null) {
            this.row2srcMap = new TreeMap();
            this.src2rowMap = new TreeMap();
            this.rowData.setTableModel(this.tableModel);
            int destRi = 0;
            for (int srcRi = 0; srcRi < this.tableModel.getRowCount(); ++srcRi) {
                this.rowData.setRowIndex(srcRi);
                if (!this.rowFilter.validate((Object)this.rowData)) continue;
                this.row2srcMap.put(destRi, srcRi);
                this.src2rowMap.put(srcRi, destRi);
                ++destRi;
            }
        }
        if (fireAllChanged) {
            this.fireAllChanged();
        }
    }

    @Override
    public synchronized void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        this.rowData.setTableModel(tableModel);
        this.applyFilter();
    }

    protected synchronized void shiftOnInsertIndexes(int from, int toInc) {
        FilterRowTMUnOrdererMaps.logFine("shiftOnInsertIndexes({0},{1})", from, toInc);
        if (this.row2srcMap == null) {
            return;
        }
        int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            Integer si = me.getValue();
            if (si < from) continue;
            me.setValue(si + icnt);
        }
        if (this.src2rowMap == null) {
            this.src2rowMap = new TreeMap();
        }
        this.src2rowMap.clear();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            this.src2rowMap.put(me.getValue(), me.getKey());
        }
    }

    protected synchronized void shiftOnDeleteIndexes(int from, int toInc, Reciver<Integer> deletedOutterIndexes) {
        FilterRowTMUnOrdererMaps.logFine("shiftOnDeleteIndexes({0},{1})", from, toInc);
        if (this.row2srcMap == null) {
            return;
        }
        int icnt = toInc - from + 1;
        if (icnt <= 0) {
            return;
        }
        LinkedHashSet<Integer> removedDI = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            Integer di = me.getKey();
            Integer si = me.getValue();
            if (si < from) continue;
            if (si <= toInc) {
                removedDI.add(di);
                continue;
            }
            Integer si2 = si - icnt;
            me.setValue(si2);
        }
        for (Integer di : removedDI) {
            this.row2srcMap.remove(di);
            if (deletedOutterIndexes == null) continue;
            deletedOutterIndexes.recive((Object)di);
        }
        AtomicInteger ni = new AtomicInteger(0);
        TreeMap<Integer, Integer> nrow2srcMap = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> en : this.row2srcMap.entrySet()) {
            Integer di = en.getKey();
            Integer si = en.getValue();
            nrow2srcMap.put(ni.get(), si);
            ni.incrementAndGet();
        }
        this.row2srcMap = nrow2srcMap;
        if (this.src2rowMap == null) {
            this.src2rowMap = new TreeMap();
        }
        this.src2rowMap.clear();
        for (Map.Entry<Integer, Integer> me : this.row2srcMap.entrySet()) {
            this.src2rowMap.put(me.getValue(), me.getKey());
        }
    }

    protected synchronized void checkDestIndexesFast() {
        if (this.row2srcMap == null) {
            return;
        }
        int size = this.row2srcMap.size();
        if (size < 1) {
            return;
        }
        int fk = this.row2srcMap.firstKey();
        if (fk != 0) {
            throw new Error("checkDestIndexesFast fail, fk=" + fk);
        }
        int lk = this.row2srcMap.lastKey();
        if (lk != size - 1) {
            throw new Error("checkDestIndexesFast fail, lk=" + lk + " size=" + size);
        }
    }

    /*
     * Exception decompiling
     */
    protected synchronized boolean isIndexesValid() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[WHILELOOP]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected synchronized List<TableModelEvent> onRowInserted(TableModelEvent e, int firstRow, int lastRow) {
        int neach;
        FilterRowTMUnOrdererMaps.logFine("onRowInserted({0},{1})", firstRow, lastRow);
        ++this.onRowInsertedCallCount;
        if (this.tableModel == null) {
            return this.deletageTMEvent(e);
        }
        if (lastRow < firstRow) {
            return this.deletageTMEvent(e);
        }
        this.shiftOnInsertIndexes(firstRow, lastRow);
        if (this.row2srcMap == null) {
            return this.deletageTMEvent(e);
        }
        LinkedHashSet<Integer> inserted = new LinkedHashSet<Integer>();
        int icnt = firstRow - lastRow + 1;
        if (icnt > 0) {
            for (int si = firstRow; si <= lastRow; ++si) {
                try {
                    this.rowData.setRowIndex(si);
                    if (this.rowFilter != null && !this.rowFilter.validate((Object)this.rowData)) continue;
                    int lkey = this.row2srcMap.lastKey();
                    int nkey = lkey + 1;
                    this.row2srcMap.put(nkey, si);
                    this.src2rowMap.put(si, nkey);
                    inserted.add(nkey);
                    FilterRowTMUnOrdererMaps.logFiner("onRowInserted({0},{1}) - add d({2})->s({3})", firstRow, lastRow, nkey, si);
                    continue;
                }
                catch (NoSuchElementException ex) {
                    this.applyFilter(true);
                    return null;
                }
            }
        }
        if ((neach = FilterRowTMUnOrdererMaps.getValidateIndexOnInsertEach()) > 0) {
            if (neach == 1) {
                if (!this.isIndexesValid()) {
                    this.applyFilter(true);
                    return null;
                }
            } else if (this.onRowInsertedCallCount % neach == 0 && !this.isIndexesValid()) {
                this.applyFilter(true);
                return null;
            }
        }
        for (Integer idx : inserted) {
            this.fireRowsInserted(idx, idx);
        }
        return null;
    }

    public synchronized void dump() {
        Output out = new Output((OutputStream)System.out);
        this.dump(out);
    }

    public synchronized void dump(Output xout) {
        if (xout == null) {
            xout = new Output((OutputStream)System.out);
        }
        Output out = xout;
        out.setLinePrefix("dump|");
        if (this.row2srcMap != null && this.src2rowMap != null) {
            out.template("row2srcMap(${rsc}) src2rowMap(${src})").bind("rsc", (Object)this.row2srcMap.size()).bind("src", (Object)this.src2rowMap.size()).println();
            for (Map.Entry<Integer, Integer> enR2S : this.row2srcMap.entrySet()) {
                Integer di1 = enR2S.getKey();
                Integer si1 = enR2S.getValue();
                Integer si2 = this.src2rowMap.containsKey(si1) ? si1 : null;
                Integer di2 = si2 != null ? this.src2rowMap.get(si2) : null;
                out.template("d${di1:3} -> s${si1:3} | d${di2:3} <- s${si2:3} | ${ok}").bind("di1", (Object)di1).bind("di2", (Object)di2).bind("si1", (Object)si1).bind("si2", (Object)si2).bind("ok", (Object)(si2 != null && di2 != null && si1 != null && di1 != null && Objects.equals(si1, si2) && Objects.equals(di1, di2) ? 1 : 0)).println();
            }
        } else {
            out.println("row2srcMap = " + this.row2srcMap);
            out.println("src2rowMap = " + this.src2rowMap);
        }
        out.flush();
    }

    public synchronized List<TableModelEvent> processRowUpdated(int firstRow, int lastRow) {
        LinkedList<TableModelEvent> evs = new LinkedList<TableModelEvent>();
        if (this.tableModel == null) {
            return null;
        }
        if (lastRow < firstRow) {
            return null;
        }
        this.checkDestIndexesFast();
        TreeSet<Integer> incList = new TreeSet<Integer>();
        TreeSet<Integer> decList = new TreeSet<Integer>();
        TreeSet<Integer> updList = new TreeSet<Integer>();
        if (this.rowFilter != null && this.src2rowMap != null && this.row2srcMap != null) {
            for (int srcRi = firstRow; srcRi <= lastRow; ++srcRi) {
                this.rowData.setRowIndex(srcRi);
                boolean inc = this.rowFilter.validate((Object)this.rowData);
                if (inc) {
                    if (!this.src2rowMap.containsKey(srcRi)) {
                        incList.add(srcRi);
                        continue;
                    }
                    updList.add(srcRi);
                    continue;
                }
                if (!this.src2rowMap.containsKey(srcRi)) continue;
                decList.add(srcRi);
            }
        } else {
            TableModelEvent e = new TableModelEvent(this, firstRow, lastRow, -1, 0);
            evs.add(e);
            return evs;
        }
        if (this.src2rowMap != null && this.row2srcMap != null) {
            Integer si;
            Integer di;
            for (Integer srcRi : updList) {
                Integer destRi = this.src2rowMap.get(srcRi);
                if (destRi == null) continue;
                FilterRowTMUnOrdererMaps.logFiner("processRowUpdated({0},{1}) - fire row updated {2}", firstRow, lastRow, destRi);
                TableModelEvent e = new TableModelEvent(this, destRi, destRi, -1, 0);
                evs.add(e);
            }
            for (Integer si2 : decList.descendingSet()) {
                Integer di2 = this.src2rowMap.get(si2);
                if (!this.row2srcMap.containsKey(di2)) {
                    throw new Error("row2srcMap.containsKey(" + di2 + ")=false and src2rowMap(" + si2 + ")=" + di2);
                }
                LinkedHashSet<Integer> removeDi = new LinkedHashSet<Integer>();
                for (Map.Entry<Integer, Integer> m : this.src2rowMap.entrySet()) {
                    if (!Objects.equals(m.getValue(), di2)) continue;
                    removeDi.add(di2);
                }
                this.src2rowMap.remove(si2);
                for (Integer di__2 : removeDi) {
                    this.row2srcMap.remove(di__2);
                }
                FilterRowTMUnOrdererMaps.logFinest("remove di={0} si={1}", di2, si2);
                FilterRowTMUnOrdererMaps.logFiner("processRowUpdated({0},{1}) - fire row delete {2} -> {3}", firstRow, lastRow, di2, si2);
                TableModelEvent e = new TableModelEvent(this, di2, di2, -1, -1);
                evs.add(e);
            }
            AtomicInteger ni = new AtomicInteger(0);
            TreeMap<Integer, Integer> nrow2srcMap = new TreeMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> enR2S : this.row2srcMap.entrySet()) {
                di = enR2S.getKey();
                si = enR2S.getValue();
                nrow2srcMap.put(ni.get(), si);
                ni.incrementAndGet();
            }
            this.row2srcMap = nrow2srcMap;
            this.src2rowMap.clear();
            for (Map.Entry<Integer, Integer> enR2S : this.row2srcMap.entrySet()) {
                di = enR2S.getKey();
                si = enR2S.getValue();
                this.src2rowMap.put(si, di);
            }
            for (Integer si3 : incList) {
                int lkey = this.row2srcMap.lastKey();
                int di3 = lkey + 1;
                this.row2srcMap.put(di3, si3);
                this.src2rowMap.put(si3, di3);
                FilterRowTMUnOrdererMaps.logFiner("processRowUpdated({0},{1}) - fire row inserted {2} -> {3}", firstRow, lastRow, di3, si3);
                TableModelEvent e = new TableModelEvent(this, di3, di3, -1, 1);
                evs.add(e);
            }
            return evs;
        }
        return null;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowUpdated(TableModelEvent e, int firstRow, int lastRow) {
        FilterRowTMUnOrdererMaps.logFine("onRowUpdated({0},{1})", firstRow, lastRow);
        ++this.onRowUpdatedCallCount;
        List<TableModelEvent> evs = this.processRowUpdated(firstRow, lastRow);
        if (evs == null) {
            int eachN = FilterRowTMUnOrdererMaps.getValidateIndexOnUpdateEach();
            if (!(eachN <= 0 || eachN != 1 && this.onRowUpdatedCallCount % eachN != 0 || this.isIndexesValid())) {
                this.applyFilter(true);
                return null;
            }
            return this.deletageTMEvent(e);
        }
        return evs;
    }

    @Override
    protected synchronized List<TableModelEvent> onRowDeleted(TableModelEvent e, int firstRow, int lastRow) {
        FilterRowTMUnOrdererMaps.logFine("onRowDeleted({0},{1})", firstRow, lastRow);
        ++this.onRowDeletedCallCount;
        if (this.tableModel == null) {
            return this.deletageTMEvent(e);
        }
        if (lastRow < firstRow) {
            return this.deletageTMEvent(e);
        }
        final TreeSet deleted = new TreeSet();
        this.shiftOnDeleteIndexes(firstRow, lastRow, new Reciver<Integer>(){

            public void recive(Integer idx) {
                deleted.add(idx);
            }
        });
        int eachN = FilterRowTMUnOrdererMaps.getValidateIndexOnDeleteEach();
        if (!(eachN <= 0 || eachN != 1 && this.onRowDeletedCallCount % eachN != 0 || this.isIndexesValid())) {
            this.applyFilter(true);
            return null;
        }
        for (Integer idx : deleted.descendingSet()) {
            this.fireRowsDeleted(idx, idx);
        }
        return null;
    }

    @Override
    protected List<TableModelEvent> onTableChanged(TableModelEvent e) {
        FilterRowTMUnOrdererMaps.logFine("onTableChanged({0},{1})", new Object[0]);
        this.applyFilter();
        return null;
    }

    static {
        boolean bl = logger.getLevel() == null ? true : (isLogSevere = logger.getLevel().intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logger.getLevel() == null ? true : (isLogWarning = logger.getLevel().intValue() <= Level.WARNING.intValue());
        boolean bl3 = logger.getLevel() == null ? true : (isLogInfo = logger.getLevel().intValue() <= Level.INFO.intValue());
        boolean bl4 = logger.getLevel() == null ? true : (isLogFine = logger.getLevel().intValue() <= Level.FINE.intValue());
        isLogFiner = logger.getLevel() == null ? true : logger.getLevel().intValue() <= Level.FINER.intValue();
        validateIndexOnInsertEach = null;
        validateIndexOnUpdateEach = null;
        validateIndexOnDeleteEach = null;
    }
}

