/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tabs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.Icon;
import xyz.cofe.gui.swing.tabs.TabHeader;
import xyz.cofe.gui.swing.tabs.TabPane;

public class CloseableTabHeader
extends TabHeader {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CloseableTabHeader.class.getName()).log(Level.SEVERE, null, ex);
    }

    public CloseableTabHeader(JTabbedPane tabbedPane, Component tabOwner, boolean useOwnerName) {
        super(tabbedPane, tabOwner, useOwnerName);
        this.getActions().add((Object)new CloseAction(tabbedPane, tabOwner));
    }

    public static class CloseAction
    extends BasicAction
    implements Closeable {
        private JTabbedPane tabbedPane = null;
        private Component tabOwner = null;
        private static Icon closeButtonIcon = new Icon(TabPane.class.getResource("close-14x14-norm.png"));

        public CloseAction(JTabbedPane tabbedPane, Component tabOwner) {
            if (tabOwner == null) {
                throw new IllegalArgumentException("tabOwner==null");
            }
            if (tabbedPane == null) {
                throw new IllegalArgumentException("tabbedPane==null");
            }
            this.tabbedPane = tabbedPane;
            this.tabOwner = tabOwner;
            this.setSmallIcon(closeButtonIcon);
            this.setShortDescription("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.tabOwner == null || this.tabbedPane == null) {
                return;
            }
            int idx = this.tabbedPane.indexOfComponent(this.tabOwner);
            if (idx < 0) {
                return;
            }
            this.tabbedPane.removeTabAt(idx);
        }

        @Override
        public void close() throws IOException {
            this.tabOwner = null;
            this.tabbedPane = null;
        }
    }
}

