/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tabs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.gui.swing.tabs.TabPane;

public class TabHeader
extends JPanel
implements Closeable,
TabPane.TabQuery {
    private JTabbedPane tabbedPane = null;
    private Component tabOwner = null;
    private JLabel titleLabel = null;
    private List<Action> actions = new ArrayList<Action>();
    private Map<Action, JButton> actions2buttonMap = new HashMap<Action, JButton>();
    private Map<JButton, Action> button2actionMap = new WeakHashMap<JButton, Action>();
    private String fontFamily = null;
    private float fontSize = 10.0f;
    private boolean fontItalic = false;
    private boolean fontBold = false;
    private boolean useOwnerNameAsTitle = false;
    private PropertyChangeListener ownerNameListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TabHeader.this.tabOwner != null && TabHeader.this.titleLabel != null) {
                String label = TabHeader.this.tabOwner.getName();
                if (label == null) {
                    label = "";
                }
                TabHeader.this.titleLabel.setText(label);
            }
        }
    };
    private MouseAdapter closeButtonML = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            TabHeader.this.onMouseEnteredOnButton(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TabHeader.this.onMouseExitedFromButton(e);
        }
    };
    private EventList<Action> elActions = null;
    private SimpleListAdapter<Action> actionsListener = new SimpleListAdapter<Action>(){

        protected void removed(Action e, EventList<Action> list, Integer position) {
            Action a = e;
            JButton but = TabHeader.this.destroyButton(a);
            TabHeader.this.remove(but);
        }

        protected void added(Action action, EventList<Action> list, Integer position) {
            JButton but = TabHeader.this.createButton(action);
            int co = list.size();
            int addIdx = -1;
            if (position < co - 1 && position >= 0 && position < list.size() - 1 && list.size() > 1) {
                Action aftAct = (Action)list.get(1);
                JButton aftBut = (JButton)TabHeader.this.actions2buttonMap.get(aftAct);
                if (aftBut != null) {
                    Component[] cmpts = TabHeader.this.getComponents();
                    int ci = -1;
                    for (Component c : cmpts) {
                        ++ci;
                        if (c != aftBut) continue;
                        addIdx = ci;
                        break;
                    }
                }
            }
            if (addIdx < 0) {
                TabHeader.this.add(but);
            } else {
                TabHeader.this.add((Component)but, addIdx);
            }
        }
    };
    private ListenersHelper<Listener, Event> listenersHelper = new ListenersHelper((Func2)new Func2<Object, Listener, Event>(){

        public Object apply(Listener listener, Event ev) {
            TabHeader.logFiner("listenersHelper.apply( {0}, {1} )", new Object[]{listener, ev});
            listener.tabHeaderEvent(ev);
            return null;
        }
    });

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TabHeader.class.getName()).log(Level.SEVERE, null, ex);
    }

    public boolean isUseOwnerNameAsTitle() {
        return this.useOwnerNameAsTitle;
    }

    public void setUseOwnerNameAsTitle(boolean useOwnerNameAsTitle) {
        if (this.useOwnerNameAsTitle && this.tabOwner != null) {
            this.tabOwner.removePropertyChangeListener("name", this.ownerNameListener);
        }
        this.useOwnerNameAsTitle = useOwnerNameAsTitle;
        if (useOwnerNameAsTitle && this.tabOwner != null) {
            this.tabOwner.addPropertyChangeListener("name", this.ownerNameListener);
            if (this.titleLabel != null) {
                String label = this.tabOwner.getName();
                if (label == null) {
                    label = "";
                }
                this.titleLabel.setText(label);
            }
        }
    }

    public TabHeader(JTabbedPane tabbedPane, Component tabOwner, boolean useOwnerName) {
        if (tabbedPane == null) {
            throw new IllegalArgumentException("tabbedPane==null");
        }
        if (tabOwner == null) {
            throw new IllegalArgumentException("tabComponent==null");
        }
        int index = tabbedPane.indexOfComponent(tabOwner);
        this.tabOwner = tabOwner;
        this.tabbedPane = tabbedPane;
        String titleText = null;
        this.useOwnerNameAsTitle = useOwnerName;
        if (useOwnerName) {
            titleText = tabOwner.getName();
            tabOwner.addPropertyChangeListener("name", this.ownerNameListener);
        } else {
            titleText = index >= 0 ? tabbedPane.getTitleAt(index) : this.getName();
        }
        if (titleText == null) {
            titleText = "tab title";
        }
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.titleLabel = null;
        Icon titleIco = null;
        if (index >= 0) {
            titleIco = tabbedPane.getIconAt(index);
        }
        if (titleIco != null) {
            this.titleLabel = new JLabel(titleText, titleIco, 2);
        } else {
            this.titleLabel = new JLabel(titleText);
            this.titleLabel.setHorizontalAlignment(2);
        }
        this.titleLabel.setOpaque(false);
        this.add(this.titleLabel);
        JPanel spacePanel = new JPanel();
        spacePanel.setMinimumSize(new Dimension(3, 3));
        spacePanel.setPreferredSize(new Dimension(3, 3));
        spacePanel.setOpaque(false);
        this.add(spacePanel);
        String tip = null;
        tip = index >= 0 ? tabbedPane.getToolTipTextAt(index) : this.getToolTipText();
        if (tip != null) {
            this.titleLabel.setToolTipText(tip);
        }
        for (Action a : this.actions) {
            JButton but = this.createButton(a);
            this.add(but);
        }
        Font fnt = this.titleLabel.getFont();
        this.fontFamily = fnt.getFamily();
        this.fontSize = fnt.getSize2D();
        this.fontBold = fnt.isBold();
        this.fontItalic = fnt.isItalic();
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public boolean isFontItalic() {
        return this.fontItalic;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontSize(float size) {
        if (size <= 0.0f) {
            throw new IllegalArgumentException("size<=0");
        }
        Float old = Float.valueOf(this.fontSize);
        this.fontSize = size;
        this.setTitleLabelFont();
        this.firePropertyChange("fontSize", old, Float.valueOf(size));
    }

    public void setFontFamily(String family) {
        if (family == null) {
            throw new IllegalArgumentException("family==null");
        }
        String old = this.fontFamily;
        this.fontFamily = family;
        this.setTitleLabelFont();
        this.firePropertyChange("fontFamily", old, family);
    }

    public void setFontItalic(boolean italic) {
        Boolean old = this.fontItalic;
        this.fontItalic = italic;
        this.setTitleLabelFont();
        this.firePropertyChange("fontItalic", old, (Object)this.fontItalic);
    }

    public void setFontBold(boolean bold) {
        Boolean old = this.fontBold;
        this.fontBold = bold;
        this.setTitleLabelFont();
        this.firePropertyChange("fontBold", old, (Object)this.fontBold);
    }

    protected void setTitleLabelFont() {
        int style = 0;
        if (this.fontBold || this.fontItalic) {
            if (this.fontBold) {
                style |= 1;
            }
            if (this.fontItalic) {
                style |= 2;
            }
        } else {
            style = 0;
        }
        Font fnt = new Font(this.fontFamily, style, (int)this.fontSize);
        this.titleLabel.setFont(fnt);
    }

    public EventList<Action> getActions() {
        if (this.elActions != null) {
            return this.elActions;
        }
        this.elActions = new IndexEventList(this.actions);
        this.elActions.addEventListListener(this.actionsListener);
        return this.elActions;
    }

    protected JButton createButton(Action action) {
        if (this.actions == null) {
            throw new IllegalArgumentException("actions==null");
        }
        if (this.actions2buttonMap.containsKey(action)) {
            return this.actions2buttonMap.get(action);
        }
        JButton button = null;
        button = new JButton();
        button.setAction(action);
        button.setOpaque(false);
        button.setBorderPainted(false);
        Icon ico = (Icon)action.getValue("SmallIcon");
        if (ico != null) {
            int prefAddX = 2;
            int prefAddY = 2;
            Dimension closeButtonPrefSize = new Dimension(ico.getIconWidth() + prefAddX, ico.getIconHeight() + prefAddY);
            button.setPreferredSize(closeButtonPrefSize);
        }
        button.addMouseListener(this.closeButtonML);
        button.addMouseMotionListener(this.closeButtonML);
        this.actions2buttonMap.put(action, button);
        this.button2actionMap.put(button, action);
        return button;
    }

    protected JButton destroyButton(Action action) {
        if (!this.actions2buttonMap.containsKey(action)) {
            return null;
        }
        JButton closeButton = this.actions2buttonMap.get(action);
        if (closeButton != null) {
            closeButton.removeMouseListener(this.closeButtonML);
            closeButton.removeMouseMotionListener(this.closeButtonML);
        }
        closeButton.setAction(null);
        this.actions2buttonMap.remove(action);
        if (closeButton != null) {
            this.button2actionMap.remove(closeButton);
        }
        return closeButton;
    }

    private void onMouseEnteredOnButton(MouseEvent e) {
        if (this.isClosed()) {
            return;
        }
        Object source = e.getSource();
        if (source != null && source instanceof JButton) {
            JButton src = (JButton)source;
            src.setBorderPainted(true);
        }
    }

    private void onMouseExitedFromButton(MouseEvent e) {
        if (this.isClosed()) {
            return;
        }
        Object source = e.getSource();
        if (source != null && source instanceof JButton) {
            JButton src = (JButton)source;
            src.setBorderPainted(false);
        }
    }

    public boolean hasTabHeaderListener(Listener listener) {
        return this.listenersHelper.hasListener((Object)listener);
    }

    public Set getTabHeaderListeners() {
        return this.listenersHelper.getListeners();
    }

    public Closeable addTabHeaderListener(Listener listener) {
        TabHeader.logFine("addScriptListener( {0} )", listener);
        return this.listenersHelper.addListener((Object)listener);
    }

    public Closeable addTabHeaderListener(Listener listener, boolean weakLink) {
        TabHeader.logFine("addScriptListener( {0}, {1} )", listener, weakLink);
        return this.listenersHelper.addListener((Object)listener, weakLink);
    }

    public void removeTabHeaderListener(Listener listener) {
        TabHeader.logFine("removeScriptListener( {0} )", listener);
        this.listenersHelper.removeListener((Object)listener);
    }

    protected void fireEvent(Event event) {
        TabHeader.logFine("fireEvent( {0} )", event);
        this.listenersHelper.fireEvent((Object)event);
    }

    protected boolean isClosed() {
        return this.tabbedPane == null && this.tabOwner == null;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this.fireEvent(new CloseEvent(this));
        }
        if (this.tabbedPane != null) {
            this.tabbedPane = null;
        }
        if (this.tabOwner != null) {
            if (this.useOwnerNameAsTitle) {
                this.tabOwner.removePropertyChangeListener("name", this.ownerNameListener);
            }
            this.tabOwner = null;
        }
        if (this.titleLabel != null) {
            this.titleLabel = null;
        }
        if (this.actions != null) {
            for (Action a : this.actions) {
                JButton but = this.destroyButton(a);
                if (but != null) {
                    this.remove(but);
                }
                if (!(a instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)a)).close();
                }
                catch (IOException e) {
                    Logger.getLogger(TabHeader.class.getName()).log(Level.SEVERE, null, e);
                }
            }
            this.actions.clear();
        }
    }

    @Override
    public void setTabOwner(Component component) {
        this.tabOwner = component;
    }

    public Component getTabOwner() {
        return this.tabOwner;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void setTabDisabledIcon(Icon disabledIcon) {
        if (this.isClosed()) {
            return;
        }
        this.titleLabel.setDisabledIcon(disabledIcon);
    }

    public Icon getTabDisabledIcon() {
        if (this.isClosed()) {
            return null;
        }
        return this.titleLabel.getDisabledIcon();
    }

    @Override
    public void setTabDisplayedMnemonicIndex(int mnemonicIndex) {
        if (this.isClosed()) {
            return;
        }
        this.titleLabel.setDisplayedMnemonicIndex(mnemonicIndex);
    }

    public int getTabDisplayedMnemonicIndex() {
        if (this.isClosed()) {
            return -1;
        }
        return this.titleLabel.getDisplayedMnemonicIndex();
    }

    @Override
    public void setTabIcon(Icon icon) {
        if (this.isClosed()) {
            return;
        }
        this.titleLabel.setIcon(icon);
    }

    public Icon getTabIcon() {
        if (this.isClosed()) {
            return null;
        }
        return this.titleLabel.getIcon();
    }

    @Override
    public void setTabMnemonic(int mnemonic) {
        if (this.isClosed()) {
            return;
        }
        this.titleLabel.setDisplayedMnemonic(mnemonic);
    }

    public int getTabMnemonic() {
        if (this.isClosed()) {
            return -1;
        }
        return this.titleLabel.getDisplayedMnemonic();
    }

    @Override
    public void setTabTitle(String title) {
        if (this.isClosed()) {
            return;
        }
        this.titleLabel.setText(title == null ? "" : title);
    }

    public String getTabTitle() {
        if (this.isClosed()) {
            return null;
        }
        return this.titleLabel.getText();
    }

    @Override
    public void setTabBackground(Color background) {
        this.titleLabel.setForeground(background);
    }

    public Color getTabBackground() {
        return this.titleLabel.getBackground();
    }

    @Override
    public void setTabEnabled(boolean enabled) {
        this.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            if (enabled) {
                if (c instanceof JButton) {
                    JButton but = (JButton)c;
                    Action a = but.getAction();
                    if (a != null) {
                        but.setEnabled(a.isEnabled());
                        continue;
                    }
                    c.setEnabled(enabled);
                    continue;
                }
                c.setEnabled(enabled);
                continue;
            }
            c.setEnabled(enabled);
        }
    }

    public boolean isTabEnabled() {
        return this.isEnabled();
    }

    @Override
    public void setTabForeground(Color foreground) {
        this.titleLabel.setForeground(foreground);
    }

    public Color getTabForeground() {
        return this.titleLabel.getBackground();
    }

    @Override
    public void setTabToolTipText(String toolTipText) {
        this.titleLabel.setToolTipText(toolTipText);
    }

    public String getTabToolTipText() {
        return this.titleLabel.getToolTipText();
    }

    public static class CloseEvent
    implements Event {
        private final TabHeader tabHeader;

        public CloseEvent(TabHeader tabHeader) {
            this.tabHeader = tabHeader;
        }

        public TabHeader getTabHeader() {
            return this.tabHeader;
        }
    }

    public static class Adapter
    implements Listener {
        @Override
        public void tabHeaderEvent(Event event) {
            if (event instanceof CloseEvent) {
                this.close((CloseEvent)event);
            }
        }

        protected void close(CloseEvent ev) {
        }
    }

    public static interface Event {
    }

    public static interface Listener {
        public void tabHeaderEvent(Event var1);
    }
}

