/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tabs;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Iterators;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.tabs.CloseableTabHeader;
import xyz.cofe.gui.swing.tabs.TabHeader;

public class TabPane
extends JTabbedPane {
    private ListenersHelper<Listener, Event> listenersHelper = new ListenersHelper((Func2)new Func2<Object, Listener, Event>(){

        public Object apply(Listener listner, Event ev) {
            listner.tabPaneEvent(ev);
            return null;
        }
    });
    protected boolean enableTabEvent = true;
    protected boolean exchangeTab = false;
    private int selectedTabIndex = -1;
    private boolean addTab = false;
    private Convertor<Component, Component> headerCreator = null;
    protected final Convertor<Component, Component> defaultHeader = new Convertor<Component, Component>(){

        public Component convert(Component from) {
            if (from == null) {
                throw new IllegalArgumentException("from==null");
            }
            TabPane tp = TabPane.this;
            CloseableTabHeader th = new CloseableTabHeader(tp, from, true);
            return th;
        }
    };
    private static final int LINEWIDTH = 3;
    private static final String NAME = "test";
    private final GhostGlassPane glassPane = new GhostGlassPane();
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = new Color(0, 100, 255);
    private int dragTabIndex = -1;
    private static Rectangle rBackward = new Rectangle();
    private static Rectangle rForward = new Rectangle();
    private static int rwh = 20;
    private static int buttonsize = 30;
    private boolean hasGhost = true;
    private boolean isPaintScrollArea = true;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TabPane.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TabPane.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Listener[] getTabPaneListeners() {
        return this.listenersHelper.getListeners().toArray(new Listener[0]);
    }

    public boolean hasTabPaneListener(Listener listener) {
        return this.listenersHelper.hasListener((Object)listener);
    }

    public Closeable addTabPaneListener(Listener listener) {
        return this.listenersHelper.addListener((Object)listener);
    }

    public Closeable addTabPaneListener(Listener listener, boolean weakLink) {
        return this.listenersHelper.addListener((Object)listener, weakLink);
    }

    public void removeTabPaneListener(Listener listener) {
        this.listenersHelper.removeListener((Object)listener);
    }

    public <EventType> Closeable onTabPanEvent(final Class<EventType> type, boolean weak, final Reciver<EventType> consumer) {
        return this.addTabPaneListener(new Listener(){

            @Override
            public void tabPaneEvent(Event ev) {
                Class<?> etype;
                if (ev != null && type != null && consumer != null && type.isAssignableFrom(etype = ev.getClass())) {
                    consumer.recive((Object)ev);
                }
            }
        }, weak);
    }

    public <EventType> Closeable onTabPanEvent(Class<EventType> type, Reciver<EventType> consumer) {
        return this.onTabPanEvent(type, false, consumer);
    }

    protected void fireTabPaneEvent(Event e) {
        if (!this.enableTabEvent) {
            return;
        }
        this.listenersHelper.fireEvent((Object)e);
    }

    private void handleChangeState() {
        int ti = this.getSelectedIndex();
        if (ti != this.selectedTabIndex) {
            this.fireTabPaneEvent(new TabSelectedEvent(this, this.selectedTabIndex, ti));
            this.selectedTabIndex = ti;
        }
    }

    public Iterable<Component> getTabs() {
        Object[] arr = new Component[this.getTabCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.getComponentAt(i);
        }
        return Iterators.array((Object[])arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            Component cmpHeader;
            super.addTab(title, icon, component, tip);
            if (lock && (cmpHeader = this.createHeaderForComponent(component)) != null && cmpHeader instanceof TabHeader) {
                TabHeader th = (TabHeader)cmpHeader;
                if (title != null) {
                    th.setTabTitle(title);
                }
                if (icon != null) {
                    th.setTabIcon(icon);
                }
                if (tip != null) {
                    th.setTabToolTipText(tip);
                }
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        int co = this.getTabCount();
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, co - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTab(String title, Icon icon, Component component) {
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            Component cmpHeader;
            super.addTab(title, icon, component);
            if (lock && (cmpHeader = this.createHeaderForComponent(component)) != null && cmpHeader instanceof TabHeader) {
                TabHeader th = (TabHeader)cmpHeader;
                if (title != null) {
                    th.setTabTitle(title);
                }
                if (icon != null) {
                    th.setTabIcon(icon);
                }
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        int co = this.getTabCount();
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, co - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTab(String title, Component component) {
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            Component cmpHeader;
            super.addTab(title, component);
            if (lock && (cmpHeader = this.createHeaderForComponent(component)) != null && title != null && cmpHeader instanceof TabHeader) {
                TabHeader th = (TabHeader)cmpHeader;
                th.setTabTitle(title);
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        int co = this.getTabCount();
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, co - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTab(TabHeader tabHeader, Component component) {
        if (tabHeader == null) {
            throw new IllegalArgumentException("tabHeader==null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component==null");
        }
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            super.addTab(tabHeader.getTabTitle(), component);
            if (lock) {
                int index = this.indexOfComponent(component);
                this.setTabComponentAt(index, tabHeader);
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        int co = this.getTabCount();
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, co - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            Component cmpHeader;
            super.insertTab(title, icon, component, tip, index);
            if (lock && (cmpHeader = this.createHeaderForComponent(component)) != null && title != null && cmpHeader instanceof TabHeader) {
                TabHeader th = (TabHeader)cmpHeader;
                if (title != null) {
                    th.setTabTitle(title);
                }
                if (icon != null) {
                    th.setTabIcon(icon);
                }
                if (tip != null) {
                    th.setTabToolTipText(tip);
                }
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTab(TabHeader tabHeader, Component component, int index) {
        if (tabHeader == null) {
            throw new IllegalArgumentException("tabHeader==null");
        }
        if (component == null) {
            throw new IllegalArgumentException("component==null");
        }
        boolean lock = false;
        if (!this.addTab) {
            this.addTab = true;
            lock = true;
        }
        try {
            super.insertTab(tabHeader.getTabTitle(), tabHeader.getTabIcon(), component, tabHeader.getTabToolTipText(), index);
            if (lock) {
                int index2 = this.indexOfComponent(component);
                this.setTabComponentAt(index2, tabHeader);
            }
        }
        finally {
            if (lock) {
                this.addTab = false;
            }
        }
        if (lock) {
            this.fireTabPaneEvent(new TabInsertedEvent(this, component, index));
        }
    }

    @Override
    public void removeTabAt(int index) {
        Component tabC = this.getTabComponentAt(index);
        Component tab = this.getComponentAt(index);
        if (!this.exchangeTab) {
            this.releaseTab(tab, tabC);
        }
        super.removeTabAt(index);
        this.fireTabPaneEvent(new TabDeletedEvent(this, tab, index));
    }

    @Override
    public void setBackgroundAt(int index, Color background) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabBackground(background);
        }
        super.setBackgroundAt(index, background);
    }

    @Override
    public void setComponentAt(int index, Component component) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabOwner(component);
        }
        super.setComponentAt(index, component);
    }

    @Override
    public void setDisabledIconAt(int index, Icon disabledIcon) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabDisabledIcon(disabledIcon);
        }
        super.setDisabledIconAt(index, disabledIcon);
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        Component cmpt = this.getTabComponentAt(tabIndex);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabDisplayedMnemonicIndex(mnemonicIndex);
        }
        super.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabEnabled(enabled);
        }
        super.setEnabledAt(index, enabled);
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabForeground(foreground);
        }
        super.setForegroundAt(index, foreground);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabIcon(icon);
        }
        super.setIconAt(index, icon);
    }

    @Override
    public void setMnemonicAt(int tabIndex, int mnemonic) {
        Component cmpt = this.getTabComponentAt(tabIndex);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabMnemonic(mnemonic);
        }
        super.setMnemonicAt(tabIndex, mnemonic);
    }

    @Override
    public void setTitleAt(int index, String title) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabTitle(title);
        }
        super.setTitleAt(index, title);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        Component cmpt = this.getTabComponentAt(index);
        if (cmpt instanceof TabQuery) {
            ((TabQuery)((Object)cmpt)).setTabToolTipText(toolTipText);
        }
        super.setToolTipTextAt(index, toolTipText);
    }

    @Override
    public void setTabComponentAt(int index, Component component) {
        Component cmpt = this.getTabComponentAt(index);
        super.setTabComponentAt(index, component);
        if (cmpt instanceof Closeable && !this.exchangeTab) {
            try {
                ((Closeable)((Object)cmpt)).close();
            }
            catch (IOException e) {
                Logger.getLogger(TabPane.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void swapTab(int tabIdx1, int tabIdx2) {
        int tabCo = this.getTabCount();
        if (tabIdx1 < 0) {
            throw new IllegalArgumentException("tabIdx1<0");
        }
        if (tabIdx2 < 0) {
            throw new IllegalArgumentException("tabIdx2<0");
        }
        if (tabIdx1 >= tabCo) {
            throw new IllegalArgumentException("tabIdx1 >= tab count");
        }
        if (tabIdx2 >= tabCo) {
            throw new IllegalArgumentException("tabIdx2 >= tab count");
        }
        if (tabIdx1 == tabIdx2) {
            return;
        }
        this.enableTabEvent = false;
        this.exchangeTab = true;
        if (tabIdx1 > tabIdx2) {
            int t = tabIdx1;
            tabIdx1 = tabIdx2;
            tabIdx2 = t;
        }
        Component cmp1 = this.getComponentAt(tabIdx1);
        Component cmpHeader1 = this.getTabComponentAt(tabIdx1);
        String title1 = this.getTitleAt(tabIdx1);
        String toolTip1 = this.getToolTipTextAt(tabIdx1);
        Icon icon1 = this.getIconAt(tabIdx1);
        Component cmp2 = this.getComponentAt(tabIdx2);
        Component cmpHeader2 = this.getTabComponentAt(tabIdx2);
        String title2 = this.getTitleAt(tabIdx2);
        String toolTip2 = this.getToolTipTextAt(tabIdx2);
        Icon icon2 = this.getIconAt(tabIdx2);
        this.remove(tabIdx2);
        this.remove(tabIdx1);
        this.insertTab(title2, icon2, cmp2, toolTip2, tabIdx1);
        this.setTabComponentAt(tabIdx1, cmpHeader2);
        this.insertTab(title1, icon1, cmp1, toolTip1, tabIdx2);
        this.setTabComponentAt(tabIdx2, cmpHeader1);
        this.enableTabEvent = true;
        this.exchangeTab = false;
    }

    protected void releaseTab(Component tabComponent, Component header) {
        if (tabComponent != null && tabComponent instanceof Closeable) {
            try {
                ((Closeable)((Object)tabComponent)).close();
            }
            catch (IOException ex) {
                Logger.getLogger(TabPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (header != null && header instanceof Closeable) {
            try {
                ((Closeable)((Object)header)).close();
            }
            catch (IOException ex) {
                Logger.getLogger(TabPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected Component createHeaderForComponent(Component owner) {
        if (!this.exchangeTab) {
            int index = this.indexOfComponent(owner);
            if (index < 0) {
                return null;
            }
            Component cmp = (Component)this.getHeaderCreator().convert((Object)owner);
            if (cmp != null) {
                this.setTabComponentAt(index, cmp);
            }
            return cmp;
        }
        return null;
    }

    public Convertor<Component, Component> getHeaderCreator() {
        if (this.headerCreator != null) {
            return this.headerCreator;
        }
        this.headerCreator = this.defaultHeader;
        return this.headerCreator;
    }

    public void setHeaderCreator(Convertor<Component, Component> creator) {
        this.headerCreator = creator;
    }

    public TabPane() {
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                TabPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                TabPane.this.glassPane.setPoint(new Point(-1000, -1000));
                TabPane.this.glassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                Point glassPt = e.getLocation();
                SwingUtilities.convertPointFromScreen(glassPt, TabPane.this.glassPane);
                int targetIdx = TabPane.this.getTargetTabIndex(glassPt);
                if (TabPane.this.getTabAreaBounds().contains(glassPt) && targetIdx >= 0 && targetIdx != TabPane.this.dragTabIndex && targetIdx != TabPane.this.dragTabIndex + 1) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    TabPane.this.glassPane.setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                    TabPane.this.glassPane.setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                TabPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                TabPane.this.dragTabIndex = -1;
                TabPane.this.glassPane.setVisible(false);
                if (TabPane.this.hasGhost()) {
                    TabPane.this.glassPane.setVisible(false);
                    TabPane.this.glassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        final Transferable t = new Transferable(){
            private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

            @Override
            public Object getTransferData(DataFlavor flavor) {
                return TabPane.this;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{this.FLAVOR};
                return f;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getHumanPresentableName().equals(TabPane.NAME);
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                if (TabPane.this.getTabCount() <= 1) {
                    return;
                }
                Point tabPt = e.getDragOrigin();
                TabPane.this.dragTabIndex = TabPane.this.indexAtLocation(tabPt.x, tabPt.y);
                if (TabPane.this.dragTabIndex < 0 || !TabPane.this.isEnabledAt(TabPane.this.dragTabIndex)) {
                    return;
                }
                TabPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, t, dsl);
                }
                catch (InvalidDnDOperationException idoe) {
                    idoe.printStackTrace();
                }
            }
        };
        new DropTarget(this.glassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
        this.selectedTabIndex = this.getSelectedIndex();
        ChangeListener ch = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabPane.this.handleChangeState();
            }
        };
        this.addChangeListener(ch);
    }

    private void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this.getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    private void autoScrollTest(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        int _tabPlacement = this.getTabPlacement();
        if (_tabPlacement == 1 || _tabPlacement == 3) {
            rBackward.setBounds(r.x, r.y, rwh, r.height);
            rForward.setBounds(r.x + r.width - rwh - buttonsize, r.y, rwh + buttonsize, r.height);
        } else if (_tabPlacement == 2 || _tabPlacement == 4) {
            rBackward.setBounds(r.x, r.y, r.width, rwh);
            rForward.setBounds(r.x, r.y + r.height - rwh - buttonsize, r.width, rwh + buttonsize);
        }
        if (rBackward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    public void setPaintGhost(boolean flag) {
        this.hasGhost = flag;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    public void setPaintScrollArea(boolean flag) {
        this.isPaintScrollArea = flag;
    }

    public boolean isPaintScrollArea() {
        return this.isPaintScrollArea;
    }

    private int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.glassPane, glassPt, this);
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (isTB) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (!r.contains(tabPt)) continue;
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        if (isTB) {
            r.setRect(r.x + r.width / 2, r.y, r.width, r.height);
        } else {
            r.setRect(r.x, r.y + r.height / 2, r.width, r.height);
        }
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    private void exchangeTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        this.enableTabEvent = false;
        this.exchangeTab = true;
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String str = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean flg = this.isEnabledAt(prev);
        int targetIndex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(str, icon, cmp, tip, targetIndex);
        this.setEnabledAt(targetIndex, flg);
        if (flg) {
            this.setSelectedIndex(targetIndex);
        }
        this.setTabComponentAt(targetIndex, tab);
        this.exchangeTab = false;
        this.enableTabEvent = true;
        this.fireTabPaneEvent(new TabExchagedEvent(this, prev, next));
        this.handleChangeState();
    }

    private void initTargetLeftRightLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(r.x - 1, r.y, 3.0, r.height);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.lineRect.setRect(r.x + r.width - 1, r.y, 3.0, r.height);
        }
    }

    private void initTargetTopBottomLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(r.x, r.y - 1, r.width, 3.0);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.lineRect.setRect(r.x, r.y + r.height - 1, r.width, 3.0);
        }
    }

    private void initGlassPane(Component c, Point tabPt) {
        this.getRootPane().setGlassPane(this.glassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(this.dragTabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            rect.x = rect.x < 0 ? 0 : rect.x;
            rect.y = rect.y < 0 ? 0 : rect.y;
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.glassPane.setImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(c, tabPt, this.glassPane);
        this.glassPane.setPoint(glassPt);
        this.glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        Component comp = this.getSelectedComponent();
        int idx = 0;
        while (comp == null && idx < this.getTabCount()) {
            comp = this.getComponentAt(idx++);
        }
        Rectangle compRect = comp == null ? new Rectangle() : comp.getBounds();
        int _tabPlacement = this.getTabPlacement();
        if (_tabPlacement == 1) {
            tabbedRect.height -= compRect.height;
        } else if (_tabPlacement == 3) {
            tabbedRect.y = tabbedRect.y + compRect.y + compRect.height;
            tabbedRect.height -= compRect.height;
        } else if (_tabPlacement == 2) {
            tabbedRect.width -= compRect.width;
        } else if (_tabPlacement == 4) {
            tabbedRect.x = tabbedRect.x + compRect.x + compRect.width;
            tabbedRect.width -= compRect.width;
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    class CDropTargetListener
    implements DropTargetListener {
        private Point pt_ = new Point();

        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (TabPane.this.getTabPlacement() == 1 || TabPane.this.getTabPlacement() == 3) {
                TabPane.this.initTargetLeftRightLine(TabPane.this.getTargetTabIndex(pt));
            } else {
                TabPane.this.initTargetTopBottomLine(TabPane.this.getTargetTabIndex(pt));
            }
            if (TabPane.this.hasGhost()) {
                TabPane.this.glassPane.setPoint(pt);
            }
            if (!this.pt_.equals(pt)) {
                TabPane.this.glassPane.repaint();
            }
            this.pt_ = pt;
            TabPane.this.autoScrollTest(pt);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (this.isDropAcceptable(e)) {
                TabPane.this.exchangeTab(TabPane.this.dragTabIndex, TabPane.this.getTargetTabIndex(e.getLocation()));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            TabPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = e.getCurrentDataFlavors();
            return t.isDataFlavorSupported(f[0]) && TabPane.this.dragTabIndex >= 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = t.getTransferDataFlavors();
            return t.isDataFlavorSupported(f[0]) && TabPane.this.dragTabIndex >= 0;
        }
    }

    class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage draggingGhost = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
        }

        public void setImage(BufferedImage draggingGhost) {
            this.draggingGhost = draggingGhost;
        }

        public void setPoint(Point location) {
            this.location = location;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(this.composite);
            if (TabPane.this.isPaintScrollArea() && TabPane.this.getTabLayoutPolicy() == 1) {
                g2.setPaint(Color.RED);
                g2.fill(rBackward);
                g2.fill(rForward);
            }
            if (this.draggingGhost != null) {
                double xx = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
                double yy = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
                g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, null);
            }
            if (TabPane.this.dragTabIndex >= 0) {
                g2.setPaint(TabPane.this.lineColor);
                g2.fill(TabPane.this.lineRect);
            }
        }
    }

    public static interface TabQuery {
        public void setTabBackground(Color var1);

        public void setTabOwner(Component var1);

        public void setTabDisabledIcon(Icon var1);

        public void setTabDisplayedMnemonicIndex(int var1);

        public void setTabEnabled(boolean var1);

        public void setTabForeground(Color var1);

        public void setTabIcon(Icon var1);

        public void setTabMnemonic(int var1);

        public void setTabTitle(String var1);

        public void setTabToolTipText(String var1);
    }

    public static class Adapter
    implements Listener {
        @Override
        public void tabPaneEvent(Event e) {
            if (e == null) {
                return;
            }
            Object _src = e.getSource();
            if (!(_src instanceof TabPane)) {
                return;
            }
            TabPane src = (TabPane)_src;
            if (e instanceof TabDeletedEvent) {
                this.tabDeleted(src, ((TabDeletedEvent)e).getComponent(), ((TabDeletedEvent)e).getIndex());
            } else if (e instanceof TabInsertedEvent) {
                this.tabInserted(src, ((TabInsertedEvent)e).getComponent(), ((TabInsertedEvent)e).getIndex());
            } else if (e instanceof TabSelectedEvent) {
                int i = ((TabSelectedEvent)e).getSelectedTabIndex();
                Component c = src.getSelectedComponent();
                this.tabSelected(src, c, i, ((TabSelectedEvent)e).getOldSelectedTabIndex());
            } else if (e instanceof TabExchagedEvent) {
                this.tabExchanged(src, ((TabExchagedEvent)e).getNextTabIndex(), ((TabExchagedEvent)e).getPreviousTabIndex());
            }
        }

        protected void tabDeleted(TabPane src, Component component, int index) {
        }

        protected void tabInserted(TabPane src, Component component, int index) {
        }

        protected void tabSelected(TabPane src, Component component, int index, int oldIndex) {
        }

        protected void tabExchanged(TabPane src, int newIndex, int oldIndex) {
        }
    }

    public static interface Listener {
        public void tabPaneEvent(Event var1);
    }

    public static class TabDeletedEvent
    extends Event {
        private Component component = null;
        private int index = -1;

        public TabDeletedEvent(TabPane tabPane, Component component, int index) {
            super(tabPane);
            this.component = component;
            this.index = index;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class TabInsertedEvent
    extends Event {
        private Component component = null;
        private int index = -1;

        public TabInsertedEvent(TabPane tabPane, Component component, int index) {
            super(tabPane);
            this.component = component;
            this.index = index;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class TabSelectedEvent
    extends Event {
        private int previousTabIndex = 0;
        private int nextTabIndex = 0;

        public TabSelectedEvent(TabPane tabPane, int prev, int next) {
            super(tabPane);
            this.previousTabIndex = prev;
            this.nextTabIndex = next;
        }

        public int getSelectedTabIndex() {
            return this.nextTabIndex;
        }

        public int getOldSelectedTabIndex() {
            return this.previousTabIndex;
        }
    }

    public static class TabExchagedEvent
    extends Event {
        private int previousTabIndex = 0;
        private int nextTabIndex = 0;

        public TabExchagedEvent(TabPane tabPane, int prev, int next) {
            super(tabPane);
            this.previousTabIndex = prev;
            this.nextTabIndex = next;
        }

        public int getNextTabIndex() {
            return this.nextTabIndex;
        }

        public int getPreviousTabIndex() {
            return this.previousTabIndex;
        }
    }

    public static class Event
    extends EventObject {
        public Event(TabPane tabPane) {
            super(tabPane);
        }
    }
}

