/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Pair;
import xyz.cofe.gui.swing.text.BaseAString;
import xyz.cofe.gui.swing.text.RichString;
import xyz.cofe.text.Text;

public class AString
extends BaseAString {
    private static final Logger logger = Logger.getLogger(AString.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(AString.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(AString.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(AString.class.getName(), method, result);
    }

    public AString(AttributedCharacterIterator[] iterators) {
        super(iterators);
    }

    public AString(String text) {
        super(text);
    }

    public AString(String text, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        super(text, attributes);
    }

    public AString(AttributedCharacterIterator text) {
        super(text);
    }

    public AString(AttributedCharacterIterator text, int beginIndex, int endIndex) {
        super(text, beginIndex, endIndex);
    }

    public AString(AttributedCharacterIterator text, int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        super(text, beginIndex, endIndex, attributes);
    }

    public AString(AttributedString astr) {
        super(astr);
    }

    @Override
    public AString clone() {
        return new AString(this.getIterator());
    }

    public AString substring(int begin, int endEx) {
        if (begin < 0) {
            throw new IllegalArgumentException("begin(" + begin + ")<0");
        }
        if (begin > endEx) {
            throw new IllegalArgumentException("begin(" + begin + ")>endEx(" + endEx + ")");
        }
        if (this.length() <= 0) {
            return new AString("");
        }
        if (begin > this.length()) {
            begin = this.length();
        }
        if (endEx > this.length()) {
            endEx = this.length();
        }
        return new AString(this.getIterator(), begin, endEx);
    }

    public AString concat(BaseAString ... astrings) {
        if (astrings == null) {
            throw new IllegalArgumentException("astrings==null");
        }
        if (astrings.length <= 0) {
            return this;
        }
        LinkedHashMap<BaseAString, Integer> begins = new LinkedHashMap<BaseAString, Integer>();
        LinkedHashMap<BaseAString, Integer> ends = new LinkedHashMap<BaseAString, Integer>();
        StringBuilder sb = new StringBuilder();
        Iterable aiters = Iterators.sequence((Iterable[])new Iterable[]{Iterators.single((Object)this), Iterators.array((Object[])astrings)});
        int ptr = 0;
        for (BaseAString sstr : aiters) {
            int len = sstr.length();
            if (len <= 0) continue;
            String str = sstr.text();
            sb.append(str);
            int begin = ptr;
            int end = ptr + str.length();
            begins.put(sstr, begin);
            ends.put(sstr, end);
        }
        AString astr = new AString(sb.toString());
        for (BaseAString sstr : begins.keySet()) {
            int begin = (Integer)begins.get(sstr);
            int end = (Integer)ends.get(sstr);
            int cnt = end - begin;
            if (Math.abs(begin - end) <= 0) continue;
            AttributedCharacterIterator sitr = sstr.getIterator();
            int ssi = -1;
            for (int si = sitr.getBeginIndex(); si < sitr.getEndIndex(); ++si) {
                sitr.setIndex(si);
                Map<AttributedCharacterIterator.Attribute, Object> m = sitr.getAttributes();
                if (++ssi >= cnt) continue;
                for (Map.Entry<AttributedCharacterIterator.Attribute, Object> me : m.entrySet()) {
                    AttributedCharacterIterator.Attribute a = me.getKey();
                    Object v = me.getValue();
                    astr.addAttribute(a, v, begin + ssi, begin + ssi + 1);
                }
            }
        }
        return astr;
    }

    public List<Pair<Integer, Integer>> newLinesIntervals() {
        ArrayList<Pair<Integer, Integer>> res;
        block1: {
            BasicPair p;
            int end;
            int begin;
            Pair nextline;
            res = new ArrayList<Pair<Integer, Integer>>();
            String srctext = this.text();
            int ptr = 0;
            while ((nextline = Text.nextNewLine((String)srctext, (int)ptr)) != null) {
                begin = ptr;
                end = (Integer)nextline.A() - ((String)nextline.B()).length();
                ptr = (Integer)nextline.A();
                p = new BasicPair((Object)begin, (Object)end);
                res.add((Pair<Integer, Integer>)p);
            }
            if (ptr >= srctext.length()) break block1;
            begin = ptr;
            end = srctext.length();
            p = new BasicPair((Object)begin, (Object)end);
            res.add((Pair<Integer, Integer>)p);
        }
        return res;
    }

    public List<AString> splitNewLines() {
        ArrayList<AString> lines = new ArrayList<AString>();
        for (Pair<Integer, Integer> lineBeginEnd : this.newLinesIntervals()) {
            AString str = this.substring((Integer)lineBeginEnd.A(), (Integer)lineBeginEnd.B());
            lines.add(str);
        }
        return lines;
    }

    public TextLayout textLayout(TextMeasurer tm) {
        if (tm == null) {
            throw new IllegalArgumentException("tm==null");
        }
        TextLayout tl = tm.getLayout(0, this.length());
        return tl;
    }

    public TextLayout textLayout(FontRenderContext frc) {
        if (frc == null) {
            throw new IllegalArgumentException("frc==null");
        }
        TextMeasurer tm = new TextMeasurer(this.getIterator(), frc);
        return this.textLayout(tm);
    }

    public TextLayout textLayout(Graphics2D gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        return this.textLayout(gs.getFontRenderContext());
    }

    public RichString rstring(TextMeasurer tm) {
        return new RichString(this.textLayout(tm));
    }

    public RichString rstring(FontRenderContext frc) {
        return new RichString(this.textLayout(frc));
    }

    public RichString rstring(Graphics2D gs) {
        return new RichString(this.textLayout(gs));
    }

    public Format format(int begin, int end) {
        return new Format(this, begin, end);
    }

    public Format format() {
        int len = this.length();
        return this.format(0, len);
    }

    public static class Format {
        protected int begin;
        protected int end;
        protected AString str;
        protected ConcurrentLinkedQueue<Func1<AString, AString>> formatters;

        public Format(AString str, int begin, int end) {
            this.begin = begin;
            this.end = end;
            this.str = str;
            this.formatters = new ConcurrentLinkedQueue();
        }

        public AString apply() {
            Func1<AString, AString> fmt;
            AString str = this.str.clone();
            while ((fmt = this.formatters.poll()) != null) {
                AString nstr = (AString)fmt.apply((Object)str);
                if (nstr == null) continue;
                str = nstr;
            }
            return str;
        }

        public Format family(final String family) {
            if (family == null) {
                throw new IllegalArgumentException("family == null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.FAMILY, family, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Family family() {
            return new Family();
        }

        public Format font(final Font font) {
            if (font == null) {
                throw new IllegalArgumentException("font == null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.FONT, font, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format foreground(final Color color) {
            if (color == null) {
                throw new IllegalArgumentException("color == null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.FOREGROUND, color, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format background(final Color color) {
            if (color == null) {
                throw new IllegalArgumentException("color == null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.BACKGROUND, color, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Weight weight() {
            return new Weight();
        }

        public Posture posture() {
            return new Posture();
        }

        public Width width() {
            return new Width();
        }

        public Format size(final Number size) {
            if (size == null) {
                throw new IllegalArgumentException("size==null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.SIZE, size, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format transform(final TransformAttribute ta) {
            if (ta == null) {
                throw new IllegalArgumentException("ta==null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.TRANSFORM, ta, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format transform(final AffineTransform at) {
            if (at == null) {
                throw new IllegalArgumentException("at==null");
            }
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.TRANSFORM, at, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format superScript() {
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format subScript() {
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Underline underline() {
            return new Underline();
        }

        public Format strikethrough() {
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format kerning() {
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.KERNING, TextAttribute.KERNING_ON, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Format ligatures() {
            this.formatters.add(new Func1<AString, AString>(){

                public AString apply(AString str) {
                    str.addAttribute(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON, Format.this.begin, Format.this.end);
                    return str;
                }
            });
            return this;
        }

        public Justification justification() {
            return new Justification();
        }

        public Clear clear() {
            return new Clear();
        }

        public class Clear {
            public Format all() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.clearAttributes(Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format justification() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.JUSTIFICATION);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format ligatures() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.LIGATURES);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format kerning() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.KERNING);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format strikethrough() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.STRIKETHROUGH);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format underline() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.UNDERLINE);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format sscript() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.SUPERSCRIPT);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format transform() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.TRANSFORM);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format size() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.SIZE);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format width() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.WIDTH);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format posture() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.POSTURE);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format weight() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.WEIGHT);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format background() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.BACKGROUND);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format foreground() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.FOREGROUND);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format family() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.FAMILY);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format font() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        LinkedHashSet<TextAttribute> set = new LinkedHashSet<TextAttribute>();
                        set.add(TextAttribute.FONT);
                        str.removeAttributes(set, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Justification {
            public Format full() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format none() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_NONE, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Underline {
            public Format on() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format lowDashed() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DASHED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format lowDotted() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format lowGray() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format onePixel() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format twoPixel() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Width {
            public Format regular() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format extended() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format condensed() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format semiCondensed() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format semiExtended() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Posture {
            public Format oblique() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format regular() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Weight {
            public Format regular() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format bold() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format light() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format medium() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format semiBold() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format ultraBold() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_ULTRABOLD, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format heavy() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format extraLight() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format extraBold() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format demiLight() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }

            public Format demiBold() {
                Format.this.formatters.add(new Func1<AString, AString>(){

                    public AString apply(AString str) {
                        str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD, Format.this.begin, Format.this.end);
                        return str;
                    }
                });
                return Format.this;
            }
        }

        public class Family {
            public Format dialogInput() {
                return Format.this.family("DialogInput");
            }

            public Format dialog() {
                return Format.this.family("Dialog");
            }

            public Format serif() {
                return Format.this.family("Serif");
            }

            public Format sansSerif() {
                return Format.this.family("SansSerif");
            }

            public Format monospaced() {
                return Format.this.family("Monospaced");
            }
        }
    }
}

