/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.text.AttributeMap;
import xyz.cofe.gui.swing.text.BaseAString;

public class AttributedStringIterator
implements AttributedCharacterIterator {
    private static final Logger logger = Logger.getLogger(AttributedStringIterator.class.getName());
    protected BaseAString astring;
    private int beginIndex;
    private int endIndex;
    private AttributedCharacterIterator.Attribute[] relevantAttributes;
    private int currentIndex;
    private int currentRunIndex;
    private int currentRunStart;
    private int currentRunLimit;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(AttributedStringIterator.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(AttributedStringIterator.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(AttributedStringIterator.class.getName(), method, result);
    }

    AttributedStringIterator(BaseAString astring, AttributedCharacterIterator.Attribute[] attributes, int beginIndex, int endIndex) {
        if (astring == null) {
            throw new IllegalArgumentException("astring == null");
        }
        this.astring = astring;
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > astring.length()) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.currentIndex = beginIndex;
        this.updateRunInfo();
        if (attributes != null) {
            this.relevantAttributes = (AttributedCharacterIterator.Attribute[])attributes.clone();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributedStringIterator)) {
            return false;
        }
        AttributedStringIterator that = (AttributedStringIterator)obj;
        if (this.astring != that.getString()) {
            return false;
        }
        return this.currentIndex == that.currentIndex && this.beginIndex == that.beginIndex && this.endIndex == that.endIndex;
    }

    public int hashCode() {
        return this.astring.text().hashCode() ^ this.currentIndex ^ this.beginIndex ^ this.endIndex;
    }

    @Override
    public Object clone() {
        try {
            AttributedStringIterator other = (AttributedStringIterator)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public char first() {
        return this.internalSetIndex(this.beginIndex);
    }

    @Override
    public char last() {
        if (this.endIndex == this.beginIndex) {
            return this.internalSetIndex(this.endIndex);
        }
        return this.internalSetIndex(this.endIndex - 1);
    }

    @Override
    public char current() {
        if (this.currentIndex == this.endIndex) {
            return '\uffff';
        }
        return this.astring.charAt(this.currentIndex);
    }

    @Override
    public char next() {
        if (this.currentIndex < this.endIndex) {
            return this.internalSetIndex(this.currentIndex + 1);
        }
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.currentIndex > this.beginIndex) {
            return this.internalSetIndex(this.currentIndex - 1);
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position < this.beginIndex || position > this.endIndex) {
            throw new IllegalArgumentException("Invalid index");
        }
        return this.internalSetIndex(position);
    }

    @Override
    public int getBeginIndex() {
        return this.beginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getIndex() {
        return this.currentIndex;
    }

    @Override
    public int getRunStart() {
        return this.currentRunStart;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
            return this.currentRunStart;
        }
        Object value = this.getAttribute(attribute);
        int runStart = this.currentRunStart;
        int runIndex = this.currentRunIndex;
        while (runStart > this.beginIndex && BaseAString.valuesMatch(value, this.astring.getAttribute(attribute, runIndex - 1))) {
            runStart = this.astring.getRunStarts()[--runIndex];
        }
        if (runStart < this.beginIndex) {
            runStart = this.beginIndex;
        }
        return runStart;
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
            return this.currentRunStart;
        }
        int runStart = this.currentRunStart;
        int runIndex = this.currentRunIndex;
        while (runStart > this.beginIndex && this.astring.attributeValuesMatch(attributes, this.currentRunIndex, runIndex - 1)) {
            runStart = this.astring.getRunStarts()[--runIndex];
        }
        if (runStart < this.beginIndex) {
            runStart = this.beginIndex;
        }
        return runStart;
    }

    @Override
    public int getRunLimit() {
        return this.currentRunLimit;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
            return this.currentRunLimit;
        }
        Object value = this.getAttribute(attribute);
        int runLimit = this.currentRunLimit;
        int runIndex = this.currentRunIndex;
        while (runLimit < this.endIndex && BaseAString.valuesMatch(value, this.astring.getAttribute(attribute, runIndex + 1))) {
            runLimit = ++runIndex < this.astring.getRunCount() - 1 ? this.astring.getRunStarts()[runIndex + 1] : this.endIndex;
        }
        if (runLimit > this.endIndex) {
            runLimit = this.endIndex;
        }
        return runLimit;
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
            return this.currentRunLimit;
        }
        int runLimit = this.currentRunLimit;
        int runIndex = this.currentRunIndex;
        while (runLimit < this.endIndex && this.astring.attributeValuesMatch(attributes, this.currentRunIndex, runIndex + 1)) {
            runLimit = ++runIndex < this.astring.getRunCount() - 1 ? this.astring.getRunStarts()[runIndex + 1] : this.endIndex;
        }
        if (runLimit > this.endIndex) {
            runLimit = this.endIndex;
        }
        return runLimit;
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        if (this.astring.getRunAttributes() == null || this.currentRunIndex == -1 || this.astring.getRunAttributes()[this.currentRunIndex] == null) {
            return new Hashtable<AttributedCharacterIterator.Attribute, Object>();
        }
        return new AttributeMap(this.astring, this.currentRunIndex, this.beginIndex, this.endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        if (this.astring.getRunAttributes() == null) {
            return new HashSet<AttributedCharacterIterator.Attribute>();
        }
        BaseAString baseAString = this.astring;
        synchronized (baseAString) {
            HashSet<AttributedCharacterIterator.Attribute> keys = new HashSet<AttributedCharacterIterator.Attribute>();
            for (int i = 0; i < this.astring.getRunCount(); ++i) {
                Vector currentRunAttributes;
                if (this.astring.getRunStarts()[i] >= this.endIndex || i != this.astring.getRunCount() - 1 && this.astring.getRunStarts()[i + 1] <= this.beginIndex || (currentRunAttributes = this.astring.getRunAttributes()[i]) == null) continue;
                int j = currentRunAttributes.size();
                while (j-- > 0) {
                    keys.add((AttributedCharacterIterator.Attribute)currentRunAttributes.get(j));
                }
            }
            return keys;
        }
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        int runIndex = this.currentRunIndex;
        if (runIndex < 0) {
            return null;
        }
        return this.astring.getAttributeCheckRange(attribute, runIndex, this.beginIndex, this.endIndex);
    }

    private BaseAString getString() {
        return this.astring;
    }

    private char internalSetIndex(int position) {
        this.currentIndex = position;
        if (position < this.currentRunStart || position >= this.currentRunLimit) {
            this.updateRunInfo();
        }
        if (this.currentIndex == this.endIndex) {
            return '\uffff';
        }
        return this.astring.charAt(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRunInfo() {
        if (this.currentIndex == this.endIndex) {
            this.currentRunStart = this.currentRunLimit = this.endIndex;
            this.currentRunIndex = -1;
        } else {
            BaseAString baseAString = this.astring;
            synchronized (baseAString) {
                int runIndex;
                for (runIndex = -1; runIndex < this.astring.getRunCount() - 1 && this.astring.getRunStarts()[runIndex + 1] <= this.currentIndex; ++runIndex) {
                }
                this.currentRunIndex = runIndex;
                if (runIndex >= 0) {
                    this.currentRunStart = this.astring.getRunStarts()[runIndex];
                    if (this.currentRunStart < this.beginIndex) {
                        this.currentRunStart = this.beginIndex;
                    }
                } else {
                    this.currentRunStart = this.beginIndex;
                }
                if (runIndex < this.astring.getRunCount() - 1) {
                    this.currentRunLimit = this.astring.getRunStarts()[runIndex + 1];
                    if (this.currentRunLimit > this.endIndex) {
                        this.currentRunLimit = this.endIndex;
                    }
                } else {
                    this.currentRunLimit = this.endIndex;
                }
            }
        }
    }
}

