/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.text.AttributedStringIterator;

public class BaseAString {
    private static final Logger logger = Logger.getLogger(BaseAString.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private long scn = 0L;
    private static final int ARRAY_SIZE_INCREMENT = 10;
    private String text;
    private int runArraySize;
    private int runCount;
    private int[] runStarts;
    private Vector[] runAttributes;
    private Vector[] runAttributeValues;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(BaseAString.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(BaseAString.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(BaseAString.class.getName(), method, result);
    }

    protected synchronized void nextScn() {
        ++this.scn;
    }

    public synchronized long getScn() {
        return this.scn;
    }

    public synchronized int getRunCount() {
        return this.runCount;
    }

    public synchronized int[] getRunStarts() {
        return this.runStarts;
    }

    public synchronized Vector[] getRunAttributes() {
        return this.runAttributes;
    }

    public synchronized Vector[] getRunAttributeValues() {
        return this.runAttributeValues;
    }

    public BaseAString(AttributedCharacterIterator[] iterators) {
        if (iterators == null) {
            throw new NullPointerException("Iterators must not be null");
        }
        if (iterators.length == 0) {
            this.text = "";
        } else {
            StringBuffer buffer = new StringBuffer();
            for (AttributedCharacterIterator iterator : iterators) {
                this.appendContents(buffer, iterator);
            }
            this.text = buffer.toString();
            if (this.text.length() > 0) {
                int offset = 0;
                Map<AttributedCharacterIterator.Attribute, Object> last = null;
                for (AttributedCharacterIterator iterator : iterators) {
                    int start = iterator.getBeginIndex();
                    int end = iterator.getEndIndex();
                    int index = start;
                    while (index < end) {
                        iterator.setIndex(index);
                        Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
                        if (BaseAString.mapsDiffer(last, attrs)) {
                            this.setAttributes(attrs, index - start + offset);
                        }
                        last = attrs;
                        index = iterator.getRunLimit();
                    }
                    offset += end - start;
                }
            }
        }
    }

    public BaseAString(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
    }

    public BaseAString(String text, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        if (text == null || attributes == null) {
            throw new NullPointerException();
        }
        this.text = text;
        if (text.length() == 0) {
            if (attributes.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        int attributeCount = attributes.size();
        if (attributeCount > 0) {
            this.createRunAttributeDataVectors();
            Vector<AttributedCharacterIterator.Attribute> newRunAttributes = new Vector<AttributedCharacterIterator.Attribute>(attributeCount);
            Vector newRunAttributeValues = new Vector(attributeCount);
            this.runAttributes[0] = newRunAttributes;
            this.runAttributeValues[0] = newRunAttributeValues;
            for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : attributes.entrySet()) {
                newRunAttributes.addElement(entry.getKey());
                newRunAttributeValues.addElement(entry.getValue());
            }
        }
    }

    public BaseAString(AttributedCharacterIterator text) {
        this(text, text.getBeginIndex(), text.getEndIndex(), null);
    }

    public BaseAString(AttributedCharacterIterator text, int beginIndex, int endIndex) {
        this(text, beginIndex, endIndex, null);
    }

    public BaseAString(AttributedCharacterIterator text, int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        if (text == null) {
            throw new NullPointerException();
        }
        int textBeginIndex = text.getBeginIndex();
        int textEndIndex = text.getEndIndex();
        if (beginIndex < textBeginIndex || endIndex > textEndIndex || beginIndex > endIndex) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuilder textBuffer = new StringBuilder();
        text.setIndex(beginIndex);
        char c = text.current();
        while (text.getIndex() < endIndex) {
            textBuffer.append(c);
            c = text.next();
        }
        this.text = textBuffer.toString();
        if (beginIndex == endIndex) {
            return;
        }
        HashSet<AttributedCharacterIterator.Attribute> keys = new HashSet<AttributedCharacterIterator.Attribute>();
        if (attributes == null) {
            keys.addAll(text.getAllAttributeKeys());
        } else {
            keys.addAll(Arrays.asList(attributes));
            keys.retainAll(text.getAllAttributeKeys());
        }
        if (keys.isEmpty()) {
            return;
        }
        block1: for (AttributedCharacterIterator.Attribute attributeKey : keys) {
            text.setIndex(textBeginIndex);
            while (text.getIndex() < endIndex) {
                int start = text.getRunStart(attributeKey);
                int limit = text.getRunLimit(attributeKey);
                Object value = text.getAttribute(attributeKey);
                if (value != null) {
                    if (value instanceof Annotation) {
                        if (start >= beginIndex && limit <= endIndex) {
                            this.addAttribute(attributeKey, value, start - beginIndex, limit - beginIndex);
                        } else if (limit > endIndex) {
                            continue block1;
                        }
                    } else {
                        if (start >= endIndex) continue block1;
                        if (limit > beginIndex) {
                            if (start < beginIndex) {
                                start = beginIndex;
                            }
                            if (limit > endIndex) {
                                limit = endIndex;
                            }
                            if (start != limit) {
                                this.addAttribute(attributeKey, value, start - beginIndex, limit - beginIndex);
                            }
                        }
                    }
                }
                text.setIndex(limit);
            }
        }
    }

    public BaseAString(AttributedString astr) {
        this(astr.getIterator());
    }

    public BaseAString(BaseAString astr) {
        this(astr.getIterator());
    }

    public BaseAString clone() {
        return new BaseAString(this);
    }

    protected void appendContents(StringBuffer buf, CharacterIterator iterator) {
        int index = iterator.getBeginIndex();
        int end = iterator.getEndIndex();
        while (index < end) {
            iterator.setIndex(index++);
            buf.append(iterator.current());
        }
    }

    protected static boolean mapsDiffer(Map last, Map attrs) {
        if (last == null) {
            return attrs != null && attrs.size() > 0;
        }
        return !last.equals(attrs);
    }

    protected synchronized void setAttributes(Map attrs, int offset) {
        int size;
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int index = this.ensureRunBreak(offset, false);
        int n = size = attrs != null ? attrs.size() : 0;
        if (attrs != null) {
            Vector runAttrs = new Vector(size);
            Vector runValues = new Vector(size);
            for (Map.Entry entry : attrs.entrySet()) {
                runAttrs.add(entry.getKey());
                runValues.add(entry.getValue());
            }
            this.runAttributes[index] = runAttrs;
            this.runAttributeValues[index] = runValues;
            this.nextScn();
        }
    }

    protected synchronized void createRunAttributeDataVectors() {
        int[] newRunStarts = new int[10];
        Vector[] newRunAttributes = new Vector[10];
        Vector[] newRunAttributeValues = new Vector[10];
        this.runStarts = newRunStarts;
        this.runAttributes = newRunAttributes;
        this.runAttributeValues = newRunAttributeValues;
        this.runArraySize = 10;
        this.runCount = 1;
        this.nextScn();
    }

    protected synchronized void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        int len = this.length();
        if (len == 0) {
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        this.addAttributeImpl(attribute, value, 0, len);
    }

    protected synchronized void addAttribute(AttributedCharacterIterator.Attribute attribute, Object value, int beginIndex, int endIndex) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (beginIndex < 0 || endIndex > this.length() || beginIndex >= endIndex) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        this.addAttributeImpl(attribute, value, beginIndex, endIndex);
    }

    protected synchronized void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, int beginIndex, int endIndex) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (beginIndex < 0 || endIndex > this.length() || beginIndex > endIndex) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (beginIndex == endIndex) {
            if (attributes.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int beginRunIndex = this.ensureRunBreak(beginIndex);
        int endRunIndex = this.ensureRunBreak(endIndex);
        for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : attributes.entrySet()) {
            this.addAttributeRunData(entry.getKey(), entry.getValue(), beginRunIndex, endRunIndex);
        }
    }

    protected synchronized void removeAttributes(Set<? extends AttributedCharacterIterator.Attribute> attributes, int beginIndex, int endIndex) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes == null");
        }
        if (attributes.isEmpty()) {
            return;
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")>endIndex(" + endIndex + ")");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")<0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex(" + beginIndex + ")<0");
        }
        if (beginIndex >= this.length()) {
            return;
        }
        if (this.runCount <= 0) {
            return;
        }
        for (AttributedCharacterIterator.Attribute attribute : attributes) {
            if (attribute == null) continue;
            this.removeAttributeImpl(attribute, beginIndex, endIndex);
        }
    }

    protected synchronized void clearAttributes(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")>endIndex(" + endIndex + ")");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")<0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex(" + beginIndex + ")<0");
        }
        if (beginIndex >= this.length()) {
            return;
        }
        if (this.runCount <= 0) {
            return;
        }
        this.clearAttributesImpl(beginIndex, endIndex);
    }

    protected synchronized void addAttributeImpl(AttributedCharacterIterator.Attribute attribute, Object value, int beginIndex, int endIndex) {
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int beginRunIndex = this.ensureRunBreak(beginIndex);
        int endRunIndex = this.ensureRunBreak(endIndex);
        this.addAttributeRunData(attribute, value, beginRunIndex, endRunIndex);
    }

    protected synchronized void removeAttributeImpl(AttributedCharacterIterator.Attribute attribute, int beginIndex, int endIndex) {
        if (this.runCount <= 0) {
            return;
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")>endIndex(" + endIndex + ")");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")<0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex(" + beginIndex + ")<0");
        }
        if (beginIndex >= this.length()) {
            return;
        }
        if (beginIndex == endIndex) {
            FoundRunBreak f1 = this.findRunBreak(beginIndex);
            if (!f1.found) {
                return;
            }
            this.removeAttributeRunData(attribute, f1.runIndex, f1.runIndex + 1);
        } else {
            FoundRunBreak f1 = this.findRunBreak(beginIndex);
            if (!f1.found) {
                return;
            }
            for (int runIndex = f1.runIndex; runIndex < this.runCount && this.runStarts[runIndex] < endIndex; ++runIndex) {
                this.removeAttributeRunData(attribute, runIndex, runIndex + 1);
            }
        }
    }

    protected synchronized void clearAttributesImpl(int beginIndex, int endIndex) {
        if (this.runCount <= 0) {
            return;
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")>endIndex(" + endIndex + ")");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex(" + beginIndex + ")<0");
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex(" + beginIndex + ")<0");
        }
        if (beginIndex >= this.length()) {
            return;
        }
        if (beginIndex == endIndex) {
            FoundRunBreak f1 = this.findRunBreak(beginIndex);
            if (!f1.found) {
                return;
            }
            this.clearAttributesRunData(f1.runIndex, f1.runIndex + 1);
        } else {
            FoundRunBreak f1 = this.findRunBreak(beginIndex);
            if (!f1.found) {
                return;
            }
            for (int runIndex = f1.runIndex; runIndex < this.runCount && this.runStarts[runIndex] < endIndex; ++runIndex) {
                this.clearAttributesRunData(runIndex, runIndex + 1);
            }
        }
    }

    protected synchronized FoundRunBreak findRunBreak(int offset) {
        int runIndex;
        if (this.runCount <= 0) {
            return new FoundRunBreak(false, -1, -1);
        }
        FoundRunBreak res = new FoundRunBreak();
        res.found = false;
        res.runIndex = -1;
        res.lastOffset = -1;
        for (runIndex = 0; runIndex < this.runCount && this.runStarts[runIndex] < offset; ++runIndex) {
            res.runIndex = runIndex;
            res.lastOffset = this.runStarts[runIndex];
        }
        if (runIndex < this.runCount && this.runStarts[runIndex] == offset) {
            res.found = true;
            res.lastOffset = offset;
            res.runIndex = runIndex;
        }
        return res;
    }

    protected synchronized int ensureRunBreak(int offset) {
        return this.ensureRunBreak(offset, true);
    }

    protected synchronized int ensureRunBreak(int offset, boolean copyAttrs) {
        int runIndex;
        if (offset == this.length()) {
            return this.runCount;
        }
        for (runIndex = 0; runIndex < this.runCount && this.runStarts[runIndex] < offset; ++runIndex) {
        }
        if (runIndex < this.runCount && this.runStarts[runIndex] == offset) {
            return runIndex;
        }
        if (this.runCount == this.runArraySize) {
            int newArraySize = this.runArraySize + 10;
            int[] newRunStarts = new int[newArraySize];
            Vector[] newRunAttributes = new Vector[newArraySize];
            Vector[] newRunAttributeValues = new Vector[newArraySize];
            for (int i = 0; i < this.runArraySize; ++i) {
                newRunStarts[i] = this.runStarts[i];
                newRunAttributes[i] = this.runAttributes[i];
                newRunAttributeValues[i] = this.runAttributeValues[i];
            }
            this.runStarts = newRunStarts;
            this.runAttributes = newRunAttributes;
            this.runAttributeValues = newRunAttributeValues;
            this.runArraySize = newArraySize;
            this.nextScn();
        }
        Vector newRunAttributes = null;
        Vector newRunAttributeValues = null;
        if (copyAttrs) {
            Vector oldRunAttributes = this.runAttributes[runIndex - 1];
            Vector oldRunAttributeValues = this.runAttributeValues[runIndex - 1];
            if (oldRunAttributes != null) {
                newRunAttributes = (Vector)oldRunAttributes.clone();
            }
            if (oldRunAttributeValues != null) {
                newRunAttributeValues = (Vector)oldRunAttributeValues.clone();
            }
        }
        ++this.runCount;
        for (int i = this.runCount - 1; i > runIndex; --i) {
            this.runStarts[i] = this.runStarts[i - 1];
            this.runAttributes[i] = this.runAttributes[i - 1];
            this.runAttributeValues[i] = this.runAttributeValues[i - 1];
        }
        this.runStarts[runIndex] = offset;
        this.runAttributes[runIndex] = newRunAttributes;
        this.runAttributeValues[runIndex] = newRunAttributeValues;
        this.nextScn();
        return runIndex;
    }

    protected synchronized void addAttributeRunData(AttributedCharacterIterator.Attribute attribute, Object value, int beginRunIndex, int endRunIndex) {
        for (int i = beginRunIndex; i < endRunIndex; ++i) {
            int keyValueIndex = -1;
            if (this.runAttributes[i] == null) {
                Vector newRunAttributes = new Vector();
                Vector newRunAttributeValues = new Vector();
                this.runAttributes[i] = newRunAttributes;
                this.runAttributeValues[i] = newRunAttributeValues;
                this.nextScn();
            } else {
                keyValueIndex = this.runAttributes[i].indexOf(attribute);
            }
            if (keyValueIndex == -1) {
                int oldSize = this.runAttributes[i].size();
                this.runAttributes[i].addElement(attribute);
                try {
                    this.runAttributeValues[i].addElement(value);
                }
                catch (Exception e) {
                    this.runAttributes[i].setSize(oldSize);
                    this.runAttributeValues[i].setSize(oldSize);
                }
                this.nextScn();
                continue;
            }
            this.runAttributeValues[i].set(keyValueIndex, value);
            this.nextScn();
        }
    }

    protected synchronized void removeAttributeRunData(AttributedCharacterIterator.Attribute attribute, int beginRunIndex, int endRunIndex) {
        for (int i = beginRunIndex; i < endRunIndex; ++i) {
            int keyValueIndex = -1;
            if (this.runAttributes[i] == null || (keyValueIndex = this.runAttributes[i].indexOf(attribute)) < 0) continue;
            this.runAttributes[i].remove(keyValueIndex);
            this.runAttributeValues[i].remove(keyValueIndex);
            this.nextScn();
        }
    }

    protected synchronized void clearAttributesRunData(int beginRunIndex, int endRunIndex) {
        for (int i = beginRunIndex; i < endRunIndex; ++i) {
            if (this.runAttributes[i] == null) continue;
            this.runAttributes[i].clear();
            this.runAttributeValues[i].clear();
            this.nextScn();
        }
    }

    public AttributedCharacterIterator getIterator() {
        return this.getIterator(null, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return this.getIterator(attributes, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int beginIndex, int endIndex) {
        return new AttributedStringIterator(this, attributes, beginIndex, endIndex);
    }

    public char charAt(int index) {
        return this.text.charAt(index);
    }

    protected synchronized Object getAttribute(AttributedCharacterIterator.Attribute attribute, int runIndex) {
        Vector currentRunAttributes = this.runAttributes[runIndex];
        Vector currentRunAttributeValues = this.runAttributeValues[runIndex];
        if (currentRunAttributes == null) {
            return null;
        }
        int attributeIndex = currentRunAttributes.indexOf(attribute);
        if (attributeIndex != -1) {
            return currentRunAttributeValues.elementAt(attributeIndex);
        }
        return null;
    }

    protected Object getAttributeCheckRange(AttributedCharacterIterator.Attribute attribute, int runIndex, int beginIndex, int endIndex) {
        Object value = this.getAttribute(attribute, runIndex);
        if (value instanceof Annotation) {
            int textLength;
            if (beginIndex > 0) {
                int currIndex = runIndex;
                int runStart = this.runStarts[currIndex];
                while (runStart >= beginIndex && BaseAString.valuesMatch(value, this.getAttribute(attribute, currIndex - 1))) {
                    runStart = this.runStarts[--currIndex];
                }
                if (runStart < beginIndex) {
                    return null;
                }
            }
            if (endIndex < (textLength = this.length())) {
                int runLimit;
                int currIndex = runIndex;
                int n = runLimit = currIndex < this.runCount - 1 ? this.runStarts[currIndex + 1] : textLength;
                while (runLimit <= endIndex && BaseAString.valuesMatch(value, this.getAttribute(attribute, currIndex + 1))) {
                    runLimit = ++currIndex < this.runCount - 1 ? this.runStarts[currIndex + 1] : textLength;
                }
                if (runLimit > endIndex) {
                    return null;
                }
            }
        }
        return value;
    }

    protected boolean attributeValuesMatch(Set attributes, int runIndex1, int runIndex2) {
        for (AttributedCharacterIterator.Attribute key : attributes) {
            if (BaseAString.valuesMatch(this.getAttribute(key, runIndex1), this.getAttribute(key, runIndex2))) continue;
            return false;
        }
        return true;
    }

    public static boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public int length() {
        return this.text.length();
    }

    public static int length(AttributedCharacterIterator astr) {
        if (astr == null) {
            throw new IllegalArgumentException("astr==null");
        }
        return astr.getEndIndex();
    }

    public String text() {
        return this.text;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    protected static class FoundRunBreak {
        public boolean found;
        public int runIndex;
        public int lastOffset;

        public FoundRunBreak(boolean found, int runBreak, int lastOffset) {
            this.found = found;
            this.runIndex = runBreak;
            this.lastOffset = lastOffset;
        }

        public FoundRunBreak() {
        }
    }
}

